/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.FigureComponent;
import com.mathworks.hg.peer.JavaSceneServerPeerInterface;
import com.mathworks.hg.peer.PaintDisabled;
import com.mathworks.hg.uij.OpenGLUtils;
import com.mathworks.hg.util.OutputHelperProcessingException;
import com.mathworks.mwswing.binding.KeySequenceDispatcher;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLException;
import javax.media.opengl.awt.GLJPanel;

public class JavaSceneServerGLJPanel
extends GLJPanel
implements FigureComponent,
KeySequenceDispatcher.IgnoresAncestorKeyBindings,
PaintDisabled.PaintDisabledHandler {
    private JavaSceneServerPeerInterface fJSSP;
    private static boolean sJOGLDoesYFlip = false;
    private boolean fInSetup;
    private boolean fPaintDisabled = false;

    public JavaSceneServerGLJPanel(GLCapabilities gLCapabilities, JavaSceneServerPeerInterface javaSceneServerPeerInterface) {
        super((GLCapabilitiesImmutable)gLCapabilities);
        this.setSkipGLOrientationVerticalFlip(!sJOGLDoesYFlip);
        this.fJSSP = javaSceneServerPeerInterface;
        this.fInSetup = false;
    }

    public static void setJOGLDoesYFlip(boolean bl) {
        sJOGLDoesYFlip = bl;
    }

    public void setupPrint(double d, double d2, int n, int n2, int n3) {
        try {
            JavaSceneServerGLJPanel.enterCriticalSection();
            OpenGLUtils.throwIfRequested();
            super.setupPrint(d, d2, n, n2, n3);
            this.fInSetup = true;
        }
        catch (GLException gLException) {
            this.fJSSP.reportGLException(gLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePrint() {
        try {
            OpenGLUtils.throwIfRequested();
            super.releasePrint();
        }
        catch (GLException gLException) {
            this.fJSSP.reportGLException(gLException);
        }
        finally {
            this.fInSetup = false;
            JavaSceneServerGLJPanel.exitCriticalSection();
        }
    }

    public void print(Graphics graphics) {
        if (this.fInSetup) {
            super.print(graphics);
        }
    }

    public void addNotify() {
        if (this.fJSSP != null) {
            this.fJSSP.causeExpose();
        }
        super.addNotify();
    }

    @Override
    public boolean isPaintDisabled() {
        return this.fPaintDisabled;
    }

    @Override
    public void setPaintDisabled(boolean bl) throws OutputHelperProcessingException {
        this.fPaintDisabled = bl;
    }

    public void display() {
        if (this.fPaintDisabled) {
            return;
        }
        super.display();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        try {
            JavaSceneServerGLJPanel.enterCriticalSection();
            this.fJSSP.predraw();
            try {
                OpenGLUtils.throwIfRequested();
                super.paintComponent(graphics);
            }
            catch (GLException gLException) {
                this.fJSSP.reportGLException(gLException);
            }
            this.fJSSP.postdraw();
        }
        finally {
            JavaSceneServerGLJPanel.exitCriticalSection();
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension;
        int n5 = n3;
        int n6 = n4;
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (this.fJSSP != null && (dimension = this.fJSSP.getMaxViewportSize()) != null) {
            if (n5 > (int)dimension.getWidth()) {
                n5 = (int)dimension.getWidth();
            }
            if (n6 > (int)dimension.getHeight()) {
                n6 = (int)dimension.getHeight();
            }
        }
        super.setBounds(n, n2, n5, n6);
    }

    public void setBounds(Rectangle rectangle) {
        Dimension dimension;
        Rectangle rectangle2 = new Rectangle(rectangle);
        if (rectangle2.width < 0) {
            rectangle2.width = 0;
        }
        if (rectangle2.height < 0) {
            rectangle2.height = 0;
        }
        if (this.fJSSP != null && (dimension = this.fJSSP.getMaxViewportSize()) != null) {
            if (rectangle2.width > (int)dimension.getWidth()) {
                rectangle2.width = (int)dimension.getWidth();
            }
            if (rectangle2.height > (int)dimension.getHeight()) {
                rectangle2.height = (int)dimension.getHeight();
            }
        }
        super.setBounds(rectangle2);
    }

    @Override
    public boolean isComponentLightweight() {
        return true;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    private static native void enterCriticalSection();

    private static native void exitCriticalSection();
}

