/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.GraphicsOpenGL;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.FigureComponent;
import com.mathworks.hg.peer.HGCanvasPeer;
import com.mathworks.hg.peer.JavaSceneServerGLCanvas;
import com.mathworks.hg.peer.JavaSceneServerGLJPanel;
import com.mathworks.hg.peer.JavaSceneServerPeerInterface;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;

public class JavaSceneServerOffScreenCanvas
implements FigureComponent,
HGCanvasPeer {
    private Component fDrawable;
    private boolean fLightweight = false;
    private static boolean sUseGLJPanel = false;
    private static boolean sUseUseGLJPanel = false;

    public static void setUseGLJPanel(boolean bl) {
        sUseGLJPanel = bl;
        sUseUseGLJPanel = true;
    }

    protected Component createAutoDrawable(GLCapabilities gLCapabilities, JavaSceneServerPeerInterface javaSceneServerPeerInterface) {
        boolean bl = true;
        if (sUseUseGLJPanel) {
            bl = sUseGLJPanel;
        }
        if (bl) {
            this.fLightweight = true;
            if (GraphicsOpenGL.useSoftware()) {
                gLCapabilities.setHardwareAccelerated(false);
                gLCapabilities.setFBO(false);
                gLCapabilities.setPBuffer(false);
                gLCapabilities.setBitmap(true);
            }
            return new JavaSceneServerGLJPanel(gLCapabilities, javaSceneServerPeerInterface);
        }
        this.fLightweight = false;
        return new JavaSceneServerGLCanvas(gLCapabilities, javaSceneServerPeerInterface);
    }

    public JavaSceneServerOffScreenCanvas(GLCapabilities gLCapabilities, JavaSceneServerPeerInterface javaSceneServerPeerInterface) {
        this.fDrawable = this.createAutoDrawable(gLCapabilities, javaSceneServerPeerInterface);
        this.fDrawable.addComponentListener(new CanvasComponentAdaptor());
    }

    @Override
    public Component getComponent() {
        return this.fDrawable;
    }

    @Override
    public boolean isComponentLightweight() {
        return this.fLightweight;
    }

    @Override
    public GLAutoDrawable getGLAutoDrawable() {
        return (GLAutoDrawable)this.fDrawable;
    }

    @Override
    public void causeExpose() {
        this.fDrawable.repaint();
        Container container = this.fDrawable.getParent();
        if (container != null) {
            container.repaint();
        }
    }

    private class CanvasComponentAdaptor
    extends ComponentAdapter {
        private boolean fFocusedOnInitialResize = false;

        private CanvasComponentAdaptor() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            DebugUtilities.logMessage(32768, "JavaSceneServerOffScreenCanvas.ComponentAdapter.componentResized " + JavaSceneServerOffScreenCanvas.this.fDrawable.getBounds(), this);
            if (!this.fFocusedOnInitialResize) {
                JavaSceneServerOffScreenCanvas.this.fDrawable.requestFocusInWindow();
                this.fFocusedOnInitialResize = true;
            }
        }
    }
}

