/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.GraphicsOpenGL;
import com.mathworks.hg.peer.AcceleratorEventNotification;
import com.mathworks.hg.peer.CanvasPeerMouseListener;
import com.mathworks.hg.peer.CommandTarget;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.FigureComponent;
import com.mathworks.hg.peer.FigureComponentNotification;
import com.mathworks.hg.peer.FigureComponentProxy;
import com.mathworks.hg.peer.FigureEditableComponentManager;
import com.mathworks.hg.peer.FigureJavaEventNotification;
import com.mathworks.hg.peer.FigureNotification;
import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.hg.peer.GLEventListenerWithReset;
import com.mathworks.hg.peer.HGCanvasPeer;
import com.mathworks.hg.peer.JavaSceneServerOffScreenCanvas;
import com.mathworks.hg.peer.JavaSceneServerPanel;
import com.mathworks.hg.peer.JavaSceneServerPeerInterface;
import com.mathworks.hg.uij.OpenGLUtils;
import com.mathworks.hg.util.GraphicsDeviceUtilities;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.hg.util.PrintTileSizeCalculator;
import com.mathworks.jmi.Matlab;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.EventListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import javax.swing.SwingUtilities;

public class JavaSceneServerPeer
extends FigureComponentProxy
implements CommandTarget,
JavaSceneServerPeerInterface,
PrintTileSizeCalculator {
    private CanvasPeerMouseListener fListener = new CanvasPeerMouseListener(this);
    private boolean fUseJogl = !this.isHeadless();
    private static Image sOffscreenBuffer = null;
    private static boolean sLibraryInitialized = false;
    private Dimension fMaxViewportSize = null;
    private long fServerProxyHandle = 0L;
    private long fCurrentlyOver = 0L;
    private boolean fEnterExitEnabled = false;
    private static final int RENDERING_HINT_GLOBAL_ANTIALIAS = 1;
    private static final int RENDERING_HINT_LIGHTWEIGHT = 2;
    private boolean fGlobalAntialias = true;
    private boolean fUseLightweight = FigurePeer.defaultUseLightWeightContainer();
    private HGCanvasPeer fCanvas = null;
    private static boolean sJOGLInitialized;
    private boolean fNonZeroSize = false;
    private final Object fSizeLock = new Object();
    private boolean fJOGLExceptionAlreadyReported = false;

    protected boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeJOGL() {
        if (!sJOGLInitialized) {
            sJOGLInitialized = true;
            if (Matlab.isMatlabAvailable() && HGUtils.showFigureWindows()) {
                try {
                    JavaSceneServerPeer.enterCriticalSection();
                    OpenGLUtils.throwIfRequested();
                    GLProfile.initSingleton();
                }
                catch (GLException gLException) {
                    OpenGLUtils.reportJOGLException(gLException);
                }
                finally {
                    JavaSceneServerPeer.exitCriticalSection();
                }
            }
        }
    }

    private boolean change_hint(int n, boolean bl) {
        boolean bl2 = false;
        if (n == 1) {
            if (this.fUseJogl && this.fGlobalAntialias != bl) {
                bl2 = true;
            }
            this.fGlobalAntialias = bl;
        } else if (n == 2) {
            if (this.fUseLightweight != bl) {
                bl2 = true;
            }
            this.fUseLightweight = bl;
        }
        return bl2;
    }

    private GLCapabilities getCaps() {
        GLCapabilities gLCapabilities = new GLCapabilities(null);
        gLCapabilities.setHardwareAccelerated(true);
        if (this.fGlobalAntialias) {
            gLCapabilities.setSampleBuffers(true);
            gLCapabilities.setNumSamples(8);
        }
        return gLCapabilities;
    }

    @Override
    public long getServerProxyHandle() {
        return this.fServerProxyHandle;
    }

    @Override
    public int getMaxBufferSize(GL gL) throws HGGLException {
        return 2048;
    }

    private static void setHints(Graphics2D graphics2D) {
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHints(renderingHints);
    }

    @Override
    public void callDoJavaPaint(Graphics graphics, boolean bl, boolean bl2) {
        int n = this.getComponent().getWidth();
        int n2 = this.getComponent().getHeight();
        if (n <= 0 || n2 <= 0) {
            return;
        }
        if (bl) {
            if (sOffscreenBuffer == null || sOffscreenBuffer.getWidth(null) != n || sOffscreenBuffer.getHeight(null) != n2) {
                sOffscreenBuffer = this.getComponent().createImage(n, n2);
            }
            Graphics graphics2 = sOffscreenBuffer.getGraphics();
            JavaSceneServerPeer.setHints((Graphics2D)graphics2);
            this.doJavaPaint(graphics2, this.fServerProxyHandle, bl2);
            graphics.drawImage(sOffscreenBuffer, 0, 0, null);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            JavaSceneServerPeer.setHints(graphics2D);
            this.doJavaPaint(graphics2D, this.fServerProxyHandle, bl2);
            graphics2D.dispose();
        }
    }

    private boolean isLibraryAlreadyLoaded(String string) {
        String string2 = "(.*)(already loaded in another classloader)(.*)";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    public JavaSceneServerPeer() {
        if (!sLibraryInitialized) {
            block8: {
                if (PlatformInfo.isWindows()) {
                    try {
                        System.loadLibrary("jawt");
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        String string = unsatisfiedLinkError.getMessage();
                        if (this.isLibraryAlreadyLoaded(string)) break block8;
                        this.reportError("MATLAB:HG:Java:FailedLoadAwt", string);
                    }
                }
            }
            try {
                System.loadLibrary("nativehg");
                sLibraryInitialized = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.reportError("MATLAB:HG:Java:FailedLoadNativeHG", "Failed to load nativehg");
            }
        }
        try {
            this.createCanvas(this.fUseJogl);
        }
        catch (GLException gLException) {
            this.reportGLException(gLException);
        }
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        this.doReshape(n, n2, n3, n4, this.fServerProxyHandle);
    }

    @Override
    public void restart(int n, boolean bl) {
        this.doRestart(this.fServerProxyHandle, n, bl);
    }

    @Override
    public void display(int n, boolean bl) {
        this.doDisplay(this.fServerProxyHandle, n, bl);
    }

    @Override
    public void predraw() {
        this.doPredraw(this.fServerProxyHandle);
    }

    @Override
    public void postdraw() {
        this.doPostdraw(this.fServerProxyHandle);
    }

    private native void doRestart(long var1, int var3, boolean var4);

    private native void doReshape(int var1, int var2, int var3, int var4, long var5);

    private native void doDisplay(long var1, int var3, boolean var4);

    private native void doSetTile(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, long var17);

    private native void doResetTiling(long var1);

    private native void doJavaPaint(Graphics var1, long var2, boolean var4);

    private native boolean doHitTest(int var1, int var2, MouseEvent var3, long var4);

    private native boolean doEnterExitTest(int var1, int var2, long var3);

    private native void doMouseEvent(MouseEvent var1, int var2, long var3);

    private native void doKeyEvent(KeyEvent var1, long var2);

    private native void doExecuteCommand(int var1, long var2, long var4);

    private native void doEnableWebOutput(long var1, int var3);

    private native void doPredraw(long var1);

    private native void doPostdraw(long var1);

    private static native void enterCriticalSection();

    private static native void exitCriticalSection();

    public void replaceClient(int n) {
        this.doEnableWebOutput(this.fServerProxyHandle, n);
    }

    @Override
    public void reportError(String string, String string2) {
        this.reportError(false, string, string2);
    }

    @Override
    public void reportError(boolean bl, String string, String string2) {
        System.out.println("JavaSceneServerPeer problem: " + string2);
    }

    public void setSceneServerProxyHandle(long l) {
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.setSceneServerProxyHandle", this);
        this.fServerProxyHandle = l;
    }

    @Override
    public void causeExpose() {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call causeExpose from event dispatch thread";
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.causeExpose", this);
        if (this.fCanvas != null) {
            this.fCanvas.causeExpose();
        }
    }

    public boolean getUseJogl() {
        return this.fUseJogl;
    }

    public void setUseJogl(boolean bl) {
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.setUseJogl", this);
        assert (SwingUtilities.isEventDispatchThread()) : "Expected to call setUseJogl from EDT";
        assert (!bl || !this.isHeadless());
        if (bl != this.fUseJogl) {
            this.doCreateCanvas(bl);
        }
    }

    @Override
    public void hide() {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call hide from event dispatch thread";
        if (this.getComponent() != null) {
            this.getComponent().setVisible(false);
        }
    }

    @Override
    public void show() {
        assert (SwingUtilities.isEventDispatchThread()) : "Must call show from event dispatch thread";
        if (this.getComponent() != null) {
            this.getComponent().setVisible(true);
        }
    }

    public void setRenderingHint(int n, boolean bl) {
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.setRenderingHint", this);
        assert (SwingUtilities.isEventDispatchThread()) : "Expected to call setRenderingHint from EDT";
        if (this.change_hint(n, bl)) {
            this.doCreateCanvas(this.fUseJogl);
        }
    }

    public static int getDefaultScreenWidth() {
        return GraphicsDeviceUtilities.getDefaultScreenWidth();
    }

    public static int getDefaultScreenHeight() {
        return GraphicsDeviceUtilities.getDefaultScreenHeight();
    }

    public static int getDefaultScreenResolution() {
        return GraphicsDeviceUtilities.getDefaultScreenResolution();
    }

    @Override
    public void setTile(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        this.doSetTile(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight(), this.getServerProxyHandle());
    }

    @Override
    public void resetTiling() {
        this.doResetTiling(this.getServerProxyHandle());
    }

    private GraphicsConfiguration getGraphicsConfiguration(Component component) {
        GraphicsConfiguration graphicsConfiguration = null;
        try {
            if (this.isHeadless()) {
                this.reportError(true, "MATLAB:HG:Java:UnsupportedHeadlessGraphicsOperation", "Unable to perform graphics operations in headless mode");
            } else {
                if (component != null) {
                    graphicsConfiguration = component.getGraphicsConfiguration();
                }
                if (graphicsConfiguration == null) {
                    if (component != null) {
                        DebugUtilities.logMessage(16, "JavaSceneViewerPeer.getGraphicsConfiguration null graphics configuration for component", component);
                    }
                    graphicsConfiguration = GraphicsDeviceUtilities.getDefaultGraphicsConfiguration();
                }
            }
        }
        catch (HeadlessException headlessException) {
            this.reportError(true, "MATLAB:HG:Java:UnsupportedHeadlessGraphicsOperation", "Unable to perform graphics operations in headless mode");
        }
        if (graphicsConfiguration == null) {
            DebugUtilities.logMessage(16, "JavaSceneViewerPeer.getGraphicsConfiguration is null", this);
        }
        return graphicsConfiguration;
    }

    public int getScreenWidth() {
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.getScreenWidth", this);
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration(this.getComponent());
        if (graphicsConfiguration == null) {
            return 0;
        }
        Rectangle rectangle = graphicsConfiguration.getBounds();
        return (int)rectangle.getWidth();
    }

    public int getScreenHeight() {
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.getScreenHeight", this);
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration(this.getComponent());
        if (graphicsConfiguration == null) {
            return 0;
        }
        Rectangle rectangle = graphicsConfiguration.getBounds();
        return (int)rectangle.getHeight();
    }

    public int getScreenResolution() {
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.getScreenResolution", this);
        if (this.getComponent() != null) {
            Toolkit toolkit = this.getComponent().getToolkit();
            return toolkit.getScreenResolution();
        }
        return GraphicsDeviceUtilities.getDefaultScreenResolution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasNonZeroSize() {
        boolean bl;
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Dimension dimension = JavaSceneServerPeer.this.getComponent().getSize();
                Object object = JavaSceneServerPeer.this.fSizeLock;
                synchronized (object) {
                    JavaSceneServerPeer.this.fNonZeroSize = dimension.height > 0 && dimension.width > 0;
                }
            }
        });
        Object object = this.fSizeLock;
        synchronized (object) {
            bl = this.fNonZeroSize;
        }
        return bl;
    }

    @Override
    public Dimension getMaxViewportSize() {
        return this.fMaxViewportSize;
    }

    @Override
    public void setMaxViewportSize(Dimension dimension) {
        this.fMaxViewportSize = dimension;
    }

    @Override
    public int getViewportWidth() {
        Rectangle rectangle;
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.getViewportWidth", this);
        int n = 0;
        if (this.getComponent() != null && (rectangle = this.getComponent().getBounds()) != null) {
            n = rectangle.width;
        }
        return n;
    }

    @Override
    public int getViewportHeight() {
        Rectangle rectangle;
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.getViewportHeight", this);
        int n = 0;
        if (this.getComponent() != null && (rectangle = this.getComponent().getBounds()) != null) {
            n = rectangle.height;
        }
        return n;
    }

    public void setEnterExitEnabled(boolean bl) {
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.setEnterExitEnabled", this);
        this.fEnterExitEnabled = bl;
    }

    public boolean getEnterExitEnabled() {
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.getEnterExitEnabled", this);
        return this.fEnterExitEnabled;
    }

    protected void createCanvas(final boolean bl) {
        assert (!SwingUtilities.isEventDispatchThread());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavaSceneServerPeer.this.doCreateCanvas(bl);
            }
        });
    }

    private void doCreateCanvas(boolean bl) {
        Container container;
        assert (SwingUtilities.isEventDispatchThread()) : "Must call JavaSceneServerPeer.createCanvas from the EDT.";
        Component component = null;
        if (this.fCanvas != null) {
            component = this.fCanvas.getComponent();
        }
        this.nullOutReferences();
        HGCanvasPeer hGCanvasPeer = null;
        if (bl) {
            Rectangle rectangle;
            assert (!this.isHeadless()) : "Unsupported in headless mode.";
            if (this.fMaxViewportSize == null) {
                rectangle = GraphicsDeviceUtilities.getSizeOfAllScreens();
                this.fMaxViewportSize = new Dimension(rectangle.width, rectangle.height);
            }
            rectangle = this.getCaps();
            try {
                hGCanvasPeer = new JavaSceneServerOffScreenCanvas((GLCapabilities)rectangle, this);
            }
            catch (GLException gLException) {
                DebugUtilities.logMessage(32784, "caught GLException", this);
                hGCanvasPeer = null;
            }
            if (hGCanvasPeer != null) {
                hGCanvasPeer.getGLAutoDrawable().addGLEventListener((GLEventListener)new GLEventListenerWithReset(this));
            } else {
                DebugUtilities.logMessage(32784, "Couldn't create JOGL canvas--using painters", this);
                this.reportError("MATLAB:HG:Java:FailedOpenGL", "Couldn't create JOGL canvas--using painters");
                bl = false;
            }
        }
        boolean bl2 = this.fUseLightweight;
        if (!bl) {
            hGCanvasPeer = new JavaSceneServerPanel(this);
            bl2 = true;
        }
        Component component2 = hGCanvasPeer.getComponent();
        component2.addMouseListener(this.fListener);
        component2.addMouseMotionListener(this.fListener);
        this.setFigureComponent((FigureComponent)((Object)hGCanvasPeer));
        this.fNotificationHandler.handleNotification(new FigureComponentNotification(1, this.getComponent(), bl2));
        if (component != null && (container = component.getParent()) != null) {
            container.remove(component);
            if (component2.getParent() == null) {
                container.add(component2);
            }
        }
        this.fCanvas = hGCanvasPeer;
        this.fUseJogl = bl;
    }

    void doFireMousePressed(MouseEvent mouseEvent) {
        FigureEditableComponentManager.commitCurrentEditableComponent();
        Component component = mouseEvent.getComponent();
        component.requestFocusInWindow();
        if (!this.doHitTest(mouseEvent.getX(), component.getHeight() - mouseEvent.getY(), mouseEvent, this.fServerProxyHandle)) {
            this.doMouseEvent(mouseEvent, component.getHeight(), this.fServerProxyHandle);
        }
    }

    void doFireMouseReleased(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        this.doMouseEvent(mouseEvent, component.getHeight(), this.fServerProxyHandle);
    }

    void doFireMouseDragged(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (this.fEnterExitEnabled) {
            this.doEnterExitTest(mouseEvent.getX(), component.getHeight() - mouseEvent.getY(), this.fServerProxyHandle);
        }
        this.doMouseEvent(mouseEvent, component.getHeight(), this.fServerProxyHandle);
    }

    void doFireMouseMoved(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (this.fEnterExitEnabled) {
            this.doEnterExitTest(mouseEvent.getX(), component.getHeight() - mouseEvent.getY(), this.fServerProxyHandle);
        }
        this.doMouseEvent(mouseEvent, component.getHeight(), this.fServerProxyHandle);
    }

    @Override
    public void executeCommand(int n, long l) {
        DebugUtilities.logMessage(32, "JavaSceneViewerPeer.executeCommand", this);
        this.doExecuteCommand(n, l, this.fServerProxyHandle);
    }

    @Override
    public void reportGLException(GLException gLException) {
        if (!this.fJOGLExceptionAlreadyReported) {
            this.fJOGLExceptionAlreadyReported = true;
            OpenGLUtils.reportJOGLException(gLException);
        }
    }

    @Override
    public void dispose() {
        assert (!SwingUtilities.isEventDispatchThread());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component component = JavaSceneServerPeer.this.getComponent();
                if (component != null && component.getParent() != null) {
                    JavaSceneServerPeer.this.fNotificationHandler.handleNotification(new FigureComponentNotification(2, component, JavaSceneServerPeer.this.fUseLightweight));
                }
                if ((component = JavaSceneServerPeer.this.getComponent()) != null) {
                    Container container = component.getParent();
                    for (MouseListener eventListener : component.getMouseListeners()) {
                        component.removeMouseListener(eventListener);
                    }
                    for (EventListener eventListener : component.getComponentListeners()) {
                        component.removeComponentListener((ComponentListener)eventListener);
                    }
                    for (EventListener eventListener : component.getKeyListeners()) {
                        component.removeKeyListener((KeyListener)eventListener);
                    }
                    component.removeMouseMotionListener(JavaSceneServerPeer.this.fListener);
                    component.removeMouseListener(JavaSceneServerPeer.this.fListener);
                    JavaSceneServerPeer.this.fListener = null;
                    if (container != null) {
                        container.remove(component);
                    }
                }
                JavaSceneServerPeer.super.dispose();
                JavaSceneServerPeer.this.nullOutReferences();
            }
        });
    }

    private void nullOutReferences() {
        this.fCanvas = null;
    }

    @Override
    public void handleNotification(FigureNotification figureNotification) {
        AWTEvent aWTEvent;
        if (figureNotification instanceof FigureJavaEventNotification && (aWTEvent = ((FigureJavaEventNotification)figureNotification).getEvent()) instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)aWTEvent;
            this.doKeyEvent(keyEvent, this.fServerProxyHandle);
            super.handleNotification(new AcceleratorEventNotification(keyEvent.getSource(), keyEvent));
            return;
        }
        super.handleNotification(figureNotification);
    }

    static {
        if (!GraphicsOpenGL.isUseSoftware() && !GraphicsOpenGL.delayJOGLInit()) {
            JavaSceneServerPeer.initializeJOGL();
        }
        sJOGLInitialized = false;
    }

    public static class HGGLRuntimeException
    extends RuntimeException {
        private HGGLException fException = null;

        public HGGLRuntimeException(HGGLException hGGLException) {
            super(hGGLException.getMessage());
            this.setStackTrace(hGGLException.getStackTrace());
            this.fException = hGGLException;
        }

        public HGGLException getSource() {
            return this.fException;
        }
    }

    public static class HGGLException
    extends Exception {
        public HGGLException(String string) {
            super(string);
        }
    }
}

