/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.AbstractUicontrolPeer;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.EditTextPeer;
import com.mathworks.hg.peer.FigureEditableComponentManager;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.jmi.Callback;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJTextPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.PlatformInfo;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public final class TextObjectEdit
extends EditTextPeer
implements KeyListener,
MouseListener,
InputMethodListener {
    public static final int TEXT_TOP = 0;
    public static final int TEXT_CAP = 1;
    public static final int TEXT_MIDDLE = 2;
    public static final int TEXT_BASELINE = 3;
    public static final int TEXT_BOTTOM = 4;
    private double fXLeft;
    private double fXRight;
    private double fXMiddle;
    private double fYBottom;
    private double fYMiddle;
    private double fInitialHeight;
    private double fHeight = 0.0;
    private double fWidth = 0.0;
    private Callback fCallback;
    private int fHorizontalAlign = 0;
    private int fVerticalAlign = 2;
    private static final int sFirstMethodIndex;
    protected static final int sSetControlPosition;
    protected static final int sRequestFocus;
    private static final int sLastMethodIndex;
    private static final String[] sLogMessages;
    private boolean fDoInitCaretPos = false;
    protected UndoAction undoAction = new UndoAction();
    protected RedoAction redoAction = new RedoAction();
    protected UndoManager undo = new UndoManager();
    private static TextObjectEdit sThis;
    private HashMap actions;
    private static MJPopupMenu sEditPopupMenu;
    private static boolean sMenuFocusFlag;

    public static TextObjectEdit getInstance() {
        return sThis;
    }

    public TextObjectEdit() {
        super(true);
        sThis = this;
        this.fCallback = new Callback();
        this.setForbidAcceleratorForwarding(true);
    }

    @Override
    protected void doCreateUicontrolPeer() {
        super.doCreateUicontrolPeer();
        this.doSetValue(null, 2.0, 0.0);
        if (this.fComponent instanceof MJTextPane) {
            MJTextPane mJTextPane = (MJTextPane)this.fComponent;
            mJTextPane.setWrapping(false);
        }
        this.fComponent.addMouseListener(this);
        this.fComponent.addKeyListener(this);
        this.getComponentPeer().setBorder(BorderFactory.createEmptyBorder());
        super.doSetTextAlign(0);
        this.fComponent.addInputMethodListener(this);
        this.createActionTable(this.fEditText);
        this.fEditText.getDocument().addUndoableEditListener(new TextEditUndoableListener());
        this.fComponent.getActionMap().put("paste-from-clipboard", this.getPasteAction());
    }

    @Override
    protected void addUicontrolButtondownListener() {
    }

    @Override
    public String getUserMethodDescription(int n) {
        String string = null;
        string = n >= sFirstMethodIndex && n <= sLastMethodIndex ? sLogMessages[n - sFirstMethodIndex] : super.getUserMethodDescription(n);
        return string;
    }

    @Override
    public void addLogMessage(int n) {
        if (DebugUtilities.isDebugOptions() && n <= this.getUserLastMethodID()) {
            if (n < sFirstMethodIndex) {
                super.addLogMessage(n);
            } else {
                DebugUtilities.logMessage(32, this.getClass().getName() + "." + this.getUserMethodDescription(n), this);
            }
        }
    }

    public void EXTERNAL_SetPosition(final double d, final double d2, final double d3, final double d4) {
        FigureEditableComponentManager.setCurrentEditableComponent(this);
        HGUtils.invokeLater(new HGPeerRunnable(this, sSetControlPosition){

            @Override
            public void run() {
                TextObjectEdit.this.EXTERNAL_doSetPosition(d, d2, d3, d4);
            }
        });
    }

    void EXTERNAL_doSetPosition(double d, double d2, double d3, double d4) {
        if (this.fWidth == d3 && this.fHeight == d4 && this.fXLeft == d && this.fYBottom == d2) {
            return;
        }
        this.fDoInitCaretPos = true;
        if (this.fComponent instanceof MJTextPane) {
            MJTextPane mJTextPane = (MJTextPane)this.fComponent;
            mJTextPane.setWrapping(false);
        }
        this.fHeight = d4;
        this.fWidth = d3;
        this.fXLeft = d;
        this.fXMiddle = d + d3 / 2.0;
        this.fXRight = d + d3;
        this.fYBottom = d2;
        this.fYMiddle = d2 - d4 / 2.0;
        this.fInitialHeight = this.getComponentPreferredSize().getHeight();
        this.updateSize(false);
    }

    public Callback getCallback() {
        return this.fCallback;
    }

    public void fireCallback(String string) {
        String[] stringArray;
        if (string.endsWith("\n")) {
            stringArray = string.concat(" ").split("\n");
            stringArray[stringArray.length - 1] = "";
        } else {
            stringArray = string.split("\n");
        }
        this.fCallback.postCallback(new Object[]{new CallbackData(this, stringArray)});
    }

    private void updateSizeLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextObjectEdit.this.updateSize(true);
            }
        });
    }

    private void updateSize(boolean bl) {
        this.updateSize(bl, 0);
    }

    private void updateSize(boolean bl, int n) {
        Dimension dimension = this.getComponentPreferredSize();
        double d = dimension.getHeight();
        double d2 = dimension.getWidth();
        if (!bl && d == 0.0) {
            if (d < this.fHeight) {
                d = this.fHeight;
            }
            if (d2 < this.fWidth) {
                d2 = this.fWidth;
            }
        }
        Font font = this.fComponent.getFont();
        FontMetrics fontMetrics = this.fComponent.getFontMetrics(font);
        double d3 = this.fVerticalAlign == 0 || this.fVerticalAlign == 1 || this.fVerticalAlign == 3 ? this.fYBottom + (d - this.fInitialHeight) : (this.fVerticalAlign == 2 ? this.fYMiddle + d / 2.0 : this.fYBottom);
        double d4 = this.fHorizontalAlign == 1 ? this.fXMiddle - d2 / 2.0 : (this.fHorizontalAlign == 2 ? this.fXRight - (d2 += (double)(fontMetrics.charWidth('m') * (n + 1))) : this.fXLeft);
        this.doSetPosition(d4, d3, d2, d);
        this.fParentPanel.revalidate();
    }

    @Override
    protected void doSetTextAlign(int n) {
        this.fHorizontalAlign = n;
        super.doSetTextAlign(n);
    }

    @Override
    protected void doSetVisible(boolean bl) {
        super.doSetVisible(bl);
        if (!bl && null != this.fCompParent) {
            this.fCompParent.requestFocus();
        }
    }

    public void setControlTextVertAlign(int n) {
    }

    public void EXTERNAL_RequestControlFocus() {
        if (this.doPreRequestFocus()) {
            HGUtils.invokeLater(new HGPeerRunnable(this, sRequestFocus, 8, this.doIsObjectMethodCoalescable()){

                @Override
                public void run() {
                    TextObjectEdit.this.doRequestFocus();
                    TextObjectEdit.this.undo.discardAllEdits();
                }
            });
        }
    }

    @Override
    protected Insets getComponentInsets() {
        if (PlatformInfo.isMacintosh()) {
            if (this.fVerticalAlign == 2) {
                return new Insets(6, 0, 4, 1);
            }
            return new Insets(-2, 0, 0, 1);
        }
        if (PlatformInfo.isSolaris()) {
            if (this.fVerticalAlign == 2) {
                return new Insets(3, 1, 2, 1);
            }
            return new Insets(0, 0, 2, 1);
        }
        if (PlatformInfo.isLinux() || PlatformInfo.isLinux64()) {
            if (this.fVerticalAlign == 2) {
                return new Insets(2, 2, 2, 1);
            }
            return new Insets(-3, 0, 2, 1);
        }
        return new Insets(-3, 0, 2, 1);
    }

    @Override
    public boolean isScrollbarVisible() {
        return false;
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        int n = inputMethodEvent.getCommittedCharacterCount();
        this.updateSize(true, n);
    }

    @Override
    public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 127 || n == 8 || n == 10) {
            this.updateSize(true);
        }
        this.fireCallback(this.doGetRawString());
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n != 127 && n != 8 && n != 10) {
            this.updateSize(true);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.fDoInitCaretPos = false;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (null != this.fCompParent && (mouseEvent.getModifiers() & 4) != 0) {
            this.getEditPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void commitChange() {
        if (sMenuFocusFlag) {
            super.commitChange();
        }
    }

    private void createActionTable(JTextComponent jTextComponent) {
        this.actions = new HashMap();
        Action[] actionArray = jTextComponent.getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            Action action = actionArray[i];
            this.actions.put(action.getValue("Name"), action);
        }
    }

    private Action getActionByName(String string) {
        return (Action)this.actions.get(string);
    }

    private MJPopupMenu getEditPopupMenu() {
        if (sEditPopupMenu == null) {
            assert (SwingUtilities.isEventDispatchThread());
            sEditPopupMenu = new MJPopupMenu();
            Action action = this.undoAction;
            sEditPopupMenu.insert(action, 0);
            sEditPopupMenu.addSeparator();
            action = this.getActionByName("cut-to-clipboard");
            JMenuItem jMenuItem = sEditPopupMenu.add(action);
            jMenuItem.setText(MJUtilities.intlString((String)"text.Cut"));
            action = this.getActionByName("copy-to-clipboard");
            jMenuItem = sEditPopupMenu.add(action);
            jMenuItem.setText(MJUtilities.intlString((String)"text.Copy"));
            action = this.getPasteAction();
            jMenuItem = sEditPopupMenu.add(action);
            jMenuItem.setText(MJUtilities.intlString((String)"text.Paste"));
            action = new TextAction(MJUtilities.intlString((String)"menuitem.Delete")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.getTextComponent(actionEvent).replaceSelection("");
                }
            };
            sEditPopupMenu.add(action);
            sEditPopupMenu.addSeparator();
            action = this.getActionByName("select-all");
            jMenuItem = sEditPopupMenu.add(action);
            jMenuItem.setText(MJUtilities.intlString((String)"text.SelectAll"));
            sEditPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    sMenuFocusFlag = true;
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    sMenuFocusFlag = false;
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    sMenuFocusFlag = true;
                }
            });
        } else {
            sEditPopupMenu.remove(0);
            Action action = this.undoAction;
            sEditPopupMenu.insert(action, 0);
            sEditPopupMenu.remove(4);
            action = this.getPasteAction();
            action.putValue("Name", MJUtilities.intlString((String)"text.Paste"));
            sEditPopupMenu.insert(action, 4);
        }
        return sEditPopupMenu;
    }

    private Action getPasteAction() {
        DefaultEditorKit.PasteAction pasteAction = new DefaultEditorKit.PasteAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                super.actionPerformed(actionEvent);
                TextObjectEdit.this.updateSize(true);
                TextObjectEdit.this.updateSizeLater();
            }
        };
        return pasteAction;
    }

    static {
        sSetControlPosition = sFirstMethodIndex = AbstractUicontrolPeer.getLastMethodIndex() + 1;
        sLastMethodIndex = sRequestFocus = sFirstMethodIndex + 1;
        sLogMessages = new String[]{"setControlPosition", "requestFocus"};
        sThis = null;
        sMenuFocusFlag = true;
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(MJUtilities.intlString((String)"action.Redo"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TextObjectEdit.this.undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
            this.updateRedoState();
            TextObjectEdit.this.undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (TextObjectEdit.this.undo.canRedo()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(MJUtilities.intlString((String)"action.Undo"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TextObjectEdit.this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
            this.updateUndoState();
            TextObjectEdit.this.redoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (TextObjectEdit.this.undo.canUndo()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    protected class TextEditUndoableListener
    implements UndoableEditListener {
        protected TextEditUndoableListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            TextObjectEdit.this.undo.addEdit(undoableEditEvent.getEdit());
            TextObjectEdit.this.undoAction.updateUndoState();
            TextObjectEdit.this.redoAction.updateRedoState();
        }
    }

    static class CallbackData {
        public TextObjectEdit source;
        public String[] data;

        public CallbackData(TextObjectEdit textObjectEdit, String[] stringArray) {
            this.source = textObjectEdit;
            this.data = stringArray;
        }
    }
}

