/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.AbstractUicontrolPeer;
import com.mathworks.hg.types.HGRectangle;
import com.mathworks.jmi.AWTUtilities;
import com.mathworks.util.PlatformInfo;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class UnitPos {
    public static final int INCHES = 0;
    public static final int CENTIMETERS = 1;
    public static final int NORMALIZED = 2;
    public static final int POINTS = 3;
    public static final int PIXELS = 4;
    public static final int CHARACTERS = 5;
    public static final int DATA = 6;
    public static final int UNKNOWN = 7;
    public static final String[] UNITS = new String[]{"inches", "centimeters", "normalized", "points", "pixels", "characters", "data"};
    private static final int POINTS_PER_INCH = 72;
    private static final double CM_PER_INCH = 2.53807;
    private int fUnits;
    private HGRectangle fPosition;
    private static String sDefaultFontName = "fixed";
    private static double sDefaultFontSize = 10.0;
    private static final Font sDefaultFont;

    public UnitPos() {
    }

    public UnitPos(int n, HGRectangle hGRectangle) {
        this.fUnits = n;
        this.fPosition = hGRectangle;
    }

    public static int unitsToInt(String string) {
        int n;
        for (n = 0; n < UNITS.length && !string.equals(UNITS[n]); ++n) {
        }
        return n;
    }

    public static String unitsToString(int n) {
        String string = "unknown";
        if (n >= 0 && n < UNITS.length) {
            string = UNITS[n];
        }
        return string;
    }

    public String toString() {
        return "UnitPos (" + this.fUnits + UnitPos.unitsToString(this.fUnits) + ") l,t,w,h=" + this.fPosition.getX() + ", " + this.fPosition.getY() + ", " + this.fPosition.getWidth() + ", " + this.fPosition.getHeight();
    }

    public void setPosition(double d, double d2, double d3, double d4) {
        this.setPosition(new HGRectangle(d, d2, d3, d4));
    }

    public void setPosition(double[] dArray) {
        if (dArray.length == 4) {
            this.setPosition(dArray[0], dArray[1], dArray[2], dArray[3]);
        } else {
            System.out.println("Invalid position vector.  Must be 1x4 or 4x1");
        }
    }

    public void setPosition(double[][] dArray) {
        if (dArray.length == 1 && dArray[0].length == 4) {
            this.setPosition(dArray[0][0], dArray[0][1], dArray[0][2], dArray[0][3]);
        } else {
            System.out.println("Invalid position vector.  Must be 1x4 or 4x1");
        }
    }

    public void setPosition(HGRectangle hGRectangle) {
        if (hGRectangle.getHeight() <= 0.0) {
            hGRectangle.setHeight(1.0);
        }
        if (hGRectangle.getWidth() <= 0.0) {
            hGRectangle.setWidth(1.0);
        }
        this.fPosition = hGRectangle;
    }

    public double[] getDoublePosition() {
        double[] dArray = new double[]{this.fPosition.getX(), this.fPosition.getY(), this.fPosition.getWidth(), this.fPosition.getHeight()};
        return dArray;
    }

    public HGRectangle getPosition() {
        return this.fPosition;
    }

    public HGRectangle getPosition(int n, Dimension dimension) {
        return UnitPos.convertPosition(this.fPosition, this.fUnits, n, dimension);
    }

    public void setUnits(int n) {
        if (n < 0 || n >= 7) {
            throw new Error("Invalid value for Units");
        }
        this.fUnits = n;
    }

    public void setUnits(int n, Dimension dimension) {
        if (dimension != null) {
            this.fPosition = UnitPos.convertPosition(this.fPosition, this.fUnits, n, dimension);
        }
        this.fUnits = n;
    }

    public void setUnits(String string) {
        int n = UnitPos.unitsToInt(string);
        if (n < 0 || n >= 7) {
            throw new Error("Invalid value for Units: " + string);
        }
        this.setUnits(n);
    }

    public int getUnits() {
        return this.fUnits;
    }

    public Rectangle getBounds(Dimension dimension) {
        HGRectangle hGRectangle = UnitPos.convertPosition(this.fPosition, this.fUnits, 4, dimension);
        Rectangle rectangle = UnitPos.pixelPositionToBounds(hGRectangle, dimension);
        return rectangle;
    }

    public void setBounds(Rectangle rectangle, Dimension dimension) {
        HGRectangle hGRectangle = UnitPos.boundsToPixelPosition(rectangle, dimension);
        this.fPosition = UnitPos.convertPosition(hGRectangle, 4, this.fUnits, dimension);
    }

    public static Rectangle pixelPositionToBounds(HGRectangle hGRectangle, Dimension dimension) {
        Rectangle rectangle = new Rectangle();
        rectangle.x = (int)(hGRectangle.getX() - 1.0);
        rectangle.width = (int)hGRectangle.getWidth();
        rectangle.height = (int)hGRectangle.getHeight();
        rectangle.y = (int)((double)dimension.height - hGRectangle.getY() + 1.0 - hGRectangle.getHeight());
        return rectangle;
    }

    public static HGRectangle boundsToPixelPosition(Rectangle rectangle, Dimension dimension) {
        return UnitPos.boundsToPixelPositionWithOffset(rectangle, dimension, 0);
    }

    static HGRectangle boundsToPixelPositionWithPixelOriginOffset(Rectangle rectangle, Dimension dimension) {
        return UnitPos.boundsToPixelPositionWithOffset(rectangle, dimension, 1);
    }

    private static HGRectangle boundsToPixelPositionWithOffset(Rectangle rectangle, Dimension dimension, int n) {
        HGRectangle hGRectangle = new HGRectangle();
        hGRectangle.setX(rectangle.x + n);
        hGRectangle.setWidth(rectangle.width);
        hGRectangle.setY(dimension.height - rectangle.y - rectangle.height + n);
        hGRectangle.setHeight(rectangle.height);
        return hGRectangle;
    }

    public static double scaleHeight(double d, int n, int n2, Dimension dimension) {
        double d2 = d;
        if (n != n2) {
            double d3 = PlatformInfo.isMacintosh() ? 72.0 : (double)Toolkit.getDefaultToolkit().getScreenResolution();
            double d4 = d3 / (double)dimension.height;
            double d5 = d3 / (double)UnitPos.GetCharacterPixelWidthAndHeight().height;
            switch (n) {
                case 4: {
                    d2 /= d3;
                    break;
                }
                case 3: {
                    d2 /= 72.0;
                    break;
                }
                case 2: {
                    d2 /= d4;
                    break;
                }
                case 1: {
                    d2 /= 2.53807;
                    break;
                }
                case 5: {
                    d2 /= d5;
                }
            }
            switch (n2) {
                case 4: {
                    d2 *= d3;
                    break;
                }
                case 3: {
                    d2 *= 72.0;
                    break;
                }
                case 2: {
                    d2 *= d4;
                    break;
                }
                case 1: {
                    d2 *= 2.53807;
                    break;
                }
                case 5: {
                    d2 *= d5;
                }
            }
        }
        return d2;
    }

    private static Dimension GetCharacterPixelWidthAndHeight() {
        HGRectangle hGRectangle = AbstractUicontrolPeer.getFontMetricExtent(sDefaultFont, false, new String[]{"x"});
        return new Dimension((int)hGRectangle.getWidth(), (int)hGRectangle.getHeight());
    }

    public static HGRectangle convertPosition(HGRectangle hGRectangle, int n, int n2, Dimension dimension) {
        Dimension dimension2;
        double d = 1.0;
        double d2 = 1.0;
        int n3 = 0;
        boolean bl = false;
        HGRectangle hGRectangle2 = new HGRectangle();
        double d3 = 0.0;
        try {
            d3 = (Double)AWTUtilities.invokeAndWait((AWTUtilities.InvocationRunnable)new AWTUtilities.InvocationRunnable(){

                public Object runWithOutput() {
                    return (double)Toolkit.getDefaultToolkit().getScreenResolution();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        switch (n) {
            case 0: {
                d = d2 = d3;
                break;
            }
            case 3: {
                d = d2 = d3 / 72.0;
                break;
            }
            case 2: {
                d = dimension.height;
                d2 = dimension.width;
                break;
            }
            case 1: {
                d = d2 = d3 / 2.53807;
                break;
            }
            case 4: {
                n3 = -1;
                break;
            }
            case 5: {
                dimension2 = UnitPos.GetCharacterPixelWidthAndHeight();
                d2 = dimension2.width;
                d = dimension2.height;
            }
        }
        switch (n2) {
            case 0: {
                d /= d3;
                d2 /= d3;
                break;
            }
            case 3: {
                d /= d3 / 72.0;
                d2 /= d3 / 72.0;
                break;
            }
            case 2: {
                d /= (double)dimension.height;
                d2 /= (double)dimension.width;
                break;
            }
            case 1: {
                d /= d3 / 2.53807;
                d2 /= d3 / 2.53807;
                break;
            }
            case 4: {
                bl = true;
                break;
            }
            case 5: {
                dimension2 = UnitPos.GetCharacterPixelWidthAndHeight();
                d2 /= (double)dimension2.width;
                d /= (double)dimension2.height;
                break;
            }
        }
        hGRectangle2.setX((hGRectangle.getX() + (double)n3) * d2 + (double)bl);
        hGRectangle2.setWidth(hGRectangle.getWidth() * d2);
        hGRectangle2.setY((hGRectangle.getY() + (double)n3) * d + (double)bl);
        hGRectangle2.setHeight(hGRectangle.getHeight() * d);
        return hGRectangle2;
    }

    static {
        if (PlatformInfo.getPlatform() == 1) {
            sDefaultFontName = "MS Sans Serif";
            sDefaultFontSize = 11.0;
        } else {
            sDefaultFontName = "Helvetica";
            sDefaultFontSize = 10.0;
        }
        sDefaultFont = new Font(sDefaultFontName, 0, (int)sDefaultFontSize);
    }
}

