/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.ui;

import com.mathworks.hg.GraphicsVersion;
import com.mathworks.hg.peer.ComponentPositionListener;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.FigureValidator;
import com.mathworks.hg.peer.IPositionable;
import com.mathworks.hg.peer.IPrintableComponent;
import com.mathworks.hg.peer.PositionDataInDevice;
import com.mathworks.hg.peer.PositionHandler;
import com.mathworks.hg.peer.PositionListener;
import com.mathworks.hg.peer.UIComponentParentWithLayout;
import com.mathworks.hg.peer.ui.FigureUIChild;
import com.mathworks.hg.types.GUIDEViewProvider;
import com.mathworks.hg.util.FontConverter;
import com.mathworks.hg.util.HGPeerQueueUser;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.hg.util.UnicodeTextTranslator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public abstract class AbstractUIBasePeer
implements HGPeerQueueUser,
FigureUIChild,
GUIDEViewProvider,
IPrintableComponent,
IPositionable {
    private FigureUIChild fFigureUIChild;
    protected EventListenerList fListenerList = new EventListenerList();
    private PositionHandler fPositionHandler = null;
    private static final int sFirstMethodIndex = 0;
    protected static final int sAddComponent = 0;
    protected static final int sRemoveComponent = 1;
    protected static final int sSetBackgroundColor = 2;
    protected static final int sSetForegroundColor = 3;
    protected static final int sSetVisible = 4;
    protected static final int sSetPosition = 5;
    protected static final int sSetFont = 6;
    protected static final int sSetName = 7;
    protected static final int sRequestFocus = 8;
    protected static final int sInitializePeer = 9;
    protected static final int sStartFireCallback = 10;
    protected static final int sStopFireCallback = 11;
    protected static final int sSetComponentName = 12;
    protected static final int sLastBaseMethodIndex = 12;
    private static final String[] sLogMessagesBase = new String[]{"addComponent", "removeComponent", "setBackgroundColor", "setForegroundColor", "setVisible", "setPosition", "setFont", "setName", "requestFocus", "initializePeer", "startFireCallback", "stopFireCallback", "sSetComponentName"};

    protected void dispose() {
        if (this.fPositionHandler != null) {
            this.fPositionHandler.peerDestroyed();
        }
    }

    protected abstract boolean isDisposed();

    protected FigureUIChild getFigureChild() {
        if (this.fFigureUIChild == null) {
            this.fFigureUIChild = this.createFigureChild();
        }
        return this.fFigureUIChild;
    }

    protected abstract FigureUIChild createFigureChild();

    @Override
    public void addComponent(UIComponentParentWithLayout uIComponentParentWithLayout, int n) {
        this.getFigureChild().addComponent(uIComponentParentWithLayout, n);
        this.getPositionHandler().setParentForRefFrame(uIComponentParentWithLayout);
        this.getPositionHandler().updatePosition();
    }

    @Override
    public void removeComponent(UIComponentParentWithLayout uIComponentParentWithLayout) {
        this.getPositionHandler().setParentForRefFrame(null);
        this.getFigureChild().removeComponent(uIComponentParentWithLayout);
    }

    @Override
    public final void setVisible(boolean bl) {
        this.getFigureChild().setVisible(bl);
    }

    protected boolean doPreSetVisible(boolean bl) {
        this.getFigureChild().addLogMessage(4);
        return true;
    }

    @Override
    public void doSetVisible(boolean bl) {
        if (!this.isDisposed()) {
            this.getFigureChild().doSetVisible(bl);
        }
    }

    @Override
    public boolean isVisible() {
        return this.getFigureChild().isVisible();
    }

    public final void setPosition(double d, double d2, double d3, double d4) {
        this.getPositionHandler().setPosition((int)d, (int)d2, (int)d3, (int)d4);
    }

    @Override
    public void doSetPosition(final Rectangle rectangle) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 5, 7, false){

            @Override
            public void run() {
                if (!AbstractUIBasePeer.this.isDisposed()) {
                    AbstractUIBasePeer.this.getFigureChild().doSetPosition(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
                }
            }
        });
    }

    @Override
    public void doSetPosition(double d, double d2, double d3, double d4) {
    }

    @Override
    public void addLogMessage(int n) {
        this.getFigureChild().addLogMessage(n);
    }

    @Override
    public void handleMouseEvent(MouseEvent mouseEvent, boolean bl) {
        this.getFigureChild().handleMouseEvent(mouseEvent, bl);
    }

    @Override
    public void handleMouseWheelEvent(MouseWheelEvent mouseWheelEvent) {
        this.getFigureChild().handleMouseWheelEvent(mouseWheelEvent);
    }

    public final void setBackgroundColor(final Color color) {
        if (this.doPreSetBackgroundColor(color)) {
            HGUtils.invokeLater(new HGPeerRunnable(this.getSourceHGPeer(), 2, 7){

                @Override
                public void run() {
                    AbstractUIBasePeer.this.doSetBackgroundColor(color);
                }
            });
        }
    }

    public void setForegroundColor(final Color color) {
        if (this.doPreSetForegroundColor(color)) {
            HGUtils.invokeLater(new HGPeerRunnable(this.getSourceHGPeer(), 3, 7){

                @Override
                public void run() {
                    AbstractUIBasePeer.this.doSetForegroundColor(color);
                }
            });
        }
    }

    protected HGPeerQueueUser getSourceHGPeer() {
        return this;
    }

    public final void setFont(Font font) {
        final Font font2 = this.deriveFont(font);
        if (this.doPreSetFont(font2)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 6, 7){

                @Override
                public void run() {
                    AbstractUIBasePeer.this.doSetFont(font2);
                }
            });
        }
    }

    public final void setFont(String string, double d, int n, int n2) {
        Font font = FontConverter.convertToJavaFont(string, d, n, n2);
        this.setFont(font);
    }

    public void setComponentName(final String string) {
        if (this.doPreSetName(string)) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 7, 7){

                @Override
                public void run() {
                    AbstractUIBasePeer.this.doSetName(string);
                }
            });
        }
    }

    protected boolean doPreSetName(String string) {
        return true;
    }

    protected void doSetName(String string) {
        if (!this.isDisposed()) {
            this.getUIComponent().setName(string);
        }
    }

    public final void startFireCallback() {
        if (this.doPreStartFireCallback()) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 10, 8){

                @Override
                public void run() {
                    AbstractUIBasePeer.this.doStartFireCallback();
                }
            });
        }
    }

    public final void stopFireCallback() {
        if (this.doPreStopFireCallback()) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 11, 8){

                @Override
                public void run() {
                    AbstractUIBasePeer.this.doStopFireCallback();
                }
            });
        }
    }

    protected boolean doPreSetBackgroundColor(Color color) {
        this.getFigureChild().addLogMessage(2);
        return true;
    }

    protected void doSetBackgroundColor(Color color) {
        if (!this.isDisposed()) {
            this.getUIComponent().setBackground(color);
        }
    }

    protected boolean doPreSetForegroundColor(Color color) {
        this.getFigureChild().addLogMessage(3);
        return true;
    }

    protected void doSetForegroundColor(Color color) {
        if (!this.isDisposed()) {
            this.getUIComponent().setForeground(color);
        }
    }

    protected boolean doPreSetFont(Font font) {
        this.getFigureChild().addLogMessage(6);
        return true;
    }

    protected void doSetFont(Font font) {
        if (!this.isDisposed()) {
            this.getUIComponent().setFont(font);
        }
    }

    protected boolean doPreStartFireCallback() {
        this.addLogMessage(10);
        return true;
    }

    protected void doStartFireCallback() {
    }

    protected boolean doPreStopFireCallback() {
        this.addLogMessage(11);
        return true;
    }

    protected void doStopFireCallback() {
    }

    private Font deriveFont(Font font) {
        return UnicodeTextTranslator.deriveFont(font);
    }

    public Color getBackgroundColor() {
        return this.getUIComponent().getBackground();
    }

    public void addLogMessage(int n, String string) {
        if (DebugUtilities.isDebugOptions()) {
            DebugUtilities.logMessage(n, string, this);
        }
    }

    public void requestFocus() {
        if (this.doPreRequestFocus()) {
            HGUtils.invokeLater(new HGPeerRunnable(this, 8, 7){

                @Override
                public void run() {
                    AbstractUIBasePeer.this.doRequestFocus();
                }
            });
        }
    }

    protected boolean doPreRequestFocus() {
        this.getFigureChild().addLogMessage(8);
        return true;
    }

    protected void doRequestFocus() {
        if (!this.isDisposed()) {
            if (!this.getUIComponent().isFocusOwner()) {
                this.addLogMessage(1024, "Clear global focus owner.");
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                keyboardFocusManager.clearGlobalFocusOwner();
            }
            if (GraphicsVersion.isGraphicsVersion1()) {
                this.manageFocusRequest();
            }
            this.getUIComponent().requestFocus();
        }
    }

    @Override
    public void manageFocusRequest() {
        this.getFigureChild().manageFocusRequest();
    }

    @Override
    public UIComponentParentWithLayout getComponentParent() {
        return this.getFigureChild().getComponentParent();
    }

    @Override
    public int getUserLastMethodID() {
        return AbstractUIBasePeer.getLastMethodIndex();
    }

    @Override
    public String getUserMethodDescription(int n) {
        String string = null;
        if (n >= 0 && n <= 12) {
            string = sLogMessagesBase[n - 0];
        } else assert (false);
        return string;
    }

    protected static int getLastMethodIndex() {
        return 12;
    }

    @Override
    public FigureValidator getParentFigureValidator() {
        return this.getComponentParent();
    }

    protected abstract void createPeerComponentImpl();

    protected abstract JComponent getUIComponent();

    protected abstract Component getTopLevelComponent();

    protected void createPeerComponent() {
        this.createPeerComponentImpl();
        this.getPositionHandler().peerCreated();
    }

    @Override
    public abstract JComponent getPrintableComponent();

    @Override
    public abstract JComponent getGUIDEView();

    @Override
    public void addGUIDEViewListeners(EventListener[] eventListenerArray) {
    }

    protected void cleanup() {
    }

    @Override
    public void addPositionListener(PositionListener positionListener) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Must add PositionListener on the Matlab thread";
        this.getPositionHandler().addPositionListener(positionListener);
    }

    @Override
    public void removePositionListener(PositionListener positionListener) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Must remove PositionListener on the Matlab thread";
        this.getPositionHandler().removePositionListener(positionListener);
    }

    @Override
    public PositionDataInDevice getPositionInDevice() {
        assert (SwingUtilities.isEventDispatchThread()) : "Must query position in device coordinates on the EDT";
        Rectangle rectangle = this.getOuterBoundsComponent().getBounds();
        return new PositionDataInDevice(rectangle);
    }

    @Override
    public ComponentPositionListener createPeerPositionListener() {
        return new ComponentPositionListener(this.getPositionHandler());
    }

    @Override
    public void addPeerPositionListener(ComponentPositionListener componentPositionListener) {
        this.getOuterBoundsComponent().addComponentListener(componentPositionListener);
    }

    @Override
    public void removePeerPositionListener(ComponentPositionListener componentPositionListener) {
        Component component = this.getOuterBoundsComponent();
        if (component != null) {
            component.removeComponentListener(componentPositionListener);
        }
    }

    protected Component getOuterBoundsComponent() {
        return this.getTopLevelComponent();
    }

    protected PositionHandler getPositionHandler() {
        if (this.fPositionHandler == null) {
            this.fPositionHandler = new PositionHandler(this);
        }
        return this.fPositionHandler;
    }
}

