/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.ui.borders;

import com.mathworks.mwswing.FontUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class TitledBorder
extends AbstractBorder {
    protected String title;
    protected Border border;
    protected int titlePosition;
    protected int titleJustification;
    protected Font titleFont;
    protected Color titleColor;
    private Insets fGrooveInsets;
    private Point textLoc = new Point();
    public static final int DEFAULT_POSITION = 0;
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    public static final int DEFAULT_JUSTIFICATION = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int LEADING = 4;
    public static final int TRAILING = 5;
    protected static final int EDGE_SPACING = 0;
    protected static final int TEXT_SPACING = 0;
    protected static final int TEXT_INSET_H = 5;
    private Rectangle fTitleBounds;

    public TitledBorder(String string) {
        this(null, string, 4, 2, null, null);
    }

    public TitledBorder(Border border) {
        this(border, "", 4, 2, null, null);
    }

    public TitledBorder(Border border, String string) {
        this(border, string, 4, 2, null, null);
    }

    public TitledBorder(Border border, String string, int n, int n2) {
        this(border, string, n, n2, null, null);
    }

    public TitledBorder(Border border, String string, int n, int n2, Font font) {
        this(border, string, n, n2, font, null);
    }

    public TitledBorder(Border border, String string, int n, int n2, Font font, Color color) {
        this.title = string;
        this.border = border;
        this.titleFont = font;
        this.titleColor = color;
        this.fGrooveInsets = new Insets(0, 0, 0, 0);
        this.fTitleBounds = null;
        this.setTitleJustification(n);
        this.setTitlePosition(n2);
    }

    public static FontMetrics getFontMetrics(JComponent jComponent, Graphics graphics) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String string = TitledBorder.getSwingUtilitiesClassName();
        Class<?> clazz = Class.forName(string);
        Object[] objectArray = new Object[]{jComponent, graphics};
        Method method = clazz.getMethod("getFontMetrics", JComponent.class, Graphics.class);
        FontMetrics fontMetrics = (FontMetrics)method.invoke(null, objectArray);
        return fontMetrics;
    }

    public static int stringWidth(JComponent jComponent, FontMetrics fontMetrics, String string) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String string2 = TitledBorder.getSwingUtilitiesClassName();
        Class<?> clazz = Class.forName(string2);
        Object[] objectArray = new Object[]{jComponent, fontMetrics, string};
        Method method = clazz.getMethod("stringWidth", JComponent.class, FontMetrics.class, String.class);
        int n = (Integer)method.invoke(null, objectArray);
        return n;
    }

    public static void drawString(JComponent jComponent, Graphics graphics, String string, int n, int n2) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String string2 = TitledBorder.getSwingUtilitiesClassName();
        Class<?> clazz = Class.forName(string2);
        Object[] objectArray = new Object[]{jComponent, graphics, string, n, n2};
        Method method = clazz.getMethod("drawString", JComponent.class, Graphics.class, String.class, Integer.TYPE, Integer.TYPE);
        method.invoke(null, objectArray);
    }

    private static String getSwingUtilitiesClassName() {
        String string = PlatformInfo.isVersion15() ? "com.sun.java.swing.SwingUtilities2" : "sun.swing.SwingUtilities2";
        return string;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Border border = this.getBorder();
        String string = this.getTitle();
        if (string == null || string.trim().isEmpty()) {
            if (border != null) {
                border.paintBorder(component, graphics, n, n2, n3, n4);
            }
            return;
        }
        Rectangle rectangle = new Rectangle(n + 0, n2 + 0, n3 - 0, n4 - 0);
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        graphics.setFont(this.getFont(component));
        Graphics2D graphics2D = (Graphics2D)graphics;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(this.getTitle(), font, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        double d = textLayout.getAscent() + textLayout.getDescent();
        rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), d);
        this.fTitleBounds = rectangle2D.getBounds();
        int n5 = (int)this.fTitleBounds.getWidth() + 1;
        int n6 = (int)this.fTitleBounds.getHeight() + 1;
        int n7 = n6 / 2;
        Insets insets = border != null ? border.getBorderInsets(component) : new Insets(0, 0, 0, 0);
        int n8 = insets.left;
        int n9 = 0;
        int n10 = this.getTitlePosition();
        switch (n10) {
            case 0: 
            case 2: {
                n9 = n8 < n6 ? n7 - n8 / 2 : 0;
                rectangle.y += n9;
                rectangle.height -= n9;
                this.textLoc.y = (int)textLayout.getAscent() + 1;
                break;
            }
            case 5: {
                n9 = n8 < n6 ? n7 - n8 / 2 : 0;
                rectangle.height -= n9;
                this.textLoc.y = n4 - (int)textLayout.getDescent() + 1;
            }
        }
        component.doLayout();
        int n11 = this.getTitleJustification();
        if (component.getComponentOrientation().isLeftToRight()) {
            if (n11 == 4 || n11 == 0) {
                n11 = 1;
            } else if (n11 == 5) {
                n11 = 3;
            }
        } else if (n11 == 4 || n11 == 0) {
            n11 = 3;
        } else if (n11 == 5) {
            n11 = 1;
        }
        switch (n11) {
            case 1: {
                this.textLoc.x = rectangle.x + 5 + insets.left;
                break;
            }
            case 3: {
                this.textLoc.x = rectangle.x + rectangle.width - (n5 + 5 + insets.right);
                break;
            }
            case 2: {
                this.textLoc.x = rectangle.x + (rectangle.width - n5) / 2;
            }
        }
        JComponent jComponent = component instanceof JComponent ? (JComponent)component : null;
        FontMetrics fontMetrics = null;
        try {
            fontMetrics = TitledBorder.getFontMetrics(jComponent, graphics);
        }
        catch (Exception exception) {
            throw new Error("Has JVM changed? Unable to get font metrics");
        }
        int n12 = fontMetrics.getDescent();
        int n13 = fontMetrics.getAscent();
        if (border != null) {
            if ((n10 == 2 || n10 == 0) && rectangle.y > this.textLoc.y - n13 || n10 == 5 && rectangle.y + rectangle.height < this.textLoc.y + n12) {
                Rectangle rectangle2 = new Rectangle();
                Rectangle rectangle3 = graphics.getClipBounds();
                rectangle2.setBounds(rectangle3);
                if (TitledBorder.computeIntersection(rectangle2, n, n2, this.textLoc.x - 1 - n, n4)) {
                    graphics.setClip(rectangle2);
                    border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                rectangle2.setBounds(rectangle3);
                if (TitledBorder.computeIntersection(rectangle2, this.textLoc.x + n5 + 1, n2, n + n3 - (this.textLoc.x + n5 + 1), n4)) {
                    graphics.setClip(rectangle2);
                    border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                if (n10 == 2 || n10 == 0) {
                    rectangle2.setBounds(rectangle3);
                    if (TitledBorder.computeIntersection(rectangle2, this.textLoc.x - 1, this.textLoc.y + n12, n5 + 2, n2 + n4 - this.textLoc.y - n12)) {
                        graphics.setClip(rectangle2);
                        border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                } else {
                    rectangle2.setBounds(rectangle3);
                    if (TitledBorder.computeIntersection(rectangle2, this.textLoc.x - 1, n2, n5 + 2, this.textLoc.y - n13 - n2)) {
                        graphics.setClip(rectangle2);
                        border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                }
                graphics.setClip(rectangle3);
            } else {
                border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        graphics.setColor(component.getBackground());
        graphics.fillRect(this.textLoc.x - 1, this.textLoc.y - n13 - n2, n5 + 5, fontMetrics.getHeight());
        graphics.setColor(this.getTitleColor());
        try {
            TitledBorder.drawString(jComponent, graphics, this.getTitle(), this.textLoc.x, this.textLoc.y);
        }
        catch (Exception exception) {
            throw new DrawStringException("Unable to draw the title in TitledBorder.java: (" + exception + ") " + exception.getMessage());
        }
        graphics.setFont(font);
        graphics.setColor(color);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        Border border = this.getBorder();
        if (border != null) {
            if (border instanceof AbstractBorder) {
                insets = ((AbstractBorder)border).getBorderInsets(component, insets);
            } else {
                Insets insets2 = border.getBorderInsets(component);
                insets.top = insets2.top;
                insets.right = insets2.right;
                insets.bottom = insets2.bottom;
                insets.left = insets2.left;
            }
        } else {
            insets.bottom = 0;
            insets.right = 0;
            insets.top = 0;
            insets.left = 0;
        }
        if (component == null || this.getTitle() == null || this.getTitle().equals("")) {
            return insets;
        }
        switch (this.getTitlePosition()) {
            case 0: 
            case 2: {
                int n = 1;
                int n2 = this.fTitleBounds == null ? n : (int)this.fTitleBounds.getHeight();
                insets.top = Math.max(n2, insets.top);
                break;
            }
            case 5: {
                int n = 1;
                int n3 = this.fTitleBounds == null ? n : (int)this.fTitleBounds.getHeight();
                insets.bottom = Math.max(n3, insets.bottom);
            }
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public Border getBorder() {
        Border border = this.border;
        if (border == null) {
            border = UIManager.getBorder("TitledBorder.border");
        }
        return border;
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    public int getTitleJustification() {
        return this.titleJustification;
    }

    public Font getTitleFont() {
        Font font = this.titleFont;
        if (font == null) {
            font = UIManager.getFont("TitledBorder.font");
        }
        if (font == null) {
            font = FontUtils.getSystemUIFont();
        }
        return font;
    }

    public Color getTitleColor() {
        Color color = this.titleColor;
        if (color == null) {
            color = UIManager.getColor("TitledBorder.titleColor");
        }
        return color;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public void setTitlePosition(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.titlePosition = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(n + " is not a valid title position.");
            }
        }
    }

    public void setTitleJustification(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.titleJustification = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(n + " is not a valid title justification.");
            }
        }
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
    }

    public void setTitleColor(Color color) {
        this.titleColor = color;
    }

    public Dimension getMinimumSize(Component component) {
        Insets insets = this.getBorderInsets(component);
        Dimension dimension = new Dimension(insets.right + insets.left, insets.top + insets.bottom);
        Font font = this.getFont(component);
        FontMetrics fontMetrics = component.getFontMetrics(font);
        JComponent jComponent = component instanceof JComponent ? (JComponent)component : null;
        switch (this.titlePosition) {
            case 1: 
            case 6: {
                try {
                    dimension.width = Math.max(TitledBorder.stringWidth(jComponent, fontMetrics, this.getTitle()), dimension.width);
                    break;
                }
                catch (Exception exception) {
                    throw new Error("Has JVM changed? Unable to calculate the string width");
                }
            }
            default: {
                try {
                    dimension.width += TitledBorder.stringWidth(jComponent, fontMetrics, this.getTitle());
                    break;
                }
                catch (Exception exception) {
                    throw new Error("Has JVM changed? Unable to calculate the string width");
                }
            }
        }
        return dimension;
    }

    protected Font getFont(Component component) {
        Font font = this.getTitleFont();
        if (font != null) {
            return font;
        }
        if (component != null && (font = component.getFont()) != null) {
            return font;
        }
        return new Font("Dialog", 0, 12);
    }

    private static boolean computeIntersection(Rectangle rectangle, int n, int n2, int n3, int n4) {
        int n5 = Math.max(n, rectangle.x);
        int n6 = Math.min(n + n3, rectangle.x + rectangle.width);
        int n7 = Math.max(n2, rectangle.y);
        int n8 = Math.min(n2 + n4, rectangle.y + rectangle.height);
        rectangle.x = n5;
        rectangle.y = n7;
        rectangle.width = n6 - n5;
        rectangle.height = n8 - n7;
        return rectangle.width > 0 && rectangle.height > 0;
    }

    public class DrawStringException
    extends RuntimeException {
        DrawStringException(String string) {
            super(string);
        }
    }
}

