/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.utils;

import com.mathworks.hg.peer.utils.MatlabIconComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.plaf.UIResource;

public class MatlabIconFactory
implements Serializable {
    private static Icon sEmptyMenuIcon;
    private static Icon sCheckBoxMenuItemIcon;

    public static Icon getEmptyMenuIcon() {
        if (sEmptyMenuIcon == null) {
            sEmptyMenuIcon = new EmptyMenuIcon();
        }
        return sEmptyMenuIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (sCheckBoxMenuItemIcon == null) {
            sCheckBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return sCheckBoxMenuItemIcon;
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private CheckBoxMenuItemIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            boolean bl = ((MatlabIconComponent)((Object)component)).isIconDrawable();
            if (bl) {
                Color color = graphics.getColor();
                graphics.setColor(component.getForeground());
                graphics.drawLine(n + 7, n2 + 1, n + 7, n2 + 3);
                graphics.drawLine(n + 6, n2 + 2, n + 6, n2 + 4);
                graphics.drawLine(n + 5, n2 + 3, n + 5, n2 + 5);
                graphics.drawLine(n + 4, n2 + 4, n + 4, n2 + 6);
                graphics.drawLine(n + 3, n2 + 5, n + 3, n2 + 7);
                graphics.drawLine(n + 2, n2 + 4, n + 2, n2 + 6);
                graphics.drawLine(n + 1, n2 + 3, n + 1, n2 + 5);
                graphics.setColor(color);
            }
        }

        @Override
        public int getIconWidth() {
            return 9;
        }

        @Override
        public int getIconHeight() {
            return 9;
        }
    }

    private static class EmptyMenuIcon
    implements Icon,
    Serializable {
        private EmptyMenuIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        @Override
        public int getIconWidth() {
            return 9;
        }

        @Override
        public int getIconHeight() {
            return 9;
        }
    }
}

