/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import com.mathworks.hg.print.ColorConverter;
import com.mathworks.hg.print.TextureInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class ColorSpaceColorConverter
implements ColorConverter {
    private ColorSpace fCS;

    public ColorSpaceColorConverter(ColorSpace colorSpace) {
        this.fCS = colorSpace;
    }

    @Override
    public Color convert(Graphics2D graphics2D, Color color) {
        float[] fArray = color.getColorSpace().getType() == 5 || color.getColorSpace().getType() == 6 ? this.fCS.fromRGB(color.getRGBColorComponents(null)) : color.getColorComponents(this.fCS, null);
        return new Color(this.fCS, fArray, (float)color.getAlpha() / 255.0f);
    }

    @Override
    public BufferedImage convertImage(Graphics2D graphics2D, BufferedImage bufferedImage) {
        ColorModel colorModel = bufferedImage.getColorModel();
        WritableRaster writableRaster = bufferedImage.getRaster();
        ComponentColorModel componentColorModel = new ComponentColorModel(this.fCS, colorModel.hasAlpha(), colorModel.isAlphaPremultiplied(), colorModel.getTransparency(), 0);
        WritableRaster writableRaster2 = this.convertRaster(writableRaster, colorModel, componentColorModel);
        return new BufferedImage(componentColorModel, writableRaster2, componentColorModel.isAlphaPremultiplied(), null);
    }

    @Override
    public Paint convertPaint(Graphics2D graphics2D, Paint paint) {
        return new ColorSpaceChangingPaint(this.fCS, paint);
    }

    private WritableRaster convertRaster(Raster raster, ColorModel colorModel, ColorModel colorModel2) {
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        WritableRaster writableRaster = colorModel2.createCompatibleWritableRaster(n, n2);
        ColorSpace colorSpace = colorModel.getColorSpace();
        ColorSpace colorSpace2 = colorModel2.getColorSpace();
        ImageComponentConverter imageComponentConverter = colorSpace.getType() == 5 ? new ImageComponentConverter(){

            @Override
            public float[] convertComponents(ColorSpace colorSpace, ColorSpace colorSpace2, float[] fArray) {
                return colorSpace2.fromRGB(fArray);
            }
        } : (colorSpace.getType() == 6 ? new ImageComponentConverter(){

            @Override
            public float[] convertComponents(ColorSpace colorSpace, ColorSpace colorSpace2, float[] fArray) {
                float[] fArray2 = colorSpace.toRGB(fArray);
                return colorSpace2.fromRGB(fArray2);
            }
        } : new ImageComponentConverter(){

            @Override
            public float[] convertComponents(ColorSpace colorSpace, ColorSpace colorSpace2, float[] fArray) {
                float[] fArray2 = colorSpace.toCIEXYZ(fArray);
                return colorSpace2.fromCIEXYZ(fArray2);
            }
        });
        int n3 = colorModel.getNumComponents();
        int n4 = colorModel2.getNumComponents();
        int[] nArray = new int[n3];
        float[] fArray = new float[n3];
        int[] nArray2 = new int[n4];
        float[] fArray2 = new float[n4];
        int[] nArray3 = new int[n3];
        boolean bl = false;
        boolean bl2 = colorModel.hasAlpha();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                nArray = raster.getPixel(i, j, nArray);
                if (!bl || !Arrays.equals(nArray, nArray3)) {
                    fArray = colorModel.getNormalizedComponents(nArray, 0, fArray, 0);
                    float[] fArray3 = imageComponentConverter.convertComponents(colorSpace, colorSpace2, fArray);
                    if (bl2) {
                        System.arraycopy(fArray3, 0, fArray2, 0, n4 - 1);
                        fArray2[n4 - 1] = fArray[n3 - 1];
                        nArray2 = colorModel2.getUnnormalizedComponents(fArray2, 0, nArray2, 0);
                    } else {
                        nArray2 = colorModel2.getUnnormalizedComponents(fArray3, 0, nArray2, 0);
                    }
                    int[] nArray4 = nArray3;
                    nArray3 = nArray;
                    nArray = nArray4;
                    bl = true;
                }
                writableRaster.setPixel(i, j, nArray2);
            }
        }
        return writableRaster;
    }

    private class ColorSpaceChangingPaint
    implements Paint,
    TextureInfo {
        private Paint fRealPaint;
        private ColorSpace fDestCS;

        public ColorSpaceChangingPaint(ColorSpace colorSpace, Paint paint) {
            this.fDestCS = colorSpace;
            this.fRealPaint = paint;
        }

        @Override
        public Dimension getBestTextureSize() {
            if (this.fRealPaint instanceof TextureInfo) {
                return ((TextureInfo)((Object)this.fRealPaint)).getBestTextureSize();
            }
            return new Dimension(-1, -1);
        }

        @Override
        public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
            PaintContext paintContext = this.fRealPaint.createContext(colorModel, rectangle, rectangle2D, affineTransform, renderingHints);
            return new ColorSpaceChangingPaintContext(paintContext);
        }

        @Override
        public int getTransparency() {
            return this.fRealPaint.getTransparency();
        }

        private class ColorSpaceChangingPaintContext
        implements PaintContext {
            private ColorModel fDestColorModel;
            private PaintContext fRealContext;

            public ColorSpaceChangingPaintContext(PaintContext paintContext) {
                this.fRealContext = paintContext;
                ColorModel colorModel = this.fRealContext.getColorModel();
                this.fDestColorModel = new ComponentColorModel(ColorSpaceChangingPaint.this.fDestCS, colorModel.hasAlpha(), colorModel.isAlphaPremultiplied(), colorModel.getTransparency(), 0);
            }

            @Override
            public void dispose() {
                this.fRealContext.dispose();
            }

            @Override
            public ColorModel getColorModel() {
                return this.fDestColorModel;
            }

            @Override
            public Raster getRaster(int n, int n2, int n3, int n4) {
                Raster raster = this.fRealContext.getRaster(n, n2, n3, n4);
                ColorModel colorModel = this.fRealContext.getColorModel();
                return ColorSpaceColorConverter.this.convertRaster(raster, colorModel, this.fDestColorModel);
            }
        }
    }

    private static interface ImageComponentConverter {
        public float[] convertComponents(ColorSpace var1, ColorSpace var2, float[] var3);
    }
}

