/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import com.mathworks.hg.print.CMYKColorSpace;
import com.mathworks.hg.print.StringReplaceOutputStream;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import org.apache.xmlgraphics.java2d.ps.AbstractPSDocumentGraphics2D;
import org.apache.xmlgraphics.java2d.ps.PSGraphics2D;

public class MWPSGraphics2D
extends PSGraphics2D {
    private ImageType fImageType = ImageType.RGB;
    private StringReplaceOutputStream fCMYKStreamFixer = null;
    private AbstractPSDocumentGraphics2D fDocumentGraphics = null;

    public MWPSGraphics2D(PSGraphics2D pSGraphics2D) {
        super(pSGraphics2D);
        if (pSGraphics2D instanceof AbstractPSDocumentGraphics2D) {
            this.fDocumentGraphics = (AbstractPSDocumentGraphics2D)pSGraphics2D;
        } else if (pSGraphics2D instanceof MWPSGraphics2D) {
            MWPSGraphics2D mWPSGraphics2D = (MWPSGraphics2D)pSGraphics2D;
            this.initFrom(mWPSGraphics2D);
        }
    }

    public MWPSGraphics2D(PSGraphics2D pSGraphics2D, AbstractPSDocumentGraphics2D abstractPSDocumentGraphics2D) {
        this(pSGraphics2D);
        this.fDocumentGraphics = abstractPSDocumentGraphics2D;
    }

    public MWPSGraphics2D(PSGraphics2D pSGraphics2D, MWPSGraphics2D mWPSGraphics2D) {
        this(pSGraphics2D);
        this.initFrom(mWPSGraphics2D);
    }

    public MWPSGraphics2D(boolean bl) {
        super(bl);
    }

    private void initFrom(MWPSGraphics2D mWPSGraphics2D) {
        this.fDocumentGraphics = mWPSGraphics2D.getRootDocument();
        this.fCMYKStreamFixer = mWPSGraphics2D.fCMYKStreamFixer;
        this.fImageType = mWPSGraphics2D.fImageType;
    }

    public static MWPSGraphics2D createFromGraphics(Graphics graphics, AbstractPSDocumentGraphics2D abstractPSDocumentGraphics2D) {
        if (graphics instanceof PSGraphics2D) {
            return new MWPSGraphics2D((PSGraphics2D)graphics, abstractPSDocumentGraphics2D);
        }
        return new MWPSGraphics2D((PSGraphics2D)abstractPSDocumentGraphics2D);
    }

    public static MWPSGraphics2D createFromGraphics(Graphics graphics, MWPSGraphics2D mWPSGraphics2D) {
        if (graphics instanceof PSGraphics2D) {
            return new MWPSGraphics2D((PSGraphics2D)graphics, mWPSGraphics2D);
        }
        return new MWPSGraphics2D(mWPSGraphics2D);
    }

    public Graphics create() {
        Graphics graphics = super.create();
        return MWPSGraphics2D.createFromGraphics(graphics, this);
    }

    public AbstractPSDocumentGraphics2D getRootDocument() {
        return this.fDocumentGraphics;
    }

    public boolean shouldBeClipped(Shape shape, Shape shape2) {
        if (shape == null || shape2 == null) {
            return false;
        }
        Area area = new Area(shape2);
        Rectangle2D rectangle2D = shape2.getBounds2D();
        if (area.isEmpty() && (rectangle2D.getWidth() > 0.0 || rectangle2D.getHeight() > 0.0)) {
            return !shape.contains(rectangle2D);
        }
        return super.shouldBeClipped(shape, shape2);
    }

    public void setImageType(ImageType imageType) {
        this.fImageType = imageType;
        if (this.fCMYKStreamFixer != null) {
            this.fCMYKStreamFixer.setMatchEnabled(imageType == ImageType.CMYK);
        }
    }

    public ImageType getImageType() {
        return this.fImageType;
    }

    public void setCMYKStreamFixer(StringReplaceOutputStream stringReplaceOutputStream) {
        this.fCMYKStreamFixer = stringReplaceOutputStream;
        this.fCMYKStreamFixer.addMatchAndReplace("/DeviceRGB setcolorspace", "/DeviceCMYK setcolorspace");
        this.fCMYKStreamFixer.addMatchAndReplace("/Decode [0 1 0 1 0 1]", "/Decode [0 1 0 1 0 1 0 1]");
        this.fCMYKStreamFixer.setMatchEnabled(this.fImageType == ImageType.CMYK);
    }

    public void setImageTypeFor(Image image) {
        if (image instanceof RenderedImage) {
            this.setRenderedImageTypeFor((RenderedImage)((Object)image));
        } else {
            this.setImageType(ImageType.RGB);
        }
    }

    private void setRenderedImageTypeFor(RenderedImage renderedImage) {
        ColorSpace colorSpace = renderedImage.getColorModel().getColorSpace();
        switch (colorSpace.getType()) {
            case 6: {
                this.setImageType(ImageType.GRAY);
                break;
            }
            case 9: {
                if (this.fCMYKStreamFixer != null) {
                    this.setImageType(ImageType.CMYK);
                    break;
                }
                this.setImageType(ImageType.RGB);
                break;
            }
            default: {
                this.setImageType(ImageType.RGB);
            }
        }
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        this.setImageTypeFor(image);
        boolean bl = super.drawImage(image, n, n2, imageObserver);
        this.setImageType(ImageType.RGB);
        return bl;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this.setImageTypeFor(image);
        boolean bl = super.drawImage(image, n, n2, n3, n4, imageObserver);
        this.setImageType(ImageType.RGB);
        return bl;
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.setRenderedImageTypeFor(renderedImage);
        super.drawRenderedImage(renderedImage, affineTransform);
        this.setImageType(ImageType.RGB);
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        if (renderableImage instanceof RenderedImage) {
            this.drawRenderedImage((RenderedImage)((Object)renderableImage), affineTransform);
        } else {
            super.drawRenderableImage(renderableImage, affineTransform);
        }
    }

    public BufferedImage buildBufferedImage(Dimension dimension) {
        switch (this.fImageType) {
            case GRAY: {
                return new BufferedImage(dimension.width, dimension.height, 10);
            }
            case CMYK: {
                ComponentColorModel componentColorModel = new ComponentColorModel(new CMYKColorSpace(), false, true, 1, 0);
                WritableRaster writableRaster = ((ColorModel)componentColorModel).createCompatibleWritableRaster(dimension.width, dimension.height);
                return new BufferedImage(componentColorModel, writableRaster, true, null);
            }
        }
        return super.buildBufferedImage(dimension);
    }

    public static enum ImageType {
        RGB,
        GRAY,
        CMYK;

    }
}

