/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.render.ps.NativeTextHandler;
import org.apache.xmlgraphics.java2d.StrokingTextHandler;
import org.apache.xmlgraphics.java2d.ps.PSGraphics2D;
import org.apache.xmlgraphics.ps.PSGenerator;

public class MWTextHandler
extends NativeTextHandler {
    protected StrokingTextHandler fStrokingTextHandler = new StrokingTextHandler();

    public MWTextHandler(PSGraphics2D pSGraphics2D, FontInfo fontInfo) {
        super(pSGraphics2D, fontInfo);
    }

    public void drawString(Graphics2D graphics2D, String string, float f, float f2) throws IOException {
        if (MWTextHandler.stringHasUnicodeChars(string)) {
            this.fStrokingTextHandler.drawString(graphics2D, string, f, f2);
        } else {
            this.drawFontString(graphics2D, string, f, f2);
        }
    }

    public void drawFontString(Graphics2D graphics2D, String string, float f, float f2) throws IOException {
        Font font;
        PSGraphics2D pSGraphics2D = (PSGraphics2D)graphics2D;
        pSGraphics2D.preparePainting();
        PSGenerator pSGenerator = pSGraphics2D.getPSGenerator();
        pSGenerator.saveGraphicsState();
        AffineTransform affineTransform = pSGraphics2D.getTransform();
        pSGenerator.concatMatrix(affineTransform);
        Rectangle rectangle = pSGraphics2D.getClipBounds();
        pSGraphics2D.setTransform(new AffineTransform());
        pSGraphics2D.setClip((Shape)rectangle);
        this.currentFontName = "";
        if (pSGraphics2D.getFont().getFontName().startsWith("Times New")) {
            this.overrideFont = this.fontInfo.getFontInstanceForAWTFont(new Font("Times", pSGraphics2D.getFont().getStyle(), pSGraphics2D.getFont().getSize()));
        } else if (pSGraphics2D.getFont().getFontName().startsWith("Courier New")) {
            this.overrideFont = this.fontInfo.getFontInstanceForAWTFont(new Font("Courier", pSGraphics2D.getFont().getStyle(), pSGraphics2D.getFont().getSize()));
        } else if (pSGraphics2D.getFont().getFontName().contains("Schoolbook")) {
            this.overrideFont = this.fontInfo.getFontInstanceForAWTFont(new Font("NewCenturySchoolbook", pSGraphics2D.getFont().getStyle(), pSGraphics2D.getFont().getSize()));
        } else if (pSGraphics2D.getFont().getFontName().contains(" ")) {
            font = new Font(pSGraphics2D.getFont().getPSName(), pSGraphics2D.getFont().getStyle(), pSGraphics2D.getFont().getSize());
            this.overrideFont = this.fontInfo.getFontInstanceForAWTFont(font);
        }
        font = pSGraphics2D.getFont();
        if ((font.getName().contains("Helvetica") || font.getName().contains("Courier") || font.getName().contains("Times")) && (font.isBold() || font.isItalic())) {
            String string2 = this.overrideFont != null ? this.overrideFont.getFontTriplet().getName() : font.getName();
            String string3 = string2 + "-" + (font.isBold() ? "Bold" : "") + (font.isItalic() ? "Italic" : "");
            FontTriplet fontTriplet = new FontTriplet(string3, font.isItalic() ? "italic" : "normal", font.isBold() ? 700 : 400);
            this.overrideFont = this.fontInfo.getFontInstance(fontTriplet, Math.round(pSGraphics2D.getFont().getSize2D() * 1000.0f));
            this.currentFontName = string3;
        }
        super.drawString(graphics2D, string, f, f2);
        this.overrideFont = null;
        pSGraphics2D.setTransform(affineTransform);
        pSGraphics2D.setClip((Shape)rectangle);
        pSGenerator.restoreGraphicsState();
    }

    public static boolean stringHasUnicodeChars(String string) {
        char[] cArray;
        for (char c : cArray = string.toCharArray()) {
            if (MWTextHandler.isAscii(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAscii(char c) {
        return c < '\u0100';
    }
}

