/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.print;

import com.mathworks.hg.print.BatikHelperDefinition;
import com.mathworks.hg.print.FOPDefinitions;
import com.mathworks.hg.print.MWEMFDefinition;
import com.mathworks.hg.print.OutputHelperDefinition;
import com.mathworks.hg.print.PrintHelperDefinition;
import com.mathworks.hg.print.RasterHelperDefinition;
import com.mathworks.hg.util.MPrintJob;
import com.mathworks.hg.util.OutputHelper;
import java.util.HashMap;

public class OutputHelperFactory {
    private static final OutputHelperFactory sInstance = new OutputHelperFactory();
    private HashMap<String, OutputHelperDefinition> fDefinitionMap = new HashMap();

    public static OutputHelperFactory getInstance() {
        return sInstance;
    }

    public void registerDefinition(String string, OutputHelperDefinition outputHelperDefinition) {
        this.fDefinitionMap.put(string, outputHelperDefinition);
    }

    public void removeDefinition(String string) {
        this.fDefinitionMap.remove(string);
    }

    public boolean hasDefinitionFor(String string) {
        return this.fDefinitionMap.containsKey(string);
    }

    public OutputHelperDefinition getDefinitionFor(String string) {
        return this.fDefinitionMap.get(string);
    }

    public OutputHelper createHelperFor(String string, MPrintJob mPrintJob) {
        OutputHelperDefinition outputHelperDefinition = this.getDefinitionFor(string);
        if (outputHelperDefinition != null) {
            return outputHelperDefinition.create(mPrintJob);
        }
        return null;
    }

    public OutputHelper createHelperFor(MPrintJob mPrintJob) {
        return this.createHelperFor(mPrintJob.getDriver(), mPrintJob);
    }

    public void registerFOPBatik() {
        this.registerDefinition("pdfwrite", FOPDefinitions.PDF());
        this.registerDefinition("ps", FOPDefinitions.PS3());
        this.registerDefinition("ps2", FOPDefinitions.PS2());
        this.registerDefinition("psc", FOPDefinitions.PS3());
        this.registerDefinition("ps2c", FOPDefinitions.PS2());
        this.registerDefinition("eps", FOPDefinitions.EPS3());
        this.registerDefinition("eps2", FOPDefinitions.EPS2());
        this.registerDefinition("epsc", FOPDefinitions.EPS3());
        this.registerDefinition("eps2c", FOPDefinitions.EPS2());
        this.registerDefinition("svg", new BatikHelperDefinition());
    }

    static {
        sInstance.registerDefinition("prn", new PrintHelperDefinition());
        sInstance.registerDefinition("raster@toolbox", new RasterHelperDefinition());
        sInstance.registerDefinition("meta", new MWEMFDefinition());
        sInstance.registerFOPBatik();
    }
}

