/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types;

import com.mathworks.beans.editors.MWPropertyEditorSupport;
import com.mathworks.hg.types.HGColor;
import com.mathworks.hg.types.HGTypeEditorIcon;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class HGColorEditor
extends MWPropertyEditorSupport {
    private static Image sIcon = null;
    protected HGColor fColorValue;
    private MJLabel fLabel = null;
    private MJPanel fPanel = null;
    private ColorGlyph fGlyph = null;

    public boolean hasCustomDialog() {
        return true;
    }

    public void invokeDialog() {
        this.launchColorPicker();
    }

    protected String getCurrentText() {
        if (this.fColorValue == null) {
            return "none";
        }
        return null;
    }

    public void updateComponentState() {
        Object object = this.getValue();
        if (object instanceof HGColor) {
            this.fColorValue = (HGColor)object;
        }
    }

    protected Color getCurrentColor() {
        this.fColorValue = (HGColor)this.getValue();
        return HGColor.getColor(this.fColorValue);
    }

    public JComponent getInspectorRenderer() {
        if (this.fPanel == null) {
            this.fPanel = this.createPanel();
        }
        return this.fPanel;
    }

    private MJPanel createPanel() {
        this.updateComponentState();
        BorderLayout borderLayout = new BorderLayout();
        MJPanel mJPanel = new MJPanel((LayoutManager)borderLayout);
        this.fGlyph = new ColorGlyph();
        this.fGlyph.setPreferredSize(new Dimension(50, 20));
        mJPanel.add((Component)((Object)this.fGlyph), (Object)"West");
        this.fLabel = new MJLabel(this.getCurrentText());
        mJPanel.add((Component)this.fLabel, (Object)"Center");
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                HGColorEditor.this.launchColorPicker();
            }
        };
        this.fGlyph.addMouseListener(mouseInputAdapter);
        this.fLabel.addMouseListener((MouseListener)mouseInputAdapter);
        return mJPanel;
    }

    public boolean isPaintable() {
        return this.fColorValue != null;
    }

    public void setColor(double[] dArray) {
        this.fColorValue = new HGColor(dArray[0], dArray[1], dArray[2]);
        this.setValue(new HGColor(dArray[0], dArray[1], dArray[2]));
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        this.fColorValue = (HGColor)this.getValue();
        rectangle2.grow(-3, -2);
        if (rectangle2.width > 60) {
            rectangle2.width = 60;
        }
        if (this.fColorValue != null) {
            int n = (int)(this.fColorValue.getRed() * 255.0);
            int n2 = (int)(this.fColorValue.getGreen() * 255.0);
            int n3 = (int)(this.fColorValue.getBlue() * 255.0);
            if (n < 0) {
                n = 0;
            } else if (n > 255) {
                n = 255;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > 255) {
                n2 = 255;
            }
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 > 255) {
                n3 = 255;
            }
            graphics.setColor(new Color(n, n2, n3));
            graphics.fillRect(rectangle2.x + 1, rectangle2.y + 1, rectangle2.width - 2, rectangle2.height - 2);
            graphics.setColor(Color.black);
            graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
            graphics.setColor(Color.darkGray);
            graphics.drawLine(rectangle2.x + 1, rectangle2.y + rectangle2.height, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
            graphics.drawLine(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, rectangle2.x + rectangle2.width, rectangle2.y + 1);
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return null;
    }

    public Image getIcon() {
        if (sIcon == null) {
            sIcon = HGTypeEditorIcon.COLOR.getIcon().getImage();
        }
        return sIcon;
    }

    public boolean canExpand() {
        return true;
    }

    public boolean canApply() {
        return true;
    }

    public void apply() {
        if (this.fColorValue != null) {
            double d = this.fColorValue.getRed();
            double d2 = this.fColorValue.getGreen();
            double d3 = this.fColorValue.getBlue();
            this.setValue(new HGColor(d, d2, d3));
        } else {
            this.setValue(null);
        }
    }

    protected double[] getInitialColorPickerRGB() {
        return new double[]{this.fColorValue.getRed(), this.fColorValue.getGreen(), this.fColorValue.getBlue()};
    }

    public void launchColorPicker() {
        Matlab matlab = new Matlab();
        double[] dArray = null;
        if (this.fColorValue != null) {
            dArray = this.getInitialColorPickerRGB();
        }
        try {
            if (dArray == null) {
                matlab.feval("uisetcolor", null, 1, (CompletionObserver)new UISetColorComplete());
            } else {
                matlab.feval("uisetcolor", new Object[]{dArray}, 1, (CompletionObserver)new UISetColorComplete());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class UISetColorComplete
    implements CompletionObserver {
        public void completed(int n, Object object) {
            double[] dArray = (double[])object;
            if (dArray != null && dArray.length > 1) {
                HGColorEditor.this.setColor(dArray);
                if (HGColorEditor.this.fPanel != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HGColorEditor.this.fPanel.repaint();
                        }
                    });
                }
            }
        }
    }

    private class ColorGlyph
    extends MJLabel {
        private ColorGlyph() {
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            Dimension dimension = this.getSize();
            int n = dimension.height / 2;
            Rectangle rectangle = new Rectangle(4, n - 4, 20, 9);
            Color color = HGColorEditor.this.getCurrentColor();
            final String string = HGColorEditor.this.getCurrentText();
            if (string == null) {
                if (color != null) {
                    graphics.setColor(color);
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            } else {
                if (graphics instanceof Graphics2D) {
                    ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                graphics.setColor(Color.gray);
                graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y);
            }
            graphics.setColor(Color.black);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HGColorEditor.this.fLabel.setText(string);
                }
            });
        }
    }
}

