/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.table.format;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.hg.types.table.format.AbstractFormatPanel;
import com.mathworks.hg.types.table.format.FormatTypeEnum;
import com.mathworks.hg.types.table.format.MultiColumnListCellRenderer;
import com.mathworks.hg.types.table.format.TextTypeEnum;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemColor;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TextPanel
extends AbstractFormatPanel {
    private MJList listTypes;
    private MJTextField fieldWidth;
    private MJTextField fieldFormat;
    private MJTextField fieldExample;
    private MJLabel warnWidth;

    public TextPanel(FormatTypeEnum formatTypeEnum) {
        super(formatTypeEnum);
    }

    @Override
    protected JPanel buildFormatPanel() {
        FormLayout formLayout = new FormLayout("p, 12dlu, p, 0dlu:g(1.0)", "p, 12dlu, p, 0dlu:g(1.0)");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.buildTextTypePanel(), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.buildOptionPanel(), cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.buildSprintfPanel(), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.buildExamplePanel(), cellConstraints.xy(3, 3));
        panelBuilder.setBorder(Borders.DLU7_BORDER);
        return panelBuilder.getPanel();
    }

    private JPanel buildTextTypePanel() {
        TextTypeEnum textTypeEnum2;
        Vector<TextTypeEnum> vector = new Vector<TextTypeEnum>();
        for (TextTypeEnum textTypeEnum2 : TextTypeEnum.values()) {
            vector.add(textTypeEnum2);
        }
        MultiColumnListCellRenderer multiColumnListCellRenderer = new MultiColumnListCellRenderer(4);
        this.listTypes = new MJList(vector);
        this.listTypes.setSelectionMode(0);
        this.listTypes.setVisibleRowCount(8);
        this.listTypes.setCellRenderer((ListCellRenderer)multiColumnListCellRenderer);
        this.listTypes.setBorder(Borders.createEmptyBorder((String)"1dlu, 1dlu, 1dlu, 1dlu"));
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.listTypes);
        this.listTypes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    TextPanel.this.processNewSelection();
                }
            }
        });
        FormLayout formLayout = new FormLayout("p", "p, 2dlu, p");
        textTypeEnum2 = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        textTypeEnum2.addLabel("Conversions:", cellConstraints.xy(1, 1));
        textTypeEnum2.add((Component)mJScrollPane, cellConstraints.xy(1, 3));
        return textTypeEnum2.getPanel();
    }

    private JPanel buildOptionPanel() {
        this.warnWidth = new MJLabel();
        this.warnWidth.setIcon((Icon)DialogIcon.WARNING_12x12.getIcon());
        Font font = this.warnWidth.getFont();
        font = font.deriveFont((float)font.getSize() - 1.0f);
        this.warnWidth.setFont(font);
        this.warnWidth.setVisible(false);
        this.fieldWidth = new MJTextField(6);
        this.fieldWidth.setInputVerifier((InputVerifier)new WidthVerifier((JLabel)this.warnWidth, 1, Integer.MAX_VALUE));
        FormLayout formLayout = new FormLayout("p, 4dlu, p, 6dlu, p, 0dlu:g(1.0)", "p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel("Field Width:", cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.fieldWidth, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.warnWidth, cellConstraints.xy(5, 1));
        return panelBuilder.getPanel();
    }

    private JPanel buildSprintfPanel() {
        this.fieldFormat = new MJTextField(16);
        FormLayout formLayout = new FormLayout("p, 4dlu, p:g(1.0)", "p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel("sprintf Format:", cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.fieldFormat, cellConstraints.xy(3, 1));
        return panelBuilder.getPanel();
    }

    private JPanel buildExamplePanel() {
        this.fieldExample = new MJTextField(16);
        FormLayout formLayout = new FormLayout("p, 4dlu, p:g(1.0)", "p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel("Example:", cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.fieldExample, cellConstraints.xy(3, 1));
        return panelBuilder.getPanel();
    }

    private void processNewSelection() {
        TextTypeEnum textTypeEnum = (TextTypeEnum)((Object)this.listTypes.getSelectedValue());
        if (textTypeEnum != null) {
            this.updateSizeFields(textTypeEnum);
            this.updateExampleFields(textTypeEnum);
        } else {
            this.showNoFormat();
        }
    }

    private void updateDisplay() {
        if (this.isValidFormat()) {
            TextTypeEnum textTypeEnum = (TextTypeEnum)((Object)this.listTypes.getSelectedValue());
            this.updateExampleFields(textTypeEnum);
        } else {
            this.showInvalidFormat();
        }
    }

    private void updateSizeFields(TextTypeEnum textTypeEnum) {
        this.fieldWidth.setText(null);
    }

    private void updateExampleFields(TextTypeEnum textTypeEnum) {
        String string;
        String string2 = textTypeEnum.getSymbol();
        string2 = this.addSizeToFormat(string2);
        switch (textTypeEnum) {
            case CHARACTER: {
                string = String.format(string2, Character.valueOf('A'));
                break;
            }
            case TEXT: {
                string = String.format(string2, "ABCDEFGH");
                break;
            }
            default: {
                string2 = null;
                string = null;
            }
        }
        this.fieldFormat.setBackground((Color)SystemColor.text);
        this.fieldFormat.setText(string2);
        this.fieldExample.setText(string);
    }

    private String addSizeToFormat(String string) {
        String string2 = string;
        if (this.fieldWidth.getText().trim().length() > 0) {
            string2 = "%" + this.fieldWidth.getText().trim() + string2.substring(1);
        }
        return string2;
    }

    private void showInvalidFormat() {
        this.fieldFormat.setText("Invalid");
        this.fieldFormat.setBackground(Color.CYAN);
        this.fieldExample.setText("Invalid");
    }

    private void showNoFormat() {
        this.fieldFormat.setText(null);
        this.fieldFormat.setBackground((Color)SystemColor.text);
        this.fieldExample.setText(null);
        this.fieldWidth.setText(null);
        this.fieldWidth.setBackground((Color)SystemColor.text);
        this.warnWidth.setVisible(false);
    }

    @Override
    protected boolean isValidFormat() {
        return this.listTypes.getSelectedIndex() >= 0 && !this.warnWidth.isVisible();
    }

    @Override
    protected String getFormat() {
        if (this.isValidFormat()) {
            return this.fieldFormat.getText();
        }
        return null;
    }

    class WidthVerifier
    extends InputVerifier {
        private JLabel warnLabel;
        private int minValue;
        private int maxValue;

        public WidthVerifier(JLabel jLabel, int n, int n2) {
            this.warnLabel = jLabel;
            this.minValue = n;
            this.maxValue = n2;
        }

        public void setMaximumValue(int n) {
            this.maxValue = n;
        }

        @Override
        public boolean shouldYieldFocus(JComponent jComponent) {
            boolean bl = this.verify(jComponent);
            TextPanel.this.updateDisplay();
            return bl;
        }

        @Override
        public boolean verify(JComponent jComponent) {
            String string = null;
            MJTextField mJTextField = (MJTextField)jComponent;
            String string2 = mJTextField.getText().trim();
            if (!string2.equals("")) {
                try {
                    int n = Integer.parseInt(string2);
                    mJTextField.setBackground((Color)SystemColor.text);
                    if (n < this.minValue) {
                        string = "Number must be >= " + this.minValue;
                    } else if (n > this.maxValue) {
                        string = "Number must be <= " + this.maxValue;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    string = "Not a number";
                }
            }
            if (string == null) {
                mJTextField.setBackground((Color)SystemColor.text);
                this.warnLabel.setText(null);
                this.warnLabel.setVisible(false);
            } else {
                mJTextField.setBackground(Color.CYAN);
                this.warnLabel.setText(string);
                this.warnLabel.setVisible(true);
            }
            return true;
        }
    }
}

