/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.table.panel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.util.LayoutStyle;
import com.jidesoft.grid.AbstractMultiTableModel;
import com.jidesoft.grid.CellStyleTable;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.grid.NumberCellRenderer;
import com.jidesoft.grid.StringCellEditor;
import com.jidesoft.grid.TableScrollPane;
import com.jidesoft.grid.TextFieldCellEditor;
import com.mathworks.hg.types.table.panel.EditableTableSupport;
import com.mathworks.hg.types.table.panel.EditableTableUtils;
import com.mathworks.hg.types.table.panel.StringListTableModel;
import com.mathworks.hg.types.table.panel.TableEnterKeyAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ChoiceListEditor
extends MJPanel
implements EditableTableSupport {
    public static final ResourceBundle EDITOR_RESOURCES = ResourceBundle.getBundle("com.mathworks.hg.types.table.resources.RES_TableEditor");
    private List<String> fOriginalChoices;
    private boolean fDidSave = false;
    private JTable fMainTable;
    private JTable fRowHeaderTable;
    private StringListTableModel fTableModel;
    private MJButton fButtonInsert;
    private MJButton fButtonCopy;
    private MJButton fButtonDelete;
    private MJButton fButtonMoveUp;
    private MJButton fButtonMoveDown;

    public static List<String> showChoiceListEditorAsDialog(Window window, List<String> list, boolean bl) {
        MJDialog mJDialog;
        if (window == null) {
            mJDialog = new MJDialog();
            mJDialog.setModal(bl);
        } else {
            mJDialog = window instanceof Frame ? new MJDialog((Frame)window, bl) : new MJDialog((Dialog)window, bl);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        if (list != null) {
            linkedList.addAll(list);
        }
        ChoiceListEditor choiceListEditor = new ChoiceListEditor(list);
        choiceListEditor.setBorder(Borders.DIALOG_BORDER);
        mJDialog.setContentPane((Container)((Object)choiceListEditor));
        mJDialog.setTitle(EDITOR_RESOURCES.getString("choicelist.title"));
        mJDialog.setDefaultCloseOperation(0);
        mJDialog.setFocusTarget(choiceListEditor.getFocusTarget());
        ChoiceListEditor.attachWindowListener((Window)mJDialog, choiceListEditor);
        mJDialog.pack();
        mJDialog.setResizable(true);
        mJDialog.setCloseOnEscapeEnabled(true);
        mJDialog.setLocationRelativeTo((Component)window);
        mJDialog.show();
        boolean bl2 = choiceListEditor.isListUpdated();
        List<String> list2 = bl2 ? choiceListEditor.getUpdatedList() : linkedList;
        mJDialog.dispose();
        return list2;
    }

    private static void attachWindowListener(final Window window, final ChoiceListEditor choiceListEditor) {
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (!choiceListEditor.discardUnsavedChanges()) {
                    return;
                }
                window.setVisible(false);
                super.windowClosing(windowEvent);
            }
        });
    }

    public ChoiceListEditor(List<String> list) {
        this.fOriginalChoices = list != null ? new ArrayList<String>(list) : new ArrayList<String>();
        this.buildPanel();
        this.initializePanel();
    }

    public List<String> getUpdatedList() {
        int n = this.fTableModel.getRowCount();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.fTableModel.getStrings());
        if (n > 0 && "".equals(arrayList.get(n - 1))) {
            arrayList.remove(n - 1);
        }
        return arrayList;
    }

    public boolean isListUpdated() {
        return this.fDidSave;
    }

    public Component getFocusTarget() {
        return this.fMainTable;
    }

    public boolean discardUnsavedChanges() {
        boolean bl = true;
        Window window = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (!this.fDidSave && this.fTableModel.isDirty() && this.fOriginalChoices != null && !this.fOriginalChoices.isEmpty()) {
            String string;
            String string2 = EDITOR_RESOURCES.getString("choicelist.dirty_msg");
            int n = MJOptionPane.showConfirmDialog((Component)window, (Object)string2, (String)(string = EDITOR_RESOURCES.getString("choicelist.title")), (int)0);
            bl = n == 0;
        }
        return bl;
    }

    private void initializePanel() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChoiceListEditor.this.requestFocusInCell(0, 0);
            }
        });
    }

    private void buildPanel() {
        FormLayout formLayout = new FormLayout("fill:p:g(1.0), 6dlu, p", "p, 4dlu, fill:p:g(1.0), 6dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)((Object)this));
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)ChoiceListEditor.buildInfoPanel(), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.buildChoicesTable(), cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.buildTableButtonPanel(), cellConstraints.xy(3, 3));
        panelBuilder.add((Component)this.buildButtonBar(), cellConstraints.xyw(1, 5, 3));
        panelBuilder.setBorder(Borders.DIALOG_BORDER);
    }

    private static JPanel buildInfoPanel() {
        MJLabel mJLabel = new MJLabel(EDITOR_RESOURCES.getString("choicelist.info"));
        FormLayout formLayout = new FormLayout("p:g(1.0)", "p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)mJLabel, cellConstraints.xy(1, 1));
        return panelBuilder.getPanel();
    }

    private TableScrollPane buildChoicesTable() {
        this.fTableModel = this.createTableModel();
        TableScrollPane tableScrollPane = ChoiceListEditor.createTableScrollPane(this.fTableModel);
        this.fMainTable = tableScrollPane.getMainTable();
        this.fRowHeaderTable = tableScrollPane.getRowHeaderTable();
        this.customizeMainTable();
        this.setTableHeaderAlignments();
        this.setChoiceColumnCellEditor();
        this.setRowHeaderColumnRenderer();
        this.attachTableModelListener();
        this.attachEnterKeyActions();
        this.attachMainTableSelectionListener();
        EditableTableUtils.attachTableAccelerators(this.fMainTable, this);
        this.attachSaveAccelerator();
        return tableScrollPane;
    }

    private StringListTableModel createTableModel() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(EDITOR_RESOURCES.getString("choicelist.title0"));
        arrayList.add(EDITOR_RESOURCES.getString("choicelist.title1"));
        StringListTableModel stringListTableModel = new StringListTableModel(arrayList, this.fOriginalChoices);
        if (this.fOriginalChoices.isEmpty()) {
            stringListTableModel.addString();
        }
        return stringListTableModel;
    }

    private static TableScrollPane createTableScrollPane(AbstractMultiTableModel abstractMultiTableModel) {
        TableScrollPane tableScrollPane = new TableScrollPane((MultiTableModel)abstractMultiTableModel, false){

            protected JTable createTable(TableModel tableModel, boolean bl) {
                return new CellStyleTable(tableModel);
            }
        };
        tableScrollPane.setPreferredSize(new Dimension(280, 220));
        return tableScrollPane;
    }

    private void customizeMainTable() {
        this.fMainTable.setAutoResizeMode(3);
        this.fMainTable.setSelectionMode(0);
        this.fMainTable.setCellSelectionEnabled(true);
        this.fMainTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    private void setTableHeaderAlignments() {
        ((JLabel)((Object)this.fMainTable.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(0);
        ((JLabel)((Object)this.fRowHeaderTable.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(0);
    }

    private void setChoiceColumnCellEditor() {
        StringCellEditor stringCellEditor = new StringCellEditor();
        this.fMainTable.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)stringCellEditor);
    }

    private void attachTableModelListener() {
        this.fTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ChoiceListEditor.this.scrollSelectedRowToVisible();
                    }
                });
            }
        });
    }

    private void attachEnterKeyActions() {
        JTextField jTextField = ((TextFieldCellEditor)this.fMainTable.getColumnModel().getColumn(0).getCellEditor()).getTextField();
        jTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "none");
        TableEnterKeyAction tableEnterKeyAction = new TableEnterKeyAction(this.fMainTable, this);
        this.fMainTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "my-action-key");
        this.fMainTable.getActionMap().put("my-action-key", tableEnterKeyAction);
    }

    private void attachMainTableSelectionListener() {
        this.fMainTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    ChoiceListEditor.this.processSelectionChange();
                }
            }
        });
    }

    private void attachSaveAccelerator() {
        this.fMainTable.getInputMap(1).put(KeyStroke.getKeyStroke(83, KeyStrokeUtils.MENU_SHORTCUT_KEY_MASK), "SaveList");
        this.fMainTable.getActionMap().put("SaveList", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ChoiceListEditor.this.fMainTable.isEditing()) {
                    ChoiceListEditor.this.fMainTable.getCellEditor().stopCellEditing();
                }
                ChoiceListEditor.this.fDidSave = true;
                ChoiceListEditor.sendWindowClosingEvent(ChoiceListEditor.this.fMainTable);
            }
        });
    }

    private void setRowHeaderColumnRenderer() {
        TableColumn tableColumn = this.fRowHeaderTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(40);
        NumberCellRenderer numberCellRenderer = new NumberCellRenderer();
        numberCellRenderer.setHorizontalAlignment(0);
        numberCellRenderer.setBackground(UIManager.getColor("TableHeader.background"));
        numberCellRenderer.setForeground(UIManager.getColor("TableHeader.foreground"));
        numberCellRenderer.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        tableColumn.setCellRenderer((TableCellRenderer)numberCellRenderer);
    }

    private JPanel buildTableButtonPanel() {
        this.fButtonInsert = ChoiceListEditor.createButton("buttons.insert", "buttons.tip_insert");
        this.fButtonInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChoiceListEditor.this.addEntry();
            }
        });
        this.fButtonCopy = ChoiceListEditor.createButton("buttons.copy", "buttons.tip_copy");
        this.fButtonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChoiceListEditor.this.copyEntry();
            }
        });
        this.fButtonDelete = ChoiceListEditor.createButton("buttons.delete", "buttons.tip_delete");
        this.fButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChoiceListEditor.this.removeEntry();
            }
        });
        this.fButtonMoveUp = ChoiceListEditor.createButton("buttons.move_up", "buttons.tip_move_up");
        this.fButtonMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChoiceListEditor.this.moveEntryUp();
            }
        });
        this.fButtonMoveDown = ChoiceListEditor.createButton("buttons.move_down", "buttons.tip_move_down");
        this.fButtonMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChoiceListEditor.this.moveEntryDown();
            }
        });
        FormLayout formLayout = new FormLayout("fill:p", "p, p, p, p, p, p, p, p, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        ConstantSize constantSize = LayoutStyle.getCurrent().getUnrelatedComponentsPadY();
        int n = constantSize.getPixelSize((Component)panelBuilder.getPanel());
        ConstantSize constantSize2 = LayoutStyle.getCurrent().getRelatedComponentsPadY();
        int n2 = constantSize2.getPixelSize((Component)panelBuilder.getPanel());
        panelBuilder.add((Component)this.fButtonInsert, cellConstraints.xy(1, 1));
        panelBuilder.add(Box.createVerticalStrut(n2), cellConstraints.xy(1, 2));
        panelBuilder.add((Component)this.fButtonCopy, cellConstraints.xy(1, 3));
        panelBuilder.add(Box.createVerticalStrut(n2), cellConstraints.xy(1, 4));
        panelBuilder.add((Component)this.fButtonDelete, cellConstraints.xy(1, 5));
        panelBuilder.add(Box.createVerticalStrut(n), cellConstraints.xy(1, 6));
        panelBuilder.add((Component)this.fButtonMoveUp, cellConstraints.xy(1, 7));
        panelBuilder.add(Box.createVerticalStrut(n2), cellConstraints.xy(1, 8));
        panelBuilder.add((Component)this.fButtonMoveDown, cellConstraints.xy(1, 9));
        return panelBuilder.getPanel();
    }

    private static MJButton createButton(String string, String string2) {
        MJButton mJButton = new MJButton();
        if (string != null) {
            mJButton.setText(EDITOR_RESOURCES.getString(string));
        }
        if (string2 != null) {
            mJButton.setToolTipText(EDITOR_RESOURCES.getString(string2));
        }
        return mJButton;
    }

    private JPanel buildButtonBar() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChoiceListEditor.this.fDidSave = ((AbstractButton)actionEvent.getSource()).getText().equals(EDITOR_RESOURCES.getString("choicelist.ok"));
                ChoiceListEditor.sendWindowClosingEvent((JComponent)actionEvent.getSource());
            }
        };
        MJButton mJButton = ChoiceListEditor.createButtonBarButton("choicelist.ok", "choicelist.tip_ok", actionListener);
        MJButton mJButton2 = ChoiceListEditor.createButtonBarButton("choicelist.cancel", "choicelist.tip_cancel", actionListener);
        return ButtonBarFactory.buildOKCancelBar((JButton)mJButton, (JButton)mJButton2);
    }

    private static MJButton createButtonBarButton(String string, String string2, ActionListener actionListener) {
        MJButton mJButton = new MJButton(EDITOR_RESOURCES.getString(string));
        mJButton.setToolTipText(EDITOR_RESOURCES.getString(string2));
        mJButton.addActionListener(actionListener);
        return mJButton;
    }

    private static void sendWindowClosingEvent(JComponent jComponent) {
        Window window = (Window)jComponent.getTopLevelAncestor();
        window.dispatchEvent(new WindowEvent(window, 201));
    }

    private void requestFocusInCell(int n, int n2) {
        this.fMainTable.setRowSelectionInterval(n, n);
        this.fMainTable.setColumnSelectionInterval(n2, n2);
        this.fMainTable.requestFocusInWindow();
    }

    @Override
    public void addEntry() {
        int n = this.fMainTable.getSelectedRow();
        if (n == -1) {
            n = this.fMainTable.getRowCount() - 1;
        }
        this.fTableModel.addString(++n);
        this.fMainTable.getSelectionModel().setSelectionInterval(n, n);
        this.fMainTable.requestFocusInWindow();
    }

    @Override
    public void copyEntry() {
        int n = this.fMainTable.getSelectedRow();
        if (n != -1) {
            this.fTableModel.copyString(n);
            this.fMainTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
            this.fMainTable.requestFocusInWindow();
        }
    }

    @Override
    public void removeEntry() {
        int n = this.fMainTable.getSelectedRow();
        if (n != -1) {
            this.fTableModel.removeString(n);
            int n2 = this.fMainTable.getRowCount() - 1;
            if (n2 >= 0) {
                n = n > n2 ? n2 : n;
                this.fMainTable.getSelectionModel().setSelectionInterval(n, n);
                this.fMainTable.requestFocusInWindow();
            }
        }
    }

    @Override
    public void moveEntryUp() {
        boolean bl = this.fButtonMoveUp.hasFocus();
        int n = this.fMainTable.getSelectedRow();
        if (n > 0) {
            this.fTableModel.moveStringUp(n);
            this.fMainTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
            if (bl) {
                this.fButtonMoveUp.requestFocusInWindow();
            }
        }
    }

    @Override
    public void moveEntryDown() {
        boolean bl = this.fButtonMoveUp.hasFocus();
        int n = this.fMainTable.getSelectedRow();
        int n2 = this.fMainTable.getRowCount() - 1;
        if (n >= 0 && n < n2) {
            this.fTableModel.moveStringDown(n);
            this.fMainTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
            if (bl) {
                this.fButtonMoveDown.requestFocusInWindow();
            }
        }
    }

    private void scrollSelectedRowToVisible() {
        int n = this.fMainTable.getSelectedRow();
        Rectangle rectangle = this.fMainTable.getCellRect(n, 0, true);
        this.fMainTable.scrollRectToVisible(rectangle);
    }

    private void processSelectionChange() {
        int n = this.fMainTable.getSelectedRow();
        int n2 = this.fMainTable.getRowCount() - 1;
        this.fButtonInsert.setSelected(true);
        this.fButtonCopy.setEnabled(n >= 0);
        this.fButtonDelete.setEnabled(n >= 0);
        this.fButtonMoveUp.setEnabled(n > 0);
        this.fButtonMoveDown.setEnabled(n >= 0 && n < n2);
    }
}

