/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.uij;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;

public class CustomCursor {
    public static final int TRANSPARENT = 0;
    public static final int WHITE = 2;
    public static final int BLACK = 1;
    private String fName;
    private Cursor fCursor;
    private int fWidth;
    private int fHeight;
    private int fHotSpotX;
    private int fHotSpotY;
    private BufferedImage fImage;
    private int[] fWhiteIndex = new int[]{0};
    private int[] fBlackIndex = new int[]{1};
    private int[] fTransparentIndex = new int[]{2};
    private static CustomCursor sCircleCursor = null;
    private static CustomCursor sCrossCursor = null;
    private static CustomCursor sNullCursor = null;

    public CustomCursor(String string) {
        this.fName = string;
        this.fCursor = null;
        this.fWidth = 0;
        this.fHeight = 0;
        this.fHotSpotX = 0;
        this.fHotSpotY = 0;
    }

    public void setPixels(int[] nArray, int n, int n2) {
        this.initializeImage(n, n2);
        if (nArray.length != n * n2) {
            throw new IllegalArgumentException("cursor dimensions don't match data");
        }
        WritableRaster writableRaster = this.fImage.getRaster();
        for (int i = 0; i < this.fWidth; ++i) {
            for (int j = 0; j < this.fHeight; ++j) {
                int n3 = i * this.fHeight + j;
                if (nArray[n3] == 2) {
                    writableRaster.setPixel(i, j, this.fWhiteIndex);
                    continue;
                }
                if (nArray[n3] != 1) continue;
                writableRaster.setPixel(i, j, this.fBlackIndex);
            }
        }
        this.fCursor = null;
    }

    public void setHotSpot(int n, int n2) {
        this.fHotSpotX = n;
        this.fHotSpotY = n2;
        this.fCursor = null;
    }

    public Cursor getCursor() {
        if (this.fCursor == null) {
            if (this.fImage == null) {
                this.initializeImage(16, 16);
            }
            if (this.fHotSpotX < 0 || this.fHotSpotX >= this.fImage.getWidth(null) || this.fHotSpotY < 0 || this.fHotSpotY >= this.fImage.getHeight(null)) {
                throw new IllegalArgumentException("hot spot must be within cursor");
            }
            Point point = new Point(this.fHotSpotX, this.fHotSpotY);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.fCursor = toolkit.createCustomCursor(this.fImage, point, this.fName);
        }
        return this.fCursor;
    }

    public static CustomCursor getCircleCursor() {
        if (sCircleCursor == null) {
            sCircleCursor = CustomCursor.createCircleCursor(7);
        }
        return sCircleCursor;
    }

    public static CustomCursor getNullCursor() {
        if (sNullCursor == null) {
            sNullCursor = new CustomCursor("null");
            int n = 0;
            int n2 = 0;
            int[] nArray = new int[n * n2];
            sNullCursor.setPixels(nArray, n, n2);
            sNullCursor.setHotSpot(0, 0);
        }
        return sNullCursor;
    }

    public static CustomCursor getCrossCursor() {
        if (sCrossCursor == null) {
            int n;
            sCrossCursor = new CustomCursor("cross");
            int n2 = 15;
            int n3 = 15;
            int[] nArray = new int[n2 * n3];
            for (n = 0; n <= 5; ++n) {
                nArray[5 * n2 + n] = 2;
                nArray[5 * n2 + (n2 - 1 - n)] = 2;
                nArray[(n3 - 1 - 5) * n2 + n] = 2;
                nArray[(n3 - 1 - 5) * n2 + (n2 - 1 - n)] = 2;
                nArray[n * n2 + 5] = 2;
                nArray[n * n2 + (n2 - 1 - 5)] = 2;
                nArray[(n3 - 1 - n) * n2 + 5] = 2;
                nArray[(n3 - 1 - n) * n2 + (n2 - 1 - 5)] = 2;
            }
            for (n = 0; n <= 6; ++n) {
                nArray[6 * n2 + n] = 1;
                nArray[6 * n2 + (n2 - 1 - n)] = 1;
                nArray[(n3 - 1 - 6) * n2 + n] = 1;
                nArray[(n3 - 1 - 6) * n2 + (n2 - 1 - n)] = 1;
                nArray[n * n2 + 6] = 1;
                nArray[n * n2 + (n2 - 1 - 6)] = 1;
                nArray[(n3 - 1 - n) * n2 + 6] = 1;
                nArray[(n3 - 1 - n) * n2 + (n2 - 1 - 6)] = 1;
            }
            sCrossCursor.setPixels(nArray, n2, n3);
            sCrossCursor.setHotSpot(6, 6);
        }
        return sCrossCursor;
    }

    private void initializeImage(int n, int n2) {
        this.fWidth = n;
        this.fHeight = n2;
        Dimension dimension = Toolkit.getDefaultToolkit().getBestCursorSize(this.fWidth, this.fHeight);
        if (dimension.width < this.fWidth || dimension.height < this.fHeight) {
            throw new IllegalArgumentException("cursor definition exceeds system limits");
        }
        byte[] byArray = new byte[]{-1, 0, 0, 0};
        byte[] byArray2 = new byte[]{-1, 0, 0, 0};
        byte[] byArray3 = new byte[]{-1, 0, 0, 0};
        byte[] byArray4 = new byte[]{-1, -1, 0, 0};
        IndexColorModel indexColorModel = new IndexColorModel(2, 4, byArray, byArray2, byArray3, byArray4);
        this.fImage = new BufferedImage(dimension.width, dimension.height, 13, indexColorModel);
        WritableRaster writableRaster = this.fImage.getRaster();
        for (int i = 0; i < dimension.width; ++i) {
            for (int j = 0; j < dimension.height; ++j) {
                writableRaster.setPixel(i, j, this.fTransparentIndex);
            }
        }
    }

    private static CustomCursor createCircleCursor(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid radius");
        }
        int n2 = 2 * (n + 1);
        int n3 = 2 * (n + 1);
        int n4 = n + 1;
        int n5 = n + 1;
        int[] nArray = new int[n2 * n3];
        int n6 = 0;
        int n7 = n;
        int n8 = 2 * (1 - n);
        while (n7 >= 0) {
            int n9;
            nArray[(n5 + n7) * n2 + (n4 + n6)] = 1;
            nArray[(n5 + n7) * n2 + (n4 - n6)] = 1;
            nArray[(n5 - n7) * n2 + (n4 + n6)] = 1;
            nArray[(n5 - n7) * n2 + (n4 - n6)] = 1;
            if (n8 < 0) {
                n9 = 2 * n8 + 2 * n7 - 1;
                if (n9 <= 0) {
                    n8 += 2 * ++n6 + 1;
                    continue;
                }
                n8 += 2 * ++n6 - 2 * --n7 + 2;
                continue;
            }
            if (n8 > 0) {
                n9 = 2 * n8 - 2 * n6 - 1;
                if (n9 <= 0) {
                    n8 += 2 * ++n6 - 2 * --n7 + 2;
                    continue;
                }
                n8 += -2 * --n7 + 1;
                continue;
            }
            if (n8 != 0) continue;
            n8 += 2 * ++n6 - 2 * --n7 + 2;
        }
        CustomCursor customCursor = new CustomCursor("circle");
        customCursor.setPixels(nArray, n2, n3);
        customCursor.setHotSpot(n4, n5);
        return customCursor;
    }
}

