/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.mathworks.hg.util.FontNameTranslator;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.jmi.Matlab;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public final class FontConverter {
    private static final int CACHE_SIZE = 5;
    private static final Map<String, Font> sFontTable = new Hashtable<String, Font>(5);
    private static final List<String> sKeys = new Vector<String>(5);
    private static File sComputerModernFontLocation = null;
    private static final int FONT_ANGLE_NORMAL = 0;
    private static final int FONT_ANGLE_ITALIC = 1;
    private static final int FONT_ANGLE_OBLIQUE = 2;
    private static final int FONT_WEIGHT_LIGHT = 0;
    private static final int FONT_WEIGHT_NORMAL = 1;
    private static final int FONT_WEIGHT_DEMI = 2;
    private static final int FONT_WEIGHT_BOLD = 3;
    private static final int FONT_LOCATION_SYSTEM = 0;
    private static final int FONT_LOCATION_TEX_TYPE1 = 1;
    private static boolean sShowDebugMessages = false;

    private FontConverter() {
    }

    public static Font convertToJavaFont(String string, double d, int n, int n2, boolean bl, int n3) {
        return FontConverter.convertToJavaFont(string, FontConverter.modifyFontSize(d, n2, n3), n, n2, 0);
    }

    public static Font convertToJavaFont(String string, double d, int n, int n2) {
        return FontConverter.convertToJavaFont(string, FontConverter.modifyFontSize(d, n2, HGUtils.getR13CompatibilityMode()), n, n2, 0);
    }

    private static double modifyFontSize(double d, int n, int n2) {
        if ((n2 & 2) == 2 && n != 3) {
            return Math.floor(d);
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font convertToJavaFont(String string, double d, int n, int n2, int n3) {
        Font font = null;
        Map<String, Font> map = sFontTable;
        synchronized (map) {
            Object object;
            FontNameTranslator fontNameTranslator = FontNameTranslator.getTranslator();
            Font font2 = fontNameTranslator.getFontFromName(string);
            String string2 = fontNameTranslator.translateFontName(string);
            d = Math.round(d);
            String string3 = string2.toLowerCase(Locale.US) + "/" + d + "/" + (n == 0 ? "0" : "1") + "/" + n2;
            if (sFontTable.containsKey(string3)) {
                font = sFontTable.get(string3);
                sFontTable.remove(string3);
                sKeys.remove(string3);
            } else {
                Float f;
                switch (n) {
                    case 1: 
                    case 2: {
                        object = TextAttribute.POSTURE_OBLIQUE;
                        break;
                    }
                    default: {
                        object = TextAttribute.POSTURE_REGULAR;
                    }
                }
                switch (n2) {
                    case 1: {
                        f = TextAttribute.WEIGHT_REGULAR;
                        break;
                    }
                    case 0: {
                        f = TextAttribute.WEIGHT_EXTRA_LIGHT;
                        break;
                    }
                    case 2: {
                        f = TextAttribute.WEIGHT_MEDIUM;
                        break;
                    }
                    case 3: {
                        f = TextAttribute.WEIGHT_BOLD;
                        break;
                    }
                    default: {
                        f = TextAttribute.WEIGHT_REGULAR;
                    }
                }
                Hashtable<TextAttribute, Object> hashtable = new Hashtable<TextAttribute, Object>();
                hashtable.put(TextAttribute.SIZE, new Float(d));
                hashtable.put(TextAttribute.POSTURE, object);
                hashtable.put(TextAttribute.WEIGHT, f);
                if (n3 == 1) {
                    font = FontConverter.loadTexFont(string2, hashtable);
                } else if (font2 == null) {
                    hashtable.put(TextAttribute.FAMILY, string2);
                    try {
                        font = new Font(hashtable);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    font = font2.deriveFont(hashtable);
                }
            }
            if (sKeys.size() >= 5) {
                object = sKeys.get(sKeys.size() - 1);
                sFontTable.remove(object);
                sKeys.remove(object);
            }
            sFontTable.put(string3, font);
            sKeys.add(0, string3);
        }
        return font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Font loadTexFont(String string, Map<TextAttribute, ? super Object> map) {
        String string2 = string.toLowerCase(Locale.US);
        String string3 = string2 + "/Generic";
        Font font = null;
        Map<String, Font> map2 = sFontTable;
        synchronized (map2) {
            font = sFontTable.get(string3);
            if (font == null) {
                File file = new File(FontConverter.getComputerModernFontLocation(), string2 + ".ttf");
                font = FontConverter.loadTexFontFirstAttempt(file);
                if (font == null) {
                    font = FontConverter.loadTexFontSecondAttempt(file, string);
                }
                if (font != null) {
                    sFontTable.put(string2, font);
                    sKeys.add(0, string3);
                }
            }
        }
        if (font != null) {
            return font.deriveFont(map);
        }
        return null;
    }

    private static Font loadTexFontFirstAttempt(File file) {
        Font font = null;
        try {
            font = Font.createFont(0, file);
            FontConverter.displayFirstFontSuccessDiagnostic();
        }
        catch (FontFormatException fontFormatException) {
            FontConverter.displayFirstFontFailureDiagnostic(fontFormatException);
        }
        catch (IOException iOException) {
            FontConverter.displayFirstFontFailureDiagnostic(iOException);
        }
        return font;
    }

    private static Font loadTexFontSecondAttempt(File file, String string) {
        Font font = null;
        try {
            font = Font.createFont(0, file);
            FontConverter.displaySecondFontSuccessDiagnostic();
        }
        catch (FontFormatException fontFormatException) {
            FontConverter.displaySecondFontFailureDiagnostic(fontFormatException, string, file);
        }
        catch (IOException iOException) {
            FontConverter.displaySecondFontFailureDiagnostic(iOException, string, file);
        }
        return font;
    }

    private static void displayFirstFontSuccessDiagnostic() {
    }

    private static void displayFirstFontFailureDiagnostic(Exception exception) {
        if (sShowDebugMessages) {
            System.out.print(exception.getClass().getName() + " when creating Font object.  Retrying...");
        }
    }

    private static void displaySecondFontSuccessDiagnostic() {
        if (sShowDebugMessages) {
            System.out.print("success");
        }
    }

    private static void displaySecondFontFailureDiagnostic(Exception exception, String string, File file) {
        System.out.println("Font creation failed twice.");
        System.out.println(exception.getClass().getName() + " when creating Font object");
        System.out.println("Using File " + file.getAbsolutePath() + " to create font " + string);
        System.out.println("File.exists(): " + file.exists());
        System.out.println("File.length(): " + file.length());
        System.out.println("Exception:");
        exception.printStackTrace();
        System.out.println("Caused by:");
        Throwable throwable = exception.getCause();
        System.out.println(throwable);
        if (throwable != null) {
            System.out.println("With trace:");
            throwable.printStackTrace();
        }
    }

    private static void setMatlabFontRoot(String string) {
        sComputerModernFontLocation = new File(string, "ttf" + File.separator + "cm");
    }

    private static File getComputerModernFontLocation() {
        if (sComputerModernFontLocation == null) {
            sComputerModernFontLocation = new File(Matlab.matlabRoot(), "sys" + File.separator + "fonts" + File.separator + "ttf" + File.separator + "cm");
        }
        return sComputerModernFontLocation;
    }

    public static void setShowDebugMessages(boolean bl) {
        sShowDebugMessages = bl;
    }
}

