/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.jogamp.nativewindow.awt.DirectDataBufferInt;
import com.mathworks.hg.peer.FigurePanelContainer;
import com.mathworks.hg.print.HGOutputFlags;
import com.mathworks.hg.print.PrintUtilities;
import com.mathworks.hg.util.MPrintJob;
import com.mathworks.hg.util.OutputHelper;
import com.mathworks.hg.util.OutputHelperProcessingException;
import com.mathworks.jmi.AWTUtilities;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;

public class HGRasterOutputHelper
extends OutputHelper {
    private Exception fException;
    private BufferedImage fBufferedImage;
    private static ResourceBundle sRasterHelperInfo = ResourceBundle.getBundle("com.mathworks.hg.util.resources.RES_rasterhelper");
    private int fFullWidth;
    private int fFullHeight;

    public HGRasterOutputHelper(MPrintJob mPrintJob) {
        super(mPrintJob);
    }

    @Override
    public void open(FigurePanelContainer figurePanelContainer) throws OutputHelperProcessingException {
    }

    @Override
    public void generateOutput(final FigurePanelContainer figurePanelContainer) throws OutputHelperProcessingException {
        this.validateContainerState(figurePanelContainer.getTargetContainer());
        double d = this.fPrintJob.getDPI();
        assert (d > 0.0);
        this.fFullWidth = (int)Math.round((double)this.fPrintJob.getPaperPosition_Width() * d);
        this.fFullHeight = (int)Math.round((double)this.fPrintJob.getPaperPosition_Height() * d);
        this.fException = null;
        try {
            AWTUtilities.invokeAndWait((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object;
                    Object object2;
                    assert (GraphicsEnvironment.isHeadless() || figurePanelContainer.getTargetContainer().isDisplayable()) : "Expected the container to be displayable before generating output.";
                    HGRasterOutputHelper.this.validateContainerSize(figurePanelContainer.getTargetContainer());
                    boolean bl = true;
                    if (bl) {
                        HGRasterOutputHelper.this.fBufferedImage = (BufferedImage)DirectDataBufferInt.createBufferedImage((int)HGRasterOutputHelper.this.fFullWidth, (int)HGRasterOutputHelper.this.fFullHeight, (int)3, null, null);
                    } else if (!GraphicsEnvironment.isHeadless()) {
                        HGRasterOutputHelper.this.fBufferedImage = (BufferedImage)figurePanelContainer.getTargetContainer().createImage(HGRasterOutputHelper.this.fFullWidth, HGRasterOutputHelper.this.fFullHeight);
                    } else {
                        HGRasterOutputHelper.this.fBufferedImage = new BufferedImage(HGRasterOutputHelper.this.fFullWidth, HGRasterOutputHelper.this.fFullHeight, 3);
                    }
                    assert (HGRasterOutputHelper.this.fBufferedImage != null) : "Unable to create a buffered image of size " + HGRasterOutputHelper.access$100(HGRasterOutputHelper.this) + " x " + HGRasterOutputHelper.access$200(HGRasterOutputHelper.this);
                    Graphics2D graphics2D = HGRasterOutputHelper.this.fBufferedImage.createGraphics();
                    boolean bl2 = false;
                    if (bl2 && !GraphicsEnvironment.isHeadless()) {
                        object2 = (BufferedImage)figurePanelContainer.getTargetContainer().createImage(2, 2);
                        object = ((BufferedImage)object2).createGraphics();
                        graphics2D.setPaint(((Graphics2D)object).getPaint());
                        graphics2D.setBackground(((Graphics2D)object).getBackground());
                        graphics2D.setColor(((Graphics)object).getColor());
                        ((Graphics)object).dispose();
                    }
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    object2 = figurePanelContainer.getTargetContainer().getSize();
                    object = new Rectangle(0, 0, HGRasterOutputHelper.this.fFullWidth, HGRasterOutputHelper.this.fFullHeight);
                    PrintUtilities.setGraphicsPosition(graphics2D, (Dimension2D)object2, (Rectangle2D)object);
                    HGRasterOutputHelper.this.prePrint(figurePanelContainer.getTargetContainer());
                    try {
                        HGOutputFlags hGOutputFlags = HGRasterOutputHelper.this.setFlagsFromPrintjob(HGRasterOutputHelper.this.fPrintJob);
                        HGRasterOutputHelper.this.fException = figurePanelContainer.printFigurePanel(graphics2D, hGOutputFlags);
                    }
                    finally {
                        HGRasterOutputHelper.this.postPrint();
                    }
                    graphics2D.dispose();
                }
            });
            if (this.fException != null) {
                throw this.fException;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            throw new OutputHelperProcessingException(new RasterSizeException(outOfMemoryError));
        }
        catch (Throwable throwable) {
            throw new OutputHelperProcessingException(throwable);
        }
    }

    public int imageWidth() {
        return this.fFullWidth;
    }

    public int imageHeight() {
        return this.fFullHeight;
    }

    @Override
    public void close() throws OutputHelperProcessingException {
    }

    @Override
    public boolean supportsGettingCDataFromBufferedImage() {
        return true;
    }

    @Override
    public BufferedImage getBufferedImage() throws OutputHelperProcessingException {
        return this.fBufferedImage;
    }

    @Override
    public boolean supportsGettingDataForClipboard() {
        return this.supportsGettingCDataFromBufferedImage();
    }

    @Override
    public ByteArrayOutputStream getDataForClipboard() throws OutputHelperProcessingException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (this.fBufferedImage != null && this.fBufferedImage.getWidth() > 0 && this.fBufferedImage.getHeight() > 0) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                String[] stringArray = new String[]{"png", "jpg", "gif", "bmp"};
                String string = "";
                int n = 0;
                do {
                    Iterator<ImageWriter> iterator;
                    if (!(iterator = ImageIO.getImageWritersByFormatName(stringArray[n])).hasNext()) continue;
                    string = stringArray[n];
                } while (string.isEmpty() && n < stringArray.length);
                if (string.isEmpty()) {
                    throw new OutputHelperProcessingException(sRasterHelperInfo.getString("raster.insufficientImageSupportForClipboard"));
                }
                ImageIO.write((RenderedImage)this.fBufferedImage, "png", byteArrayOutputStream);
                byteArrayOutputStream.flush();
            }
            catch (IOException iOException) {
                byteArrayOutputStream = null;
            }
        }
        if (byteArrayOutputStream == null) {
            throw new OutputHelperProcessingException(sRasterHelperInfo.getString("raster.errorRetrievingRasterDataForClipboard"));
        }
        return byteArrayOutputStream;
    }

    @Override
    public void release() throws OutputHelperProcessingException {
        this.fBufferedImage = null;
    }

    public static class RasterSizeException
    extends Exception {
        public RasterSizeException(Throwable throwable) {
            super(throwable);
        }
    }
}

