/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.collection;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SoftCache {
    private final Map map = new HashMap();
    private final ReferenceQueue queue = new ReferenceQueue();

    public Object put(Object object, Object object2) {
        this.processQueue();
        Value value = Value.create(object, object2, this.queue);
        return Value.strip(this.map.put(object, value), true);
    }

    public Object get(Object object) {
        this.processQueue();
        return Value.strip(this.map.get(object), false);
    }

    public Object remove(Object object) {
        this.processQueue();
        return Value.strip(this.map.remove(object), true);
    }

    public void clear() {
        this.processQueue();
        Iterator iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            Value value = (Value)iterator.next();
            if (value == null) continue;
            value.drop();
        }
        this.map.clear();
    }

    private void processQueue() {
        Value value;
        while ((value = (Value)this.queue.poll()) != null) {
            if (value.key == Value.DROPPED) continue;
            this.map.remove(value.key);
        }
    }

    private static class Value
    extends SoftReference {
        static final Object DROPPED = new Object();
        Object key;

        static Value create(Object object, Object object2, ReferenceQueue referenceQueue) {
            return object2 != null ? new Value(object, object2, referenceQueue) : null;
        }

        static Object strip(Object object, boolean bl) {
            if (object != null) {
                Value value = (Value)object;
                object = value.get();
                if (bl) {
                    value.drop();
                }
            }
            return object;
        }

        void drop() {
            this.clear();
            this.key = DROPPED;
        }

        private Value(Object object, Object object2, ReferenceQueue referenceQueue) {
            super(object2, referenceQueue);
            this.key = object;
        }
    }
}

