/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import com.sun.jini.collection.WeakIdentityMap;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import net.jini.security.policy.DynamicPolicy;

public class LoaderSplitPolicyProvider
extends Policy
implements DynamicPolicy {
    private static final ProtectionDomain myDomain = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return (class$com$sun$jini$start$LoaderSplitPolicyProvider == null ? (class$com$sun$jini$start$LoaderSplitPolicyProvider = LoaderSplitPolicyProvider.class$("com.sun.jini.start.LoaderSplitPolicyProvider")) : class$com$sun$jini$start$LoaderSplitPolicyProvider).getProtectionDomain();
        }
    });
    private final ClassLoader loader;
    private final Policy loaderPolicy;
    private final Policy defaultPolicy;
    private final WeakIdentityMap delegateMap = new WeakIdentityMap();
    static /* synthetic */ Class class$com$sun$jini$start$LoaderSplitPolicyProvider;

    public LoaderSplitPolicyProvider(ClassLoader classLoader, Policy policy, Policy policy2) {
        if (classLoader == null || policy == null || policy2 == null) {
            throw new NullPointerException();
        }
        this.loader = classLoader;
        this.loaderPolicy = policy;
        this.defaultPolicy = policy2;
        this.ensureDependenciesResolved();
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        return this.defaultPolicy.getPermissions(codeSource);
    }

    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        if (protectionDomain == myDomain) {
            Permissions permissions = new Permissions();
            ((PermissionCollection)permissions).add(new AllPermission());
            return permissions;
        }
        return this.getDelegate(protectionDomain.getClassLoader()).getPermissions(protectionDomain);
    }

    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        return protectionDomain == myDomain || this.getDelegate(protectionDomain.getClassLoader()).implies(protectionDomain, permission);
    }

    public void refresh() {
        this.loaderPolicy.refresh();
        this.defaultPolicy.refresh();
    }

    public boolean grantSupported() {
        return this.loaderPolicy instanceof DynamicPolicy && ((DynamicPolicy)((Object)this.loaderPolicy)).grantSupported() && this.defaultPolicy instanceof DynamicPolicy && ((DynamicPolicy)((Object)this.defaultPolicy)).grantSupported();
    }

    public void grant(Class clazz, Principal[] principalArray, Permission[] permissionArray) {
        if (!this.grantSupported()) {
            throw new UnsupportedOperationException("grants not supported");
        }
        ((DynamicPolicy)((Object)this.getDelegate(LoaderSplitPolicyProvider.getClassLoader(clazz)))).grant(clazz, principalArray, permissionArray);
    }

    public Permission[] getGrants(Class clazz, Principal[] principalArray) {
        if (!this.grantSupported()) {
            throw new UnsupportedOperationException("grants not supported");
        }
        return ((DynamicPolicy)((Object)this.getDelegate(LoaderSplitPolicyProvider.getClassLoader(clazz)))).getGrants(clazz, principalArray);
    }

    private void ensureDependenciesResolved() {
        this.getDelegate(this.loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Policy getDelegate(final ClassLoader classLoader) {
        Policy policy;
        if (classLoader == null) {
            return this.loaderPolicy;
        }
        WeakIdentityMap weakIdentityMap = this.delegateMap;
        synchronized (weakIdentityMap) {
            policy = (Policy)this.delegateMap.get(classLoader);
        }
        if (policy == null) {
            policy = (Policy)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    for (ClassLoader classLoader2 = classLoader; classLoader2 != null; classLoader2 = classLoader2.getParent()) {
                        if (classLoader2 != LoaderSplitPolicyProvider.this.loader) continue;
                        return LoaderSplitPolicyProvider.this.loaderPolicy;
                    }
                    return LoaderSplitPolicyProvider.this.defaultPolicy;
                }
            });
            weakIdentityMap = this.delegateMap;
            synchronized (weakIdentityMap) {
                this.delegateMap.put(classLoader, policy);
            }
        }
        return policy;
    }

    private static ClassLoader getClassLoader(final Class clazz) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getClassLoader();
            }
        });
    }
}

