/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public final class LayoutMode {
    private final Set<Property> fProperties;
    public static final LayoutMode ALL_CAPABILITIES = LayoutMode.of(Property.values());
    public static final LayoutMode VERTICAL_HORIZONTAL_NO_LABELS_CAPABILITIES = LayoutMode.of(Property.VERTICAL, Property.HORIZONTAL, Property.NO_LABEL);
    public static final LayoutMode HORIZONTAL_NO_LABELS_CAPABILITIES = LayoutMode.of(Property.VERTICAL, Property.HORIZONTAL, Property.NO_LABEL);
    public static final LayoutMode VERTICAL_ONLY_CAPABILITIES = LayoutMode.of(Property.VERTICAL);
    public static final LayoutMode HORIZONTAL_ONLY_CAPABILITIES = LayoutMode.of(Property.HORIZONTAL);
    public static final LayoutMode COMPACT_LAYOUT = LayoutMode.of(Property.HORIZONTAL, Property.NO_LABEL);
    public static final LayoutMode HORIZONTAL_LAYOUT = LayoutMode.of(Property.HORIZONTAL);
    public static final LayoutMode VERTICAL_LAYOUT = LayoutMode.of(Property.VERTICAL);
    public static final LayoutMode VERTICAL_NO_LABELS_LAYOUT = LayoutMode.of(Property.VERTICAL, Property.NO_LABEL);

    private LayoutMode(Property ... propertyArray) {
        if (propertyArray.length == 0) {
            this.fProperties = EnumSet.noneOf(Property.class);
        } else if (propertyArray.length == 1) {
            this.fProperties = EnumSet.of(propertyArray[0]);
        } else {
            this.fProperties = EnumSet.of(propertyArray[0]);
            int n = propertyArray.length;
            for (int i = 1; i < n; ++i) {
                this.fProperties.add(propertyArray[i]);
            }
        }
    }

    private LayoutMode(Collection<Property> collection) {
        this.fProperties = EnumSet.copyOf(collection);
    }

    public boolean hasProperty(Property property) {
        return this.fProperties.contains((Object)property);
    }

    public Set<Property> getProperties() {
        return Collections.unmodifiableSet(this.fProperties);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("layout<");
        for (Property property : this.fProperties) {
            stringBuilder.append((Object)property).append(",");
        }
        if (stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this.fProperties.hashCode();
    }

    public boolean equals(Object object) {
        return this.fProperties.equals(((LayoutMode)object).fProperties);
    }

    public static LayoutMode of(Property ... propertyArray) {
        return new LayoutMode(propertyArray);
    }

    public static LayoutMode of(Collection<Property> collection) {
        return new LayoutMode(collection);
    }

    public LayoutMode mask(LayoutMode layoutMode) {
        Object object = ((EnumSet)this.fProperties).clone();
        for (Property property : this.fProperties) {
            if (layoutMode.fProperties.contains((Object)property)) continue;
            ((AbstractCollection)object).remove((Object)property);
        }
        return new LayoutMode((Collection<Property>)object);
    }

    public LayoutMode include(Property ... propertyArray) {
        LayoutMode layoutMode = new LayoutMode(propertyArray);
        layoutMode.fProperties.addAll(this.fProperties);
        return layoutMode;
    }

    public LayoutMode exclude(Property ... propertyArray) {
        Object object = ((EnumSet)this.fProperties).clone();
        for (Property property : propertyArray) {
            object.remove((Object)property);
        }
        return new LayoutMode((Collection<Property>)object);
    }

    public static enum Property {
        NO_LABEL,
        VERTICAL,
        HORIZONTAL;

    }
}

