/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components;

import com.mathworks.toolstrip.components.DropDownActionEvent;
import com.mathworks.toolstrip.components.DropDownActionListener;
import com.mathworks.toolstrip.components.DropDownButtonModel;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;

public class SplitButtonModel
extends DropDownButtonModel {
    public static final int DD_ARMED = 65536;
    public static final int DD_PRESSED = 131072;

    @Override
    public void setPressed(boolean bl) {
        this.originalSetPressed(bl);
    }

    public void setDropDownArmed(boolean bl) {
        if (this.isDropDownArmed() == bl || !this.isEnabled()) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 0x10000) : (this.stateMask &= 0xFFFEFFFF);
        this.fireStateChanged();
    }

    public void setDropDownPressed(boolean bl) {
        if (this.isDropDownPressed() == bl || !this.isEnabled()) {
            return;
        }
        this.stateMask = bl ? (this.stateMask |= 0x20000) : (this.stateMask &= 0xFFFDFFFF);
        if (this.isDropDownPressed() && this.isDropDownArmed()) {
            int n = 0;
            AWTEvent aWTEvent = EventQueue.getCurrentEvent();
            if (aWTEvent instanceof InputEvent) {
                n = ((InputEvent)aWTEvent).getModifiers();
            } else if (aWTEvent instanceof ActionEvent) {
                n = ((ActionEvent)aWTEvent).getModifiers();
            }
            this.fireDropDownActionPerformed(new DropDownActionEvent(this, 1001, this.getActionCommand() + "DropDown", EventQueue.getMostRecentEventTime(), n));
        }
        this.fireStateChanged();
        if (this.isDropDownPressed() && this.getPopupListener() != null) {
            this.setSelected(!this.isSelected());
        }
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.setDropDownArmed(false);
        this.setDropDownPressed(false);
    }

    public boolean isDropDownArmed() {
        return (this.stateMask & 0x10000) != 0;
    }

    public boolean isDropDownPressed() {
        return (this.stateMask & 0x20000) != 0;
    }

    public void addDropDownActionListener(DropDownActionListener dropDownActionListener) {
        this.listenerList.add(DropDownActionListener.class, dropDownActionListener);
    }

    public void removeDropDownActionListener(DropDownActionListener dropDownActionListener) {
        this.listenerList.remove(DropDownActionListener.class, dropDownActionListener);
    }

    protected void fireDropDownActionPerformed(DropDownActionEvent dropDownActionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DropDownActionListener.class) continue;
            ((DropDownActionListener)objectArray[i + 1]).dropDownActionPerformed(dropDownActionEvent);
        }
    }
}

