/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components;

import com.mathworks.desktop.mnemonics.HasMnemonic;
import com.mathworks.desktop.mnemonics.Mnemonic;
import com.mathworks.desktop.mnemonics.MnemonicsProvider;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.toolstrip.components.LayoutMode;
import com.mathworks.toolstrip.components.TSComponent;
import com.mathworks.toolstrip.components.TSUtil;
import com.mathworks.toolstrip.plaf.ComponentMnemonicsProvider;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.ToolstripCheckBoxUI;
import java.awt.Point;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TSCheckBox
extends MJCheckBox
implements TSComponent,
HasMnemonic {
    private String fMnemonic;

    public TSCheckBox() {
    }

    public TSCheckBox(Action action) {
        super(action);
    }

    public TSCheckBox(Icon icon) {
        super(icon);
    }

    public TSCheckBox(Icon icon, boolean bl) {
        super(icon, bl);
    }

    public TSCheckBox(String string) {
        super(string);
    }

    public TSCheckBox(String string, boolean bl) {
        super(string, bl);
    }

    public TSCheckBox(String string, Icon icon) {
        super(string, icon);
    }

    public TSCheckBox(String string, Icon icon, boolean bl) {
        super(string, icon, bl);
    }

    public void setText(String string) {
        if (this.isAutoMnemonicEnabled()) {
            String[] stringArray = LAFUtil.parseMnemonic(string);
            super.setText(stringArray[0]);
            this.fMnemonic = stringArray[1];
        } else {
            super.setText(string);
        }
        this.fOriginalString = string;
    }

    public String getButtonMnemonic() {
        return this.fMnemonic;
    }

    public void setButtonMnemonic(String string) {
        this.fMnemonic = string;
    }

    public Mnemonic getComponentMnemonic() {
        return this.fMnemonic == null ? null : new Mnemonic(){

            @NotNull
            public String getMnemonic() {
                return TSCheckBox.this.fMnemonic;
            }

            @NotNull
            public Point getLocationOnComponent() {
                return TSUtil.getMnemonicLocation((AbstractButton)((Object)TSCheckBox.this));
            }

            @NotNull
            public JComponent getComponent() {
                return TSCheckBox.this;
            }
        };
    }

    public MnemonicsProvider getMnemonicsProvider() {
        return this.fMnemonic == null ? null : this.createProvider();
    }

    protected ButtonMnemonicsProvider createProvider() {
        return new ButtonMnemonicsProvider();
    }

    @Override
    @NotNull
    public LayoutMode getSupportedLayoutMode() {
        return LayoutMode.HORIZONTAL_ONLY_CAPABILITIES;
    }

    @Override
    public int getPreferredWidth(@NotNull LayoutMode layoutMode, int n) {
        return this.getPreferredSize().width;
    }

    @Override
    public boolean canBeGroupedWith(@NotNull TSComponent tSComponent) {
        return tSComponent instanceof AbstractButton;
    }

    public ToolstripCheckBoxUI getUI() {
        return (ToolstripCheckBoxUI)this.ui;
    }

    public String getUIClassID() {
        return "Toolstrip.CheckBoxUI";
    }

    public String toString() {
        return LAFUtil.getComponentDescription(this, this.getText());
    }

    public class ButtonMnemonicsProvider
    extends ComponentMnemonicsProvider {
        public ButtonMnemonicsProvider() {
            super((JComponent)((Object)TSCheckBox.this));
        }

        @Override
        protected void execute() {
            TSUtil.clickButton((AbstractButton)((Object)TSCheckBox.this));
        }
    }
}

