/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.components.gallery.popupview;

import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolstrip.components.gallery.GalleryIcon;
import com.mathworks.toolstrip.components.gallery.GalleryResources;
import com.mathworks.toolstrip.components.gallery.model.GalleryModel;
import com.mathworks.toolstrip.components.gallery.model.Item;
import com.mathworks.toolstrip.components.gallery.popupview.GalleryPopupView;
import java.awt.event.ActionEvent;

public class FavoriteAction
extends MJAbstractAction {
    private final Item fItem;
    private final GalleryModel fModel;
    private final Runnable fFavoritesAnimation;

    public FavoriteAction(Item item, GalleryModel galleryModel) {
        this(item, galleryModel, null);
    }

    public FavoriteAction(Item item, GalleryModel galleryModel, Runnable runnable) {
        this.fItem = item;
        this.fModel = galleryModel;
        this.fFavoritesAnimation = runnable;
        this.setComponentName("Favorite_" + item.getName());
        this.update();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.fFavoritesAnimation instanceof GalleryPopupView.FavoriteAnimation) {
            if (((GalleryPopupView.FavoriteAnimation)((Object)this.fFavoritesAnimation)).isRunning()) {
                return;
            }
            if (this.fModel.isFavorite(this.fItem)) {
                ((GalleryPopupView.FavoriteAnimation)((Object)this.fFavoritesAnimation)).setItem(this.fItem);
                ((GalleryPopupView.FavoriteAnimation)((Object)this.fFavoritesAnimation)).setMoveTo(false);
                this.fFavoritesAnimation.run();
            } else {
                ((GalleryPopupView.FavoriteAnimation)((Object)this.fFavoritesAnimation)).setItem(this.fItem);
                ((GalleryPopupView.FavoriteAnimation)((Object)this.fFavoritesAnimation)).setMoveTo(true);
                this.fFavoritesAnimation.run();
            }
        } else if (this.fModel.isFavorite(this.fItem)) {
            this.fModel.removeFromFavorites(this.fItem);
        } else {
            this.fModel.addToFavorites(this.fItem);
        }
        this.update();
    }

    private void update() {
        if (this.fModel.isFavorite(this.fItem)) {
            this.putValue("Name", GalleryResources.getString("favorite.remove.menuitem"));
            this.putValue("SmallIcon", GalleryIcon.ACTIVE_FAVORITE_ICON.getIcon());
            this.setTip(GalleryResources.getString("favorite.remove.tooltip"));
        } else {
            this.putValue("Name", GalleryResources.getString("favorite.add.menuitem"));
            this.putValue("SmallIcon", GalleryIcon.INACTIVE_FAVORITE_ICON.getIcon());
            this.setTip(GalleryResources.getString("favorite.add.tooltip"));
        }
    }
}

