/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.factory;

import com.mathworks.toolstrip.factory.TSTabConfiguration;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TSRegistry {
    private final List<TSTabConfiguration> fTabConfigurationList = new ArrayList<TSTabConfiguration>();
    private final Map<String, TSToolSetContents> fToolSetContentsMap = new HashMap<String, TSToolSetContents>();
    private final Map<String, TSToolSet> fToolSetMap = new HashMap<String, TSToolSet>();
    private final Map<String, String> fContextMap = new HashMap<String, String>();
    private final List<Listener> fListeners = new ArrayList<Listener>();
    private final List<Listener> fCoalescingListeners = new ArrayList<Listener>();
    private Runnable fPendingNotifier;

    public void addTabConfiguration(TSTabConfiguration tSTabConfiguration) {
        if (tSTabConfiguration != null) {
            this.fTabConfigurationList.add(tSTabConfiguration);
            this.fireUpdateEvent(UpdateType.ADDED_TAB_CONFIG, tSTabConfiguration);
        }
    }

    public void replaceTabConfiguration(TSTabConfiguration tSTabConfiguration) {
        String string = tSTabConfiguration.getName();
        for (int i = 0; i < this.fTabConfigurationList.size(); ++i) {
            TSTabConfiguration tSTabConfiguration2 = this.fTabConfigurationList.get(i);
            if (!tSTabConfiguration2.getName().equals(string)) continue;
            this.fTabConfigurationList.remove(i);
            this.fTabConfigurationList.add(i, tSTabConfiguration);
            this.fireUpdateEvent(UpdateType.UPDATED_TAB_CONFIG, tSTabConfiguration);
            break;
        }
    }

    public List<TSTabConfiguration> getTabConfigurations() {
        return Collections.unmodifiableList(this.fTabConfigurationList);
    }

    public TSTabConfiguration getTabConfiguration(String string) {
        for (TSTabConfiguration tSTabConfiguration : this.fTabConfigurationList) {
            if (!tSTabConfiguration.getName().equals(string)) continue;
            return tSTabConfiguration;
        }
        return null;
    }

    public void addToolSetContents(TSToolSetContents tSToolSetContents) {
        if (tSToolSetContents == null) {
            return;
        }
        for (TSToolSetContents tSToolSetContents2 : this.fToolSetContentsMap.values()) {
            TSToolSetContents.resolveDependencies(tSToolSetContents2, tSToolSetContents);
        }
        this.fToolSetContentsMap.put(tSToolSetContents.getName(), tSToolSetContents);
        this.fireUpdateEvent(UpdateType.ADDED_TOOL_SET_CONTENT, tSToolSetContents);
    }

    public void replaceToolSetContents(TSToolSetContents tSToolSetContents) {
        TSToolSetContents tSToolSetContents2 = this.fToolSetContentsMap.remove(tSToolSetContents.getName());
        if (tSToolSetContents2 != null) {
            this.fToolSetContentsMap.put(tSToolSetContents.getName(), tSToolSetContents);
            this.fireUpdateEvent(UpdateType.UPDATED_TOOL_SET_CONTENT, tSToolSetContents);
        }
    }

    public TSToolSetContents getToolSetContents(String string) {
        return this.fToolSetContentsMap.get(string);
    }

    public void addToolSet(TSToolSet tSToolSet) {
        this.fToolSetMap.put(tSToolSet.getName(), tSToolSet);
        this.fireUpdateEvent(UpdateType.ADDED_TOOL_SET, tSToolSet);
    }

    public void replaceToolSet(TSToolSet tSToolSet) {
        TSToolSet tSToolSet2 = this.fToolSetMap.remove(tSToolSet.getName());
        if (tSToolSet2 != null) {
            this.fToolSetMap.put(tSToolSet.getName(), tSToolSet);
            this.fireUpdateEvent(UpdateType.UPDATED_TOOL_SET, tSToolSet);
        }
    }

    public TSToolSet getToolSet(String string) {
        return this.fToolSetMap.get(string);
    }

    public Map<String, TSToolSet> getToolSetMap() {
        return Collections.unmodifiableMap(this.fToolSetMap);
    }

    public void addTabContext(String string, String string2) {
        this.fContextMap.put(string, string2);
    }

    public String getTabContextLabel(String string) {
        return this.fContextMap.get(string);
    }

    public void removeTabContext(String string) {
        this.fContextMap.remove(string);
    }

    public void addListener(Listener listener) {
        this.fListeners.add(listener);
    }

    public void addCoalescingListener(Listener listener) {
        this.fCoalescingListeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.fListeners.remove(listener);
        this.fCoalescingListeners.remove(listener);
    }

    private void fireUpdateEvent(UpdateType updateType, Object object) {
        if (!this.fCoalescingListeners.isEmpty() && this.fPendingNotifier == null) {
            this.fPendingNotifier = new Runnable(){

                @Override
                public void run() {
                    UpdateEvent updateEvent = new UpdateEvent(TSRegistry.this, UpdateType.UPDATED_TOOL_SET, TSRegistry.this);
                    for (Listener listener : TSRegistry.this.fCoalescingListeners) {
                        listener.registryUpdated(updateEvent);
                    }
                    TSRegistry.this.fPendingNotifier = null;
                }
            };
            EventQueue.invokeLater(this.fPendingNotifier);
        }
        if (this.fListeners.isEmpty()) {
            return;
        }
        UpdateEvent updateEvent = new UpdateEvent(this, updateType, object);
        for (Listener listener : this.fListeners) {
            listener.registryUpdated(updateEvent);
        }
    }

    public static interface Listener {
        public void registryUpdated(UpdateEvent var1);
    }

    public static class UpdateEvent {
        private final TSRegistry fSource;
        private final UpdateType fType;
        private final Object fChanged;

        private UpdateEvent(TSRegistry tSRegistry, UpdateType updateType, Object object) {
            this.fSource = tSRegistry;
            this.fType = updateType;
            this.fChanged = object;
        }

        public TSRegistry getSource() {
            return this.fSource;
        }

        public UpdateType getType() {
            return this.fType;
        }

        public Object getChanged() {
            return this.fChanged;
        }
    }

    public static enum UpdateType {
        ADDED_TAB_CONFIG,
        ADDED_TOOL_SET_CONTENT,
        ADDED_TOOL_SET,
        UPDATED_TAB_CONFIG,
        UPDATED_TOOL_SET_CONTENT,
        UPDATED_TOOL_SET;

    }
}

