/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.toolstrip.components.ButtonOrientation;
import com.mathworks.toolstrip.components.LayoutMode;
import com.mathworks.toolstrip.components.TSComponent;
import com.mathworks.toolstrip.components.TSUtil;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.ToolstripButtonUI;
import com.mathworks.util.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.ChangeEvent;

public class RegularButtonUI
extends ToolstripButtonUI {
    private static final RegularButtonUI REGULAR_BUTTON_UI = new RegularButtonUI();

    public static RegularButtonUI createUI(JComponent jComponent) {
        return REGULAR_BUTTON_UI;
    }

    @Override
    protected void paintPressed(Graphics2D graphics2D, AbstractButton abstractButton, Rectangle rectangle) {
        RectangularShape rectangularShape = LAFUtil.getButtonRect(rectangle);
        LAFUtil.drawRoundButtonPressedRect(graphics2D, rectangularShape, this.fTheme);
    }

    @Override
    protected void paintUnArmed(Graphics2D graphics2D, AbstractButton abstractButton, Rectangle rectangle) {
    }

    @Override
    protected void paintArmed(Graphics2D graphics2D, AbstractButton abstractButton, Rectangle rectangle) {
        LAFUtil.drawButtonArmedRect(graphics2D, rectangle, this.fTheme);
    }

    @Override
    protected void paintContent(Graphics2D graphics2D, AbstractButton abstractButton, Rectangle rectangle) {
        this.paintContent(graphics2D, abstractButton, rectangle, false);
    }

    protected void paintContent(Graphics2D graphics2D, AbstractButton abstractButton, Rectangle rectangle, boolean bl) {
        boolean bl2;
        String string = abstractButton.getText();
        LayoutMode layoutMode = LAFUtil.getLayoutMode(abstractButton);
        boolean bl3 = layoutMode.hasProperty(LayoutMode.Property.NO_LABEL);
        boolean bl4 = layoutMode.hasProperty(LayoutMode.Property.VERTICAL);
        ButtonOrientation buttonOrientation = this.getButtonOrientation(abstractButton);
        if (buttonOrientation != ButtonOrientation.AUTO) {
            bl4 = buttonOrientation == ButtonOrientation.VERTICAL;
        }
        Icon icon = RegularButtonUI.getIcon(abstractButton, bl4);
        if (bl4 || icon == null) {
            bl3 = false;
        }
        boolean bl5 = bl2 = icon != null && icon.getIconHeight() > 30;
        if (!bl4 && bl2 && buttonOrientation == ButtonOrientation.AUTO) {
            bl4 = true;
        }
        if (StringUtils.isEmpty((String)string)) {
            bl3 = true;
        }
        if (!bl3) {
            graphics2D.setFont(abstractButton.getFont());
            graphics2D.setColor(abstractButton.isEnabled() ? abstractButton.getForeground() : this.fTheme.getButtonDisabledTextColor());
        }
        if (bl4) {
            List list;
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            List list2 = list = bl3 ? Collections.emptyList() : StringUtils.split((String)string, (String)"\n");
            if (icon != null) {
                RegularButtonUI.drawIconWithShadow(graphics2D, abstractButton, icon, rectangle.x + (rectangle.width - icon.getIconWidth()) / 2, rectangle.y + 5);
                RegularButtonUI.drawLines(graphics2D, rectangle, fontMetrics, list, bl, bl2);
            } else {
                RegularButtonUI.drawLines(graphics2D, rectangle, fontMetrics, list, bl, bl2);
            }
        } else {
            int n = 4;
            if (icon != null) {
                RegularButtonUI.drawIconWithShadow(graphics2D, abstractButton, icon, rectangle.x + n, rectangle.y + (rectangle.height - icon.getIconHeight()) / 2);
                n += icon.getIconWidth() + (bl3 ? 0 : 4);
            }
            int n2 = 0;
            if (!bl3 && string != null) {
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                n2 = fontMetrics.stringWidth(string);
                if (icon == null) {
                    n = (rectangle.width - n2 - (bl ? 13 : 0)) / 2;
                }
                LAFUtil.drawString(graphics2D, string, rectangle.x + n, rectangle.y + (rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
            }
            if (bl) {
                if (ColorUtils.isDark((Color)abstractButton.getForeground())) {
                    LAFUtil.paintDarkTriangle(graphics2D, rectangle.x + n + n2 + 6, rectangle.y + (rectangle.height - 4) / 2);
                } else {
                    LAFUtil.paintWhiteTriangle(graphics2D, rectangle.x + n + n2 + 6, rectangle.y + (rectangle.height - 4) / 2);
                }
            }
        }
    }

    protected static void drawLines(Graphics2D graphics2D, Rectangle rectangle, FontMetrics fontMetrics, List<String> list, boolean bl, boolean bl2) {
        int n = rectangle.y + rectangle.height - 5 - fontMetrics.getHeight() * (bl2 ? 1 : 2);
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            String string = list.get(i);
            int n3 = fontMetrics.stringWidth(string);
            boolean bl3 = bl && (n2 > 1 && i == n2 - 1 || n2 == 1 && bl2);
            int n4 = rectangle.x + (rectangle.width - (n3 + (bl3 ? 13 : 0))) / 2;
            LAFUtil.drawString(graphics2D, string, n4, n + fontMetrics.getAscent());
            if (bl3) {
                LAFUtil.paintDarkTriangle(graphics2D, n4 + n3 + 6, n + (fontMetrics.getHeight() - 4) / 2);
            }
            n += fontMetrics.getHeight();
        }
        if (n2 == 1 && bl && !bl2) {
            LAFUtil.paintDarkTriangle(graphics2D, rectangle.x + (rectangle.width - 7) / 2, n + (fontMetrics.getHeight() - 4) / 2);
        }
    }

    @Override
    public int getPreferredWidth(TSComponent tSComponent, LayoutMode layoutMode) {
        return this.getPreferredSize((AbstractButton)((AbstractButton)((Object)tSComponent)), (LayoutMode)layoutMode, (boolean)false).width;
    }

    public Dimension getPreferredSize(AbstractButton abstractButton, LayoutMode layoutMode, boolean bl) {
        boolean bl2;
        String string = abstractButton.getText();
        boolean bl3 = layoutMode.hasProperty(LayoutMode.Property.NO_LABEL);
        boolean bl4 = layoutMode.hasProperty(LayoutMode.Property.VERTICAL);
        ButtonOrientation buttonOrientation = this.getButtonOrientation(abstractButton);
        if (buttonOrientation != ButtonOrientation.AUTO) {
            bl4 = buttonOrientation == ButtonOrientation.VERTICAL;
        }
        Icon icon = RegularButtonUI.getIcon(abstractButton, bl4);
        if (bl4 || icon == null) {
            bl3 = false;
        }
        boolean bl5 = bl2 = icon != null && icon.getIconHeight() > 30;
        if (!bl4 && bl2 && buttonOrientation == ButtonOrientation.AUTO) {
            bl4 = true;
        }
        if (StringUtils.isEmpty((String)string)) {
            bl3 = true;
        }
        int n = 0;
        int n2 = 0;
        if (bl4) {
            int n3 = icon != null ? 12 + icon.getIconWidth() : 0;
            FontMetrics fontMetrics = FontUtils.getFontMetrics((Font)abstractButton.getFont());
            int n4 = 0;
            List list = bl3 ? Collections.emptyList() : StringUtils.split((String)string, (String)"\n");
            int n5 = list.size();
            for (int i = 0; i < n5; ++i) {
                String string2 = (String)list.get(i);
                int n6 = fontMetrics.stringWidth(string2);
                if (bl && (n5 > 1 && i == n5 - 1 || n5 == 1 && bl2)) {
                    n6 += 13;
                }
                n4 = Math.max(n4, n6);
            }
            n = Math.max(8 + n4, n3);
            n2 = this.fTheme.getToolstripControlContentHeight();
        } else {
            int n7;
            n2 += 6;
            n += 8;
            int n8 = n7 = icon != null ? icon.getIconHeight() : 16;
            n += icon != null ? icon.getIconWidth() + (bl3 ? 0 : 4) : 0;
            if (!bl3) {
                FontMetrics fontMetrics = FontUtils.getFontMetrics((Font)abstractButton.getFont());
                n += fontMetrics.stringWidth(string);
                if (bl) {
                    n += 13;
                }
                n7 = Math.max(n7, fontMetrics.getHeight());
            }
            n2 += n7;
        }
        return new Dimension(n, n2);
    }

    protected Dimension getPreferredSize(JComponent jComponent, boolean bl) {
        return this.getPreferredSize((AbstractButton)jComponent, LAFUtil.getLayoutMode(jComponent), bl);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent, false);
    }

    @Override
    protected ToolstripButtonUI.ToolstripButtonListener newToolstripButtonListener(AbstractButton abstractButton) {
        return new RegularToolstripButtonListener(abstractButton);
    }

    static class RegularToolstripButtonListener
    extends ToolstripButtonUI.ToolstripButtonListener
    implements ActionListener {
        private long lastPressedTimestamp;
        private boolean shouldDiscardRelease;

        RegularToolstripButtonListener(AbstractButton abstractButton) {
            super(abstractButton);
            abstractButton.addActionListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.fButton.revalidate();
            this.fButton.repaint();
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.fButton.revalidate();
            this.fButton.repaint();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.fButton.repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.fButton.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.fButton.contains(mouseEvent.getX(), mouseEvent.getY())) {
                long l = this.fButton.getMultiClickThreshhold();
                long l2 = this.lastPressedTimestamp;
                long l3 = this.lastPressedTimestamp = mouseEvent.getWhen();
                if (l2 != -1L && l3 - l2 < l) {
                    this.shouldDiscardRelease = true;
                } else {
                    ButtonModel buttonModel = this.fButton.getModel();
                    if (buttonModel.isEnabled()) {
                        this.mousePressedImpl(mouseEvent);
                    }
                }
            }
        }

        protected void mousePressedImpl(MouseEvent mouseEvent) {
            ButtonModel buttonModel = this.fButton.getModel();
            buttonModel.setArmed(true);
            buttonModel.setPressed(true);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (this.shouldDiscardRelease) {
                    this.shouldDiscardRelease = false;
                } else {
                    this.mouseReleasedImpl();
                }
            }
        }

        protected void mouseReleasedImpl() {
            this.fButton.getModel().setPressed(false);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.fButton.getModel().setArmed(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.fButton.getModel().setArmed(false);
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            if (ancestorEvent.getSource() == this.fButton) {
                this.fButton.getModel().setArmed(false);
            }
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            this.ancestorAdded(ancestorEvent);
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TSUtil.toolstripActionProcessed(this.fButton);
        }
    }
}

