/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.mathworks.mwswing.plaf.MBasicComboPopup;
import com.mathworks.toolstrip.components.TSComboBox;
import com.mathworks.toolstrip.components.TSList;
import com.mathworks.toolstrip.components.TSTextField;
import com.mathworks.toolstrip.components.TSUtil;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.ToolstripTextBorder;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;

public class ToolstripComboBoxUI
extends BasicComboBoxUI {
    public static final String DO_NOT_CLOSE_ON_SELECTION = "do.not.close.on.selection";

    public static ToolstripComboBoxUI createUI(JComponent jComponent) {
        return new ToolstripComboBoxUI();
    }

    @Override
    protected ComboPopup createPopup() {
        return new MBasicComboPopup(this.comboBox){

            protected JList createList() {
                TSList tSList = new TSList(this.comboBox.getModel()){

                    public void processMouseEvent(MouseEvent mouseEvent) {
                        if (mouseEvent.isControlDown()) {
                            mouseEvent = new MouseEvent((Component)mouseEvent.getSource(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers() ^ 2, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), 0);
                        }
                        super.processMouseEvent(mouseEvent);
                    }
                };
                tSList.putClientProperty(ToolstripComboBoxUI.DO_NOT_CLOSE_ON_SELECTION, true);
                return tSList;
            }
        };
    }

    @Override
    protected void installDefaults() {
        Insets insets = UIManager.getInsets("ComboBox.padding");
        UIManager.put("ComboBox.padding", this.getDefaultInsets());
        super.installDefaults();
        UIManager.put("ComboBox.padding", insets);
        this.comboBox.setOpaque(true);
    }

    private Insets getDefaultInsets() {
        return new Insets(0, 2, 0, 2);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ToolstripComboBoxUI.this.comboBox != null && ToolstripComboBoxUI.this.comboBox.isDisplayable()) {
                    Timer timer = new Timer(100, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (ToolstripComboBoxUI.this.comboBox != null && !ToolstripComboBoxUI.this.comboBox.isPopupVisible()) {
                                TSUtil.toolstripActionProcessed(ToolstripComboBoxUI.this.comboBox);
                            }
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                }
            }
        });
        this.comboBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("editable") || propertyChangeEvent.getPropertyName().equals("enabled")) {
                    ToolstripComboBoxUI.this.updateColors();
                }
            }
        });
        this.comboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                if (ToolstripComboBoxUI.this.comboBox == null) {
                    return;
                }
                if (ToolstripComboBoxUI.this.comboBox.isEditable()) {
                    ((JComponent)ToolstripComboBoxUI.this.comboBox.getEditor().getEditorComponent()).setRequestFocusEnabled(false);
                } else {
                    ToolstripComboBoxUI.this.comboBox.setRequestFocusEnabled(false);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                if (ToolstripComboBoxUI.this.comboBox == null) {
                    return;
                }
                TSUtil.relinquishFocus(ToolstripComboBoxUI.this.comboBox);
                if (ToolstripComboBoxUI.this.comboBox.isEditable()) {
                    ((JComponent)ToolstripComboBoxUI.this.comboBox.getEditor().getEditorComponent()).setRequestFocusEnabled(true);
                } else {
                    ToolstripComboBoxUI.this.comboBox.setRequestFocusEnabled(true);
                }
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        JTextComponent jTextComponent = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
        LocalMouseListener localMouseListener = new LocalMouseListener();
        this.comboBox.addMouseListener(localMouseListener);
        this.arrowButton.addMouseListener(localMouseListener);
        this.arrowButton.putClientProperty("focusable-sibling", jTextComponent);
        this.updateColors();
        jComponent.setBorder(new ToolstripTextBorder(jTextComponent));
        jComponent.setFont(ToolstripTheme.getInstance().getTSComboBoxFont());
    }

    private void updateColors() {
        if (this.comboBox == null) {
            return;
        }
        ToolstripTheme toolstripTheme = ToolstripTheme.getInstance();
        if (!this.comboBox.isEnabled()) {
            this.comboBox.setBackground(toolstripTheme.getTextDisabledBackground());
            this.comboBox.setForeground(Color.darkGray);
        } else if (!this.comboBox.isEditable()) {
            this.comboBox.setBackground(toolstripTheme.getTextNonEditableBackground());
            this.comboBox.setForeground(Color.black);
        }
    }

    protected ListCellRenderer createRenderer() {
        return new CellRenderer();
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new MyComboBoxEditor();
    }

    @Override
    protected JButton createArrowButton() {
        JButton jButton = new JButton(){

            @Override
            public void paint(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                int n = this.getWidth();
                int n2 = this.getHeight();
                if (ToolstripComboBoxUI.this.comboBox.isEditable()) {
                    graphics2D.setColor(this.getBackground());
                    graphics.fillRect(0, 0, n, n2);
                }
                Composite composite = graphics2D.getComposite();
                if (!ToolstripComboBoxUI.this.comboBox.isEnabled()) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
                }
                LAFUtil.paintDarkTriangle(graphics2D, (n - 7) / 2, (n2 - 4) / 2);
                graphics2D.setComposite(composite);
            }
        };
        jButton.setOpaque(false);
        jButton.setName("ComboBox.arrowButton");
        return jButton;
    }

    @Override
    public void configureArrowButton() {
        super.configureArrowButton();
    }

    private boolean isArmed() {
        if (!this.comboBox.isEnabled()) {
            return false;
        }
        Boolean bl = (Boolean)this.comboBox.getClientProperty("mouse-is-over");
        return bl != null && bl != false;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable() || !this.comboBox.isEnabled()) {
            Rectangle rectangle = this.rectangleForCurrentValue();
            this.paintBackground(graphics, new Rectangle(0, 0, this.comboBox.getWidth(), this.comboBox.getHeight()), this.hasFocus);
            this.paintCurrentValue(graphics, rectangle, this.hasFocus);
        }
    }

    public void paintBackground(Graphics graphics, Rectangle rectangle, boolean bl) {
        Color color = graphics.getColor();
        graphics.setColor(this.comboBox.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (bl || this.isArmed()) {
            LAFUtil.drawArmedRect((Graphics2D)graphics, rectangle);
        }
        graphics.setColor(color);
    }

    @Override
    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        boolean bl2 = bl && !this.isPopupVisible(this.comboBox);
        ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
        Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, bl2, false);
        if (!this.comboBox.isEditable()) {
            ((JLabel)component).setOpaque(false);
        } else {
            component.setBackground(this.comboBox.getBackground());
        }
        component.setForeground(this.comboBox.getForeground());
        component.setFont(this.comboBox.getFont());
        boolean bl3 = false;
        if (component instanceof JPanel) {
            bl3 = true;
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        Insets insets = this.getDefaultInsets();
        if (insets != null) {
            n = rectangle.x + insets.left;
            n2 = rectangle.y + insets.top;
            n3 = rectangle.width - (insets.left + insets.right);
            n4 = rectangle.height - (insets.top + insets.bottom);
        }
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, n, n2, n3, n4, bl3);
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    private static class LocalMouseListener
    extends MouseAdapter {
        private LocalMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            TSComboBox tSComboBox = this.getComboBox(mouseEvent);
            tSComboBox.putClientProperty("mouse-is-over", true);
            ((JComponent)tSComboBox.getEditor().getEditorComponent()).putClientProperty("mouse-is-over", true);
            tSComboBox.repaint();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            TSComboBox tSComboBox = this.getComboBox(mouseEvent);
            Point point = mouseEvent.getPoint();
            if (mouseEvent.getComponent() != tSComboBox) {
                point = SwingUtilities.convertPoint(mouseEvent.getComponent(), point, (Component)((Object)tSComboBox));
            }
            if (point.x < 0 || point.y < 0 || point.x >= tSComboBox.getWidth() || point.y >= tSComboBox.getHeight()) {
                tSComboBox.putClientProperty("mouse-is-over", false);
                ((JComponent)tSComboBox.getEditor().getEditorComponent()).putClientProperty("mouse-is-over", false);
                tSComboBox.repaint();
            }
        }

        private TSComboBox getComboBox(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            return (TSComboBox)((Object)(component instanceof TSComboBox ? component : SwingUtilities.getAncestorOfClass(TSComboBox.class, component)));
        }
    }

    private class MyComboBoxEditor
    extends BasicComboBoxEditor
    implements PropertyChangeListener {
        private MyComboBoxEditor() {
        }

        @Override
        protected JTextField createEditorComponent() {
            TSTextField tSTextField = new TSTextField("", 9);
            tSTextField.setBorder(new EmptyBorder(0, 3, 0, 1));
            tSTextField.addPropertyChangeListener(this);
            return tSTextField;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ToolstripComboBoxUI.this.arrowButton != null && this.editor != null) {
                ToolstripComboBoxUI.this.arrowButton.setBackground(this.editor.getBackground());
            }
        }
    }

    public static class CellRenderer
    extends JLabel
    implements ListCellRenderer {
        private Color fSelectionForeground;
        private Color fSelectionBackground;

        public CellRenderer() {
            this.setFont(ToolstripTheme.getInstance().getTSComboBoxFont());
            this.fSelectionBackground = UIManager.getColor("List.selectionBackground");
            this.fSelectionForeground = UIManager.getColor("List.selectionForeground");
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            String string2 = string = object != null ? object.toString() : "";
            if (string.length() == 0) {
                string = " ";
            }
            this.setText(string);
            if (bl) {
                this.setForeground(this.fSelectionForeground);
                this.setBackground(this.fSelectionBackground);
                this.setOpaque(true);
            } else {
                this.setForeground(Color.black);
                this.setOpaque(false);
            }
            return this;
        }
    }
}

