/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.plaf;

import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.text.JTextComponent;

class ToolstripTextBorder
extends AbstractBorder {
    private final JTextComponent fTextComponent;
    private Insets fPadding;

    ToolstripTextBorder(JTextComponent jTextComponent) {
        this(jTextComponent, new Insets(0, 0, 0, 0));
    }

    ToolstripTextBorder(JTextComponent jTextComponent, Insets insets) {
        this.fTextComponent = jTextComponent;
        this.fPadding = insets;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.translate(n, n2);
        boolean bl = LAFUtil.isActive(this.fTextComponent);
        ToolstripTheme toolstripTheme = ToolstripTheme.getInstance();
        graphics.setColor(bl ? toolstripTheme.getTextActiveBorderTop() : toolstripTheme.getTextInactiveBorderTop());
        graphics.drawLine(0, 0, 0, n4 - 1);
        graphics.drawLine(1, 0, n3 - 1, 0);
        graphics.drawLine(n3 - 1, 1, n3 - 1, n4 - 1);
        graphics.setColor(bl ? toolstripTheme.getTextActiveBorderBottom() : toolstripTheme.getTextInactiveBorderBottom());
        graphics.drawLine(1, n4 - 1, n3 - 2, n4 - 1);
        graphics.translate(-n, -n2);
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.top = this.fPadding.top + 1;
        insets.left = this.fPadding.left + 1;
        insets.right = this.fPadding.right + 1;
        insets.bottom = this.fPadding.bottom + 1;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

