/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.sections;

import com.google.common.base.Preconditions;
import com.mathworks.desktop.overlay.Overlay;
import com.mathworks.desktop.overlay.OverlayConstraints;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.desktop.overlay.OverlayType;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.toolstrip.ToolstripSection;
import com.mathworks.toolstrip.accessories.IsOnToolstripPredicate;
import com.mathworks.toolstrip.components.ButtonOrientation;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSDropDownButton;
import com.mathworks.toolstrip.components.TSPanel;
import com.mathworks.toolstrip.components.TSSplitButton;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.plaf.ToolstripTheme;
import com.mathworks.toolstrip.sections.DefaultToolstripSection;
import com.mathworks.toolstrip.sections.SectionBuilder;
import com.mathworks.util.Disposable;
import com.mathworks.util.Disposer;
import com.mathworks.util.NegationPredicate;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;

public class ToolstripSections {
    public static final String BUTTON_POPUP_NAME = "popupListName";
    private static final int HORIZONTAL_COLUMNS_GAP = 4;
    private static LayoutManager SECTION_LAYOUT = new SectionLayout();
    private static LayoutManager COLUMN_LAYOUT = new ColumnLayout();

    private ToolstripSections() {
    }

    public static SectionBuilder newSectionBuilder() {
        return new MySectionBuilder();
    }

    public static SectionBuilder newSectionBuilder(String string) {
        return new MySectionBuilder().name(string);
    }

    public static SectionBuilder newSectionBuilder(String string, String string2) {
        return new MySectionBuilder().name(string).title(string2);
    }

    public static SectionBuilder newSectionBuilder(String string, String string2, int n) {
        return new MySectionBuilder().name(string).title(string2).priority(n);
    }

    public static TSSplitButton newSplitButton(Action action, ListItem[] listItemArray, ListStyle listStyle, ListActionListener listActionListener) {
        return ToolstripSections.newSplitButton(action, listItemArray, listStyle, listActionListener, true);
    }

    public static TSSplitButton newSplitButton(Action action, ListItem[] listItemArray, ListStyle listStyle, ListActionListener listActionListener, boolean bl) {
        return ToolstripSections.newSplitButton(action, listItemArray, listStyle, listActionListener, bl, BUTTON_POPUP_NAME);
    }

    public static TSSplitButton newSplitButton(Action action, ListItem[] listItemArray, ListStyle listStyle, ListActionListener listActionListener, boolean bl, String string) {
        return (TSSplitButton)ToolstripSections.setPopupOnDropDownButton(new TSSplitButton(action), listItemArray, listStyle, listActionListener, bl, string);
    }

    public static TSDropDownButton newDropDownButton(Action action, ListItem[] listItemArray, ListStyle listStyle, ListActionListener listActionListener, boolean bl, String string) {
        return ToolstripSections.setPopupOnDropDownButton(new TSDropDownButton(action), listItemArray, listStyle, listActionListener, bl, string);
    }

    public static TSDropDownButton newDropDownButton(Action action, ListItem[] listItemArray, ListStyle listStyle, ListActionListener listActionListener, boolean bl) {
        return ToolstripSections.newDropDownButton(action, listItemArray, listStyle, listActionListener, bl, BUTTON_POPUP_NAME);
    }

    private static TSDropDownButton setPopupOnDropDownButton(TSDropDownButton tSDropDownButton, final ListItem[] listItemArray, final ListStyle listStyle, final ListActionListener listActionListener, boolean bl, final String string) {
        tSDropDownButton.setOrientation(bl ? ButtonOrientation.VERTICAL : ButtonOrientation.HORIZONTAL);
        tSDropDownButton.setPopupListener(new PopupListener(){

            @Override
            public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
                PopupList popupList = ToolstripSections.createList(listItemArray, listActionListener, listStyle);
                popupList.setName(string);
                popupCallback.show(popupList);
            }
        });
        return tSDropDownButton;
    }

    public static PopupList createList(ListItem[] listItemArray, ListActionListener listActionListener, ListStyle listStyle) {
        PopupList popupList = new PopupList(listItemArray);
        popupList.setListStyle(listStyle);
        popupList.addListActionListener(listActionListener);
        return popupList;
    }

    public static Overlay showPopup(JComponent jComponent, JComponent jComponent2) {
        return ToolstripSections.showPopup(jComponent, jComponent2, true, jComponent.isFocusOwner() ? jComponent : null);
    }

    public static Overlay showPopup(final JComponent jComponent, JComponent jComponent2, boolean bl, final Component component) {
        jComponent.putClientProperty("PopupComponent", jComponent2);
        Window window = WindowUtils.getTopmostWindow((Component)jComponent);
        Dimension dimension = jComponent2.getPreferredSize();
        Rectangle rectangle = LAFUtil.convertRectangleToScreen(jComponent.getBounds(), jComponent.getParent());
        Rectangle rectangle2 = rectangle.width > dimension.width ? new Rectangle(rectangle.x + rectangle.width - dimension.width, rectangle.y + rectangle.height, dimension.width, dimension.height) : new Rectangle(rectangle.x, rectangle.y + rectangle.height, dimension.width, dimension.height);
        int n = rectangle2.height;
        Rectangle rectangle3 = WindowUtils.getScreenBoundsWithOrNearestToPoint((Point)new Point(rectangle.x + rectangle.width - 10, rectangle.y));
        rectangle2.y = Math.max(rectangle2.y, rectangle3.y);
        int n2 = Math.min(rectangle2.y + rectangle2.height, rectangle3.y + rectangle3.height - 20);
        rectangle2.height = Math.min(rectangle2.height, Math.max(100, n2 - rectangle2.y));
        rectangle2.y = Math.min(rectangle3.y + rectangle3.height - rectangle2.height, rectangle2.y);
        rectangle2.x = Math.max(rectangle2.x, rectangle3.x);
        rectangle2.x = Math.min(rectangle2.x, rectangle3.x + rectangle3.width - (rectangle2.width + 20));
        final Rectangle rectangle4 = LAFUtil.convertRectangleFromScreen(rectangle2, window);
        Overlay overlay = null;
        if (jComponent2 instanceof JPopupMenu) {
            final JPopupMenu jPopupMenu = (JPopupMenu)jComponent2;
            final Overlay overlay2 = overlay = new Overlay(){

                public Component getComponent() {
                    return jPopupMenu;
                }

                public Rectangle layout(Window window) {
                    return rectangle4;
                }

                public OverlayType getType() {
                    return new OverlayType(0, Overlay.Mode.AUTO, true);
                }

                public void dispose() {
                    jPopupMenu.setVisible(false);
                }
            };
            jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    this.dispose();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    this.dispose();
                }

                private void dispose() {
                    jPopupMenu.removePopupMenuListener(this);
                    MJUtilities.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Disposer.dispose((Disposable)overlay2);
                        }
                    });
                }
            });
            Rectangle rectangle5 = SwingUtilities.convertRectangle(window, rectangle4, jComponent);
            jPopupMenu.show(jComponent, rectangle5.x, rectangle5.y);
        } else {
            Object object;
            if (rectangle2.height < n) {
                object = new MJScrollPane((Component)jComponent2, 22, 31);
                rectangle4.width += object.getVerticalScrollBar().getPreferredSize().width;
            } else {
                object = new JPanel(new BorderLayout());
                ((JComponent)object).setBorder(new LineBorder(new Color(0x868686), 1));
                ((Container)object).add(jComponent2);
            }
            OverlayConstraints overlayConstraints = OverlayConstraints.popup((Component)jComponent, (Component)object);
            overlayConstraints.setBounds(rectangle4);
            overlayConstraints.setShouldConsumeDismissEvent((Predicate)new NegationPredicate((Predicate)new IsOnToolstripPredicate()));
            final OverlayManager overlayManager = OverlayManagers.get((Component)jComponent);
            if (overlayManager != null) {
                final Overlay overlay3 = overlay = overlayManager.addOverlay((Component)object, overlayConstraints);
                Disposer.register((Disposable)new Disposable(){

                    public void dispose() {
                        jComponent.putClientProperty("PopupComponent", null);
                    }
                }, (Disposable)overlay3);
                ((JComponent)object).getInputMap(1).put(KeyStroke.getKeyStroke("ESCAPE"), "escape");
                ((JComponent)object).getActionMap().put("escape", new AbstractAction("escape"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        overlayManager.removeOverlay(overlay3);
                        if (component != null) {
                            if (PlatformInfo.isLinux()) {
                                component.requestFocus();
                            } else {
                                component.requestFocusInWindow();
                            }
                        }
                    }
                });
                jComponent2.putClientProperty("temporary-focus-owner", true);
                if (bl) {
                    if (PlatformInfo.isLinux()) {
                        jComponent2.requestFocus();
                    } else {
                        jComponent2.requestFocusInWindow();
                    }
                }
            }
        }
        return overlay;
    }

    public static Overlay showPopup(JComponent jComponent, ListItem[] listItemArray, ListStyle listStyle, ListActionListener listActionListener) {
        return ToolstripSections.showPopup(jComponent, ToolstripSections.createList(listItemArray, listActionListener, listStyle));
    }

    public static Overlay showPopup(JComponent jComponent, ListItem[] listItemArray, ListStyle listStyle, ListActionListener listActionListener, boolean bl, Component component) {
        return ToolstripSections.showPopup(jComponent, ToolstripSections.createList(listItemArray, listActionListener, listStyle), bl, component);
    }

    private static Dimension[] getChildSizes(Container container) {
        int n = container.getComponentCount();
        Dimension[] dimensionArray = new Dimension[n];
        for (int i = 0; i < container.getComponentCount(); ++i) {
            dimensionArray[i] = container.getComponent(i).getPreferredSize();
        }
        return dimensionArray;
    }

    private static class ColumnLayout
    implements LayoutManager {
        private ColumnLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(this.maxWidth(ToolstripSections.getChildSizes(container)), 1000);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            int n = container.getComponentCount();
            if (n == 0) {
                return;
            }
            int n2 = container.getHeight();
            int n3 = container.getWidth();
            int n4 = n == 1 ? n2 : n2 / 3;
            Dimension[] dimensionArray = ToolstripSections.getChildSizes(container);
            int n5 = 0;
            int n6 = n == 2 ? n4 / 2 : 0;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                int n7 = 0;
                int n8 = dimensionArray[i].height;
                if (n8 < n4) {
                    Integer n9 = null;
                    if (component instanceof JComponent) {
                        n9 = (Integer)((JComponent)component).getClientProperty("verticalAlignment");
                    }
                    if (n9 == null) {
                        n9 = 0;
                    }
                    if (n9 == 0) {
                        n7 = (n4 - n8) / 2;
                    } else if (n9 == 3) {
                        n7 = n4 - n8;
                    }
                } else if (n8 > n4) {
                    n8 = n4;
                }
                int n10 = 0;
                int n11 = dimensionArray[i].width;
                Integer n12 = null;
                if (component instanceof JComponent) {
                    n12 = (Integer)((JComponent)component).getClientProperty("horizontalAlignment");
                }
                if (n12 == null) {
                    n12 = 2;
                }
                if (n12 == 4) {
                    n10 = n3 - n11;
                } else if (n12 == 0) {
                    n10 = (n3 - n11) / 2;
                }
                component.setBounds(n5 + n10, n6 + n7, n11, n8);
                n6 += n4;
            }
        }

        private int maxWidth(Dimension ... dimensionArray) {
            int n = 0;
            for (Dimension dimension : dimensionArray) {
                if (dimension.width <= n) continue;
                n = dimension.width;
            }
            return n;
        }
    }

    private static class SectionLayout
    implements LayoutManager {
        private SectionLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(this.totalWidth(ToolstripSections.getChildSizes(container)), ToolstripTheme.getInstance().getToolstripTotalContentHeight());
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            Dimension[] dimensionArray;
            int n;
            int n2 = container.getComponentCount();
            if (n2 == 0) {
                return;
            }
            int n3 = container.getHeight();
            int n4 = container.getWidth();
            int n5 = n4 <= (n = this.totalWidth(dimensionArray = ToolstripSections.getChildSizes(container))) ? 0 : (n4 - n) / 2;
            int n6 = 0;
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                component.setBounds(n5, n6, dimensionArray[i].width, n3);
                n5 += dimensionArray[i].width + 4;
            }
        }

        private int totalWidth(Dimension ... dimensionArray) {
            int n = dimensionArray.length == 0 ? 0 : -4;
            for (Dimension dimension : dimensionArray) {
                n += dimension.width + 4;
            }
            return n;
        }
    }

    private static class MySectionBuilder
    implements SectionBuilder {
        private String fName;
        private String fTitle;
        private int fPriority;
        private List<Column> fColumns = new ArrayList<Column>();

        private MySectionBuilder() {
            this.fColumns.add(new Column());
        }

        @Override
        public SectionBuilder name(String string) {
            Preconditions.checkState((this.fName == null ? 1 : 0) != 0, (Object)"Name has been already specified");
            this.fName = string;
            return this;
        }

        @Override
        public SectionBuilder title(String string) {
            Preconditions.checkState((this.fTitle == null ? 1 : 0) != 0, (Object)"Title has been already specified");
            this.fTitle = string;
            return this;
        }

        @Override
        public SectionBuilder priority(int n) {
            this.fPriority = n;
            return this;
        }

        @Override
        public SectionBuilder separator() {
            if (this.fColumns.get((int)(this.fColumns.size() - 1)).fComponents.size() > 0) {
                this.fColumns.add(new Column());
            }
            return this;
        }

        @Override
        public SectionBuilder add(JComponent jComponent) {
            this.fColumns.get(this.fColumns.size() - 1).add(jComponent);
            return this;
        }

        @Override
        public ToolstripSection build() {
            Preconditions.checkNotNull((Object)this.fName, (Object)"Name has to be specified");
            Preconditions.checkNotNull((Object)this.fTitle, (Object)"Title has to be specified");
            Preconditions.checkArgument((this.fColumns.get((int)0).fComponents.size() > 0 ? 1 : 0) != 0, (Object)"Section should not be empty");
            DefaultToolstripSection defaultToolstripSection = new DefaultToolstripSection(this.fName, this.fTitle){

                @NotNull
                protected JComponent createComponent() {
                    int n = MySectionBuilder.this.fColumns.size();
                    if (((Column)((MySectionBuilder)MySectionBuilder.this).fColumns.get((int)(n - 1))).fComponents.size() == 0) {
                        --n;
                    }
                    TSPanel tSPanel = new TSPanel(SECTION_LAYOUT);
                    for (int i = 0; i < n; ++i) {
                        Column column = (Column)MySectionBuilder.this.fColumns.get(i);
                        int n2 = column.fComponents.size();
                        TSPanel tSPanel2 = new TSPanel(COLUMN_LAYOUT);
                        for (int j = 0; j < n2; ++j) {
                            JComponent jComponent = column.fComponents.get(j);
                            Object object = jComponent.getClientProperty("canManageOpacity");
                            if (object == null || !((Boolean)object).booleanValue()) {
                                jComponent.setOpaque(false);
                            }
                            tSPanel2.add(jComponent);
                        }
                        tSPanel.add((Component)((Object)tSPanel2));
                    }
                    return tSPanel;
                }
            };
            defaultToolstripSection.setAttribute(ToolstripSection.PRIORITY, this.fPriority);
            return defaultToolstripSection;
        }

        private static class Column {
            List<JComponent> fComponents = new ArrayList<JComponent>();

            private Column() {
            }

            void add(JComponent jComponent) {
                this.fComponents.add(jComponent);
            }
        }
    }
}

