/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.phoenix;

import com.sun.jini.phoenix.AID;
import com.sun.jini.phoenix.Activator;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationID;
import java.rmi.server.UID;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;
import net.jini.security.proxytrust.TrustEquivalence;

final class ConstrainableAID
extends AID
implements RemoteMethodControl,
TrustEquivalence {
    private static final long serialVersionUID = 2625527831091986783L;
    private static final Method[] methodMapping = new Method[2];
    private final MethodConstraints constraints;

    public ConstrainableAID(Activator activator, UID uID) {
        this(activator, uID, null);
    }

    private ConstrainableAID(Activator activator, UID uID, MethodConstraints methodConstraints) {
        super(activator, uID);
        if (!(activator instanceof RemoteMethodControl)) {
            throw new IllegalArgumentException("activator not RemoteMethodControl instance");
        }
        if (!(activator instanceof TrustEquivalence)) {
            throw new IllegalArgumentException("activator not TrustEquivalence instance");
        }
        this.constraints = methodConstraints;
    }

    private ProxyTrustIterator getProxyTrustIterator() {
        return new SingletonProxyTrustIterator((Object)this.activator);
    }

    public RemoteMethodControl setConstraints(MethodConstraints methodConstraints) {
        MethodConstraints methodConstraints2 = ConstrainableProxyUtil.translateConstraints(methodConstraints, methodMapping);
        RemoteMethodControl remoteMethodControl = ((RemoteMethodControl)this.activator).setConstraints(methodConstraints2);
        return new ConstrainableAID((Activator)remoteMethodControl, this.uid, methodConstraints);
    }

    public MethodConstraints getConstraints() {
        return this.constraints;
    }

    public boolean checkTrustEquivalence(Object object) {
        if (!(object instanceof ConstrainableAID)) {
            return false;
        }
        ConstrainableAID constrainableAID = (ConstrainableAID)((Object)object);
        return this.uid.equals(constrainableAID.uid) && ((TrustEquivalence)this.activator).checkTrustEquivalence((Object)constrainableAID.activator);
    }

    private Object writeReplace() {
        return new State(this.activator, this.uid, this.constraints);
    }

    static {
        try {
            ConstrainableAID.methodMapping[0] = ActivationID.class.getMethod("activate", Boolean.TYPE);
            ConstrainableAID.methodMapping[1] = Activator.class.getMethod("activate", ActivationID.class, Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
    }

    static final class Verifier
    implements TrustVerifier,
    Serializable {
        private static final long serialVersionUID = 570158651966790233L;
        private final RemoteMethodControl activator;

        Verifier(Activator activator) {
            if (!(activator instanceof RemoteMethodControl)) {
                throw new IllegalArgumentException("activator not a RemoteMethodControl instance");
            }
            if (!(activator instanceof TrustEquivalence)) {
                throw new IllegalArgumentException("activator must implement TrustEquivalence");
            }
            this.activator = (RemoteMethodControl)activator;
        }

        public boolean isTrustedObject(Object object, TrustVerifier.Context context) throws RemoteException {
            if (object == null || context == null) {
                throw new NullPointerException();
            }
            if (!(object instanceof ConstrainableAID)) {
                return false;
            }
            RemoteMethodControl remoteMethodControl = (RemoteMethodControl)((ConstrainableAID)((Object)object)).activator;
            MethodConstraints methodConstraints = remoteMethodControl.getConstraints();
            TrustEquivalence trustEquivalence = (TrustEquivalence)this.activator.setConstraints(methodConstraints);
            return trustEquivalence.checkTrustEquivalence((Object)remoteMethodControl);
        }
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1673734348880788487L;
        private final Activator activator;
        private final UID uid;
        private final MethodConstraints constraints;

        State(Activator activator, UID uID, MethodConstraints methodConstraints) {
            this.activator = activator;
            this.uid = uID;
            this.constraints = methodConstraints;
        }

        private Object readResolve() throws InvalidObjectException {
            ConstrainableProxyUtil.verifyConsistentConstraints(this.constraints, this.activator, methodMapping);
            return new ConstrainableAID(this.activator, this.uid, this.constraints);
        }
    }
}

