/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.mapreduce;

import com.mathworks.toolbox.parallel.mapreduce.Endpoint;
import com.mathworks.toolbox.parallel.mapreduce.KeyValueMessage;
import com.mathworks.toolbox.parallel.mapreduce.KeyValueSocket;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;

public final class KeyValueProxySink
implements Closeable {
    private final KeyValueSocket fKeyValueSocket = new KeyValueSocket();
    private final Queue<KeyValueMessage> fQueue = new ConcurrentLinkedQueue<KeyValueMessage>();
    private boolean fCloseRequestSent = false;
    private boolean fCloseResponseReceived = false;

    public KeyValueProxySink(Endpoint endpoint) throws IOException {
        this.fKeyValueSocket.connect(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws IOException {
        assert (!this.fKeyValueSocket.isClosed());
        Queue<KeyValueMessage> queue = this.fQueue;
        synchronized (queue) {
            this.fQueue.add(KeyValueMessage.createKeyMessage(byteBuffer));
            this.fQueue.add(KeyValueMessage.createValueMessage(byteBuffer2));
        }
    }

    public void write(byte[] byArray, byte[] byArray2) throws IOException {
        this.write(ByteBuffer.wrap(byArray), ByteBuffer.wrap(byArray2));
    }

    public void write(byte[][] byArray, byte[][] byArray2) throws IOException {
        if (byArray.length != byArray2.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < byArray.length; ++i) {
            this.write(byArray[i], byArray2[i]);
        }
    }

    public boolean flush(long l, TimeUnit timeUnit) throws IOException {
        while (!this.fQueue.isEmpty()) {
            KeyValueMessage keyValueMessage = this.fQueue.peek();
            if (!this.fKeyValueSocket.send(keyValueMessage, l, timeUnit)) {
                return false;
            }
            this.fQueue.poll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit(long l, TimeUnit timeUnit) throws IOException {
        Object object;
        if (this.fKeyValueSocket.isClosed()) {
            return true;
        }
        if (!this.fCloseRequestSent) {
            object = this.fQueue;
            synchronized (object) {
                this.fQueue.add(KeyValueMessage.createCloseMessage());
            }
            this.fCloseRequestSent = true;
        }
        if (!this.fCloseResponseReceived) {
            if (!this.flush(l, timeUnit)) {
                return false;
            }
            object = this.fKeyValueSocket.recv(l, timeUnit);
            if (object == null) {
                return false;
            }
            assert (((KeyValueMessage)object).isCloseMessage());
            this.fCloseResponseReceived = true;
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        this.fKeyValueSocket.close();
    }
}

