/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.parallel.mapreduce;

import java.nio.charset.Charset;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class MD5HashPartitioner {
    private final MessageDigest fMessageDigest = MessageDigest.getInstance("MD5");
    private final Charset fUtf16Charset = Charset.forName("UTF-16");

    public int[] partition(String[] stringArray, int n) throws DigestException {
        int[] nArray = new int[stringArray.length];
        byte[] byArray = new byte[this.fMessageDigest.getDigestLength()];
        for (int i = 0; i < stringArray.length; ++i) {
            this.fMessageDigest.update(stringArray[i].getBytes(this.fUtf16Charset));
            this.fMessageDigest.digest(byArray, 0, byArray.length);
            nArray[i] = this.pModDigest(byArray, n);
        }
        return nArray;
    }

    public int[] partition(byte[] byArray, int n, int n2) throws DigestException {
        int n3 = byArray.length / n;
        int[] nArray = new int[n3];
        byte[] byArray2 = new byte[this.fMessageDigest.getDigestLength()];
        for (int i = 0; i < n3; ++i) {
            this.fMessageDigest.update(byArray, i * n, n);
            this.fMessageDigest.digest(byArray2, 0, byArray2.length);
            nArray[i] = this.pModDigest(byArray2, n2);
        }
        return nArray;
    }

    private int pModDigest(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = 1;
        for (int i = 0; i < byArray.length; ++i) {
            int n4 = byArray[i] < 0 ? 256 - byArray[i] : byArray[i];
            n2 = (n2 + n4 * n3) % n;
            n3 = n3 * 256 % n;
        }
        return n2 + 1;
    }
}

