/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.browser;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.toolbox.testmeas.browser.Browser;
import com.mathworks.toolbox.testmeas.browser.BrowserBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class BrowserDecoration
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Font FONT = UIManager.getFont("InternalFrame.titleFont");
    private Color defaultBackground;
    private Browser browser;
    private JLabel labelComponent;
    private MJButton helpButton;
    private boolean showHelp = true;

    public BrowserDecoration(String string, boolean bl) {
        this(string, null, bl);
    }

    public BrowserDecoration(String string, ImageIcon imageIcon, boolean bl) {
        this.layoutPanel(string, imageIcon, bl);
    }

    public void cleanup() {
        if (this.helpButton != null) {
            this.helpButton.removeActionListener((ActionListener)this);
        }
        this.browser = null;
    }

    private void layoutPanel(String string, ImageIcon imageIcon, boolean bl) {
        this.setBorder(new BrowserBorder());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 0, 0.0, 1.0, 17, 0, new Insets(0, 1, 0, 0), 0, 0);
        this.defaultBackground = this.getBackground();
        this.labelComponent = new JLabel(string);
        this.labelComponent.setFont(FONT);
        this.labelComponent.setForeground(SystemColor.textInactiveText);
        this.add((Component)this.labelComponent, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)new JLabel(), gridBagConstraints);
        if (!bl) {
            return;
        }
        MJToolBar mJToolBar = new MJToolBar();
        mJToolBar.setFloatable(false);
        mJToolBar.setBorder(null);
        this.helpButton = new MJButton("Hide Help");
        this.helpButton.setFont(FONT);
        this.helpButton.setForeground((Color)SystemColor.textInactiveText);
        this.helpButton.setName("Browser Help Button");
        this.helpButton.setFlyOverAppearance(true);
        this.helpButton.setFocusPainted(false);
        this.helpButton.setPreferredSize(new Dimension(95, 18));
        this.helpButton.addActionListener((ActionListener)this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 13;
        mJToolBar.add((Component)this.helpButton);
        this.add((Component)mJToolBar, gridBagConstraints);
    }

    public void selectDecoration(boolean bl) {
        if (bl) {
            this.setBackground(SystemColor.activeCaption);
            this.labelComponent.setForeground(SystemColor.activeCaptionText);
            this.labelComponent.setBackground(SystemColor.activeCaption);
        } else {
            this.setBackground(this.defaultBackground);
            this.labelComponent.setForeground(SystemColor.textInactiveText);
            this.labelComponent.setBackground(this.defaultBackground);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width, 23);
    }

    public void showHelpButton(boolean bl) {
        if (this.helpButton == null) {
            return;
        }
        this.helpButton.setVisible(bl);
    }

    public void setText(String string) {
        this.labelComponent.setText(string);
    }

    public void setText(String string, ImageIcon imageIcon) {
        this.labelComponent.setText(string);
        this.labelComponent.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = this.showHelp = !this.showHelp;
        if (this.showHelp) {
            this.helpButton.setText("Hide Help");
        } else {
            this.helpButton.setText("View Help");
        }
        this.browser.updateHelp();
        this.helpButton.setSelected(false);
    }

    public void setBrowser(Browser browser) {
        this.browser = browser;
    }

    public boolean isHelpShown() {
        return this.showHelp;
    }

    public void setIsHelpShown(boolean bl) {
        this.showHelp = bl;
        if (this.showHelp) {
            this.helpButton.setText("Hide Help");
        } else {
            this.helpButton.setText("View Help");
        }
        this.helpButton.setSelected(false);
    }
}

