/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.guiutil;

import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.testmeas.browser.Browser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AboutWindow
extends JPanel
implements ActionListener,
Runnable {
    private static final long serialVersionUID = 1L;
    public static final int DATA_ACQUISITION = 0;
    public static final int INSTRUMENT_CONTROL = 1;
    public static final int IMAGE_ACQUISITION = 2;
    public static final int OPC = 3;
    private static ImageIcon defaultImage = new ImageIcon(Browser.class.getResource("/com/mathworks/toolbox/testmeas/resources/tm.gif"));
    private static ImageIcon daqImage = new ImageIcon(Browser.class.getResource("/com/mathworks/toolbox/testmeas/resources/data_acquisition.gif"));
    private static ImageIcon instrImage = new ImageIcon(Browser.class.getResource("/com/mathworks/toolbox/testmeas/resources/instrument_control.gif"));
    private static ImageIcon imaqImage = new ImageIcon(Browser.class.getResource("/com/mathworks/toolbox/testmeas/resources/image_acquisition.gif"));
    private static ImageIcon opcImage = new ImageIcon(Browser.class.getResource("/com/mathworks/toolbox/testmeas/resources/opc.gif"));
    private static final String[] VER_STR = new String[]{"daq", "instrument", "imaq", "opc"};
    private static final String[] NAMES = new String[]{"Data Acquisition Toolbox", "Instrument Control Toolbox", "Image Acquisition Toolbox", "OPC Toolbox"};
    private static final String[] FIRST_YEAR = new String[]{"1998", "1999", "2001", "2001"};
    private int frameWidth = 311;
    private int frameHeight = 300;
    private MJDialog dialog;
    private MJFrame dialogFrame;
    private int type;
    private JLabel versionLabel;
    private String releaseInfo;

    public AboutWindow(int n, MJFrame mJFrame) {
        this.init(n, mJFrame);
    }

    public AboutWindow(int n, MJFrame mJFrame, ImageIcon imageIcon) {
        defaultImage = imageIcon;
        this.init(n, mJFrame);
    }

    private void init(int n, MJFrame mJFrame) {
        this.type = n;
        this.dialogFrame = mJFrame;
        Calendar calendar = Calendar.getInstance();
        int n2 = calendar.get(1);
        String string = "Copyright " + FIRST_YEAR[this.type] + "-" + n2 + ", The MathWorks, Inc.";
        if (FIRST_YEAR[this.type].equals(String.valueOf(n2))) {
            string = "Copyright " + FIRST_YEAR[this.type] + ", The MathWorks, Inc.";
        }
        this.layoutPanel(string);
        Matlab.whenMatlabReady((Runnable)this);
    }

    private void layoutPanel(String string) {
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 0, 0));
        jPanel.setBackground(Color.white);
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1, 0, 0));
        jPanel2.setBackground(Color.white);
        jPanel2.add(new JLabel(this.getToolboxNameLabel(), 0));
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1, 0, 0));
        jPanel3.setBackground(Color.white);
        this.versionLabel = new JLabel(" ", 0);
        jPanel3.add(this.versionLabel);
        jPanel3.add(new JLabel(string, 0));
        jPanel.add(jPanel3);
        this.add((Component)new JLabel(defaultImage, 2), "Center");
        this.add((Component)this.createButtonPanel(), "South");
    }

    private ImageIcon getToolboxNameLabel() {
        switch (this.type) {
            case 0: {
                return daqImage;
            }
            case 1: {
                return instrImage;
            }
            case 2: {
                return imaqImage;
            }
            case 3: {
                return opcImage;
            }
        }
        return null;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1, 0, 5));
        JPanel jPanel2 = new JPanel(new GridLayout(1, 1, 5, 0));
        jPanel.setBackground(Color.white);
        jPanel2.setBackground(Color.white);
        JButton jButton = new JButton("OK");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private void showAsDialog(MJFrame mJFrame) {
        int n;
        this.dialog = new MJDialog((Frame)mJFrame, "About " + NAMES[this.type], true);
        this.dialog.getContentPane().add(this);
        this.dialog.setSize(this.frameWidth, this.frameHeight);
        this.dialog.setResizable(false);
        Rectangle rectangle = mJFrame.getBounds();
        int n2 = rectangle.x + rectangle.width / 2 - this.frameWidth / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = rectangle.y + rectangle.height / 2 - this.frameHeight / 2) < 0) {
            n = 0;
        }
        this.dialog.setLocation(n2, n);
        this.dialog.show();
    }

    @Override
    public void run() {
        try {
            Object[] objectArray = new Object[]{VER_STR[this.type]};
            Object[] objectArray2 = (Object[])Matlab.mtFeval((String)"ver", (Object[])objectArray, (int)1);
            Object[] objectArray3 = (Object[])objectArray2[1];
            Object[] objectArray4 = (Object[])objectArray3[0];
            this.releaseInfo = "Version " + objectArray4[1] + " " + objectArray4[2];
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AboutWindow.this.versionLabel.setText(AboutWindow.this.releaseInfo);
                    AboutWindow.this.showAsDialog(AboutWindow.this.dialogFrame);
                }
            });
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.dialog.dispose();
    }
}

