/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.tmswing.table;

import com.jidesoft.grid.BooleanCheckBoxCellRenderer;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TableModelWrapperUtils;
import com.jidesoft.grid.TableUtils;
import com.mathworks.jmi.Callback;
import com.mathworks.jmi.ComponentBridge;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.toolbox.testmeas.propertyeditor.TMNoMarginPanel;
import com.mathworks.toolbox.testmeas.tmswing.table.AnnotationCellRenderer;
import com.mathworks.toolbox.testmeas.tmswing.table.ClipboardCallbackEventData;
import com.mathworks.toolbox.testmeas.tmswing.table.ColumnInfo;
import com.mathworks.toolbox.testmeas.tmswing.table.ColumnInfoTableModel;
import com.mathworks.toolbox.testmeas.tmswing.table.KeyPressedEventData;
import com.mathworks.toolbox.testmeas.tmswing.table.MenuSelectedEventData;
import com.mathworks.toolbox.testmeas.tmswing.table.RowEventData;
import com.mathworks.toolbox.testmeas.tmswing.table.StringCellEditor;
import com.mathworks.toolbox.testmeas.tmswing.table.StringCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public abstract class TablePanel
implements ComponentBridge {
    protected SortableTable fTable = new SortableTable();
    private MJPopupMenu fRightClickMenu = new MJPopupMenu();
    private ListSelectionListener fTableSelectionListener;
    private List<ColumnInfo> fColumnInfoList;
    private TMNoMarginPanel fPanel = new TMNoMarginPanel();
    private boolean fEditable = true;
    private Callback fRowSelectedCallback = new Callback();
    private Callback fCellEditedCallback = new Callback();
    private Callback fKeyPressedCallback = new Callback();
    private Callback fMenuSelectedCallback = new Callback();
    private Callback fClipboardCallback = new Callback();
    private int[] fPackColumns = new int[0];
    private MJScrollPane fTableScrollPane;
    public static final int TEST_VECTOR_TABLE_SCROLLPANE_WIDTH = 537;
    public static final int TABLE_HEIGHT = 262;
    public static final int ROW_HEIGHT = 23;

    public TablePanel(List<ColumnInfo> list, String string) {
        assert (list != null && !list.isEmpty()) : "columnInfoList cannot be null or empty";
        this.fColumnInfoList = list;
        this.initializeTable();
        this.fTable.setName(string + ".Table");
        this.fPanel.setName(string + ".Panel");
    }

    protected abstract SortableTable createTable();

    public void setMenuNames(List<String> list, String string, String string2) {
        assert (list != null) : "Menu Names list cannot be null";
        this.fRightClickMenu.setName("TableContextMenu");
        for (final String string3 : list) {
            String[] stringArray;
            if (string3.equals(string)) {
                this.fRightClickMenu.addSeparator();
                continue;
            }
            if (string3.equals(string2)) {
                if (list.indexOf(string3) != 0) {
                    this.fRightClickMenu.addSeparator();
                }
                stringArray = new String[]{"Cut", "Copy", "Paste"};
                KeyStroke[] keyStrokeArray = new KeyStroke[]{KeyStroke.getKeyStroke(88, 2), KeyStroke.getKeyStroke(67, 2), KeyStroke.getKeyStroke(86, 2)};
                for (int i = 0; i < stringArray.length; ++i) {
                    final String string4 = stringArray[i];
                    MJMenuItem mJMenuItem = new MJMenuItem(string4);
                    mJMenuItem.setName("TableContextMenuItem." + string3);
                    mJMenuItem.setAccelerator(keyStrokeArray[i]);
                    mJMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n = TablePanel.this.fTable.getActualRowAt(TablePanel.this.fTable.getSelectedRow());
                            TablePanel.this.fClipboardCallback.postCallback(new Object[]{new ClipboardCallbackEventData(n, string4)});
                        }
                    });
                    this.fRightClickMenu.add((JMenuItem)mJMenuItem);
                }
                if (list.indexOf(string3) == list.size() - 1) continue;
                this.fRightClickMenu.addSeparator();
                continue;
            }
            stringArray = new MJMenuItem(string3);
            stringArray.setName("TableContextMenuItem." + string3);
            stringArray.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = TablePanel.this.fTable.getActualRowAt(TablePanel.this.fTable.getSelectedRow());
                    TablePanel.this.fMenuSelectedCallback.postCallback(new Object[]{new MenuSelectedEventData(n, TablePanel.this.fTable.getSelectedColumn(), string3)});
                }
            });
            this.fRightClickMenu.add((JMenuItem)stringArray);
        }
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                int n = TablePanel.this.fTable.rowAtPoint(mouseEvent.getPoint());
                int n2 = TablePanel.this.fTable.getActualRowAt(n);
                if (n2 != -1 && TablePanel.this.fTable.getActualRowAt(TablePanel.this.fTable.getSelectedRow()) != n2) {
                    TablePanel.this.setSelectedRow(n2);
                    TablePanel.this.fRowSelectedCallback.postCallback(new Object[]{new RowEventData(n2)});
                }
                if (mouseEvent.isPopupTrigger()) {
                    TablePanel.this.fRightClickMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        this.fTable.addMouseListener((MouseListener)mouseAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTable() {
        try {
            this.fTable.getSelectionModel().removeListSelectionListener(this.fTableSelectionListener);
            ColumnInfoTableModel columnInfoTableModel = (ColumnInfoTableModel)TableModelWrapperUtils.getActualTableModel((TableModel)this.fTable.getModel());
            columnInfoTableModel.fireTableChanged();
        }
        finally {
            this.fTable.getSelectionModel().addListSelectionListener(this.fTableSelectionListener);
        }
    }

    public void enableMenus(String[] stringArray, boolean[] blArray) {
        assert (stringArray != null) : "Menu Name cannot be null";
        assert (blArray != null) : "isEnabled cannot be null";
        for (int i = 0; i < this.fRightClickMenu.getComponentCount(); ++i) {
            if (!(this.fRightClickMenu.getComponent(i) instanceof MJMenuItem)) continue;
            MJMenuItem mJMenuItem = (MJMenuItem)this.fRightClickMenu.getComponent(i);
            for (int j = 0; j < stringArray.length; ++j) {
                if (!mJMenuItem.getText().equals(stringArray[j])) continue;
                mJMenuItem.setEnabled(blArray[j]);
            }
        }
    }

    public void setEditable(boolean bl) {
        this.fEditable = bl;
        this.revalidateTable();
    }

    public Boolean isEditable() {
        return this.fEditable;
    }

    public void setTableData(List<List> list, int n) {
        assert (list != null && this.fColumnInfoList.size() == list.size()) : "Data must not be null. Cannot change number of columns of the table";
        for (int i = 0; i < this.fColumnInfoList.size(); ++i) {
            this.fColumnInfoList.get(i).setData(list.get(i));
        }
        this.updateTable();
        this.setSelectedRow(n);
    }

    public void setColumnData(int n, List list) {
        assert (list != null) : "Data must not be null";
        assert (n >= 0 && n < this.fTable.getModel().getColumnCount()) : "Illegal Column Index : " + n;
        this.fColumnInfoList.get(n).setData(list);
        this.revalidateTable();
    }

    public void setCellData(int n, int n2, Object object) {
        assert (n2 >= 0 && n2 < this.fTable.getModel().getColumnCount()) : "Illegal Column Index : " + n2;
        assert (n >= 0 && n < this.fTable.getModel().getRowCount()) : "Illegal Row Index : " + n;
        assert (object != null) : "Cell Data must not be null";
        this.fColumnInfoList.get(n2).setData(n, object);
        this.revalidateTable();
    }

    public void clearTableData() {
        for (ColumnInfo columnInfo : this.fColumnInfoList) {
            columnInfo.setData(new ArrayList());
        }
        this.revalidateTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedRow(int n) {
        assert (n >= 0 && n < this.fTable.getModel().getRowCount()) : "Illegal Row Index : " + n;
        try {
            this.fTable.getSelectionModel().removeListSelectionListener(this.fTableSelectionListener);
            int n2 = this.fTable.getSortedRowAt(n);
            this.fTable.setRowSelectionInterval(n2, n2);
            this.fTable.scrollRectToVisible(this.fTable.getCellRect(n2, 0, true));
        }
        finally {
            this.fTable.getSelectionModel().addListSelectionListener(this.fTableSelectionListener);
        }
    }

    public void editCell(int n, int n2) {
        assert (n2 >= 0 && n2 < this.fTable.getModel().getColumnCount()) : "Illegal Column Index : " + n2;
        assert (n >= 0 && n < this.fTable.getModel().getRowCount()) : "Illegal Row Index : " + n;
        int n3 = this.fTable.getSortedRowAt(n);
        this.fTable.editCellAt(n3, n2);
        this.fTable.requestFocus();
        StringCellEditor stringCellEditor = (StringCellEditor)this.fTable.getCellEditor(n, n2);
        stringCellEditor.shouldSelectCell(new ListSelectionEvent(this, n, n, true));
    }

    public void setErrorMessage(int n, int n2, String string) {
        assert (n2 >= 0 && n2 < this.fTable.getModel().getColumnCount()) : "Illegal Column Index : " + n2;
        assert (n >= 0 && n < this.fTable.getModel().getRowCount()) : "Illegal Row Index : " + n;
        this.fColumnInfoList.get(n2).setAnnotationMessage(n, ColumnInfo.Annotation.ERROR, string);
        this.revalidateTable();
    }

    public void setWarningMessage(int n, int n2, String string) {
        assert (n2 >= 0 && n2 < this.fTable.getModel().getColumnCount()) : "Illegal Column Index : " + n2;
        assert (n >= 0 && n < this.fTable.getModel().getRowCount()) : "Illegal Row Index : " + n;
        this.fColumnInfoList.get(n2).setAnnotationMessage(n, ColumnInfo.Annotation.WARNING, string);
        this.revalidateTable();
    }

    public void clearMessages() {
        for (int i = 0; i < this.fTable.getModel().getRowCount(); ++i) {
            for (int j = 0; j < this.fTable.getModel().getColumnCount(); ++j) {
                this.fColumnInfoList.get(j).setAnnotationMessage(i, ColumnInfo.Annotation.NORMAL, "");
            }
        }
        this.revalidateTable();
    }

    public void setErrorBorderOnTable() {
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(SystemColor.red, 2), BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.fTableScrollPane.setViewportBorder((Border)compoundBorder);
    }

    public void clearErrorBorderOnTable() {
        this.fTableScrollPane.setViewportBorder(BorderFactory.createLoweredBevelBorder());
    }

    private void initializeTable() {
        assert (this.fColumnInfoList != null && !this.fColumnInfoList.isEmpty()) : "columnInfoList cannot be null or empty";
        this.fTable = this.createTable();
        this.fTable.setBorder(BorderFactory.createLoweredBevelBorder());
        this.fTableScrollPane = new MJScrollPane((Component)this.fTable);
        this.fTableScrollPane.getViewport().setBackground(Color.WHITE);
        this.fTableScrollPane.setVerticalScrollBarPolicy(20);
        this.fTableScrollPane.setHorizontalScrollBarPolicy(31);
        this.fTableScrollPane.setPreferredSize(new Dimension(537, 262));
        this.fPanel.addLine((JComponent)this.fTableScrollPane, 8);
        this.fTable.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.fTable.setDefaultRenderer(String.class, (TableCellRenderer)new AnnotationCellRenderer(new StringCellRenderer()));
        this.fTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)new AnnotationCellRenderer((TableCellRenderer)new BooleanCheckBoxCellRenderer()));
        this.fTable.setDefaultEditor(String.class, (TableCellEditor)new StringCellEditor(new JTextField()));
        TablePanel.setSortableTableDefaults(this.fTable);
        this.addSelectionCallback();
        this.addKeyCallback();
        if (!this.fColumnInfoList.isEmpty() && this.fColumnInfoList.get(0).getLength() > 0) {
            this.setSelectedRow(0);
        }
    }

    public static void setSortableTableDefaults(SortableTable sortableTable) {
        sortableTable.setSelectionMode(0);
        sortableTable.getTableHeader().setReorderingAllowed(false);
        sortableTable.setRowHeight(23);
        ((DefaultTableCellRenderer)sortableTable.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
        sortableTable.setSelectInsertedRows(true);
        sortableTable.setMultiColumnSortable(false);
        sortableTable.setOptimized(true);
        sortableTable.setAutoResort(false);
        sortableTable.setShowSortOrderNumber(false);
        sortableTable.setCellEditorManagerEnabled(false);
        sortableTable.setCellRendererManagerEnabled(false);
    }

    private void addSelectionCallback() {
        this.fTableSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                int n = TablePanel.this.fTable.getActualRowAt(TablePanel.this.fTable.getSelectedRow());
                if (n == -1) {
                    return;
                }
                TablePanel.this.fRowSelectedCallback.postCallback(new Object[]{new RowEventData(n)});
            }
        };
        this.fTable.getSelectionModel().addListSelectionListener(this.fTableSelectionListener);
    }

    private void addKeyCallback() {
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                String string = KeyEvent.getKeyText(keyEvent.getKeyCode());
                int n = TablePanel.this.fTable.getActualRowAt(TablePanel.this.fTable.getSelectedRow());
                if (n == -1) {
                    return;
                }
                if (keyEvent.isControlDown()) {
                    String string2 = "";
                    if (string.equalsIgnoreCase("x")) {
                        string2 = "Cut";
                    } else if (string.equalsIgnoreCase("c")) {
                        string2 = "Copy";
                    } else if (string.equalsIgnoreCase("v")) {
                        string2 = "Paste";
                    }
                    if (string2.length() > 0) {
                        TablePanel.this.fClipboardCallback.postCallback(new Object[]{new ClipboardCallbackEventData(n, string2)});
                        return;
                    }
                }
                TablePanel.this.fKeyPressedCallback.postCallback(new Object[]{new KeyPressedEventData(n, TablePanel.this.fTable.getSelectedColumn(), keyEvent.getKeyChar(), string, KeyEvent.getKeyModifiersText(keyEvent.getModifiers()))});
            }
        });
    }

    public JComponent getPanel() {
        return this.fPanel;
    }

    public List<ColumnInfo> getColumnInfoList() {
        return this.fColumnInfoList;
    }

    public Callback getRowSelectedCallback() {
        return this.fRowSelectedCallback;
    }

    public Callback getCellEditedCallback() {
        return this.fCellEditedCallback;
    }

    public Callback getKeyPressedCallback() {
        return this.fKeyPressedCallback;
    }

    public Callback getMenuSelectedCallback() {
        return this.fMenuSelectedCallback;
    }

    public Callback getClipboardCallback() {
        return this.fClipboardCallback;
    }

    /*
     * WARNING - void declaration
     */
    public void destroy() {
        void var5_14;
        MouseListener[] mouseListenerArray;
        KeyListener[] keyListenerArray;
        this.fTable.getSelectionModel().removeListSelectionListener(this.fTableSelectionListener);
        for (KeyListener actionListenerArray : keyListenerArray = this.fTable.getKeyListeners()) {
            this.fTable.removeKeyListener(actionListenerArray);
        }
        for (int i = 0; i < this.fRightClickMenu.getComponentCount(); ++i) {
            ActionListener[] actionListenerArray;
            if (!(this.fRightClickMenu.getComponent(i) instanceof MJMenuItem)) continue;
            MJMenuItem mJMenuItem = (MJMenuItem)this.fRightClickMenu.getComponent(i);
            for (ActionListener actionListener : actionListenerArray = mJMenuItem.getActionListeners()) {
                mJMenuItem.removeActionListener(actionListener);
            }
        }
        this.fRightClickMenu.dispose();
        MouseListener[] mouseListenerArray2 = mouseListenerArray = this.fTable.getMouseListeners();
        int n = mouseListenerArray2.length;
        boolean bl = false;
        while (var5_14 < n) {
            MouseListener mouseListener = mouseListenerArray2[var5_14];
            this.fTable.removeMouseListener(mouseListener);
            ++var5_14;
        }
        this.fTable.setModel((TableModel)new DefaultTableModel());
        this.fPanel.removeAll();
        this.fColumnInfoList.clear();
    }

    private void revalidateTable() {
        int[] nArray = TableUtils.saveSelection((JTable)this.fTable);
        this.updateTable();
        if (!this.fColumnInfoList.isEmpty() && this.fColumnInfoList.get(0).getLength() != 0) {
            TableUtils.loadSelection((JTable)this.fTable, (int[])nArray);
        }
    }

    public void hideTableHeaders() {
        this.fTable.setTableHeader(null);
    }

    public void setPackColumns(int[] nArray) {
        this.fPackColumns = nArray;
        this.resizeColumnToFit();
    }

    private void resizeColumnToFit() {
        for (int n : this.fPackColumns) {
            this.fTable.setAutoResizeMode(2);
            this.packColumn(n, 2);
        }
    }

    public void packColumn(int n, int n2) {
        DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)this.fTable.getColumnModel();
        TableColumn tableColumn = defaultTableColumnModel.getColumn(n);
        int n3 = 0;
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer != null) {
            Component component = tableCellRenderer.getTableCellRendererComponent((JTable)this.fTable, tableColumn.getHeaderValue(), false, false, 0, 0);
            n3 = component.getPreferredSize().width;
        }
        for (int i = 0; i < this.fTable.getRowCount(); ++i) {
            tableCellRenderer = this.fTable.getCellRenderer(i, n);
            Component component = tableCellRenderer.getTableCellRendererComponent((JTable)this.fTable, this.fTable.getValueAt(i, n), false, false, i, n);
            n3 = Math.max(n3, component.getPreferredSize().width);
        }
        tableColumn.setMaxWidth(n3 += 2 * n2);
        tableColumn.setMinWidth(n3);
    }
}

