/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.util;

import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.Collator;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;

public class TMStringUtil {
    private static final String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static final String FILESEP = System.getProperty("file.separator");
    public static final String LINESEP = new Character('\n').toString();
    public static final char CARRIAGE = '\r';
    public static final String STR_CARRIAGE = new Character('\r').toString();
    public static final char LINEFEED = '\n';
    public static final String STR_LINEFEED = new Character('\n').toString();
    private static String STR_UNDERSCORE = "_";
    private static char UNDERSCORE = STR_UNDERSCORE.charAt(0);
    private static Vector<String> MATLABKeywords;
    private static Collator collator;

    private TMStringUtil() {
    }

    public static void error(String string) throws TMException {
        throw new TMException(string);
    }

    public static final void throwReadOnlyPropertyError(String string) throws TMException {
        TMStringUtil.error("The property: '" + string + "' is read-only.");
    }

    public static final void warning(String string) {
        Object[] objectArray = new Object[]{string};
        try {
            Matlab.mtFevalConsoleOutput((String)"warning", (Object[])objectArray, (int)0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void error(String string, String string2) {
        MJOptionPane.showMessageDialog((Component)new MJFrame(), (Object)TMStringUtil.cleanupMessage(string2), (String)string, (int)0);
    }

    public static void error(MJFrame mJFrame, String string, String string2) {
        MJOptionPane.showMessageDialog((Component)mJFrame, (Object)TMStringUtil.cleanupMessage(string2), (String)string, (int)0);
    }

    public static void warn(String string, String string2) {
        MJOptionPane.showMessageDialog((Component)new MJFrame(), (Object)TMStringUtil.cleanupMessage(string2), (String)string, (int)2);
    }

    public static int confirm(MJFrame mJFrame, String string, String string2) {
        return MJOptionPane.showConfirmDialog((Component)mJFrame, (Object)TMStringUtil.cleanupMessage(string2), (String)string, (int)0);
    }

    public static int confirmWithCancel(MJFrame mJFrame, String string, String string2) {
        return MJOptionPane.showConfirmDialog((Component)mJFrame, (Object)TMStringUtil.cleanupMessage(string2), (String)string, (int)1, (int)2);
    }

    public static void warn(MJFrame mJFrame, String string, String string2) {
        MJOptionPane.showMessageDialog((Component)mJFrame, (Object)TMStringUtil.cleanupMessage(string2), (String)string, (int)2);
    }

    public static String cleanupMessage(String string) {
        return string.replace('\r', '\n');
    }

    public static final int findPropertyCompleteName(String string, String[] stringArray) throws TMException {
        String string2 = string.toLowerCase();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string3 = stringArray[i].toLowerCase();
            if (!string3.startsWith(string2)) continue;
            if (i + 1 < n && stringArray[i + 1].toLowerCase().startsWith(string2) && !string3.equals(string2)) {
                throw new TMException("Specified property: '" + string + "' is not unique.");
            }
            return i;
        }
        throw new TMException("Invalid property: '" + string + "' specified.");
    }

    public static double str2double(String string) {
        return TMStringUtil.str2double(string, false);
    }

    public static double str2double(String string, boolean bl) {
        if (bl) {
            return Double.valueOf(string);
        }
        if (TMStringUtil.isdouble(string, false)) {
            return Double.valueOf(string);
        }
        throw new NumberFormatException();
    }

    public static int str2int(String string) {
        return TMStringUtil.str2int(string, false, true);
    }

    public static int str2int(String string, boolean bl) {
        return TMStringUtil.str2int(string, bl, true);
    }

    public static int str2int(String string, boolean bl, boolean bl2) {
        if (bl) {
            return Integer.valueOf(string);
        }
        if (TMStringUtil.isinteger(string, false, bl2)) {
            return Integer.valueOf(string);
        }
        throw new NumberFormatException();
    }

    public static String bool2str(boolean bl) {
        if (bl) {
            return "true";
        }
        return "false";
    }

    public static boolean str2bool(String string) {
        return string.toLowerCase().equals("true");
    }

    public static String removeTrailingCRLF(String string) {
        while (string.endsWith(STR_CARRIAGE) || string.endsWith(STR_LINEFEED)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static Vector<String> sort(Vector<String> vector, Vector<String> vector2) {
        int n;
        String[] stringArray = new String[vector.size() + vector2.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray[n] = vector.elementAt(n);
        }
        for (n = vector.size(); n < stringArray.length; ++n) {
            stringArray[n] = vector2.elementAt(n - vector.size());
        }
        String[] stringArray2 = TMStringUtil.sort(stringArray);
        return TMStringUtil.stringArray2Vector(stringArray2);
    }

    public static String[] sort(String[] stringArray) {
        if (collator == null) {
            collator = Collator.getInstance();
        }
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = i + 1; j < stringArray.length; ++j) {
                if (collator.compare(stringArray[i], stringArray[j]) <= 0) continue;
                string = stringArray[i];
                stringArray[i] = stringArray[j];
                stringArray[j] = string;
            }
        }
        string = null;
        return stringArray;
    }

    public static String strrep(String string, String string2, String string3) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf(string2);
        int n2 = string2.length();
        int n3 = string3.length();
        while (n != -1) {
            string = string.substring(0, n) + string3 + string.substring(n + n2, string.length());
            n = string.indexOf(string2, n + n3);
        }
        return string;
    }

    public static Vector<String> stringArray2Vector(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        return vector;
    }

    public static String[] vector2StringArray(Vector<?> vector) {
        if (vector == null) {
            return null;
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static boolean isOnlyWhiteSpace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isvarname(String string) {
        if (MATLABKeywords == null) {
            TMStringUtil.defineMATLABKeywords();
        }
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        if (string.length() > Matlab.getNameLengthMax() || MATLABKeywords.contains(string) || !Character.isLetter(string.charAt(0))) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetterOrDigit(string.charAt(i)) || UNDERSCORE == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean ismethodname(String string) {
        if (MATLABKeywords == null) {
            TMStringUtil.defineMATLABKeywords();
        }
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        if (MATLABKeywords.contains(string) || !Character.isLetter(string.charAt(0))) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetterOrDigit(string.charAt(i)) || UNDERSCORE == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean ispropertyname(String string) {
        return TMStringUtil.ismethodname(string);
    }

    private static void defineMATLABKeywords() {
        MATLABKeywords = new Vector();
        MATLABKeywords.addElement("break");
        MATLABKeywords.addElement("case");
        MATLABKeywords.addElement("catch");
        MATLABKeywords.addElement("continue");
        MATLABKeywords.addElement("else");
        MATLABKeywords.addElement("elseif");
        MATLABKeywords.addElement("end");
        MATLABKeywords.addElement("for");
        MATLABKeywords.addElement("function");
        MATLABKeywords.addElement("global");
        MATLABKeywords.addElement("if");
        MATLABKeywords.addElement("otherwise");
        MATLABKeywords.addElement("persistent");
        MATLABKeywords.addElement("return");
        MATLABKeywords.addElement("switch");
        MATLABKeywords.addElement("try");
        MATLABKeywords.addElement("while");
    }

    public static boolean isnumeric(String string) {
        return TMStringUtil.isnumeric(string, false);
    }

    public static boolean isnumeric(String string, boolean bl) {
        return TMStringUtil.isdouble(string, bl);
    }

    public static boolean isdouble(String string) {
        return TMStringUtil.isdouble(string, false);
    }

    public static boolean isdouble(String string, boolean bl) {
        try {
            String string2;
            Double.parseDouble(string);
            if (bl) {
                return true;
            }
            if ((string = string.toLowerCase()).equalsIgnoreCase(string2 = "Infinity") || string.equalsIgnoreCase("-" + string2)) {
                return true;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (!Character.isLetter(string.charAt(i)) || string.charAt(i) == 'e') continue;
                return false;
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isinteger(String string) {
        return TMStringUtil.isinteger(string, false, true);
    }

    public static boolean isinteger(String string, boolean bl) {
        return TMStringUtil.isinteger(string, bl, true);
    }

    public static boolean isinteger(String string, boolean bl, boolean bl2) {
        try {
            Integer.parseInt(string);
            if (bl) {
                return true;
            }
            string = string.toLowerCase();
            for (int i = 0; i < string.length(); ++i) {
                if (!Character.isLetter(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            if (!bl2) {
                return false;
            }
            try {
                double d = Double.parseDouble(string);
                if (d > 2.147483647E9 || d < -2.147483648E9) {
                    return false;
                }
                if (d == Math.floor(d)) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException2) {
                // empty catch block
            }
            return false;
        }
    }

    public static String getDate() {
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        String string = TMStringUtil.padWithZero(calendar.get(5));
        String string2 = TMStringUtil.padWithZero(calendar.get(11));
        String string3 = TMStringUtil.padWithZero(calendar.get(12));
        String string4 = TMStringUtil.padWithZero(calendar.get(13));
        return string + "-" + MONTHS[n2] + "-" + n + " " + string2 + ":" + string3 + ":" + string4;
    }

    private static final String padWithZero(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return new Integer(n).toString();
    }

    public static char[] readFile(String string) throws FileNotFoundException, IOException {
        File file = new File(string);
        char[] cArray = new char[(int)file.length()];
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        bufferedReader.read(cArray);
        bufferedReader.close();
        return cArray;
    }

    public static String processTokenizedString(String string, HashMap<String, String> hashMap) throws FileNotFoundException, IOException {
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(TMStringUtil.readFile(string)));
        Set<String> set = hashMap.keySet();
        for (String string2 : set) {
            TMStringUtil.replaceAll(stringBuilder, string2, hashMap.get(string2));
        }
        return stringBuilder.toString();
    }

    public static void replaceAll(StringBuilder stringBuilder, String string, String string2) {
        int n = stringBuilder.indexOf(string);
        while (n != -1) {
            stringBuilder.replace(n, n + string.length(), string2);
            n = stringBuilder.indexOf(string);
        }
    }

    public static String splitOnUpperCase(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 65535;
        if (string.length() > 0) {
            n = string.charAt(0);
        }
        stringBuilder.append(string);
        for (int i = stringBuilder.length() - 1; i > 0; --i) {
            if (Character.isUpperCase(stringBuilder.charAt(i)) && (Character.isLowerCase(stringBuilder.charAt(i - 1)) || Character.isDigit(stringBuilder.charAt(i - 1)))) {
                stringBuilder.insert(i, " ");
                continue;
            }
            if (i >= stringBuilder.length() - 2 || !Character.isUpperCase(stringBuilder.charAt(i)) || !Character.isUpperCase(stringBuilder.charAt(i - 1)) || !Character.isLowerCase(stringBuilder.charAt(i + 1))) continue;
            stringBuilder.insert(i, " ");
        }
        return stringBuilder.toString();
    }

    static {
        collator = null;
    }
}

