/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.util;

import com.mathworks.beans.EnumPair;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.toolbox.testmeas.util.ErrorSettingPropertyException;
import com.mathworks.toolbox.testmeas.util.IDeletionListener;
import com.mathworks.toolbox.testmeas.util.IPropertyChangeCompletionObserver;
import com.mathworks.toolbox.testmeas.util.TMMatlabWorker;
import com.mathworks.toolbox.testmeas.util.TMUDDObjectDeletedException;
import com.mathworks.util.Assert;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.ResourceBundle;

public abstract class TMUDDAdaptor {
    private static final ResourceBundle sResource = ResourceBundle.getBundle("com.mathworks.toolbox.testmeas.util.resource.RES_TMUTIL");
    private UDDObject fUDDObj;
    private HashMap<String, Object> fPropertyCache = new HashMap();

    public synchronized UDDObject getUDDObject() throws TMUDDObjectDeletedException {
        if (this.fUDDObj == null) {
            throw new TMUDDObjectDeletedException();
        }
        return this.fUDDObj;
    }

    protected TMUDDAdaptor(UDDObject uDDObject) {
        this.fUDDObj = uDDObject;
    }

    private Object getProperty(String string) {
        try {
            return this.fPropertyCache.get(string);
        }
        catch (Exception exception) {
            this.forcePropertyCacheUpdate(string);
            return null;
        }
    }

    public void forcePropertyCacheUpdate(final String string) {
        MatlabWorker matlabWorker = new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                try {
                    return TMUDDAdaptor.this.getUDDObject().getPropertyValue(string);
                }
                catch (TMUDDObjectDeletedException tMUDDObjectDeletedException) {
                    return tMUDDObjectDeletedException;
                }
                catch (Exception exception) {
                    return exception;
                }
            }

            public void runOnAWTEventDispatchThread(Object object) {
                if (Exception.class.isInstance(object)) {
                    return;
                }
                TMUDDAdaptor.this.updatePropertyCache(string, object);
            }
        };
        matlabWorker.start();
    }

    private void updatePropertyCache(String string, Object object) {
        this.fPropertyCache.put(string, object);
    }

    private void setProperty(final String string, final Object object, final IPropertyChangeCompletionObserver iPropertyChangeCompletionObserver) {
        MatlabWorker matlabWorker = new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                try {
                    TMUDDAdaptor.this.getUDDObject().setPropertyValue(string, object);
                }
                catch (TMUDDObjectDeletedException tMUDDObjectDeletedException) {
                    return tMUDDObjectDeletedException;
                }
                catch (RuntimeException runtimeException) {
                    if (runtimeException.getMessage().matches(string + ".*maximum.*")) {
                        Object[] objectArray = new Object[]{string};
                        return new ErrorSettingPropertyException(string, MessageFormat.format(sResource.getString("TMUDDAdaptor.OverMaxError"), objectArray));
                    }
                    if (runtimeException.getMessage().matches(string + ".*minimum.*")) {
                        Object[] objectArray = new Object[]{string};
                        return new ErrorSettingPropertyException(string, MessageFormat.format(sResource.getString("TMUDDAdaptor.BelowMinError"), objectArray));
                    }
                    return new ErrorSettingPropertyException(string, runtimeException.getMessage());
                }
                return TMUDDAdaptor.this.getUDDObject().getPropertyValue(string);
            }

            public void runOnAWTEventDispatchThread(Object object2) {
                if (Exception.class.isInstance(object2)) {
                    if (iPropertyChangeCompletionObserver != null) {
                        iPropertyChangeCompletionObserver.setFailed((Exception)object2);
                    }
                    return;
                }
                TMUDDAdaptor.this.updatePropertyCache(string, object2);
                if (iPropertyChangeCompletionObserver != null) {
                    iPropertyChangeCompletionObserver.setSuccessful();
                }
            }
        };
        matlabWorker.start();
    }

    protected double getDoubleProperty(String string) {
        Object object = this.getProperty(string);
        if (object == null) {
            return 0.0;
        }
        return (Double)object;
    }

    protected void setDoubleProperty(String string, double d, IPropertyChangeCompletionObserver iPropertyChangeCompletionObserver) {
        this.setProperty(string, d, iPropertyChangeCompletionObserver);
    }

    protected double[] getDoubleArrayProperty(String string) {
        Object object = this.getProperty(string);
        if (object == null) {
            double[] dArray = new double[]{0.0};
            return dArray;
        }
        return (double[])object;
    }

    protected void setDoubleArrayProperty(String string, double[] dArray, IPropertyChangeCompletionObserver iPropertyChangeCompletionObserver) {
        this.setProperty(string, dArray, iPropertyChangeCompletionObserver);
    }

    protected int getIntegerProperty(String string) {
        Object object = this.getProperty(string);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    protected void setIntegerProperty(String string, int n, IPropertyChangeCompletionObserver iPropertyChangeCompletionObserver) {
        this.setProperty(string, n, iPropertyChangeCompletionObserver);
    }

    protected String getStringProperty(String string) {
        Object object = this.getProperty(string);
        if (object == null) {
            return "";
        }
        return (String)object;
    }

    protected void setStringProperty(String string, String string2, IPropertyChangeCompletionObserver iPropertyChangeCompletionObserver) {
        this.setProperty(string, string2, iPropertyChangeCompletionObserver);
    }

    protected int getEnumeratedProperty(String string) {
        return this.getIntegerProperty(string);
    }

    protected void setEnumeratedProperty(String string, int n, IPropertyChangeCompletionObserver iPropertyChangeCompletionObserver) {
        this.setIntegerProperty(string, n, iPropertyChangeCompletionObserver);
    }

    protected String getEnumeratedPropertyAsString(String string) {
        PropertyDescriptor[] propertyDescriptorArray;
        int n = this.getEnumeratedProperty(string);
        try {
            propertyDescriptorArray = Introspector.getBeanInfo(this.getUDDObject().getClass()).getPropertyDescriptors();
        }
        catch (Exception exception) {
            Assert._assert((boolean)false, (String)exception.getMessage());
            return "";
        }
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            if (!propertyDescriptorArray[i].getName().equals(string)) continue;
            EnumPair[] enumPairArray = (EnumPair[])propertyDescriptorArray[i].getValue("EnumTags");
            for (int j = 0; j < enumPairArray.length; ++j) {
                if (enumPairArray[j].getValue() != n) continue;
                return enumPairArray[j].getName();
            }
            Assert._assert((boolean)false, (String)("Enumeration" + string + "does not have value " + String.valueOf(n) + "."));
            return "";
        }
        Assert._assert((boolean)false, (String)("Property" + string + "is not an enumeration."));
        return "";
    }

    protected void setEnumeratedProperty(String string, String string2, IPropertyChangeCompletionObserver iPropertyChangeCompletionObserver) {
        try {
            PropertyDescriptor[] propertyDescriptorArray = Introspector.getBeanInfo(this.getUDDObject().getClass()).getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (!propertyDescriptorArray[i].getName().equals(string)) continue;
                EnumPair[] enumPairArray = (EnumPair[])propertyDescriptorArray[i].getValue("EnumTags");
                for (int j = 0; j < enumPairArray.length; ++j) {
                    if (!enumPairArray[j].getName().equalsIgnoreCase(string2)) continue;
                    this.setEnumeratedProperty(string, enumPairArray[j].getValue(), iPropertyChangeCompletionObserver);
                    return;
                }
                Assert._assert((boolean)false, (String)("Enumeration '" + string + "' does not have value '" + string2 + "'."));
                return;
            }
            Assert._assert((boolean)false, (String)("Property" + string + "is not an enumeration."));
        }
        catch (TMUDDObjectDeletedException tMUDDObjectDeletedException) {
            Assert._assert((boolean)false, (String)"Attempt to set property on object after attempt to delete.");
        }
        catch (IntrospectionException introspectionException) {
            Assert._assert((boolean)false, (String)introspectionException.getMessage());
            return;
        }
    }

    public synchronized void deleteUnderlyingObject() {
        this.deleteUnderlyingObject(null);
    }

    public synchronized void deleteUnderlyingObject(final IDeletionListener iDeletionListener) {
        TMMatlabWorker tMMatlabWorker = new TMMatlabWorker(){
            IDeletionListener aCompletionObserver;
            UDDObject tobedeleted;
            Object fResult;
            {
                this.aCompletionObserver = iDeletionListener;
                this.tobedeleted = TMUDDAdaptor.this.fUDDObj;
            }

            @Override
            public void construct() {
                try {
                    Object[] objectArray = new Object[]{this.tobedeleted};
                    MatlabMCR.mtFeval((String)"delete", (Object[])objectArray, (int)0);
                    this.fResult = null;
                }
                catch (Exception exception) {
                    this.fResult = exception.getMessage();
                }
            }

            @Override
            public void finished() {
                super.finished();
                if (this.aCompletionObserver != null) {
                    if (this.fResult == null) {
                        this.aCompletionObserver.deleteSuccessful();
                    } else {
                        TMUDDAdaptor.this.fUDDObj = this.tobedeleted;
                        this.aCompletionObserver.deleteFailed((String)this.fResult);
                    }
                }
            }
        };
        this.fUDDObj = null;
        tMMatlabWorker.start();
    }
}

