/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.QueueEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;

public class MWStatusBar
extends MWPanel {
    static final int INSET_SIZE = 2;
    static final int BORDER_SIZE = 1;
    static final int BEVEL_NONE = 0;
    static final int BEVEL_LEFT = 1;
    static final int BEVEL_RIGHT = 2;
    static final int BEVEL_BOTH = 3;
    static final int LEFT_INSET_SHIFT = 24;
    static final int LEFT_INDENT_SHIFT = 16;
    static final int RIGHT_INSET_SHIFT = 8;
    static final int TOP_INSET_SHIFT = 24;
    static final int BOTTOM_INSET_SHIFT = 8;
    private StatusLabel fStatus;
    private boolean fBorderOn;

    public MWStatusBar() {
        super(new BorderLayout());
        this.setOpaqueInsets(false);
        this.setInsets(new Insets(1, 0, 0, 0));
        this.fStatus = new StatusLabel("", 20);
        super.add((Component)this.fStatus, "Center");
        this.setFont(Decorations.getFont(0));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = 20;
        return dimension;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fStatus.setFont(font);
    }

    @Override
    public Component add(Component component) {
        return component;
    }

    @Override
    public Component add(String string, Component component) {
        return component;
    }

    @Override
    public Component add(Component component, int n) {
        return component;
    }

    @Override
    public void add(Component component, Object object) {
        String string = object == null ? "East" : (object instanceof String ? (String)object : null);
        if (string != null) {
            if (string.equals("East") || string.equals("West")) {
                super.add(component, string);
            } else {
                string = null;
            }
        }
        if (string == null) {
            throw new IllegalArgumentException("cannot add component: constraint must be BorderLayout.EAST or BorderLayout.WEST (or null)");
        }
    }

    @Override
    public void add(Component component, Object object, int n) {
    }

    public void clear() {
        this.fStatus.setLabel(null);
    }

    public void setStatusText(String string) {
        this.fStatus.setLabel(string);
    }

    public String getStatusText() {
        return this.fStatus.getLabel();
    }

    public void setBorderOn(boolean bl) {
        if (this.fBorderOn != bl) {
            this.fBorderOn = bl;
            if (!bl) {
                this.setInsets(new Insets(1, 0, 0, 0));
            } else {
                this.setInsets(new Insets(1, 1, 1, 1));
            }
        }
    }

    public boolean isBorderOn() {
        return this.fBorderOn;
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        Color color = Decorations.getColor(7);
        if (this.fBorderOn) {
            graphics.setColor(Decorations.getColor(9));
            graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
            graphics.drawLine(dimension.width - 1, 1, dimension.width - 1, dimension.height - 2);
            graphics.setColor(color);
            graphics.drawLine(0, 0, dimension.width - 1, 0);
            graphics.drawLine(0, 1, 0, dimension.height - 2);
        } else {
            graphics.setColor(color);
            graphics.drawLine(0, 0, dimension.width - 1, 0);
        }
        super.paint(graphics);
    }

    private static Rectangle getDrawableArea(Component component, int n) {
        Rectangle rectangle = MWUtils.boundsInTopLevelWindow(component);
        if (n != 0) {
            int n2;
            Dimension dimension = MWUtils.getTopLevelWindow(component).getSize();
            int n3 = PlatformInfo.isUnix() ? 5 : 4;
            int n4 = dimension.width - rectangle.x - rectangle.width;
            int n5 = dimension.height - rectangle.y - rectangle.height;
            int n6 = n4 <= n3 && n4 >= 2 ? 0 : 2;
            int n7 = n5 <= n3 && n5 >= 2 ? 0 : 2;
            int n8 = n2 = 2 - n6;
            if (n6 > 0 && rectangle.x <= n3) {
                n8 = 2;
            } else if (n6 == 0 && rectangle.x > n3) {
                n8 = 0;
            }
            if ((n & 1) == 0) {
                n8 = 2;
            }
            if ((n & 2) == 0) {
                n2 = 2;
            }
            int n9 = 2 - n8;
            int n10 = 2 - n2;
            n3 = n8 + n2;
            n8 = n3 >> 1;
            n2 = n3 - n8;
            rectangle.x = n9 << 24 | n8 << 16 | n10 << 8 | n2;
            rectangle.y = 0x2000000 | n7 << 8;
            rectangle.width = rectangle.width - n9 - n10 - 2;
            rectangle.height = rectangle.height - 2 - n7 - 2;
        } else {
            rectangle.x = 131074;
            rectangle.y = 0;
        }
        return rectangle;
    }

    private static void drawBevel(Graphics graphics, Rectangle rectangle) {
        int n = rectangle.x >> 24 & 0xFF;
        int n2 = rectangle.x >> 8 & 0xFF;
        int n3 = rectangle.y >> 24 & 0xFF;
        int n4 = rectangle.y >> 8 & 0xFF;
        int n5 = rectangle.width + n + n2 + 2;
        int n6 = rectangle.height + n3 + n4 + 2;
        graphics.setColor(Decorations.getColor(6));
        graphics.fillRect(0, 0, n5, n3);
        if (rectangle.y > 0) {
            graphics.fillRect(0, n6 - n4, n5, n4);
        }
        if (n > 0) {
            graphics.fillRect(0, 0, n, n6);
        }
        if (n2 > 0) {
            graphics.fillRect(n5 - n2, 0, n2, n6);
        }
        graphics.setColor(Decorations.getColor(9));
        graphics.drawLine(n, n3, (n5 -= n2 + 1) - 1, n3);
        graphics.drawLine(n, n3, n, (n6 -= n4 + 1) - 1);
        graphics.setColor(Decorations.getColor(7));
        graphics.drawLine(n, n6, n5, n6);
        graphics.drawLine(n5, n3, n5, n6);
    }

    private static void drawItem(Graphics graphics, Rectangle rectangle, boolean bl, int n, int n2, int n3, String string, int n4, char[] cArray, int n5, int n6) {
        int n7 = rectangle.width;
        int n8 = rectangle.height;
        int n9 = rectangle.x >> 24 & 0xFF;
        int n10 = rectangle.y >> 8 & 0xFF;
        Color color = Decorations.getColor(6);
        if (cArray != null || string != null && string.length() > 0) {
            int n11;
            Rectangle rectangle2 = null;
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n12 = n + fontMetrics.getAscent() + (n8 - fontMetrics.getAscent() - fontMetrics.getDescent() >> 1);
            int n13 = n11 = n3 <= 0 ? n : n + n3 + n2;
            if (cArray != null) {
                n7 = Math.min(n7, n4 + n6 + n2);
            }
            if (bl) {
                if (n9 == 0) {
                    n11 -= 2;
                }
                rectangle2 = graphics.getClipBounds();
                graphics.clipRect(n11, n, n7, n8);
            }
            graphics.setColor(color);
            graphics.fillRect(n11, n, n7, n8);
            graphics.setColor(Decorations.getColor(11));
            if (n3 <= 0) {
                n11 += n2 + n3;
            }
            if (string != null) {
                graphics.drawString(string, n11, n12);
            }
            if (cArray != null) {
                graphics.drawChars(cArray, 0, n5, n11 += n4, n12);
            }
            if (bl) {
                graphics.setClip(rectangle2);
            }
        } else {
            graphics.setColor(color);
            if (bl && n9 == 0) {
                graphics.fillRect(n - 2, n, n7, n8);
            } else {
                graphics.fillRect(n, n, n7, n8);
            }
        }
    }

    public static class StatusValue
    extends MWCanvas {
        public static final int BEVEL_NONE = 0;
        public static final int BEVEL_LEFT = 1;
        public static final int BEVEL_RIGHT = 2;
        public static final int BEVEL_BOTH = 3;
        private AWTPaintEvent fEvent;
        private int MIN_HEIGHT = 20;
        private int MIN_WIDTH = 24;
        private boolean fBevelOn;
        private int fBevelStyle;
        private int fIndent;
        private int fInset;
        private Rectangle fArea;
        int[] fMaxDigits;
        String[] fLabels;
        int[] fLabelWidths;
        int[] fValues;
        int[] fValueWidths;
        char[] fBuf;
        boolean[] fDirtyLabels;
        boolean[] fDirtyValues;

        public StatusValue(String[] stringArray, int[] nArray) {
            int n;
            if (stringArray == null || nArray == null || stringArray.length != nArray.length) {
                throw new IllegalArgumentException("labels and widths must be non null and must have the same length");
            }
            this.fEvent = new AWTPaintEvent(this);
            this.fBuf = new char[16];
            this.fValues = new int[nArray.length];
            this.fDirtyValues = new boolean[nArray.length];
            this.fLabels = new String[stringArray.length];
            this.fDirtyLabels = new boolean[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                this.fLabels[n] = stringArray[n];
            }
            this.fMaxDigits = new int[nArray.length];
            for (n = 0; n < nArray.length; ++n) {
                this.fMaxDigits[n] = nArray[n];
            }
            this.enableEvents(1L);
        }

        @Override
        protected void processComponentEvent(ComponentEvent componentEvent) {
            super.processComponentEvent(componentEvent);
            if (componentEvent.getID() == 101 || componentEvent.getID() == 100) {
                this.fArea = null;
                if (componentEvent.getComponent() == this && componentEvent.getComponent().isShowing()) {
                    this.fArea = MWStatusBar.getDrawableArea(this, this.fBevelStyle);
                    this.repaint();
                }
            }
        }

        public void setBevel(int n) {
            if (n != this.fBevelStyle) {
                this.fBevelStyle = n;
                if (n == 0) {
                    this.fIndent = 5;
                    this.fInset = 0;
                    this.fBevelOn = false;
                } else {
                    this.fIndent = 2;
                    this.fInset = 3;
                    this.fBevelOn = true;
                }
                this.invalidate();
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            int n;
            int n2;
            FontMetrics fontMetrics;
            Font font = this.getFont();
            if (font != null) {
                fontMetrics = this.getFontMetrics(font);
                n2 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + (this.fInset << 1);
            } else {
                n2 = this.MIN_HEIGHT;
                fontMetrics = null;
            }
            if (fontMetrics == null) {
                n = 0;
            } else {
                int n3;
                if (this.fLabelWidths == null) {
                    this.fLabelWidths = new int[this.fLabels.length];
                    this.fValueWidths = new int[this.fValues.length];
                    n = fontMetrics.charWidth('3');
                    for (n3 = 0; n3 < this.fLabels.length; ++n3) {
                        this.fLabelWidths[n3] = this.fLabels[n3] == null ? 0 : fontMetrics.stringWidth(this.fLabels[n3]);
                        this.fValueWidths[n3] = this.fMaxDigits[n3] * n;
                    }
                }
                n = (this.fInset << 1) + this.fIndent;
                for (n3 = 0; n3 < this.fLabels.length; ++n3) {
                    n += this.fLabelWidths[n3] + this.fValueWidths[n3] + this.fIndent;
                }
            }
            if (n < this.MIN_WIDTH) {
                n = this.MIN_WIDTH;
            }
            return new Dimension(n, n2);
        }

        private void awtPaint(boolean bl) {
            if (this.isShowing()) {
                if (MWUtils.isAWTEventQueueThread()) {
                    Graphics graphics = this.getGraphics();
                    this.paintAll(graphics, bl);
                    graphics.dispose();
                } else {
                    this.fEvent.setAll(bl);
                    QueueEvent.postQueueEvent((QueueEvent)this.fEvent);
                }
            }
        }

        @Override
        public void paint(Graphics graphics) {
            this.paintAll(graphics, true);
        }

        private void paintAll(Graphics graphics, boolean bl) {
            int n;
            Rectangle rectangle = null;
            if (this.fLabelWidths == null) {
                for (Component component = this; component != null; component = component.getParent()) {
                    component.invalidate();
                    if (!(component instanceof MWStatusBar)) continue;
                    ((Container)component).doLayout();
                    break;
                }
                return;
            }
            if (this.fArea == null) {
                this.fArea = MWStatusBar.getDrawableArea(this, this.fBevelStyle);
                if (this.fArea == null) {
                    return;
                }
            }
            rectangle = this.fArea;
            graphics.setFont(this.getFont());
            int n2 = this.fLabels.length;
            if (bl) {
                for (n = 0; n < n2; ++n) {
                    this.fDirtyLabels[n] = true;
                    this.fDirtyValues[n] = true;
                }
            }
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                int n4;
                char[] cArray;
                String string;
                int n5;
                int n6 = this.fIndent;
                if (this.fDirtyLabels[n]) {
                    n5 = this.fLabelWidths[n];
                    string = this.fLabels[n];
                    if (n == 0) {
                        n3 = -n6;
                        n6 = (n6 << 1) + (rectangle.x >> 16 & 0xFF);
                    }
                } else {
                    n5 = 0;
                    string = null;
                    n3 += this.fLabelWidths[n];
                    if (n == 0) {
                        n3 += rectangle.x >> 16 & 0xFF;
                    }
                }
                int n7 = this.fValueWidths[n];
                if (this.fDirtyValues[n]) {
                    cArray = this.fBuf;
                    n4 = this.uintToChars(cArray, this.fValues[n]);
                } else {
                    cArray = null;
                    n4 = 0;
                }
                if (n + 1 == n2) {
                    n7 += rectangle.x & 0xFF;
                }
                if (cArray != null || string != null || bl) {
                    MWStatusBar.drawItem(graphics, rectangle, this.fBevelOn, this.fInset, n6, n3, string, n5, cArray, n4, n7);
                }
                this.fDirtyLabels[n] = false;
                this.fDirtyValues[n] = false;
                n3 += n5 + n7 + n6;
            }
            if (this.fBevelOn && bl) {
                MWStatusBar.drawBevel(graphics, rectangle);
            }
        }

        public void setLabel(int n, String string) {
            if (n >= 0 && n < this.fLabels.length) {
                this.fLabels[n] = string;
                this.fDirtyLabels[n] = true;
                this.awtPaint(false);
            }
        }

        public void setValue(int n, int n2) {
            if (n >= 0 && n < this.fValues.length && this.fValues[n] != n2) {
                this.fValues[n] = n2;
                this.fDirtyValues[n] = true;
                this.awtPaint(false);
            }
        }

        public void setValues(int[] nArray, int[] nArray2) {
            int n;
            for (n = 0; n < nArray.length; ++n) {
                int n2 = nArray[n];
                if (n2 < 0 || n2 >= this.fValues.length || this.fValues[n2] == nArray2[n]) continue;
                this.fValues[n2] = nArray2[n];
                this.fDirtyValues[n2] = true;
            }
            if (n > 0) {
                this.awtPaint(false);
            }
        }

        private int uintToChars(char[] cArray, int n) {
            int n2 = 0;
            do {
                cArray[n2++] = (char)(n % 10 + 48);
            } while ((n /= 10) > 0);
            int n3 = n2 >> 1;
            for (int i = 0; i < n3; ++i) {
                char c = cArray[i];
                cArray[i] = cArray[n2 - i - 1];
                cArray[n2 - i - 1] = c;
            }
            return n2;
        }
    }

    private static class AWTPaintEvent
    extends QueueEvent {
        StatusLabel fStatusLabel;
        StatusValue fStatusValue;
        boolean fAll;

        public AWTPaintEvent(StatusValue statusValue) {
            this.fStatusValue = statusValue;
        }

        public AWTPaintEvent(StatusLabel statusLabel) {
            this.fStatusLabel = statusLabel;
        }

        public void dispatch() {
            if (this.fStatusLabel != null) {
                this.fStatusLabel.awtPaint(this.fAll);
            } else if (this.fStatusValue != null) {
                this.fStatusValue.awtPaint(this.fAll);
            }
            this.fAll = false;
        }

        void setAll(boolean bl) {
            if (!this.fAll) {
                this.fAll = bl;
            }
        }
    }

    public static class StatusLabel
    extends MWCanvas {
        public static final int BEVEL_NONE = 0;
        public static final int BEVEL_LEFT = 1;
        public static final int BEVEL_RIGHT = 2;
        public static final int BEVEL_BOTH = 3;
        private int MIN_HEIGHT = 20;
        private String fLabel;
        private String fFixedLabel;
        private int fMinWidth;
        private int fFixedWidth;
        private int fBevelStyle;
        private boolean fBevelOn;
        private int fIndent;
        private int fInset;
        private Rectangle fArea;
        private AWTPaintEvent fEvent;

        public StatusLabel(String string, int n) {
            this.fLabel = string;
            this.fMinWidth = n;
            this.fIndent = 5;
            this.fInset = 0;
            this.fEvent = new AWTPaintEvent(this);
            this.enableEvents(1L);
        }

        public StatusLabel(int n) {
            this.fFixedWidth = n;
            this.fIndent = 5;
            this.fEvent = new AWTPaintEvent(this);
            this.enableEvents(1L);
        }

        @Override
        protected void processComponentEvent(ComponentEvent componentEvent) {
            super.processComponentEvent(componentEvent);
            if (componentEvent.getID() == 101 || componentEvent.getID() == 100) {
                this.fArea = null;
                if (componentEvent.getComponent() == this && componentEvent.getComponent().isShowing()) {
                    this.fArea = MWStatusBar.getDrawableArea(this, this.fBevelStyle);
                    this.fFixedLabel = null;
                    this.repaint();
                }
            }
        }

        public void setLabel(String string) {
            if (string != this.fLabel) {
                this.fLabel = string;
                this.fFixedLabel = null;
                this.awtPaint(false);
            }
        }

        public String getLabel() {
            return this.fLabel;
        }

        public void setBevel(int n) {
            if (n != this.fBevelStyle) {
                this.fBevelStyle = n;
                if (n == 0) {
                    this.fIndent = 5;
                    this.fInset = 0;
                    this.fBevelOn = false;
                } else {
                    this.fIndent = 2;
                    this.fInset = 3;
                    this.fBevelOn = true;
                }
                this.invalidate();
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            int n;
            int n2;
            FontMetrics fontMetrics;
            Font font = this.getFont();
            if (font != null) {
                fontMetrics = this.getFontMetrics(font);
                n2 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + (this.fInset << 1);
            } else {
                n2 = this.MIN_HEIGHT;
                fontMetrics = null;
            }
            if (this.fFixedWidth > 0) {
                n = this.fFixedWidth;
            } else {
                n = this.fLabel == null || this.fLabel.length() == 0 || fontMetrics == null ? this.fMinWidth : fontMetrics.stringWidth(this.fLabel) + this.fIndent + (this.fInset << 1);
                if (n < this.fMinWidth) {
                    n = this.fMinWidth;
                }
            }
            return new Dimension(n, n2);
        }

        private void awtPaint(boolean bl) {
            if (this.isShowing()) {
                if (MWUtils.isAWTEventQueueThread()) {
                    Graphics graphics = this.getGraphics();
                    this.paintAll(graphics, bl);
                    graphics.dispose();
                } else {
                    this.fEvent.setAll(bl);
                    QueueEvent.postQueueEvent((QueueEvent)this.fEvent);
                }
            }
        }

        @Override
        public void paint(Graphics graphics) {
            this.paintAll(graphics, true);
        }

        private void paintAll(Graphics graphics, boolean bl) {
            String string;
            if (this.fArea == null) {
                this.fArea = MWStatusBar.getDrawableArea(this, this.fBevelStyle);
                if (this.fArea == null) {
                    return;
                }
            }
            Rectangle rectangle = this.fArea;
            graphics.setFont(this.getFont());
            if (this.fFixedWidth > 0) {
                if (this.fFixedLabel == null && this.fLabel != null) {
                    int n;
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    int n2 = fontMetrics.stringWidth(this.fLabel);
                    if (n2 > (n = rectangle.width - this.fIndent)) {
                        int n3 = fontMetrics.charWidth('.') * 3;
                        if (n3 < n) {
                            n -= n3;
                            for (n3 = this.fLabel.length() - 1; n3 >= 0; --n3) {
                                if ((n2 -= fontMetrics.charWidth(this.fLabel.charAt(n3))) > n) continue;
                                this.fFixedLabel = this.fLabel.substring(0, n3) + "...";
                                break;
                            }
                        } else {
                            this.fFixedLabel = "...";
                        }
                    } else {
                        this.fFixedLabel = this.fLabel;
                    }
                }
                string = this.fFixedLabel;
            } else {
                string = this.fLabel;
            }
            MWStatusBar.drawItem(graphics, rectangle, this.fBevelOn, this.fInset, this.fIndent, 0, string, 0, null, 0, 0);
            if (this.fBevelOn && bl) {
                MWStatusBar.drawBevel(graphics, rectangle);
            }
        }
    }
}

