/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWCardPanel;
import com.mathworks.mwt.MWFocusChain;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWScrollbar;
import com.mathworks.mwt.MWTab;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MWTabPanel
extends MWCardPanel
implements MWFocusChain {
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int BOTTOM = 3;
    public static final int RIGHT = 4;
    public static final int DIALOG = 0;
    public static final int DOCUMENT = 1;
    public static final int DOCUMENT_OVERLAP = 2;
    private MWTab fTabs;
    private Spacer fLeftSpacer;
    private Spacer fRightSpacer;
    private MWPanel fTabScrollSpacer;
    private TabScrollPanel fTabScroll;
    private boolean fShowBevel = true;
    private Color fSelectedPanelColor;
    private transient ItemListener fItemListener;

    public MWTabPanel(int n, int n2, boolean bl) {
        if (PlatformInfo.isWindows()) {
            this.fSelectedPanelColor = new Color(250, 250, 250);
        }
        this.fTabScroll = new TabScrollPanel();
        this.fRightSpacer = new Spacer(this, 0, 5);
        this.fLeftSpacer = new Spacer(this, 0, 5);
        this.fTabScrollSpacer = new MWPanel(new BorderLayout());
        this.fTabScrollSpacer.setOpaque(false);
        this.fTabScrollSpacer.add((Component)this.fTabScroll, "Center");
        this.fTabScrollSpacer.add((Component)this.fRightSpacer, "East");
        this.fTabScrollSpacer.add((Component)this.fLeftSpacer, "West");
        this.fTabs = this.fTabScroll.getTabs();
        this.fTabs.addItemListener(new TabHandler());
        super.setStyle(2);
        super.setLabel("");
        this.setStyle(n2);
        this.setOrientation(n);
        this.setHasScrollbar(bl);
        if (n2 == 0) {
            this.setRightGap(0);
        } else {
            this.setRightGap(16);
        }
        this.addMouseListener(new MouseHandler());
    }

    public MWTabPanel(int n, int n2) {
        this(n, n2, false);
    }

    public MWTabPanel(int n) {
        this(n, 0);
    }

    public MWTabPanel() {
        this(1);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.fTabs.setEnabled(bl);
    }

    public int getLeftGap() {
        return this.fLeftSpacer.getPreferredSize().width;
    }

    public void setLeftGap(int n) {
        Dimension dimension = this.fLeftSpacer.getPreferredSize();
        dimension.width = n;
        this.fLeftSpacer.setPreferredSize(dimension);
    }

    public int getRightGap() {
        return this.fRightSpacer.getPreferredSize().width;
    }

    public void setRightGap(int n) {
        Dimension dimension = this.fRightSpacer.getPreferredSize();
        dimension.width = n;
        this.fRightSpacer.setPreferredSize(dimension);
    }

    public void setHasScrollbar(boolean bl) {
        this.fTabScroll.setHasScrollbar(bl);
    }

    public boolean getHasScrollbar() {
        return this.fTabScroll.getScrollbar().isVisible();
    }

    public MWScrollbar getScrollbar() {
        return this.fTabScroll.getScrollbar();
    }

    private void syncTabsToPanels() {
        while (this.getPanelCount() < this.fTabs.getItemCount()) {
            this.fTabs.remove(0);
        }
        for (int i = 0; i < this.getPanelCount(); ++i) {
            String string = this.getPanelName(i);
            if (i >= this.fTabs.getItemCount()) {
                this.fTabs.addItem(string);
            } else {
                this.fTabs.setItem(string, i);
            }
            if (i != this.getSelectedIndex()) continue;
            this.fTabs.select(i);
        }
    }

    public void addTabMouseAndMotionListener(MouseListener mouseListener) {
        this.fTabs.addMouseListener(mouseListener);
        if (mouseListener instanceof MouseMotionListener) {
            this.fTabs.addMouseMotionListener((MouseMotionListener)((Object)mouseListener));
        }
    }

    public void removeTabMouseAndMotionListener(MouseListener mouseListener) {
        this.fTabs.removeMouseListener(mouseListener);
        if (mouseListener instanceof MouseMotionListener) {
            this.fTabs.removeMouseMotionListener((MouseMotionListener)((Object)mouseListener));
        }
    }

    @Override
    public int addPanelNoSelect(String string, Component component) {
        return this.addPanel(string, component, true);
    }

    @Override
    public int addPanel(String string, Component component) {
        return this.addPanel(string, component, false);
    }

    private int addPanel(String string, Component component, boolean bl) {
        int n = bl ? super.addPanelNoSelect(string, component) : super.addPanel(string, component);
        boolean bl2 = PlatformInfo.getAppearance() == 0;
        this.syncTabsToPanels();
        if (this.getPanelCount() == 1 && !bl2) {
            this.fRightSpacer.setDrawEdge(false);
        }
        return n;
    }

    @Override
    public void removePanel(int n) {
        super.removePanel(n);
        this.syncTabsToPanels();
        if (this.getPanelCount() == 0) {
            this.fRightSpacer.setDrawEdge(true);
        }
    }

    public void setSelectedPanelColor(Color color) {
        if (color != this.fSelectedPanelColor) {
            Component component = this.getComponent(0);
            if (component != null) {
                if (color == null) {
                    component.setBackground(Decorations.getColor(6));
                } else {
                    component.setBackground(color);
                }
            }
            this.fSelectedPanelColor = color;
        }
    }

    @Override
    public void selectPanel(int n) {
        Component component;
        super.selectPanel(n);
        if (PlatformInfo.useWindowsXPAppearance() && this.fSelectedPanelColor != null && (component = this.getComponent(0)) != null) {
            component.setBackground(this.fSelectedPanelColor);
        }
        this.syncTabsToPanels();
    }

    @Override
    public void showPanel(int n) {
        super.showPanel(n);
        this.syncTabsToPanels();
    }

    @Override
    public void setPanelName(String string, int n) {
        super.setPanelName(string, n);
        this.syncTabsToPanels();
    }

    @Override
    public void setPanelNameID(String string, int n) {
        super.setPanelNameID(string, n);
        this.syncTabsToPanels();
    }

    public boolean isScrollable() {
        return this.fTabs.isScrollable();
    }

    public void setScrollable(boolean bl) {
        this.fTabs.setScrollable(bl);
    }

    public int getSelectedTabColor() {
        return this.fTabs.getSelectedTabColor();
    }

    public void setSelectedTabColor(int n) {
        this.fTabs.setSelectedTabColor(n);
        this.getGroupbox().setBackground(Decorations.getColor(n));
    }

    @Override
    public int getStyle() {
        return this.fTabs.getStyle();
    }

    @Override
    public void setStyle(int n) {
        switch (n) {
            case 0: {
                this.fTabs.setStyle(n);
                if (this.fShowBevel) {
                    this.getGroupbox().setStyle(2);
                    break;
                }
                this.getGroupbox().setStyle(5);
                break;
            }
            case 1: 
            case 2: {
                this.fTabs.setStyle(n);
                if (this.fShowBevel) {
                    this.getGroupbox().setStyle(4);
                    break;
                }
                this.getGroupbox().setStyle(5);
            }
        }
    }

    public boolean getShowBevel() {
        return this.fShowBevel;
    }

    public void setShowBevel(boolean bl) {
        if (bl != this.fShowBevel) {
            this.fShowBevel = bl;
            this.setStyle(this.getStyle());
        }
    }

    public int getOrientation() {
        return this.fTabs.getOrientation();
    }

    public void setOrientation(int n) {
        this.fTabs.setOrientation(n);
        this.remove(this.fTabScrollSpacer);
        switch (this.fTabs.getOrientation()) {
            case 1: {
                this.remove(this.fTabScrollSpacer);
                this.getGroupbox().setHiddenEdge(1);
                this.add((Component)this.fTabScrollSpacer, "North");
                break;
            }
            case 2: {
                this.remove(this.fTabScrollSpacer);
                this.getGroupbox().setHiddenEdge(2);
                this.add((Component)this.fTabScrollSpacer, "West");
                break;
            }
            case 3: {
                this.getGroupbox().setHiddenEdge(3);
                this.add((Component)this.fTabScrollSpacer, "South");
                break;
            }
            case 4: {
                this.getGroupbox().setHiddenEdge(4);
                this.add((Component)this.fTabScrollSpacer, "East");
            }
        }
        this.validate();
        this.repaint();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fTabs.setFont(this.getFont());
    }

    @Override
    public void focusEvent(FocusEvent focusEvent) {
        MWFocusChain mWFocusChain = MWUtils.getNextFocusLink(this);
        if (mWFocusChain != null) {
            mWFocusChain.focusEvent(focusEvent);
        }
    }

    @Override
    public void focusSwitch(KeyEvent keyEvent) {
        int n = -1;
        if (keyEvent != null) {
            int n2;
            int n3 = keyEvent.getKeyCode();
            int n4 = keyEvent.getModifiers();
            if ((n4 == 2 || n4 == 3) && (n2 = this.getPanelCount()) > 1) {
                if (n3 == 34 || n3 == 9 && !keyEvent.isShiftDown()) {
                    n = this.getSelectedIndex() + 1;
                    if (n == n2) {
                        n = 0;
                    }
                } else if ((n3 == 33 || n3 == 9 && keyEvent.isShiftDown()) && (n = this.getSelectedIndex() - 1) < 0) {
                    n = n2 - 1;
                }
            }
        }
        if (n < 0) {
            MWFocusChain mWFocusChain = MWUtils.getNextFocusLink(this);
            if (mWFocusChain != null) {
                mWFocusChain.focusSwitch(keyEvent);
            }
        } else {
            this.selectPanel(n);
        }
    }

    @Override
    public void focusMousePressed(MouseEvent mouseEvent) {
        MWFocusChain mWFocusChain = MWUtils.getNextFocusLink(this);
        if (mWFocusChain != null) {
            mWFocusChain.focusMousePressed(mouseEvent);
        }
    }

    private class Spacer
    extends MWCanvas {
        private boolean fDrawEdge;
        private MWTabPanel fOwner;

        Spacer(MWTabPanel mWTabPanel2, int n, int n2) {
            super(n, n2);
            this.fOwner = mWTabPanel2;
            this.fDrawEdge = true;
        }

        void setDrawEdge(boolean bl) {
            this.fDrawEdge = bl;
            this.repaint(5L);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            if (this.fOwner.getStyle() != 0 && this.fDrawEdge) {
                int n = this.getSize().width;
                int n2 = this.getSize().height;
                graphics.setColor(Color.black);
                switch (this.fOwner.getOrientation()) {
                    case 1: {
                        graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
                        break;
                    }
                    case 3: {
                        graphics.drawLine(0, 0, n - 1, 0);
                        break;
                    }
                    case 4: {
                        graphics.drawLine(0, 0, 0, n2 - 1);
                        break;
                    }
                    case 2: {
                        graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
                    }
                }
            }
        }
    }

    private class ScrollbarDivider
    extends MWCanvas
    implements MouseMotionListener,
    MouseListener {
        private Point fOffset;

        ScrollbarDivider() {
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.setCursor(Cursor.getPredefinedCursor(10));
        }

        @Override
        public void paint(Graphics graphics) {
            Rectangle rectangle = this.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            Decorations.drawButtonBevel(graphics, rectangle, false, false, true);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(5, 5);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.fOffset = mouseEvent.getPoint();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            TabScrollPanel tabScrollPanel = (TabScrollPanel)this.getParent();
            Point point = mouseEvent.getPoint();
            Point point2 = this.getLocation();
            Dimension dimension = this.getSize();
            Dimension dimension2 = tabScrollPanel.getSize();
            boolean bl = tabScrollPanel.isVisible();
            int n = dimension2.width - (point.x + point2.x - this.fOffset.x + dimension.width);
            tabScrollPanel.setRightSize(n);
            if (bl) {
                tabScrollPanel.setVisible(false);
            }
            tabScrollPanel.doLayout();
            if (bl) {
                tabScrollPanel.setVisible(true);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private class TabScrollPanel
    extends MWPanel {
        private MWTab fTabs;
        private MWScrollbar fScrollbar;
        private ScrollbarDivider fDivider;
        private int fRightSize;
        private Dimension fCachedSize;

        TabScrollPanel() {
            this.setOpaque(false);
            this.setLayout(null);
            this.fRightSize = -1;
            this.fCachedSize = null;
            this.fTabs = new MWTab();
            this.fScrollbar = new MWScrollbar(1);
            this.fDivider = new ScrollbarDivider();
            this.add(this.fTabs);
            this.add(this.fScrollbar);
            this.add(this.fDivider);
        }

        MWTab getTabs() {
            return this.fTabs;
        }

        MWScrollbar getScrollbar() {
            return this.fScrollbar;
        }

        void setHasScrollbar(boolean bl) {
            this.fDivider.setVisible(bl);
            this.fScrollbar.setVisible(bl);
        }

        void setRightSize(int n) {
            int n2 = this.getSize().height * 2;
            int n3 = this.getSize().width - 5;
            this.fRightSize = n < n2 ? n2 : (n > n3 ? n3 : n);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension;
            Dimension dimension2 = new Dimension(0, 0);
            if (this.fTabs.isVisible()) {
                dimension = this.fTabs.getPreferredSize();
                dimension2.height = Math.max(dimension2.height, dimension.height);
                dimension2.width += dimension.width;
            }
            if (this.fDivider.isVisible()) {
                dimension = this.fDivider.getPreferredSize();
                dimension2.height = Math.max(dimension2.height, dimension.height);
                dimension2.width += dimension.width;
            }
            if (this.fScrollbar.isVisible()) {
                dimension = this.fScrollbar.getPreferredSize();
                dimension2.height = Math.max(dimension2.height, dimension.height);
                dimension2.width += dimension.width;
            }
            return dimension2;
        }

        @Override
        public void doLayout() {
            Dimension dimension = this.getSize();
            int n = dimension.width;
            int n2 = dimension.height * 2;
            int n3 = dimension.width - 5;
            if (this.fCachedSize == null) {
                this.fCachedSize = this.getSize();
                this.fRightSize = this.fCachedSize.width / 2;
            } else if (!this.fCachedSize.equals(dimension)) {
                int n4 = this.fCachedSize.width != 0 ? dimension.width * this.fRightSize / this.fCachedSize.width : 0;
                this.fRightSize = n4;
                this.fCachedSize = dimension;
            }
            if (this.fRightSize < n2) {
                this.fRightSize = n2;
            } else if (this.fRightSize > n3) {
                this.fRightSize = n3;
            }
            if (this.fScrollbar.isVisible()) {
                this.fScrollbar.setBounds(n -= this.fRightSize, 0, this.fRightSize, dimension.height);
            }
            if (this.fDivider.isVisible()) {
                Dimension dimension2 = this.fDivider.getPreferredSize();
                this.fDivider.setBounds(n -= dimension2.width, 0, dimension2.width, dimension.height);
            }
            if (this.fTabs.isVisible()) {
                this.fTabs.setBounds(0, 0, n, dimension.height);
            }
        }
    }

    private class TabHandler
    implements ItemListener {
        private TabHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            MWTabPanel.this.selectPanel(MWTabPanel.this.fTabs.getSelectedIndex());
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Point point = MWTabPanel.this.fTabs.getLocation();
            Dimension dimension = MWTabPanel.this.fTabs.getSize();
            for (Container container = MWTabPanel.this.fTabs.getParent(); container != null && !(container instanceof MWTabPanel); container = container.getParent()) {
                point.x += container.getLocation().x;
                point.y += container.getLocation().y;
            }
            Rectangle rectangle = new Rectangle(point.x, point.y, dimension.width, dimension.height);
            if (rectangle.contains(mouseEvent.getPoint())) {
                mouseEvent.translatePoint(-point.x, -point.y);
                MWTabPanel.this.fTabs.dispatchEvent(mouseEvent);
                mouseEvent.translatePoint(point.x, point.y);
            }
        }
    }
}

