/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.command;

import com.mathworks.mwt.command.MWCommandCenterOwner;
import com.mathworks.mwt.command.MWCommandChain;
import com.mathworks.mwt.command.MWCommandSource;
import com.mathworks.mwt.command.MWCommandTarget;
import com.mathworks.util.IntHashtable;
import com.mathworks.util.MutableInt;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;

public class MWCommandCenter
implements MWCommandTarget {
    public static final int SHIFT_MOD = 0x1000000;
    public static final int CTRL_MOD = 0x2000000;
    public static final int META_MOD = 0x4000000;
    public static final int ALT_MOD = 0x8000000;
    public static final int NO_MOD = Integer.MIN_VALUE;
    public static final int CTRL_X_MOD = 0x40000000;
    public static final int CTRL_X_CTRL_MOD = 0x42000000;
    public static final int COMMAND_KEY_HANDLED = 0;
    public static final int COMMAND_KEY_NOT_FOUND = 1;
    public static final int COMMAND_KEY_NOT_ENABLED = 2;
    private boolean fActive = true;
    private MWCommandTarget fCurrentTarget;
    private IntHashtable fCommands;
    private IntHashtable fAccelerators;

    public MWCommandCenter(MWCommandTarget mWCommandTarget) {
        this(mWCommandTarget, 20);
    }

    public MWCommandCenter(MWCommandTarget mWCommandTarget, int n) {
        if (mWCommandTarget == null) {
            throw new NullPointerException();
        }
        this.fCommands = new IntHashtable(n);
        this.fAccelerators = new IntHashtable(n);
        this.fCurrentTarget = mWCommandTarget;
    }

    public void setCurrentTarget(MWCommandChain mWCommandChain) {
        if (mWCommandChain == null) {
            throw new NullPointerException();
        }
        if (mWCommandChain != this.fCurrentTarget) {
            this.fCurrentTarget = mWCommandChain;
            Enumeration enumeration = this.fCommands.keys();
            while (enumeration.hasMoreElements()) {
                MutableInt mutableInt = (MutableInt)enumeration.nextElement();
                int n = mutableInt.getValue();
                CommandInfo commandInfo = (CommandInfo)this.fCommands.get(n);
                commandInfo.setState(mWCommandChain.isCommandEnabled(n));
            }
        }
    }

    @Override
    public void doCommand(int n) {
        CommandInfo commandInfo = (CommandInfo)this.fCommands.get(n);
        if (commandInfo != null && commandInfo.getState()) {
            this.fCurrentTarget.doCommand(n);
        }
    }

    public void addCommand(int n, boolean bl, int n2) {
        CommandInfo commandInfo = (CommandInfo)this.fCommands.get(n);
        this.setCommandEnabled(n, bl);
        if (n2 != 0) {
            Integer n3 = null;
            if (commandInfo != null) {
                n3 = (Integer)this.fAccelerators.get(n2);
            }
            if (n3 == null) {
                this.fAccelerators.put(n2, (Object)new Integer(n));
            }
        }
    }

    public void removeKey(int n) {
        this.fAccelerators.remove(n);
    }

    public void addKey(int n, int n2) {
        if (n != -1) {
            this.fAccelerators.put(n, (Object)new Integer(n2));
        }
    }

    public void clearAllKeys() {
        this.fAccelerators.clear();
    }

    public int processKey(int n) {
        CommandInfo commandInfo;
        int n2 = 1;
        Integer n3 = (Integer)this.fAccelerators.get(n);
        if (n3 != null && (commandInfo = (CommandInfo)this.fCommands.get(n3.intValue())) != null) {
            n2 = 2;
            if (commandInfo.getState()) {
                this.fCurrentTarget.doCommand(n3);
                n2 = 0;
            }
        }
        return n2;
    }

    public void addCommandSource(MWCommandSource mWCommandSource, int n) {
        CommandInfo commandInfo = (CommandInfo)this.fCommands.get(n);
        if (commandInfo == null) {
            commandInfo = new CommandInfo();
            this.fCommands.put(n, (Object)commandInfo);
        }
        commandInfo.addSource(mWCommandSource);
        mWCommandSource.setCommand(n);
        mWCommandSource.setTarget(this);
        mWCommandSource.enableCommand(commandInfo.getState());
    }

    public void removeCommandSource(MWCommandSource mWCommandSource, int n) {
        mWCommandSource.setCommand(0);
        mWCommandSource.setTarget(null);
        CommandInfo commandInfo = (CommandInfo)this.fCommands.get(n);
        if (commandInfo != null) {
            commandInfo.removeSource(mWCommandSource);
        }
    }

    public boolean hasCommand(int n) {
        CommandInfo commandInfo = (CommandInfo)this.fCommands.get(n);
        return null != commandInfo;
    }

    public void setCommandEnabled(int n, boolean bl) {
        CommandInfo commandInfo = (CommandInfo)this.fCommands.get(n);
        if (commandInfo == null) {
            commandInfo = new CommandInfo(bl);
            this.fCommands.put(n, (Object)commandInfo);
        } else {
            if (this.fCurrentTarget instanceof MWCommandChain) {
                MWCommandChain mWCommandChain = (MWCommandChain)this.fCurrentTarget;
                bl = mWCommandChain.isCommandEnabled(n);
            }
            commandInfo.setState(bl);
        }
    }

    public void updateCommand(int n) {
        CommandInfo commandInfo;
        if (this.fCurrentTarget instanceof MWCommandChain && (commandInfo = (CommandInfo)this.fCommands.get(n)) != null) {
            MWCommandChain mWCommandChain = (MWCommandChain)this.fCurrentTarget;
            commandInfo.setState(mWCommandChain.isCommandEnabled(n));
        }
    }

    public boolean getCommandEnabled(int n) {
        CommandInfo commandInfo = (CommandInfo)this.fCommands.get(n);
        if (commandInfo != null) {
            if (this.fCurrentTarget instanceof MWCommandChain) {
                MWCommandChain mWCommandChain = (MWCommandChain)this.fCurrentTarget;
                return mWCommandChain.isCommandEnabled(n);
            }
            return commandInfo.getState();
        }
        return true;
    }

    public void setActive(boolean bl) {
        if (bl != this.fActive) {
            this.fActive = bl;
            Enumeration enumeration = this.fCommands.elements();
            while (enumeration.hasMoreElements()) {
                CommandInfo commandInfo = (CommandInfo)enumeration.nextElement();
                if (!commandInfo.getState()) continue;
                commandInfo.enableSources(bl);
            }
        }
    }

    public static MWCommandCenter findCommandCenter(Component component) {
        while (component != null) {
            if (component instanceof MWCommandCenterOwner) {
                return ((MWCommandCenterOwner)((Object)component)).getCommandCenter();
            }
            component = component.getParent();
        }
        return null;
    }

    private final class CommandInfo {
        private boolean fEnabled;
        private Vector fSources;

        CommandInfo() {
            this.fEnabled = true;
        }

        CommandInfo(boolean bl) {
            this.fEnabled = bl;
        }

        void setState(boolean bl) {
            if (bl != this.fEnabled) {
                this.fEnabled = bl;
                this.enableSources(bl);
            }
        }

        boolean getState() {
            return this.fEnabled;
        }

        synchronized void addSource(MWCommandSource mWCommandSource) {
            if (this.fSources == null) {
                this.fSources = new Vector(2);
            }
            this.fSources.addElement(mWCommandSource);
        }

        synchronized void removeSource(MWCommandSource mWCommandSource) {
            if (this.fSources != null) {
                this.fSources.removeElement(mWCommandSource);
                if (this.fSources.size() == 0) {
                    this.fSources = null;
                }
            }
        }

        synchronized void enableSources(boolean bl) {
            if (this.fSources != null) {
                Enumeration enumeration = this.fSources.elements();
                while (enumeration.hasMoreElements()) {
                    MWCommandSource mWCommandSource = (MWCommandSource)enumeration.nextElement();
                    mWCommandSource.enableCommand(bl);
                }
            }
        }
    }
}

