/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.dnd;

import com.mathworks.mwt.MWComponent;
import com.mathworks.mwt.MWContainer;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.dnd.DragMessage;
import com.mathworks.mwt.dnd.DropTarget;
import com.mathworks.util.Timer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class DragItem {
    public static DataFlavor STRING_FLAVOR = DataFlavor.stringFlavor;
    public static DataFlavor STRINGS_FLAVOR;
    private Component fSourceObject;
    private Rectangle fItemRect;
    private Transferable fDropItem;
    private MouseDragger fMouseTracker;

    public DragItem(Component component, Rectangle rectangle, Point point, Transferable transferable) {
        this.fSourceObject = component;
        this.fDropItem = transferable;
        this.fItemRect = new Rectangle(rectangle);
        this.fItemRect.x -= point.x;
        this.fItemRect.y -= point.y;
        if (component.isShowing()) {
            if (component instanceof MWComponent) {
                this.fMouseTracker = new MouseDragger(((MWComponent)component).getFrame());
            } else if (component instanceof MWContainer) {
                this.fMouseTracker = new MouseDragger(((MWContainer)component).getFrame());
            }
        }
        if (this.fMouseTracker != null) {
            component.addMouseListener(this.fMouseTracker);
            component.addMouseMotionListener(this.fMouseTracker);
        }
    }

    public void setDragVisible(boolean bl) {
        this.fMouseTracker.setDragVisible(bl);
    }

    public void startDrag() {
        this.fMouseTracker.startDrag();
    }

    public void paintDragOutline() {
        this.fMouseTracker.paintDragOutline();
    }

    public void paintActiveRect() {
        this.fMouseTracker.paintActiveRect();
    }

    public static void main(String[] stringArray) {
        MWFrame mWFrame = new MWFrame("Drag test");
        mWFrame.setSize(400, 300);
        DragTester dragTester = new DragTester();
        mWFrame.add((Component)dragTester, "West");
        DropTester dropTester = new DropTester();
        mWFrame.add((Component)dropTester, "East");
        dropTester = new DropTester();
        mWFrame.add((Component)dropTester, "Center");
        mWFrame.setVisible(true);
    }

    static {
        try {
            STRINGS_FLAVOR = new DataFlavor(Class.forName("[Ljava.lang.String;"), "Array of String");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class DragTester
    extends MWComponent
    implements MouseListener {
        private String fDrawString = "Hi there!";
        private Rectangle fTestRect = new Rectangle(20, 80, 60, 20);

        public DragTester() {
            this.addMouseListener(this);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(100, 100);
        }

        @Override
        public void paint(Graphics graphics) {
            Rectangle rectangle = this.getBounds();
            rectangle.y = 0;
            rectangle.x = 0;
            graphics.setColor(Color.pink);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(Color.black);
            graphics.drawString(this.fDrawString, this.fTestRect.x + 4, this.fTestRect.y + this.fTestRect.height - 6);
            graphics.drawRect(this.fTestRect.x, this.fTestRect.y, this.fTestRect.width, this.fTestRect.height);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (this.fTestRect.contains(mouseEvent.getPoint())) {
                StringSelection stringSelection = new StringSelection(this.fDrawString);
                new DragItem(this, this.fTestRect, mouseEvent.getPoint(), stringSelection);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    static class DropTester
    extends MWComponent
    implements DropTarget {
        private String fDrawString = "Pre-drop";
        private boolean fInside = false;
        private Rectangle fTestRect = new Rectangle(20, 80, 60, 20);

        DropTester() {
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(100, 100);
        }

        @Override
        public void paint(Graphics graphics) {
            Rectangle rectangle = this.getBounds();
            rectangle.y = 0;
            rectangle.x = 0;
            if (this.fInside) {
                graphics.setColor(Color.green);
            } else {
                graphics.setColor(Color.orange);
            }
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(Color.black);
            graphics.drawString(this.fDrawString, this.fTestRect.x + 4, this.fTestRect.y + this.fTestRect.height - 6);
            graphics.drawRect(this.fTestRect.x, this.fTestRect.y, this.fTestRect.width, this.fTestRect.height);
        }

        @Override
        public boolean willReceiveDrag(Transferable transferable, MouseEvent mouseEvent, Rectangle rectangle) {
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor) && this.fTestRect.contains(mouseEvent.getPoint())) {
                rectangle.setBounds(this.fTestRect);
                return true;
            }
            return false;
        }

        @Override
        public void receiveDrop(Transferable transferable) {
            try {
                this.fDrawString = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.fInside = false;
                this.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void trackDrag(DragMessage dragMessage) {
            if (dragMessage.getMessageType() == 1) {
                this.fInside = true;
                this.repaint();
            } else if (dragMessage.getMessageType() == 3) {
                this.fInside = false;
                this.repaint();
            }
        }
    }

    class MouseDragger
    extends MouseAdapter
    implements MouseMotionListener,
    ActionListener {
        private Frame fRame;
        private Graphics fRameGraphics;
        private Component fCurrentComponent;
        private Point fCurrentPoint;
        private Point fStartPoint;
        private Point fOffset;
        private int fXOffset;
        private int fYOffset;
        private boolean fOutlineVisible;
        private boolean fRectVisible;
        private boolean fDoingDrag;
        private Timer fTimer;
        private Rectangle fActiveRect;
        private Rectangle fTempRect;
        private DragMessage fDragMessage;
        private double fIncX;
        private double fCurrentX;
        private double fSlope;
        private double fYIntercept;
        private final double STEP_SIZE = 5.0;

        public MouseDragger(Frame frame) {
            this.fRame = frame;
            this.createFrameGraphics();
            this.fCurrentPoint = new Point(-1, -1);
            this.fStartPoint = new Point(-1, -1);
            this.fActiveRect = new Rectangle();
            this.fTempRect = new Rectangle();
            Point point = new Point(0, 0);
            point = MWUtils.mapFromComponentToComponent(point, DragItem.this.fSourceObject, (Component)this.fRame);
            this.fXOffset = point.x;
            this.fYOffset = point.y;
            this.fOutlineVisible = false;
            this.fRectVisible = false;
            this.fDoingDrag = false;
        }

        private void createFrameGraphics() {
            this.fRameGraphics = this.fRame.getGraphics();
            this.fRameGraphics.setColor(Color.white);
            this.fRameGraphics.setXORMode(Color.gray);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            boolean bl = false;
            if (this.fDoingDrag) {
                this.setDragVisible(false);
                mouseEvent.translatePoint(this.fXOffset, this.fYOffset);
                Component component = this.getDropTargetAt(this.fRame, mouseEvent, this.fTempRect);
                if (component != null) {
                    ((DropTarget)((Object)component)).receiveDrop(DragItem.this.fDropItem);
                    component.requestFocus();
                    bl = true;
                }
                if (!bl) {
                    this.whizBack();
                }
                if (this.fRame instanceof MWFrame) {
                    ((MWFrame)this.fRame).stopDrag();
                }
            }
            DragItem.this.fSourceObject.removeMouseListener(this);
            DragItem.this.fSourceObject.removeMouseMotionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setDragOutlineVisible(false);
            if ((double)Math.abs(this.fCurrentPoint.x - this.fStartPoint.x) > 5.0 || (double)Math.abs(this.fCurrentPoint.y - this.fStartPoint.y) > 5.0) {
                this.fCurrentX += this.fIncX;
                this.fCurrentPoint.x = (int)this.fCurrentX;
                this.fCurrentPoint.y = (int)(this.fSlope * this.fCurrentX + this.fYIntercept);
                this.setDragOutlineVisible(true);
            } else {
                this.fTimer.stop();
            }
        }

        private void whizBack() {
            this.fStartPoint.x += this.fXOffset;
            this.fStartPoint.y += this.fYOffset;
            if (this.fStartPoint.x == this.fCurrentPoint.x) {
                this.fStartPoint.x += 3;
            }
            this.fSlope = (float)(this.fCurrentPoint.y - this.fStartPoint.y) / (float)(this.fCurrentPoint.x - this.fStartPoint.x);
            this.fYIntercept = (double)this.fCurrentPoint.y - this.fSlope * (double)this.fCurrentPoint.x;
            this.fIncX = (double)(this.fStartPoint.x - this.fCurrentPoint.x) / 5.0;
            this.fCurrentX = this.fCurrentPoint.x;
            do {
                this.setDragOutlineVisible(false);
                this.fCurrentX += this.fIncX;
                this.fCurrentPoint.x = (int)this.fCurrentX;
                this.fCurrentPoint.y = (int)(this.fSlope * this.fCurrentX + this.fYIntercept);
                this.setDragOutlineVisible(true);
                long l = System.currentTimeMillis();
                long l2 = l + 50L;
                while (l < l2) {
                    l = System.currentTimeMillis();
                }
            } while ((double)Math.abs(this.fCurrentPoint.x - this.fStartPoint.x) > 5.0 || (double)Math.abs(this.fCurrentPoint.y - this.fStartPoint.y) > 5.0);
            this.setDragOutlineVisible(false);
        }

        private void exitCurrentComponent(MouseEvent mouseEvent) {
            if (this.fCurrentComponent != null) {
                DragMessage dragMessage = new DragMessage(3, DragItem.this.fDropItem, mouseEvent, DragItem.this.fSourceObject);
                ((DropTarget)((Object)this.fCurrentComponent)).trackDrag(dragMessage);
            }
            this.fCurrentComponent = null;
        }

        protected void drawDragOutline(Point point) {
            if (this.fRameGraphics == null) {
                this.createFrameGraphics();
            }
            this.fRameGraphics.drawRect(((DragItem)DragItem.this).fItemRect.x + point.x, ((DragItem)DragItem.this).fItemRect.y + point.y, ((DragItem)DragItem.this).fItemRect.width, ((DragItem)DragItem.this).fItemRect.height);
            Toolkit.getDefaultToolkit().sync();
        }

        protected void paintDragOutline() {
            if (this.fOutlineVisible) {
                this.drawDragOutline(this.fCurrentPoint);
            }
        }

        private void drawActiveRect() {
            if (!this.fActiveRect.isEmpty()) {
                if (this.fRameGraphics == null) {
                    this.createFrameGraphics();
                }
                this.fRameGraphics.drawRect(this.fActiveRect.x + 1, this.fActiveRect.y + 1, this.fActiveRect.width - 2, this.fActiveRect.height - 2);
                this.fRameGraphics.drawRect(this.fActiveRect.x + 2, this.fActiveRect.y + 2, this.fActiveRect.width - 4, this.fActiveRect.height - 4);
                Toolkit.getDefaultToolkit().sync();
            }
        }

        protected void paintActiveRect() {
            if (this.fRectVisible && this.fCurrentComponent != DragItem.this.fSourceObject) {
                this.drawActiveRect();
            }
        }

        private void setDragOutlineVisible(boolean bl) {
            if (this.fOutlineVisible != bl) {
                this.drawDragOutline(this.fCurrentPoint);
                this.fOutlineVisible = bl;
            }
        }

        private void setActiveRectVisible(boolean bl) {
            if (this.fRectVisible != bl && this.fCurrentComponent != DragItem.this.fSourceObject) {
                this.drawActiveRect();
                this.fRectVisible = bl;
            }
        }

        public void setDragVisible(boolean bl) {
            this.setDragOutlineVisible(bl);
            this.setActiveRectVisible(bl);
        }

        public Component getDropTargetAt(Container container, MouseEvent mouseEvent, Rectangle rectangle) {
            int n = container.getComponentCount();
            Component[] componentArray = container.getComponents();
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            rectangle.setBounds(0, 0, 0, 0);
            if (container == null || !container.contains(mouseEvent.getX(), mouseEvent.getY())) {
                return null;
            }
            for (int i = 0; i < n; ++i) {
                Component component = componentArray[i];
                if (component == null || !component.isVisible()) continue;
                point.setLocation(mouseEvent.getX(), mouseEvent.getY());
                Rectangle rectangle2 = component.getBounds();
                point.translate(-rectangle2.x, -rectangle2.y);
                if (!component.contains(point)) continue;
                MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), 506, mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                if (component instanceof DropTarget && ((DropTarget)((Object)component)).willReceiveDrag(DragItem.this.fDropItem, mouseEvent2, rectangle)) {
                    return component;
                }
                if (!(component instanceof Container) || !component.isVisible()) continue;
                return this.getDropTargetAt((Container)component, mouseEvent2, rectangle);
            }
            return null;
        }

        public void startDrag() {
            this.fDoingDrag = true;
            if (this.fRame instanceof MWFrame) {
                ((MWFrame)this.fRame).startDrag(DragItem.this);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.fStartPoint.x == -1) {
                this.fStartPoint.x = mouseEvent.getX();
                this.fStartPoint.y = mouseEvent.getY();
                this.fOffset = new Point();
            }
            if (!this.fDoingDrag) {
                if (Math.abs(this.fStartPoint.x - mouseEvent.getX()) > 2 || Math.abs(this.fStartPoint.y - mouseEvent.getY()) > 2) {
                    this.startDrag();
                } else {
                    return;
                }
            }
            this.setDragOutlineVisible(false);
            this.fCurrentPoint.x = mouseEvent.getX() + this.fXOffset;
            this.fCurrentPoint.y = mouseEvent.getY() + this.fYOffset;
            if (!this.fActiveRect.isEmpty() && this.fActiveRect.contains(mouseEvent.getPoint())) {
                if (this.fCurrentComponent == DragItem.this.fSourceObject) {
                    this.fDragMessage.setMouseEvent(mouseEvent);
                    ((DropTarget)((Object)this.fCurrentComponent)).trackDrag(this.fDragMessage);
                }
                this.setDragOutlineVisible(true);
                return;
            }
            MouseEvent mouseEvent2 = new MouseEvent((Component)mouseEvent.getSource(), 506, mouseEvent.getWhen(), mouseEvent.getModifiers(), this.fCurrentPoint.x, this.fCurrentPoint.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            Component component = this.getDropTargetAt(this.fRame, mouseEvent2, this.fTempRect);
            if (!this.fTempRect.isEmpty() && component != null) {
                this.fActiveRect.setBounds(this.fTempRect);
                MWUtils.mapFromComponentToComponent(this.fActiveRect, component, (Component)this.fRame);
                if (component != DragItem.this.fSourceObject) {
                    this.setActiveRectVisible(true);
                }
            } else {
                this.setActiveRectVisible(false);
                this.fActiveRect.setBounds(0, 0, 0, 0);
                this.fTempRect.setBounds(0, 0, 0, 0);
            }
            if (component != null) {
                if (this.fCurrentComponent != component) {
                    this.fOffset = new Point(this.fXOffset, this.fYOffset);
                    MWUtils.mapFromComponentToComponent(this.fOffset, (Component)this.fRame, component);
                    mouseEvent.translatePoint(this.fOffset.x, this.fOffset.y);
                    this.exitCurrentComponent(mouseEvent);
                    DragMessage dragMessage = new DragMessage(1, DragItem.this.fDropItem, mouseEvent, DragItem.this.fSourceObject);
                    ((DropTarget)((Object)component)).trackDrag(dragMessage);
                    this.fCurrentComponent = component;
                    if (component == DragItem.this.fSourceObject) {
                        this.fDragMessage = new DragMessage(2, DragItem.this.fDropItem, mouseEvent, DragItem.this.fSourceObject);
                    }
                } else {
                    mouseEvent.translatePoint(this.fOffset.x, this.fOffset.y);
                    DragMessage dragMessage = new DragMessage(2, DragItem.this.fDropItem, mouseEvent, DragItem.this.fSourceObject);
                    ((DropTarget)((Object)component)).trackDrag(dragMessage);
                }
            } else {
                mouseEvent.translatePoint(this.fOffset.x, this.fOffset.y);
                this.exitCurrentComponent(mouseEvent);
            }
            mouseEvent.translatePoint(-this.fOffset.x, -this.fOffset.y);
            this.setDragOutlineVisible(true);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

