/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.text;

import com.mathworks.mwt.text.MWTextEvent;

class TextInsEvent
extends MWTextEvent {
    private String fText = "";
    private int fMinPos;
    private int fMaxPos = -1;
    private int fLength;
    private int fMinLine = -1;
    private int fMaxLine = -1;

    public TextInsEvent(Object object, int n, int n2) {
        super(object, 1);
        this.fMinPos = n;
        this.fLength = n2;
    }

    void initEvent(int n, int n2) {
        this.fMinPos = n;
        this.fLength = n2;
        this.fMaxPos = -1;
        this.fMinLine = -1;
        this.fMaxLine = -1;
    }

    @Override
    public String getCommandID() {
        throw new IllegalArgumentException("Can't call getCommandID() for insertion event");
    }

    @Override
    public String getText() {
        if (this.fText.length() == 0) {
            this.fText = this.getModel().getText(this.getMinPos(), this.getMaxPos());
        }
        return this.fText;
    }

    @Override
    public int getMinPos() {
        return this.fMinPos;
    }

    @Override
    public int getMaxPos() {
        if (this.fMaxPos == -1) {
            this.fMaxPos = this.getMinPos() + this.getLength();
        }
        return this.fMaxPos;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public int getMinLine() {
        if (this.fMinLine == -1) {
            this.fMinLine = this.getModel().lineFromPos(this.getMinPos());
        }
        return this.fMinLine;
    }

    @Override
    public int getMaxLine() {
        if (this.fMaxLine == -1) {
            this.fMaxLine = this.getModel().lineFromPos(this.getMaxPos());
        }
        return this.fMaxLine;
    }

    @Override
    public boolean isLeftToRight() {
        return true;
    }
}

