/*
 * Decompiled with CFR 0.152.
 */
package javax.bluetooth;

import com.intel.bluetooth.Utils;

public class UUID {
    private byte[] uuidValue;

    public UUID(long uuidValue) {
        this(Utils.toHexString(uuidValue), true);
        if (uuidValue < 0L || uuidValue > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("uuidValue is not in the range [0, 2^32 -1]");
        }
    }

    public UUID(String uuidValue, boolean shortUUID) {
        if (uuidValue == null) {
            throw new NullPointerException("uuidValue is null");
        }
        int length = uuidValue.length();
        if (shortUUID) {
            if (length < 1 || length > 8) {
                throw new IllegalArgumentException();
            }
            this.uuidValue = Utils.UUIDToByteArray("00000000".substring(length) + uuidValue + "00001000800000805F9B34FB");
        } else {
            if (length < 1 || length > 32) {
                throw new IllegalArgumentException();
            }
            this.uuidValue = Utils.UUIDToByteArray("00000000000000000000000000000000".substring(length) + uuidValue);
        }
    }

    public String toString() {
        return Utils.UUIDByteArrayToString(this.uuidValue);
    }

    public boolean equals(Object value) {
        if (value == null || !(value instanceof UUID)) {
            return false;
        }
        for (int i = 0; i < 16; ++i) {
            if (this.uuidValue[i] == ((UUID)value).uuidValue[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.uuidValue[12] << 24 & 0xFF000000 | this.uuidValue[13] << 16 & 0xFF0000 | this.uuidValue[14] << 8 & 0xFF00 | this.uuidValue[15] & 0xFF;
    }
}

