/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdhist;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.mde.cmdhist.AltHistoryCollection;
import com.mathworks.mde.cmdhist.AltHistoryIcon;
import com.mathworks.mde.cmdhist.AltHistoryTable;
import com.mathworks.mde.cmdhist.CmdHistoryPrefs;
import com.mathworks.mde.cmdhist.CmdHistoryPrinter;
import com.mathworks.mde.cmdhist.CommandStyleInfo;
import com.mathworks.mde.cmdwin.CmdWin;
import com.mathworks.mde.cmdwin.CmdWinDocument;
import com.mathworks.mde.cmdwin.CmdWinEditorKit;
import com.mathworks.mde.cmdwin.XCmdWndView;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlwidgets.shortcuts.ShortcutEditor;
import com.mathworks.mlwidgets.shortcuts.ShortcutUtils;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJLayeredPane;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJRadioButtonMenuItem;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.FontListener;
import com.mathworks.services.FontPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.toolstrip.factory.ContextTargetingManager;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.WindowsWidgetFactory;
import com.mathworks.widgets.action.AbstractCopyAction;
import com.mathworks.widgets.action.AbstractCutAction;
import com.mathworks.widgets.action.AbstractPageSetupAction;
import com.mathworks.widgets.action.AbstractPrintAction;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTClientProperty;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.desk.DTOnTopWindow;
import com.mathworks.widgets.desk.DTProperty;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.messagepanel.AbstractMessageModel;
import com.mathworks.widgets.messagepanel.DefaultMessage;
import com.mathworks.widgets.messagepanel.DefaultMessageModel;
import com.mathworks.widgets.messagepanel.MessageModel;
import com.mathworks.widgets.messagepanel.MessagePanel;
import com.mathworks.widgets.messagepanel.MessagePanelListener;
import com.mathworks.widgets.messagepanel.MessagePanelPainter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.apache.commons.io.FileUtils;

public class AltHistory
extends DTClientBase {
    static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mde.cmdhist.resources.RES_CmdHist");
    private final AltHistoryCollection fCollection;
    private final List<RecallListener> fRecallListeners = new ArrayList<RecallListener>();
    private final ListSelectionModel fRecallModel = new DefaultListSelectionModel();
    private final AltHistoryTable fTable;
    private final JScrollPane fScroller;
    private final JLabel fEmptyLabel;
    private JComponent fBackupDialogPane;
    private final JComponent fAlignmentPanel;
    private final FocusListener fFocusAppearanceUpdater = new FocusAppearanceUpdater();
    private PopupVisibilityListener fPopupVisibilityListener;
    private AbstractMessageModel fMatchIndicatorModel;
    private MessagePanel fMatchIndicatorBar;
    private JComponent fMatchToolBar;
    private JButton fCancelFindButton;
    private JButton fToolBarActionsButton;
    private JButton fUpperRightActionsButton;
    private MJTextField fMatchTextField;
    private boolean fIsTemporaryFind;
    private boolean fFilterMatches = CmdHistoryPrefs.getFilterMatches();
    private String fTextToMatch;
    private int fLastComputedHeight;
    private int fLastComputedWidth;
    private boolean fClientOpened;
    private boolean fPopupShown;
    private boolean fMatchUpdatePending;
    private boolean fBlockReset;
    private boolean fIsEvaluatingSelection;
    private Runnable fPendingSelectionNotification;
    private final MJAbstractAction fCutAction = new CutAction();
    private final MJAbstractAction fCopyAction = new CopyAction();
    private final MJAbstractAction fUndoAction = new UndoAction();
    private final MJAbstractAction fSelectAllAction = new SelectAllAction();
    private final MJAbstractAction fFindAction = new FindAction();
    private final MJAbstractAction fInsertTimeStampAction = new InsertTimeStampAction();
    private final MJAbstractAction fDeleteAction = new DeleteAction();
    private final MJAbstractAction fClearAction = new ClearAction();
    private final MJAbstractAction fPrintAction = new PrintAction();
    private final MJAbstractAction fPrintSelectionAction = new PrintSelectionAction();
    private final MJAbstractAction fPageSetupAction = new PageSetupAction();
    private final MJAbstractAction fEvaluateAction = new EvaluateAction();
    private final MJAbstractAction fCopyToPromptAction = new CopyToPromptAction();
    private final MJAbstractAction fCreateMFileAction = new CreateMFileAction();
    private final MJAbstractAction fCreateShortcutAction = new CreateShortcutAction();
    private final MJAbstractAction fMatchAnywhereAction = new MatchAnywhereAction();
    private final MJAbstractAction fMatchBeginningAction = new MatchBeginningAction();
    private final MJAbstractAction fMatchCaseAction = new MatchCaseAction();
    private final MJAbstractAction fFilterMatchesAction = new FilterMatchesAction();
    private final MJAbstractAction fShowExecutionTimeAction = new ShowExecutionTimeAction();
    private final MJAbstractAction fShowMatchToolBarAction = new ShowMatchToolBarAction();
    private final MJAbstractAction fShowMatchIndicatorBarAction = new ShowMatchIndicatorBarAction();
    private final MJAbstractAction fPreviousMatchAction = new PreviousMatchAction();
    private final MJAbstractAction fNextMatchAction = new NextMatchAction();
    private final MJAbstractAction fExtendToPreviousMatchAction = new ExtendToPreviousMatchAction();
    private final MJAbstractAction fExtendToNextMatchAction = new ExtendToNextMatchAction();
    private final MJAbstractAction fCancelFindAction = new CancelFindAction();
    private final MJAbstractAction fDockAction = new DockAction();
    private final MJAbstractAction fCloseAction = new CloseAction();
    static final String TITLE = sRes.getString("title");
    static final String CLIENT_NAME = "Command History";
    private static final String PREF_ROOT = "AltHistory";
    private static final String POPUP_HEIGHT_KEY = "PopupHeight";
    private static final String POPUP_WIDTH_KEY = "PopupWidth";
    private static final String MULTI_SELECT_KEY = "MultiSelectDotDotDot";
    private static final int SCREEN_TOP_MARGIN = 10;
    private static final int DEFAULT_POPUP_HEIGHT = 250;
    private static final int DEFAULT_POPUP_WIDTH = 400;
    private static final int CONSTRAINED_POPUP_HEIGHT = 200;
    private static final int MINIMUM_POPUP_HEIGHT = 60;
    private static final int MINIMUM_POPUP_WIDTH = 200;
    private static final Color UNDOCKED_BACKGROUND_COLOR = new Color(250, 250, 250);
    private static final Color ANCHORED_SELECTION_BACKGROUND = new Color(230, 230, 230);
    private static final Color TOOL_BAR_BACKGROUND_COLOR = UIManager.getColor("control");
    private static final Color INDICATOR_BAR_BACKGROUND_COLOR = new Color(192, 192, 192);
    private static final int MODIFIER_MASK = 46;
    private static final String FORWARD_FROM_COMMAND_WINDOW = "forward-from-command-window";
    private static final String FORWARD_EVEN_IF_NOT_SHOWING = "forward-even-if-not-showing";
    private static AltHistory sInstance = null;
    private static final Paint MESSAGE_PAINT = new GradientPaint(0.0f, 0.0f, CommandStyleInfo.HIGHLIGHT_BACKGROUND, 15.0f, 15.0f, CommandStyleInfo.HIGHLIGHT_BACKGROUND);
    private static final Paint MESSAGES_PAINT = new GradientPaint(0.0f, 0.0f, ColorUtils.mixColors((Color)CommandStyleInfo.HIGHLIGHT_BACKGROUND, (Color)Color.white, (float)0.5f), 15.0f, 15.0f, ColorUtils.darker((Color)CommandStyleInfo.HIGHLIGHT_BACKGROUND, (double)0.9f));
    private static final Paint NO_MESSAGES_PAINT = new GradientPaint(0.0f, 0.0f, Color.WHITE, 15.0f, 15.0f, new Color(192, 192, 192));

    public static boolean showDotDotDotForMultiSelect() {
        return AltHistory.showDotDotDotForMultiSelectWhenAnchored() && AltHistory.getInstance().isAnchored();
    }

    public static boolean showDotDotDotForMultiSelectWhenAnchored() {
        return Prefs.getBooleanPref((String)"AltHistoryMultiSelectDotDotDot", (boolean)false);
    }

    public static AltHistory getInstance() {
        if (sInstance == null) {
            sInstance = new AltHistory();
        }
        return sInstance;
    }

    private static boolean hasInstance() {
        return sInstance != null;
    }

    public static void addCommands(final List<String> list) {
        if (EventQueue.isDispatchThread()) {
            if (AltHistory.getInstance().isAnchored()) {
                AltHistory.getInstance().setTextToMatch(null);
            }
            AltHistory.getInstance().fCollection.addCommands(list);
            AltHistory.getInstance().updateUndoAction();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AltHistory.addCommands(list);
                }
            });
        }
    }

    public static void recordCompletion() {
        final long l = System.currentTimeMillis();
        if (EventQueue.isDispatchThread()) {
            if (AltHistory.hasInstance()) {
                AltHistory.getInstance().fCollection.recordCompletion(l);
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AltHistory.getInstance().fCollection.recordCompletion(l);
                }
            });
        }
    }

    public static void recordContinuation() {
        if (EventQueue.isDispatchThread()) {
            if (AltHistory.hasInstance()) {
                AltHistory.getInstance().fCollection.recordContinuation();
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AltHistory.getInstance().fCollection.recordContinuation();
                }
            });
        }
    }

    public static void recordError(final String string) {
        if (EventQueue.isDispatchThread()) {
            if (AltHistory.hasInstance()) {
                AltHistory.getInstance().fCollection.recordError(string);
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AltHistory.getInstance().fCollection.recordError(string);
                }
            });
        }
    }

    public static String recallPrevious(String string, boolean bl) {
        AltHistory.getInstance()._recallPrevious(AltHistory.getInstance().getTextToMatch(string), bl);
        String[] stringArray = AltHistory.getRecalledCommands();
        return stringArray.length == 0 ? null : stringArray[0];
    }

    public static String recallNext(String string, boolean bl) {
        AltHistory.getInstance()._recallNext(AltHistory.getInstance().getTextToMatch(string), bl);
        String[] stringArray = AltHistory.getRecalledCommands();
        return stringArray.length == 0 ? null : stringArray[0];
    }

    private String getTextToMatch(String string) {
        if (this.isAnchored() && this.fTextToMatch != null) {
            string = this.fTextToMatch;
        }
        return string;
    }

    public static String[] getRecalledCommands() {
        ListSelectionModel listSelectionModel = AltHistory.getInstance().getActiveRecallModel();
        if (listSelectionModel.isSelectionEmpty()) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = Math.min(listSelectionModel.getMaxSelectionIndex(), AltHistory.getInstance().fTable.getRowCount() - 1);
        for (int i = listSelectionModel.getMinSelectionIndex(); i <= n; ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            arrayList.add(AltHistory.getInstance().fTable.getCommand(i));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static int getRecalledCount() {
        ListSelectionModel listSelectionModel = AltHistory.getInstance().getActiveRecallModel();
        if (listSelectionModel.isSelectionEmpty()) {
            return 0;
        }
        int n = 0;
        for (int i = listSelectionModel.getMinSelectionIndex(); i <= listSelectionModel.getMaxSelectionIndex(); ++i) {
            ++n;
        }
        return n;
    }

    public static void resetRecall() {
        AltHistory.getInstance().getActiveRecallModel().clearSelection();
        if (AltHistory.getInstance().isAnchored() && !AltHistory.getInstance().fBlockReset) {
            AltHistory.getInstance().hidePopup();
            AltHistory.getInstance().setTextToMatch(null);
            AltHistory.getInstance().hideEmptyLabel();
        }
    }

    public static void addRecallListener(RecallListener recallListener) {
        AltHistory.getInstance().fRecallListeners.add(recallListener);
    }

    public static void removeRecallListener(RecallListener recallListener) {
        AltHistory.getInstance().fRecallListeners.remove(recallListener);
    }

    public static String[] getAllCommands() {
        return AltHistory.getInstance().fCollection.getAllCommands();
    }

    public static String[] getSessionCommands() {
        return AltHistory.getInstance().fCollection.getSessionCommands();
    }

    public static void clear() {
        if (EventQueue.isDispatchThread()) {
            AltHistory.getInstance().fTable.clearSelection();
            AltHistory.getInstance().fCollection.clear();
            AltHistory.getInstance().fCollection.addTimeStamp();
            AltHistory.getInstance().updateUndoAction();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AltHistory.clear();
                }
            });
        }
    }

    public static void save() {
        if (EventQueue.isDispatchThread()) {
            if (AltHistory.hasInstance()) {
                AltHistory.getInstance().fCollection.flushSave();
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AltHistory.save();
                }
            });
        }
    }

    public static void save(final File file) {
        if (EventQueue.isDispatchThread()) {
            AltHistory.getInstance().fCollection.saveCommands(file);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AltHistory.save(file);
                }
            });
        }
    }

    public static void load(final File file, final boolean bl) {
        if (EventQueue.isDispatchThread()) {
            AltHistory.getInstance().fCollection.recallCommands(file, bl);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AltHistory.load(file, bl);
                }
            });
        }
    }

    public static boolean isPopupShowing() {
        return AltHistory.getInstance()._isPopupShowing();
    }

    public static void showPopup() {
        AltHistory.getInstance()._showPopup();
    }

    public static boolean willShowAsPopup() {
        return AltHistory.getInstance().isAnchored();
    }

    public static boolean isEvaluatingRecalledCommands() {
        return AltHistory.getInstance()._isEvaluatingRecalledCommands();
    }

    public static void invokeTableAction(String string) {
        AltHistoryTable altHistoryTable = AltHistory.getInstance().fTable;
        Action action = ((JComponent)((Object)altHistoryTable)).getActionMap().get(string);
        if (action != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent((Object)altHistoryTable, 1001, string));
        }
    }

    private AltHistory() {
        this.setName(CLIENT_NAME);
        this.setLayout(new BorderLayout());
        this.fCollection = new AltHistoryCollection();
        File file = new File(com.mathworks.util.FileUtils.getPreferencesDirectory(), "History.xml");
        File file2 = new File(com.mathworks.util.FileUtils.getPreferencesDirectory(), "History.bak");
        if (file.exists()) {
            if (this.fCollection.recallCommands(file, false)) {
                if (!this.fCollection.isEmpty()) {
                    if (file2.exists()) {
                        file2.delete();
                    }
                    try {
                        FileUtils.copyFile((File)file, (File)file2);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.fCollection.isFull()) {
                    this.fCollection.initiateSaveAll();
                }
            } else if (file2.exists()) {
                this.fBackupDialogPane = this.createBackupDialogPane();
            } else {
                this.fCollection.initiateSaveAll();
            }
        }
        if (this.fBackupDialogPane == null) {
            this.fCollection.addTimeStamp();
        }
        this.fRecallModel.setSelectionMode(1);
        this.fTable = new AltHistoryTable(this.fCollection){

            @Override
            public Color getOverridableSelectionBackground() {
                if (AltHistory.this.isAnchored()) {
                    if (UNDOCKED_BACKGROUND_COLOR.equals(this.getBackground())) {
                        return ANCHORED_SELECTION_BACKGROUND;
                    }
                    return ColorUtils.mixColors((Color)this.getBackground(), (Color)this.getForeground(), (float)0.75f);
                }
                return super.getOverridableSelectionBackground();
            }

            @Override
            public Color getOverridableSelectionForeground() {
                return AltHistory.this.isAnchored() ? this.getForeground() : super.getOverridableSelectionForeground();
            }
        };
        this.fScroller = new MJScrollPane((Component)((Object)this.fTable), 20, 31);
        this.fScroller.setBorder(BorderFactory.createEmptyBorder());
        this.fEmptyLabel = new MJLabel();
        this.fEmptyLabel.setFont(this.fEmptyLabel.getFont().deriveFont(2));
        if (this.fTable.getRowCount() == 0) {
            this.showEmptyLabel(false);
        } else {
            this.fEmptyLabel.setVisible(false);
        }
        this.fAlignmentPanel = new AlignmentPanel();
        this.add(this.fAlignmentPanel, "Center");
        PreferenceListener preferenceListener = new PreferenceListener();
        ColorPrefs.addColorListener((String)"ColorsText", (PrefListener)preferenceListener);
        ColorPrefs.addColorListener((String)"ColorsBackground", (PrefListener)preferenceListener);
        this.setFont(FontPrefs.getFontForComponent((String)TITLE));
        FontPrefs.addFontListener((String)TITLE, (FontListener)preferenceListener);
        LocalMouseListener localMouseListener = new LocalMouseListener();
        this.fTable.addMouseListener(localMouseListener);
        this.fScroller.getViewport().addMouseListener(localMouseListener);
        this.fAlignmentPanel.addMouseListener(localMouseListener);
        this.fTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                AltHistory.this.updateSelectionDependentActions();
            }
        });
        final TableModelListener tableModelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getType() == 1 && !AltHistory.this.fIsEvaluatingSelection) {
                    AltHistory.this.fTable.scrollToBottom();
                }
                AltHistory.this.fUndoAction.setEnabled(AltHistory.this.fTable.anythingToUndo());
                AltHistory.this.updateMatchIndicatorBar();
            }
        };
        this.fTable.getModel().addTableModelListener(tableModelListener);
        this.fTable.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TableModel tableModel = (TableModel)propertyChangeEvent.getOldValue();
                tableModel.removeTableModelListener(tableModelListener);
                TableModel tableModel2 = (TableModel)propertyChangeEvent.getNewValue();
                tableModel2.addTableModelListener(tableModelListener);
                AltHistory.this.fUndoAction.setEnabled(AltHistory.this.fTable.anythingToUndo());
                AltHistory.this.updateMatchIndicatorBar();
            }
        });
        this.fTable.setSelectionAppearanceReflectsFocus(false);
        this.fTable.addFocusListener(this.fFocusAppearanceUpdater);
        this.fTable.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AltHistory.this.toFront();
            }
        });
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(final ListSelectionEvent listSelectionEvent) {
                if (AltHistory.this.fPendingSelectionNotification == null) {
                    AltHistory.this.fPendingSelectionNotification = new Runnable(){

                        @Override
                        public void run() {
                            if (listSelectionEvent.getSource() == AltHistory.this.getActiveRecallModel()) {
                                String[] stringArray = AltHistory.getRecalledCommands();
                                for (RecallListener recallListener : AltHistory.this.fRecallListeners) {
                                    recallListener.commandRecalled(stringArray);
                                }
                            }
                            AltHistory.this.fPendingSelectionNotification = null;
                        }
                    };
                    EventQueue.invokeLater(AltHistory.this.fPendingSelectionNotification);
                }
            }
        };
        this.fRecallModel.addListSelectionListener(listSelectionListener);
        this.fTable.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                Window window = SwingUtilities.windowForComponent((Component)((Object)AltHistory.this));
                if (AltHistory.this.fPopupVisibilityListener == null) {
                    if (window instanceof JWindow) {
                        AltHistory.this.fPopupVisibilityListener = new PopupVisibilityListener(window);
                    }
                } else if (!(window instanceof JWindow)) {
                    AltHistory.this.fPopupVisibilityListener.dispose();
                    AltHistory.this.fPopupVisibilityListener = null;
                } else if (window != AltHistory.this.fPopupVisibilityListener.iWindow) {
                    AltHistory.this.fPopupVisibilityListener.dispose();
                    AltHistory.this.fPopupVisibilityListener = new PopupVisibilityListener(window);
                }
            }
        });
        this.setClientName(CLIENT_NAME);
        this.setOnTopWhenUndocked(true);
        this.putClientProperty(DTProperty.ON_TOP_EVEN_IF_MAC, true);
        this.setDockableTearOff(true);
        this.setContextActions(new Action[]{this.fCutAction, this.fCopyAction, this.fDeleteAction, this.fSelectAllAction, this.fPrintAction, this.fPrintSelectionAction, this.fPageSetupAction});
        this.initKeyBindings();
    }

    protected void setParentDesktop(Desktop desktop) {
        super.setParentDesktop(desktop);
        if (desktop != null) {
            this.updateColors();
            boolean bl = desktop.isClientDocked((Component)((Object)this)) ? CmdHistoryPrefs.getShowExecutionTimeWhenDocked() : CmdHistoryPrefs.getShowExecutionTime();
            this.fTable.setTimeColumnVisible(bl);
            this.fShowExecutionTimeAction.setSelected(bl);
            boolean bl2 = desktop.isClientDocked((Component)((Object)this)) ? CmdHistoryPrefs.getShowMatchBarWhenDocked() : CmdHistoryPrefs.getShowMatchToolBar();
            this.fShowMatchToolBarAction.setSelected(bl2);
            desktop.addClientListener((Component)((Object)this), (DTClientListener)new HistoryClientListener());
            desktop.addClientListener("Command Window", (DTClientListener)new CommandWindowClientListener());
        }
    }

    private JMenu createTitleBarMenu() {
        MJMenu mJMenu = new MJMenu();
        mJMenu.add((Action)this.fFindAction);
        mJMenu.add((JMenuItem)new MJRadioButtonMenuItem((Action)this.fMatchAnywhereAction));
        mJMenu.add((JMenuItem)new MJRadioButtonMenuItem((Action)this.fMatchBeginningAction));
        mJMenu.add((JMenuItem)new MJCheckBoxMenuItem((Action)this.fMatchCaseAction));
        mJMenu.add((JMenuItem)new MJCheckBoxMenuItem((Action)this.fFilterMatchesAction));
        mJMenu.addSeparator();
        mJMenu.add((JMenuItem)new MJCheckBoxMenuItem((Action)this.fShowMatchToolBarAction));
        mJMenu.add((JMenuItem)new MJCheckBoxMenuItem((Action)this.fShowMatchIndicatorBarAction));
        mJMenu.add((JMenuItem)new MJCheckBoxMenuItem((Action)this.fShowExecutionTimeAction));
        mJMenu.addSeparator();
        mJMenu.add((Action)this.fInsertTimeStampAction);
        mJMenu.add((Action)this.fClearAction);
        return mJMenu;
    }

    private void initKeyBindings() {
        ExtendedAction[] extendedActionArray = new ExtendedAction[]{this.fCopyAction, this.fCutAction, this.fDeleteAction, this.fUndoAction, this.fSelectAllAction, this.fFindAction, this.fCancelFindAction, this.fEvaluateAction, this.fCopyToPromptAction, this.fCreateMFileAction, this.fCreateShortcutAction, this.fPrintAction, this.fPrintSelectionAction, this.fPageSetupAction, this.fClearAction, this.fDockAction, this.fCloseAction, this.fMatchCaseAction, this.fMatchAnywhereAction, this.fMatchBeginningAction, this.fFilterMatchesAction};
        MInputMap mInputMap = new MInputMap();
        mInputMap.setParent(this.fTable.getInputMap(0));
        this.fTable.setInputMap(0, (InputMap)mInputMap);
        this.addActionBindingsToMaps(mInputMap, this.fTable.getActionMap(), extendedActionArray);
        this.fTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (!(Character.isISOControl(c) || keyEvent.getModifiers() != 0 && keyEvent.getModifiers() != 1)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(c);
                    if (AltHistory.this.isMatchToolBarVisible()) {
                        Document document = AltHistory.this.fMatchTextField.getDocument();
                        try {
                            document.insertString(document.getLength(), stringBuilder.toString(), null);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                        AltHistory.this.fMatchTextField.requestFocusInWindow();
                    } else {
                        AltHistory.this.startFind();
                        AltHistory.this.fMatchTextField.setText(stringBuilder.toString());
                    }
                }
            }
        });
    }

    private void addActionBindingsToMaps(MInputMap mInputMap, ActionMap actionMap, ExtendedAction[] extendedActionArray) {
        for (ExtendedAction extendedAction : extendedActionArray) {
            if (extendedAction.getContextID() != null) {
                MatlabKeyBindings.getManager().addToActionMap(extendedAction, actionMap);
                MatlabKeyBindings.getManager().addKeyBindings(extendedAction, (ExtendedInputMap)mInputMap);
                continue;
            }
            actionMap.put(extendedAction.getActionID(), (Action)extendedAction);
            mInputMap.put(extendedAction.getAccelerator(), (Object)extendedAction.getActionID());
        }
    }

    private JComponent createBackupDialogPane() {
        this.setPseudoModal(true);
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("4dlu, p, 4dlu:grow", "p, 4dlu, p, 2dlu, p"));
        mJPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        CellConstraints cellConstraints = new CellConstraints();
        MJMultilineLabel mJMultilineLabel = new MJMultilineLabel(sRes.getString("message.problem_loading"), false);
        mJMultilineLabel.setForeground(Color.red);
        mJMultilineLabel.setOpaque(false);
        mJPanel.add((Component)mJMultilineLabel, cellConstraints.xyw(1, 1, 3));
        MJButton mJButton = new MJButton(sRes.getString("action.load_backup"));
        mJButton.setToolTipText(sRes.getString("tip.load_backup"));
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(com.mathworks.util.FileUtils.getPreferencesDirectory(), "History.bak");
                AltHistory.this.fCollection.recallCommands(file, false);
                AltHistory.this.fCollection.addTimeStamp();
                AltHistory.this.removeBackupDialogPane();
                AltHistory.this.hideEmptyLabel();
            }
        });
        mJPanel.add((Component)mJButton, cellConstraints.xy(2, 3));
        MJButton mJButton2 = new MJButton(sRes.getString("action.accept_history"));
        mJButton2.setToolTipText(sRes.getString("tip.accept_history"));
        mJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltHistory.this.removeBackupDialogPane();
                AltHistory.this.fCollection.initiateSaveAll();
                AltHistory.this.fCollection.addTimeStamp();
            }
        });
        mJPanel.add((Component)mJButton2, cellConstraints.xy(2, 5));
        return mJPanel;
    }

    private void removeBackupDialogPane() {
        this.fAlignmentPanel.remove(this.fBackupDialogPane);
        this.fBackupDialogPane = null;
        this.setPseudoModal(false);
        this.revalidate();
        this.repaint();
    }

    private MessagePanel getMatchIndicatorBar() {
        if (this.fMatchIndicatorBar == null) {
            this.fMatchIndicatorBar = this.createMatchIndicatorBar();
            this.add((Component)this.fMatchIndicatorBar, "East");
        }
        return this.fMatchIndicatorBar;
    }

    private MessagePanel createMatchIndicatorBar() {
        this.fMatchIndicatorModel = new DefaultMessageModel(Collections.EMPTY_LIST, 0);
        CorrectedMessagePanel correctedMessagePanel = new CorrectedMessagePanel((MessageModel)this.fMatchIndicatorModel, new MatchIndicatorPainter()){

            public String getToolTipText(MouseEvent mouseEvent) {
                if (this.isOverSummary(mouseEvent)) {
                    int n = AltHistory.this.fMatchIndicatorModel.getMessageCount();
                    return n == 0 ? sRes.getString("message.no_matches_found") : MessageFormat.format(sRes.getString("message.matches_found"), Integer.toString(n));
                }
                return super.getToolTipText(mouseEvent);
            }
        };
        correctedMessagePanel.setName("CommadHistoryMatchIndicatorBar");
        correctedMessagePanel.addListener((MessagePanelListener)new MessagePanelListener<DefaultMessage>(){

            public void messageClicked(DefaultMessage defaultMessage) {
                Rectangle rectangle = AltHistory.this.fTable.getCellRect(defaultMessage.getLineNumber(), 0, false);
                JViewport jViewport = AltHistory.this.fScroller.getViewport();
                Rectangle rectangle2 = jViewport.getViewRect();
                int n = (rectangle2.height - rectangle.height) / 2;
                int n2 = AltHistory.this.fTable.getHeight();
                Point point = new Point(rectangle2.x, rectangle.y - n);
                if (point.y + rectangle2.height > n2) {
                    point.y = n2 - rectangle2.height;
                }
                if (point.y < 0) {
                    point.y = 0;
                }
                jViewport.setViewPosition(point);
            }

            public void summarySquareClicked(boolean bl) {
                AltHistory.this.selectPreviousMatch(true);
            }
        });
        correctedMessagePanel.setVisible(false);
        return correctedMessagePanel;
    }

    private JComponent getMatchToolBar() {
        if (this.fMatchToolBar == null) {
            this.fMatchToolBar = this.createMatchToolBar();
            this.add(this.fMatchToolBar, "North");
            this.fMatchToolBar.setVisible(false);
            this.setMatchToolBarTemporary(false);
        }
        return this.fMatchToolBar;
    }

    private JComponent createMatchToolBar() {
        Insets insets;
        MJTextField mJTextField;
        MJToolBar mJToolBar = new MJToolBar();
        mJToolBar.setName("CommandHistoryFindToolBar");
        mJToolBar.setFloatable(false);
        mJToolBar.setBorder(BorderFactory.createEmptyBorder(0, 3, 4, 2));
        mJToolBar.setBackground(TOOL_BAR_BACKGROUND_COLOR);
        this.fMatchTextField = this.createMatchTextField();
        if (PlatformInfo.isMacOSLeopardOrLater()) {
            mJTextField = this.fMatchTextField;
            this.fMatchTextField.putClientProperty((Object)"JTextField.variant", (Object)"search");
            this.fMatchTextField.putClientProperty((Object)"JTextField.Search.CancelAction", (Object)this.createClearMatchListener());
        } else {
            mJTextField = new MJPanel((LayoutManager)new BorderLayout());
            mJTextField.add((Component)this.fMatchTextField, "Center");
            mJTextField.add((Component)WindowsWidgetFactory.createSearchAndClearButton((JTextField)this.fMatchTextField, (ActionListener)this.createClearMatchListener()), "East");
            insets = this.fMatchTextField.getInsets();
            mJTextField.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(), this.fMatchTextField.getBorder()));
            mJTextField.setBackground(new Color(this.fMatchTextField.getBackground().getRGB()));
            this.fMatchTextField.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
            this.fMatchTextField.setBackground(null);
        }
        mJToolBar.add((Component)mJTextField);
        mJToolBar.add((Action)this.fPreviousMatchAction);
        mJToolBar.add((Action)this.fNextMatchAction);
        mJToolBar.add(Box.createHorizontalStrut(4));
        insets = new ChildAction((Action)this.fMatchCaseAction);
        insets.putValue("Name", ChildAction.NULL_VALUE);
        insets.putValue("SmallIcon", AltHistoryIcon.CASE_SENSITIVE.getIcon());
        JToggleButton jToggleButton = mJToolBar.addToggle((Action)((Object)insets));
        jToggleButton.setBorder(null);
        jToggleButton.setSelectedIcon(AltHistoryIcon.CASE_SENSITIVE_SELECTED.getIcon());
        mJToolBar.add(Box.createHorizontalStrut(6));
        ChildAction childAction = new ChildAction((Action)this.fMatchAnywhereAction);
        childAction.putValue("Name", ChildAction.NULL_VALUE);
        childAction.putValue("SmallIcon", (Object)AltHistoryIcon.MATCH_ANYWHERE.getIcon());
        JToggleButton jToggleButton2 = mJToolBar.addToggle((Action)childAction);
        jToggleButton2.setBorder(null);
        jToggleButton2.setSelectedIcon(AltHistoryIcon.MATCH_ANYWHERE_SELECTED.getIcon());
        mJToolBar.add(Box.createHorizontalStrut(2));
        ChildAction childAction2 = new ChildAction((Action)this.fMatchBeginningAction);
        childAction2.putValue("Name", ChildAction.NULL_VALUE);
        childAction2.putValue("SmallIcon", (Object)AltHistoryIcon.MATCH_BEGINNING.getIcon());
        JToggleButton jToggleButton3 = mJToolBar.addToggle((Action)childAction2);
        jToggleButton3.setBorder(null);
        jToggleButton3.setSelectedIcon(AltHistoryIcon.MATCH_BEGINNING_SELECTED.getIcon());
        mJToolBar.add(Box.createHorizontalStrut(6));
        ChildAction childAction3 = new ChildAction((Action)this.fFilterMatchesAction);
        childAction3.putValue("Name", ChildAction.NULL_VALUE);
        childAction3.putValue("SmallIcon", (Object)AltHistoryIcon.FILTER.getIcon());
        JToggleButton jToggleButton4 = mJToolBar.addToggle((Action)childAction3);
        jToggleButton4.setBorder(null);
        jToggleButton4.setSelectedIcon(AltHistoryIcon.FILTER_SELECTED.getIcon());
        MJToolBar mJToolBar2 = new MJToolBar();
        mJToolBar2.setFloatable(false);
        mJToolBar2.setBorder(BorderFactory.createEmptyBorder());
        mJToolBar2.setBackground(TOOL_BAR_BACKGROUND_COLOR);
        mJToolBar2.add(Box.createHorizontalStrut(6));
        this.fCancelFindButton = mJToolBar2.add((Action)this.fCancelFindAction);
        this.fToolBarActionsButton = this.createShowActionsButton();
        this.fToolBarActionsButton.setName("Command History Actions Tool Bar Button");
        mJToolBar2.add((Component)this.fToolBarActionsButton);
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.add((Component)mJToolBar, (Object)"Center");
        mJPanel.add((Component)mJToolBar2, (Object)"East");
        return mJPanel;
    }

    private MJTextField createMatchTextField() {
        final MJTextField mJTextField = new MJTextField(){

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.width = 72;
                return dimension;
            }

            public Dimension getPreferredSize() {
                int n;
                Dimension dimension = super.getPreferredSize();
                String string = this.getText();
                if (string != null && string.length() > 0) {
                    dimension.width += 12;
                }
                if (dimension.width < (n = 10 * this.getFontMetrics(this.getFont()).charWidth('M'))) {
                    dimension.width = n;
                }
                return dimension;
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
                if (mouseEvent.getID() == 501 && AltHistory.this.isAnchored()) {
                    Window window = SwingUtilities.windowForComponent((Component)((Object)AltHistory.this));
                    window.setFocusableWindowState(true);
                }
                super.processMouseEvent(mouseEvent);
            }
        };
        mJTextField.setName("CommandHistoryFindTextField");
        mJTextField.setSelectAllOnFocus(false);
        if (this.fTextToMatch != null) {
            mJTextField.setText(this.fTextToMatch);
        }
        ExtendedAction[] extendedActionArray = new ExtendedAction[]{this.fPreviousMatchAction, this.fExtendToPreviousMatchAction, this.fNextMatchAction, this.fExtendToNextMatchAction, this.fEvaluateAction, this.fCopyToPromptAction, this.fCancelFindAction, this.fMatchCaseAction, this.fMatchAnywhereAction, this.fMatchBeginningAction, this.fFilterMatchesAction};
        MInputMap mInputMap = new MInputMap();
        mInputMap.setParent(mJTextField.getInputMap(0));
        mJTextField.setInputMap(0, (InputMap)mInputMap);
        this.addActionBindingsToMaps(mInputMap, mJTextField.getActionMap(), extendedActionArray);
        mJTextField.addFocusListener(this.fFocusAppearanceUpdater);
        mJTextField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AltHistory.this.toFront();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (AltHistory.this.isAnchored()) {
                    Window window = SwingUtilities.windowForComponent((Component)((Object)AltHistory.this));
                    window.setFocusableWindowState(false);
                }
            }
        });
        mJTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.updateMatch();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.updateMatch();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.updateMatch();
            }

            private void updateMatch() {
                AltHistory.this.setTextToMatch(mJTextField.getText());
                AltHistory.this.updateMatchRecall();
            }
        });
        return mJTextField;
    }

    private boolean isMatchToolBarVisible() {
        return this.fMatchToolBar != null && this.fMatchToolBar.isVisible();
    }

    public void setMatchToolBarVisible(boolean bl) {
        if (bl != this.isMatchToolBarVisible()) {
            this.getMatchToolBar().setVisible(bl);
            if (!bl) {
                this.fMatchTextField.setText("");
            }
            this.updateUpperRightActionButtonVisibility();
            this.updateBounds();
        }
    }

    private void updateBounds() {
        if (this.isShowing() && !this.isDocked()) {
            Rectangle rectangle = this.getPopupBounds();
            Window window = SwingUtilities.windowForComponent((Component)((Object)this));
            if (this.isAnchored()) {
                window.setBounds(rectangle);
            } else {
                window.setSize(rectangle.getSize());
            }
        }
    }

    private void setMatchToolBarTemporary(boolean bl) {
        this.fIsTemporaryFind = bl;
        if (this.fCancelFindButton != null) {
            this.fCancelFindButton.setVisible(bl);
        }
        if (this.fToolBarActionsButton != null) {
            this.fToolBarActionsButton.setVisible(!bl && this.isAnchored());
        }
        this.updateUpperRightActionButtonVisibility();
    }

    private boolean isMatchToolBarTemporary() {
        return this.fIsTemporaryFind;
    }

    private void updateToolBarActionsButtonVisibility() {
        if (this.fToolBarActionsButton != null) {
            this.fToolBarActionsButton.setVisible(this.isAnchored() && !this.isMatchToolBarTemporary());
        }
    }

    private void updateUpperRightActionButtonVisibility() {
        if (this.fUpperRightActionsButton != null) {
            this.fUpperRightActionsButton.setVisible(this.isAnchored() && (!this.isMatchToolBarVisible() || this.isMatchToolBarTemporary()));
        }
    }

    private void updateSelectionDependentActions() {
        boolean bl = this.fTable.getSelectedRowCount() > 0;
        boolean bl2 = this.isFiltered();
        this.fCutAction.setEnabled(bl && !bl2);
        this.fCopyAction.setEnabled(bl);
        this.fDeleteAction.setEnabled(bl && !bl2);
        this.fPrintSelectionAction.setEnabled(bl);
        this.fEvaluateAction.setEnabled(bl);
        this.fCreateMFileAction.setEnabled(bl);
        this.fCreateShortcutAction.setEnabled(bl);
        this.updateMatchNavigationActions();
    }

    private void updateLocationDependentActions() {
        boolean bl = this.isAnchored();
        this.fDockAction.setEnabled(bl);
        this.fCloseAction.setEnabled(bl);
    }

    private void dissociateWithCommandWindow() {
        if (this.fTextToMatch != null && !this.isMatchToolBarVisible()) {
            this.setTextToMatch(null);
            if (this.fMatchTextField != null) {
                this.fMatchTextField.setText("");
            }
        }
        if (AltHistory.showDotDotDotForMultiSelectWhenAnchored()) {
            String[] stringArray = new String[]{};
            for (RecallListener recallListener : this.fRecallListeners) {
                recallListener.commandRecalled(stringArray);
            }
            stringArray = this.fTable.getSelectedCommands();
            if (stringArray.length > 1) {
                stringArray[0] = "";
                CmdWinEditorKit.appendCommands(stringArray);
            }
        }
        if (this.fPopupVisibilityListener != null) {
            this.fPopupVisibilityListener.restoreCommandWindow();
        }
        this.hideEmptyLabel();
    }

    private void showEmptyLabel(boolean bl) {
        this.fEmptyLabel.setText(sRes.getString(bl ? "message.no_matching_commands" : "message.no_commands_recorded"));
        this.fEmptyLabel.setVisible(true);
        this.fScroller.setVisible(false);
    }

    private void hideEmptyLabel() {
        if (this.fEmptyLabel.isVisible()) {
            this.fEmptyLabel.setVisible(false);
            this.fScroller.setVisible(true);
            this.updateBounds();
        }
    }

    private void updateUndoAction() {
        this.fUndoAction.setEnabled(this.fTable.anythingToUndo());
    }

    private boolean isAnchored() {
        Desktop desktop = this.getParentDesktop();
        return desktop != null && desktop.isClientAnchored((Component)((Object)this));
    }

    private boolean isDocked() {
        Desktop desktop = this.getParentDesktop();
        return desktop == null || desktop.isClientDocked((Component)((Object)this));
    }

    private ListSelectionModel getActiveRecallModel() {
        return this.isAnchored() ? this.fTable.getSelectionModel() : this.fRecallModel;
    }

    private void toFront() {
        if (!this.isAnchored() && !this.isDocked()) {
            Window window = SwingUtilities.windowForComponent((Component)((Object)this));
            window.toFront();
        }
    }

    private void _recallPrevious(String string, boolean bl) {
        int n;
        boolean bl2;
        ListSelectionModel listSelectionModel;
        Desktop desktop = this.getParentDesktop();
        if (desktop != null && desktop.isClientShowing((Component)((Object)this)) && !desktop.isClientDocked((Component)((Object)this)) && desktop.isClientAnchored((Component)((Object)this)) && !this.isShowing()) {
            AltHistory.resetRecall();
        }
        int n2 = (listSelectionModel = this.getActiveRecallModel()).isSelectionEmpty() ? -1 : listSelectionModel.getLeadSelectionIndex();
        boolean bl3 = bl2 = string != null && string.length() > 0;
        if (this.isAnchored()) {
            n = this.fTextToMatch != null ? 1 : 0;
            this.setTextToMatch(bl2 ? string : "");
            if (this.fMatchTextField != null && bl2 && n == 0) {
                this.fMatchTextField.setText(string);
            }
        }
        if (n2 < 0 && bl && !bl2 && this.fTable.getRowCount() > 0) {
            for (n = this.fTable.getRowCount() - 1; n > 0 && this.fTable.getCommandRecord(n).isTimeStamp(); --n) {
            }
            int n3 = n;
            if (this.fCollection.isInBatch(n)) {
                n3 = this.fCollection.getBatchStart(n);
            }
            listSelectionModel.setSelectionInterval(n, n3);
            if (this.isAnchored()) {
                this.fTable.scrollToBottom();
            }
        } else {
            n = this.fTable.rowOfPreviousMatch(n2, (String)(bl && n2 >= 0 ? null : string), this.fMatchCaseAction.isSelected(), this.fMatchAnywhereAction.isSelected());
            if (n >= 0) {
                if (bl) {
                    int n4 = listSelectionModel.getAnchorSelectionIndex();
                    if (n4 < 0 || n2 < 0) {
                        n4 = this.fTable.getRowCount() - 1;
                        if (this.isAnchored()) {
                            this.fTable.scrollToBottom();
                        }
                    }
                    listSelectionModel.setSelectionInterval(n4, n);
                } else {
                    listSelectionModel.setSelectionInterval(n, n);
                }
                if (this.isAnchored()) {
                    if (n == this.fTable.getRowCount() - 1) {
                        this.fTable.scrollToBottom();
                    } else {
                        this.fTable.ensureRowVisible(this.fTable.getRowCount() - 1);
                        this.fTable.ensureRowVisible(n);
                    }
                }
            }
        }
        if (this.isAnchored() && !this.isShowing() && (!listSelectionModel.isSelectionEmpty() || this.fCollection.isEmpty() || CmdHistoryPrefs.getShowMessageWhenEmpty())) {
            if (listSelectionModel.isSelectionEmpty()) {
                this.showEmptyLabel(string != null && string.length() > 0);
            }
            this._showPopup();
        }
    }

    private void _recallNext(String string, boolean bl) {
        ListSelectionModel listSelectionModel = this.getActiveRecallModel();
        int n = listSelectionModel.isSelectionEmpty() ? -1 : listSelectionModel.getLeadSelectionIndex();
        int n2 = this.fTable.rowOfNextMatch(n, (String)(bl && n >= 0 ? null : string), this.fMatchCaseAction.isSelected(), this.fMatchAnywhereAction.isSelected());
        if (n2 < 0) {
            if (!bl) {
                listSelectionModel.clearSelection();
            }
        } else {
            if (bl) {
                listSelectionModel.setSelectionInterval(listSelectionModel.getAnchorSelectionIndex(), n2);
            } else {
                listSelectionModel.setSelectionInterval(n2, n2);
            }
            if (this.isAnchored()) {
                this.fTable.ensureRowVisible(n2);
            }
        }
        if (listSelectionModel.isSelectionEmpty()) {
            AltHistory.resetRecall();
        }
    }

    private int getPreviousMatchRow() {
        int n = this.fTable.getSelectionModel().getMinSelectionIndex();
        if (n == -1) {
            n = this.fTable.getRowCount();
        }
        if (this.fFilterMatches) {
            return n - 1;
        }
        if (this.fMatchIndicatorModel == null || this.fMatchIndicatorModel.getMessageCount() == 0) {
            return "".equals(this.fTextToMatch) && n > 0 ? n - 1 : -1;
        }
        for (int i = this.fMatchIndicatorModel.getMessageCount() - 1; i >= 0; --i) {
            int n2 = this.fMatchIndicatorModel.getLineNumberAt(i);
            if (n2 >= n) continue;
            return n2;
        }
        return -1;
    }

    private void selectPreviousMatch(boolean bl) {
        int n = this.getPreviousMatchRow();
        if (bl && n < 0 && this.fMatchIndicatorModel != null && this.fMatchIndicatorModel.getMessageCount() > 1) {
            this.fTable.getSelectionModel().clearSelection();
            n = this.getPreviousMatchRow();
        }
        if (n >= 0) {
            this.fTable.getSelectionModel().setSelectionInterval(n, n);
            this.fTable.ensureRowVisible(n);
        }
    }

    private void extendSelectionToPreviousMatch() {
        int n = this.getPreviousMatchRow();
        if (n >= 0) {
            this.fTable.getSelectionModel().addSelectionInterval(n, n);
            this.fTable.ensureRowVisible(n);
        }
    }

    private int getNextMatchRow() {
        int n = this.fTable.getSelectionModel().getMaxSelectionIndex();
        if (this.fFilterMatches) {
            return n < this.fTable.getRowCount() - 1 ? n + 1 : -1;
        }
        if (this.fMatchIndicatorModel == null || this.fMatchIndicatorModel.getMessageCount() == 0) {
            return "".equals(this.fTextToMatch) && n < this.fTable.getRowCount() - 1 ? n + 1 : -1;
        }
        for (int i = 0; i < this.fMatchIndicatorModel.getMessageCount(); ++i) {
            int n2 = this.fMatchIndicatorModel.getLineNumberAt(i);
            if (n2 <= n) continue;
            return n2;
        }
        return -1;
    }

    private void selectNextMatch() {
        int n = this.getNextMatchRow();
        if (n >= 0) {
            this.fTable.getSelectionModel().setSelectionInterval(n, n);
            this.fTable.ensureRowVisible(n);
        }
    }

    private void extendSelectionToNextMatch() {
        int n = this.getNextMatchRow();
        if (n >= 0) {
            this.fTable.getSelectionModel().addSelectionInterval(n, n);
            this.fTable.ensureRowVisible(n);
        }
    }

    private void updateMatchRecall() {
        if (this.fTextToMatch != null && this.isAnchored() && this.isShowing()) {
            ListSelectionModel listSelectionModel = this.getActiveRecallModel();
            listSelectionModel.clearSelection();
            this._recallPrevious(this.fTextToMatch, false);
            if (!listSelectionModel.isSelectionEmpty()) {
                this.hideEmptyLabel();
            }
        }
    }

    public Object getLazyProperty(DTProperty dTProperty) {
        if (dTProperty == DTClientProperty.TEAR_OFF_ANCHOR_LOCATION) {
            return this.getPromptLocation();
        }
        if (dTProperty == DTClientProperty.TEAR_OFF_ANCHORED_BOUNDS) {
            return this.getPopupBounds();
        }
        if (dTProperty == DTClientProperty.CONTEXT_MENU) {
            return this.createTitleBarMenu();
        }
        return null;
    }

    public boolean isLazyProperty(DTProperty dTProperty) {
        return dTProperty == DTClientProperty.TEAR_OFF_ANCHOR_LOCATION || dTProperty == DTClientProperty.TEAR_OFF_ANCHORED_BOUNDS || dTProperty == DTClientProperty.CONTEXT_MENU;
    }

    public JButton getShowActionsButton() {
        if (this.fToolBarActionsButton != null && this.fToolBarActionsButton.isVisible()) {
            return this.fToolBarActionsButton;
        }
        if (this.fUpperRightActionsButton != null && this.fUpperRightActionsButton.isVisible()) {
            return this.fUpperRightActionsButton;
        }
        return null;
    }

    private void _showPopup() {
        Window window;
        Desktop desktop = this.getParentDesktop();
        if (desktop != null && !desktop.isClientDocked((Component)((Object)this)) && !this.isShowing() && (window = SwingUtilities.windowForComponent((Component)((Object)this))) != null) {
            if (!this.fPopupShown) {
                window.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentShown(ComponentEvent componentEvent) {
                        int n = AltHistory.this.fTable.getSelectionModel().getMinSelectionIndex();
                        if (n >= 0) {
                            AltHistory.this.fTable.ensureRowVisible(n);
                        }
                        AltHistory.this.fPopupShown = true;
                        window.removeComponentListener(this);
                    }
                });
            }
            window.setBounds(this.getPopupBounds());
            window.setVisible(true);
        }
    }

    private void hidePopup() {
        Desktop desktop = this.getParentDesktop();
        if (desktop != null) {
            desktop.hideAnchoredClient((Component)((Object)this));
        }
    }

    private boolean _isPopupShowing() {
        Desktop desktop = this.getParentDesktop();
        return desktop != null && desktop.isAnchoredClientShowing((Component)((Object)this));
    }

    private boolean _isEvaluatingRecalledCommands() {
        return this._isPopupShowing() || this.fIsEvaluatingSelection;
    }

    private Point getPromptLocation() {
        int n;
        XCmdWndView xCmdWndView = XCmdWndView.getInstance();
        Point point = xCmdWndView.getAfterPromptPoint();
        Rectangle rectangle = xCmdWndView.getVisibleRect();
        if (point.x < rectangle.x) {
            point.x = rectangle.x;
        }
        if (point.y > (n = rectangle.y + rectangle.height - xCmdWndView.getFontMetrics(xCmdWndView.getFont()).getHeight())) {
            point.y = n;
        }
        SwingUtilities.convertPointToScreen(point, XCmdWndView.getInstance());
        return point;
    }

    private Rectangle getPopupBounds() {
        int n;
        int n2;
        Point point = this.getPromptLocation();
        point.x -= this.fTable.getCommandInset() + 4;
        Rectangle rectangle = WindowUtils.getScreenBoundsWithOrNearestToPoint((Point)point);
        int n3 = point.y - rectangle.y - 10;
        if (PlatformInfo.isLinux() && rectangle.y == 0) {
            n3 -= 30;
        }
        int n4 = (this.fScroller.isVisible() ? this.fTable.getPreferredSize().height : this.fEmptyLabel.getPreferredSize().height) + (this.isAnchored() ? 14 : 22);
        Dimension dimension = null;
        if (this.isMatchToolBarVisible()) {
            dimension = this.fMatchToolBar.getPreferredSize();
            n4 += dimension.height;
        }
        if (this.fBackupDialogPane != null) {
            n4 += this.fBackupDialogPane.getPreferredSize().height;
        }
        int n5 = Math.min(n4, n3 + Math.max(0, XCmdWndView.getInstance().getSpaceBelowPrompt()));
        int n6 = Prefs.getIntegerPref((String)"AltHistoryPopupHeight", (int)-1);
        if (n6 > 0) {
            if (n6 < 60) {
                n6 = 60;
            }
            if (n6 > n3) {
                n6 = Math.min(n6, Math.max(n3, 200));
            }
            n2 = Math.min(n5, n6);
        } else {
            n2 = Math.min(n5, n3 < 250 ? 200 : 250);
        }
        int n7 = Prefs.getIntegerPref((String)"AltHistoryPopupWidth", (int)-1);
        if (n7 > 0) {
            n = Math.max(n7, 200);
        } else {
            int n8 = this.fMatchIndicatorBar != null && this.fMatchIndicatorBar.isVisible() ? this.fMatchIndicatorBar.getPreferredSize().width : 0;
            n = Math.min(CmdWin.getInstance().getWidth() - 80, this.fScroller.isVisible() ? 400 : this.fEmptyLabel.getPreferredSize().width + n8 + 40);
            if (dimension != null && dimension.width > n) {
                n = dimension.width;
            }
        }
        if (n2 > n3) {
            point.y += n2 - n3;
        }
        this.fLastComputedHeight = n2;
        this.fLastComputedWidth = n;
        return new Rectangle(point.x, point.y - n2, n, n2);
    }

    private void evaluateSelection() {
        this.fIsEvaluatingSelection = true;
        String string = this.fTable.getSelectedString();
        MLExecuteServices.executeCommand((String)string);
        if (this.isAnchored()) {
            this.clearTextAfterPrompt();
        }
        this.fIsEvaluatingSelection = false;
    }

    private void clearTextAfterPrompt() {
        try {
            CmdWinDocument.getInstance().removeCurrentPromptLine();
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void copySelectionToPrompt() {
        CmdWinEditorKit.appendCommands(this.fTable.getSelectedCommands());
    }

    public void showContextMenu() {
        if (this.isAnchored()) {
            final Window window = SwingUtilities.windowForComponent((Component)((Object)this));
            if (window == null) {
                return;
            }
            window.setFocusableWindowState(true);
            Rectangle rectangle = this.fTable.getVisibleRect();
            this.showContextMenu((Component)((Object)this.fTable), rectangle.x, rectangle.y, new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    window.setFocusableWindowState(true);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    window.setFocusableWindowState(false);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
        }
    }

    private JPopupMenu showContextMenu(Component component, int n, int n2, PopupMenuListener popupMenuListener) {
        MJPopupMenu mJPopupMenu = new MJPopupMenu();
        mJPopupMenu.add((Action)this.fCutAction);
        mJPopupMenu.add((Action)this.fCopyAction);
        mJPopupMenu.add((Action)this.fDeleteAction);
        mJPopupMenu.add((Action)this.fUndoAction);
        mJPopupMenu.addSeparator();
        mJPopupMenu.add((Action)this.fEvaluateAction);
        mJPopupMenu.add((Action)this.fCreateMFileAction);
        mJPopupMenu.add((Action)this.fCreateShortcutAction);
        mJPopupMenu.add((Action)((Object)new ToggleErrorAction()));
        if (popupMenuListener != null) {
            mJPopupMenu.addPopupMenuListener(popupMenuListener);
        }
        mJPopupMenu.show(component, n, n2);
        return mJPopupMenu;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.fTable != null) {
            this.fTable.setFont(font);
        }
    }

    public void requestFocus() {
        this.fTable.requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.fTable.requestFocusInWindow();
    }

    private void updateColors() {
        this.updateBackgroundColor();
        this.updateForegroundColor();
    }

    private void updateBackgroundColor() {
        Color color = ColorPrefs.getBackgroundColor();
        if (!this.isDocked()) {
            color = color.equals(Color.white) ? UNDOCKED_BACKGROUND_COLOR : (color.equals(Color.black) ? new Color(64, 64, 64) : (ColorUtils.isDark((Color)color) ? ColorUtils.brighter((Color)color, (double)0.9) : ColorUtils.darker((Color)color, (double)0.95)));
        }
        this.setBackground(color);
        this.fScroller.setBackground(color);
        this.fScroller.getViewport().setBackground(color);
        this.fTable.setBackground(color);
        this.fEmptyLabel.setBackground(color);
        this.fEmptyLabel.setForeground(this.fTable.getSecondaryForeground());
        this.fAlignmentPanel.setBackground(color);
        if (this.fUpperRightActionsButton != null) {
            this.fUpperRightActionsButton.setBackground(color);
        }
    }

    private void updateForegroundColor() {
        Color color = ColorPrefs.getTextColor();
        this.fTable.setForeground(color);
    }

    private void setTextToMatch(String string) {
        if (this.fTextToMatch == null && string != null && string.length() > 0 || this.fTextToMatch != null && !this.fTextToMatch.equals(string)) {
            this.fTextToMatch = string;
            if (this.fFilterMatches) {
                this.fTable.setFilterText(string);
                this.updateSelectionDependentActions();
            } else {
                this.fTable.setTextToHighlight(string == null || string.length() == 0 ? null : string);
                this.updateMatchIndicatorBarVisibility();
                this.updateMatchIndicatorBar();
            }
        }
    }

    private void updateMatchIndicatorBarVisibility() {
        boolean bl;
        boolean bl2 = bl = this.fTextToMatch != null && this.fTextToMatch.length() > 0 && !this.fFilterMatches && CmdHistoryPrefs.getShowMatchIndicatorBar();
        if (this.getMatchIndicatorBar().isVisible() != bl) {
            this.fMatchIndicatorBar.setVisible(bl);
            this.revalidate();
            this.repaint();
        }
    }

    private void setMatchAnywhere(boolean bl) {
        this.fTable.setMatchAnywhere(bl);
        this.updateMatchIndicatorBar();
        this.fMatchBeginningAction.setSelected(!bl);
        this.fMatchAnywhereAction.setSelected(bl);
        this.updateMatchRecall();
    }

    private void setFilterMatches(boolean bl) {
        if (bl == this.fFilterMatches) {
            return;
        }
        if (this.fTextToMatch != null) {
            String string = this.fTextToMatch;
            this.setTextToMatch(null);
            this.fFilterMatches = bl;
            this.setTextToMatch(string);
        } else {
            this.fFilterMatches = bl;
            this.updateSelectionDependentActions();
        }
    }

    private boolean isFiltered() {
        return this.fFilterMatches && this.fTextToMatch != null;
    }

    private void updateMatchIndicatorBar() {
        if (this.fMatchIndicatorModel == null) {
            return;
        }
        if (!this.fMatchUpdatePending) {
            this.fMatchUpdatePending = true;
            this.getMatchIndicatorBar().setPanelValid(false);
            Timer timer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = AltHistory.this.fTable.getHighlightedRows();
                    ArrayList<DefaultMessage> arrayList = new ArrayList<DefaultMessage>(nArray.length);
                    for (int n : nArray) {
                        arrayList.add(new DefaultMessage(AltHistory.this.fTable.getCommand(n), n));
                    }
                    AltHistory.this.fMatchIndicatorModel.update(arrayList, AltHistory.this.fTable.getRowCount());
                    AltHistory.this.fMatchIndicatorBar.setPanelValid(true);
                    if (AltHistory.this.isMatchToolBarVisible() && nArray.length > 0) {
                        int n = AltHistory.this.fTable.getSelectedRow();
                        if (n == AltHistory.this.fTable.getRowCount() - 1) {
                            AltHistory.this.fTable.clearSelection();
                        } else if (n >= 0) {
                            AltHistory.this.fTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
                        }
                        AltHistory.this.selectPreviousMatch(true);
                        AltHistory.this.updateMatchNavigationActions();
                    }
                    AltHistory.this.fMatchUpdatePending = false;
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
    }

    private void updateMatchNavigationActions() {
        this.fPreviousMatchAction.setEnabled(this.getPreviousMatchRow() >= 0);
        this.fNextMatchAction.setEnabled(this.getNextMatchRow() >= 0);
    }

    private void startFind() {
        if (!this.isMatchToolBarVisible()) {
            this.setMatchToolBarVisible(true);
            this.setMatchToolBarTemporary(true);
            if (this.isAnchored()) {
                this.updateMatchNavigationActions();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int n = AltHistory.this.fTable.getSelectionModel().getMaxSelectionIndex();
                        if (n > 0) {
                            AltHistory.this.fTable.ensureRowVisible(n);
                        }
                    }
                });
            }
            this.revalidate();
            this.repaint();
        }
        if (this.isAnchored()) {
            Window window = SwingUtilities.windowForComponent((Component)((Object)this));
            window.setFocusableWindowState(true);
            ComponentAdapter componentAdapter = new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    AltHistory.this.cancelFind();
                }
            };
            window.addComponentListener(componentAdapter);
            this.fMatchToolBar.putClientProperty("HideListener", componentAdapter);
        } else {
            this.fMatchTextField.setText("");
        }
        this.fMatchTextField.requestFocus();
    }

    private void cancelFind() {
        if (this.isMatchToolBarVisible()) {
            this.setTextToMatch(null);
            this.fMatchTextField.setText("");
            if (this.isMatchToolBarTemporary()) {
                this.fMatchToolBar.setVisible(false);
                this.revalidate();
                this.repaint();
            }
            if (this.isAnchored()) {
                Window window = SwingUtilities.windowForComponent((Component)((Object)this));
                window.setFocusableWindowState(false);
                ComponentListener componentListener = (ComponentListener)this.fMatchToolBar.getClientProperty("HideListener");
                if (componentListener != null) {
                    window.removeComponentListener(componentListener);
                    this.fMatchToolBar.putClientProperty("HideListener", null);
                }
            } else {
                this.fMatchTextField.transferFocus();
            }
        }
    }

    private ActionListener createClearMatchListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltHistory.this.fMatchTextField.setText("");
                AltHistory.this.fMatchTextField.transferFocus();
            }
        };
    }

    private Runnable blockDeactivationOnLinux() {
        Runnable runnable;
        if (PlatformInfo.isLinux() && !this.isDocked()) {
            final JFrame jFrame = (JFrame)WindowUtils.getTopmostWindow((Component)((Object)this));
            final WindowAdapter windowAdapter = new WindowAdapter(){

                @Override
                public void windowDeactivated(WindowEvent windowEvent) {
                    windowEvent.getWindow().toFront();
                    jFrame.removeWindowListener(this);
                }
            };
            jFrame.addWindowListener(windowAdapter);
            runnable = new Runnable(){

                @Override
                public void run() {
                    jFrame.removeWindowListener(windowAdapter);
                }
            };
        } else {
            runnable = new Runnable(){

                @Override
                public void run() {
                }
            };
        }
        return runnable;
    }

    public class MatchIndicatorPainter
    implements MessagePanelPainter {
        public Paint getPaintForMessage(Object object) {
            return MESSAGE_PAINT;
        }

        public Paint getPaintForSummary(MessageModel messageModel) {
            return messageModel.getMessageCount() == 0 ? NO_MESSAGES_PAINT : MESSAGES_PAINT;
        }
    }

    private class CloseAction
    extends MJAbstractAction {
        CloseAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "close-item", (ExtendedAction)this);
            this.putValue(AltHistory.FORWARD_FROM_COMMAND_WINDOW, true);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AltHistory.this.isAnchored()) {
                AltHistory.this.hidePopup();
            }
        }
    }

    private class DockAction
    extends MJAbstractAction {
        DockAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", "dock", (ExtendedAction)this);
            this.putValue(AltHistory.FORWARD_FROM_COMMAND_WINDOW, true);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Desktop desktop = AltHistory.this.getParentDesktop();
            if (desktop != null && AltHistory.this.isAnchored()) {
                desktop.setClientDocked((Component)((Object)AltHistory.this), true);
            }
        }
    }

    private class CancelFindAction
    extends MJAbstractAction {
        CancelFindAction() {
            super("", (Icon)MiscellaneousIcon.CANCEL_15x15.getIcon());
            this.setComponentName("CancelFind");
            this.setAccelerator(KeyStroke.getKeyStroke(27, 0));
            this.putValue("ActionCommandKey", "cancel-find");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AltHistory.this.cancelFind();
        }
    }

    private class ExtendToNextMatchAction
    extends MJAbstractAction {
        ExtendToNextMatchAction() {
            this.setAccelerator(KeyStroke.getKeyStroke(40, 1));
            this.putValue("ActionCommandKey", "extend-to-next-match");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AltHistory.this.extendSelectionToNextMatch();
        }
    }

    private class ExtendToPreviousMatchAction
    extends MJAbstractAction {
        ExtendToPreviousMatchAction() {
            this.setAccelerator(KeyStroke.getKeyStroke(38, 1));
            this.putValue("ActionCommandKey", "extend-to-previous-match");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AltHistory.this.extendSelectionToPreviousMatch();
        }
    }

    private class NextMatchAction
    extends MJAbstractAction {
        NextMatchAction() {
            super("", (Icon)MiscellaneousIcon.CLOSE_ARROW.getIcon());
            this.setComponentName("GoToNextMatch");
            this.setAccelerator(KeyStroke.getKeyStroke(40, 0));
            this.putValue("ActionCommandKey", "next-match");
            this.setTip(sRes.getString("tip.next_match"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AltHistory.this.selectNextMatch();
        }
    }

    private class PreviousMatchAction
    extends MJAbstractAction {
        PreviousMatchAction() {
            super("", (Icon)MiscellaneousIcon.OPEN_ARROW.getIcon());
            this.setComponentName("GoToPreviousMatch");
            this.setAccelerator(KeyStroke.getKeyStroke(38, 0));
            this.putValue("ActionCommandKey", "previous-match");
            this.setEnabled(false);
            this.setTip(sRes.getString("tip.previous_match"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AltHistory.this.selectPreviousMatch(false);
        }
    }

    private class ShowMatchIndicatorBarAction
    extends MJAbstractAction
    implements PrefListener {
        ShowMatchIndicatorBarAction() {
            super(sRes.getString("action.show_match_indicator_bar"));
            this.setComponentName("ShowMatchIndicatorBar");
            this.setSelected(CmdHistoryPrefs.getShowMatchIndicatorBar());
            Prefs.addListener((PrefListener)this, (String)"CommandHistoryShowMachIndicatorBar");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdHistoryPrefs.setShowMatchIndicatorBar(this.isSelected());
        }

        public void prefChanged(PrefEvent prefEvent) {
            this.setSelected(CmdHistoryPrefs.getShowMatchIndicatorBar());
            AltHistory.this.updateMatchIndicatorBarVisibility();
        }
    }

    private class ShowMatchToolBarAction
    extends MJAbstractAction
    implements PrefListener {
        ShowMatchToolBarAction() {
            super(sRes.getString("action.show_match_tool_bar"));
            this.setComponentName("ShowMatchToolBar");
            Prefs.addListener((PrefListener)this, (String)"CommandHistoryShowMatchBar");
            Prefs.addListener((PrefListener)this, (String)"CommandHistoryShowMatchBarWhenDocked");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AltHistory.this.isDocked()) {
                CmdHistoryPrefs.setShowMatchBarWhenDocked(this.isSelected());
            } else {
                CmdHistoryPrefs.setShowMatchToolBar(this.isSelected());
            }
        }

        public void prefChanged(PrefEvent prefEvent) {
            this.setSelected(AltHistory.this.isDocked() ? CmdHistoryPrefs.getShowMatchBarWhenDocked() : CmdHistoryPrefs.getShowMatchToolBar());
            AltHistory.this.setMatchToolBarVisible(this.isSelected());
            if (this.isSelected()) {
                AltHistory.this.setMatchToolBarTemporary(false);
            }
        }
    }

    private class ShowExecutionTimeAction
    extends MJAbstractAction
    implements PrefListener {
        ShowExecutionTimeAction() {
            super(sRes.getString("action.show_execution_time"));
            this.setComponentName("ShowExecutionTime");
            Prefs.addListener((PrefListener)this, (String)"CommandHistoryShowExecutionTime");
            Prefs.addListener((PrefListener)this, (String)"CommandHistoryShowExecutionTimeWhenDocked");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AltHistory.this.isDocked()) {
                CmdHistoryPrefs.setShowExecutionTimeWhenDocked(this.isSelected());
            } else {
                CmdHistoryPrefs.setShowExecutionTime(this.isSelected());
            }
        }

        public void prefChanged(PrefEvent prefEvent) {
            this.setSelected(AltHistory.this.isDocked() ? CmdHistoryPrefs.getShowExecutionTimeWhenDocked() : CmdHistoryPrefs.getShowExecutionTime());
            AltHistory.this.fTable.setTimeColumnVisible(this.isSelected());
        }
    }

    private class FilterMatchesAction
    extends MJAbstractAction
    implements PrefListener {
        FilterMatchesAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandHistory", "filter-matches", (ExtendedAction)this);
            this.setComponentName("FilterMatches");
            this.setSelected(AltHistory.this.fFilterMatches);
            this.setTip(sRes.getString("tip.filter_matches"));
            this.putValue(AltHistory.FORWARD_EVEN_IF_NOT_SHOWING, true);
            Prefs.addListener((PrefListener)this, (String)"CommandHistoryFilterMatches");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!(actionEvent.getSource() instanceof AbstractButton)) {
                this.setSelected(!this.isSelected());
            }
            CmdHistoryPrefs.setFilterMatches(this.isSelected());
        }

        public void prefChanged(PrefEvent prefEvent) {
            this.setSelected(CmdHistoryPrefs.getFilterMatches());
            AltHistory.this.setFilterMatches(this.isSelected());
        }
    }

    private class MatchBeginningAction
    extends MJAbstractAction
    implements PrefListener {
        MatchBeginningAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandHistory", "match-beginning", (ExtendedAction)this);
            this.setComponentName("MatchBeginning");
            this.setSelected(!CmdHistoryPrefs.getMatchAnywhere());
            this.setTip(sRes.getString("tip.match_beginning"));
            this.putValue(AltHistory.FORWARD_EVEN_IF_NOT_SHOWING, true);
            Prefs.addListener((PrefListener)this, (String)"CommandHistoryMatchAnywhere");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdHistoryPrefs.setMatchAnywhere(false);
        }

        public void prefChanged(PrefEvent prefEvent) {
            AltHistory.this.setMatchAnywhere(CmdHistoryPrefs.getMatchAnywhere());
        }
    }

    private class MatchAnywhereAction
    extends MJAbstractAction
    implements PrefListener {
        MatchAnywhereAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandHistory", "match-anywhere", (ExtendedAction)this);
            this.setComponentName("MatchAnywhere");
            this.setSelected(CmdHistoryPrefs.getMatchAnywhere());
            this.setTip(sRes.getString("tip.match_anywhere"));
            this.putValue(AltHistory.FORWARD_EVEN_IF_NOT_SHOWING, true);
            Prefs.addListener((PrefListener)this, (String)"CommandHistoryMatchAnywhere");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdHistoryPrefs.setMatchAnywhere(true);
        }

        public void prefChanged(PrefEvent prefEvent) {
            AltHistory.this.setMatchAnywhere(CmdHistoryPrefs.getMatchAnywhere());
        }
    }

    private class MatchCaseAction
    extends MJAbstractAction
    implements PrefListener {
        MatchCaseAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandHistory", "match-case", (ExtendedAction)this);
            this.setComponentName("ToggleCaseSensitivity");
            this.setSelected(CmdHistoryPrefs.getMatchCase());
            this.setTip(sRes.getString("tip.match_case"));
            this.putValue(AltHistory.FORWARD_EVEN_IF_NOT_SHOWING, true);
            Prefs.addListener((PrefListener)this, (String)"CommandHistoryMatchCase");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!(actionEvent.getSource() instanceof AbstractButton)) {
                this.setSelected(!this.isSelected());
            }
            CmdHistoryPrefs.setMatchCase(this.isSelected());
        }

        public void prefChanged(PrefEvent prefEvent) {
            this.setSelected(CmdHistoryPrefs.getMatchCase());
            AltHistory.this.fTable.setCaseSensitiveMatching(this.isSelected());
            AltHistory.this.updateMatchIndicatorBar();
            AltHistory.this.updateMatchRecall();
        }
    }

    private class CreateShortcutAction
    extends MJAbstractAction {
        CreateShortcutAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandHistory", "create-shortcut-from-selection", (ExtendedAction)this);
            this.putValue(AltHistory.FORWARD_FROM_COMMAND_WINDOW, true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = AltHistory.this.fTable.getSelectedString();
            if (AltHistory.this.isAnchored()) {
                AltHistory.resetRecall();
                AltHistory.this.clearTextAfterPrompt();
            }
            ShortcutEditor.invoke(null, (String)string, (String)ShortcutUtils.getDefaultToolbarCategoryName());
        }
    }

    private class CreateMFileAction
    extends MJAbstractAction {
        CreateMFileAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandHistory", "create-mfile-from-selection", (ExtendedAction)this);
            this.putValue(AltHistory.FORWARD_FROM_COMMAND_WINDOW, true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLEditorServices.getEditorApplication().newEditor(AltHistory.this.fTable.getSelectedString());
            if (AltHistory.this.isAnchored()) {
                AltHistory.resetRecall();
                AltHistory.this.clearTextAfterPrompt();
            }
        }
    }

    private class ToggleErrorAction
    extends MJAbstractAction {
        private boolean iCausedError;

        ToggleErrorAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandHistory", "toggle-error-flag", (ExtendedAction)this);
            String string = "action.set_error_indicator";
            if (AltHistory.this.fTable.getSelectedRowCount() == 0) {
                this.setEnabled(false);
            } else {
                this.iCausedError = AltHistory.this.fTable.selectionCausedError();
                string = this.iCausedError ? "action.clear_error_indicator" : "action.set_error_indicator";
            }
            this.setName(sRes.getString(string));
            this.setComponentName("ToggleError");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AltHistory.this.fTable.setCausedErrorForSelection(!this.iCausedError);
        }
    }

    private class CopyToPromptAction
    extends MJAbstractAction {
        CopyToPromptAction() {
            this.setComponentName("CopyToPrompt");
            this.setAccelerator(KeyStroke.getKeyStroke(10, 1));
            this.putValue("ActionCommandKey", "copy-to-prompt");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AltHistory.this.copySelectionToPrompt();
            Desktop desktop = AltHistory.this.getParentDesktop();
            if (desktop != null) {
                desktop.setClientSelected((Component)((Object)CmdWin.getInstance()), true);
            }
        }
    }

    private class EvaluateAction
    extends MJAbstractAction {
        EvaluateAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandHistory", "evaluate-selection", (ExtendedAction)this);
            this.putValue(AltHistory.FORWARD_FROM_COMMAND_WINDOW, true);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AltHistory.this.evaluateSelection();
        }
    }

    private class PageSetupAction
    extends AbstractPageSetupAction {
        PageSetupAction() {
            ContextTargetingManager.setToolName((Action)((Object)this), (String)DTMenuMergeTag.PAGE_SETUP.toString());
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandHistory", "show-page-setup", (ExtendedAction)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AltHistory.this.blockDeactivationOnLinux();
            CmdHistoryPrinter.pageSetup();
        }
    }

    private class PrintSelectionAction
    extends MJAbstractAction {
        PrintSelectionAction() {
            ContextTargetingManager.setToolName((Action)((Object)this), (String)DTMenuMergeTag.PRINT_SELECTION.toString());
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandHistory", "print-selection", (ExtendedAction)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = AltHistory.this.blockDeactivationOnLinux();
            CmdHistoryPrinter.printCommands((JComponent)((Object)AltHistory.this.fTable), AltHistory.this.fTable.getSelectedCommands());
            runnable.run();
        }
    }

    private class PrintAction
    extends AbstractPrintAction {
        PrintAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandHistory", "print", (ExtendedAction)this);
            ContextTargetingManager.setToolName((Action)((Object)this), (String)DTMenuMergeTag.PRINT.toString());
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = AltHistory.this.blockDeactivationOnLinux();
            CmdHistoryPrinter.printCommands((JComponent)((Object)AltHistory.this.fTable), AltHistory.this.fCollection.getAllCommands());
            runnable.run();
        }
    }

    private class ClearAction
    extends MJAbstractAction {
        ClearAction() {
            super(sRes.getString("action.delete_entire_history"));
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandHistory", "clear-command-history", (ExtendedAction)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Runnable runnable = AltHistory.this.blockDeactivationOnLinux();
            int n = MJOptionPane.showConfirmDialog((Component)((Object)AltHistory.this), (Object)sRes.getString("message.delete_entire_history"), (String)TITLE, (int)0);
            runnable.run();
            if (n == 0) {
                AltHistory.clear();
            }
        }
    }

    private class DeleteAction
    extends MJAbstractAction {
        DeleteAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandHistory", "delete-next", (ExtendedAction)this);
            this.putValue(AltHistory.FORWARD_FROM_COMMAND_WINDOW, true);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AltHistory.this.fTable.deleteSelectedCommands();
            if (AltHistory.this.isAnchored()) {
                AltHistory.this.fBlockReset = true;
                try {
                    CmdWinDocument.getInstance().removeCurrentPromptLine();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                AltHistory.this.fBlockReset = false;
            }
        }
    }

    private class InsertTimeStampAction
    extends MJAbstractAction {
        InsertTimeStampAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandHistory", "inset-time-stamp", (ExtendedAction)this);
            this.setComponentName("InsertTimeStamp");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AltHistory.this.fCollection.addTimeStamp();
        }
    }

    private class FindAction
    extends MJAbstractAction {
        FindAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandHistory", "find-and-replace", (ExtendedAction)this);
            this.putValue(AltHistory.FORWARD_FROM_COMMAND_WINDOW, true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AltHistory.this.startFind();
        }
    }

    private class SelectAllAction
    extends MJAbstractAction {
        SelectAllAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandHistory", "select-all", (ExtendedAction)this);
            ContextTargetingManager.setToolName((Action)((Object)this), (String)DTMenuMergeTag.SELECT_ALL.toString());
            this.putValue(AltHistory.FORWARD_FROM_COMMAND_WINDOW, true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AltHistory.this.fTable.selectAll();
        }
    }

    private class UndoAction
    extends MJAbstractAction {
        UndoAction() {
            this.setComponentName("UndoDelete");
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandHistory", "undo", (ExtendedAction)this);
            ContextTargetingManager.setToolName((Action)((Object)this), (String)DTMenuMergeTag.UNDO.toString());
            this.setName(sRes.getString("action.undo_delete"));
            this.putValue(AltHistory.FORWARD_FROM_COMMAND_WINDOW, true);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ((MJScrollPane)AltHistory.this.fScroller).isAtBottom();
            final Point point = AltHistory.this.fScroller.getViewport().getViewPosition();
            AltHistory.this.fTable.undoLastDeletion();
            AltHistory.this.hideEmptyLabel();
            AltHistory.this.updateUndoAction();
            if (bl) {
                AltHistory.this.fTable.scrollToBottom();
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AltHistory.this.fScroller.getViewport().setViewPosition(point);
                    }
                });
            }
        }
    }

    private class CopyAction
    extends AbstractCopyAction {
        CopyAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandHistory", "copy-to-clipboard", (ExtendedAction)this);
            ContextTargetingManager.setToolName((Action)((Object)this), (String)DTMenuMergeTag.COPY.toString());
            this.putValue(AltHistory.FORWARD_FROM_COMMAND_WINDOW, true);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AltHistory.this.fTable.copySelectedCommands();
        }
    }

    private class CutAction
    extends AbstractCutAction {
        CutAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandHistory", "cut-to-clipboard", (ExtendedAction)this);
            ContextTargetingManager.setToolName((Action)((Object)this), (String)DTMenuMergeTag.CUT.toString());
            this.putValue(AltHistory.FORWARD_FROM_COMMAND_WINDOW, true);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AltHistory.this.fTable.cutSelectedCommands();
            if (AltHistory.this.isAnchored()) {
                AltHistory.this.clearTextAfterPrompt();
            }
        }
    }

    private class CommandWindowKeyListener
    extends KeyAdapter {
        private CommandWindowKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            Action action;
            Object object;
            int n = keyEvent.getModifiers();
            if (((n & 0x2E) != 0 || keyEvent.isActionKey() || keyEvent.getKeyCode() == 127) && AltHistory.this.isAnchored() && XCmdWndView.getInstance().getSelectionStart() == XCmdWndView.getInstance().getSelectionEnd() && (object = AltHistory.this.fTable.getInputMap().get(KeyStroke.getKeyStrokeForEvent(keyEvent))) != null && (!object.equals(AltHistory.this.fDeleteAction.getActionID()) || XCmdWndView.getInstance().getCaret().getDot() >= CmdWinDocument.getInstance().getLength()) && (action = AltHistory.this.fTable.getActionMap().get(object)) != null && action.isEnabled() && (AltHistory.this.isShowing() && action.getValue(AltHistory.FORWARD_FROM_COMMAND_WINDOW) == Boolean.TRUE || action.getValue(AltHistory.FORWARD_EVEN_IF_NOT_SHOWING) == Boolean.TRUE)) {
                action.actionPerformed(new ActionEvent(XCmdWndView.getInstance(), 1001, (String)action.getValue("ActionCommandKey"), n));
                keyEvent.consume();
            }
        }
    }

    private class PopupVisibilityListener
    extends ComponentAdapter {
        private Window iWindow;
        private boolean iPushedPrompt;

        private PopupVisibilityListener(Window window) {
            this.iWindow = window;
            window.addComponentListener(this);
        }

        private void dispose() {
            this.restoreCommandWindow();
            this.iWindow.removeComponentListener(this);
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            if (AltHistory.this.isAnchored()) {
                MJScrollPane mJScrollPane = XCmdWndView.getInstance().getScrollPane();
                if (!mJScrollPane.getHorizontalScrollBar().isVisible()) {
                    mJScrollPane.setHorizontalScrollBarPolicy(31);
                }
                Point point = AltHistory.this.getPromptLocation();
                Rectangle rectangle = this.iWindow.getBounds();
                int n = rectangle.y + rectangle.height;
                if (n > point.y + 1) {
                    XCmdWndView.getInstance().pushPrompt(n - point.y);
                    this.iPushedPrompt = true;
                }
            }
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            this.restoreCommandWindow();
            if (AltHistory.this.isAnchored()) {
                if (AltHistory.this.fMatchTextField != null) {
                    AltHistory.this.fMatchTextField.setText("");
                    AltHistory.this.fTextToMatch = null;
                }
                if (AltHistory.showDotDotDotForMultiSelectWhenAnchored()) {
                    CmdWinEditorKit.appendRecalledCommands();
                } else {
                    XCmdWndView.getInstance().scrollToBottom();
                }
            }
        }

        private void restoreCommandWindow() {
            MJScrollPane mJScrollPane = XCmdWndView.getInstance().getScrollPane();
            if (mJScrollPane.getHorizontalScrollBarPolicy() == 31) {
                mJScrollPane.setHorizontalScrollBarPolicy(30);
                XCmdWndView.getInstance().revalidate();
                XCmdWndView.getInstance().scrollToBottom();
            }
            if (this.iPushedPrompt) {
                XCmdWndView.getInstance().popPrompt();
                this.iPushedPrompt = false;
            }
        }
    }

    private class FocusAppearanceUpdater
    implements FocusListener {
        private FocusAppearanceUpdater() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.updateAppearance();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary() || !AltHistory.this.isDocked() && !AltHistory.this.isAnchored() || focusEvent.getOppositeComponent() == null || WindowUtils.getTopmostWindow((Component)focusEvent.getComponent()) != WindowUtils.getTopmostWindow((Component)focusEvent.getOppositeComponent())) {
                this.updateAppearance();
            }
        }

        private void updateAppearance() {
            boolean bl;
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            boolean bl2 = bl = component != null && (component == AltHistory.this.fTable || component == AltHistory.this.fMatchTextField || AltHistory.this.isAnchored() && component == XCmdWndView.getInstance());
            if (bl) {
                AltHistory.this.fTable.useFocusedSelectionColors();
            } else {
                AltHistory.this.fTable.useUnfocusedSelectionColors();
            }
        }
    }

    private class CommandWindowClientListener
    extends DTClientAdapter {
        private boolean iIsShowPending;

        private CommandWindowClientListener() {
        }

        public void clientDocking(DTClientEvent dTClientEvent) {
            this.hideHistory();
        }

        public void clientUndocking(DTClientEvent dTClientEvent) {
            this.hideHistory();
        }

        public void clientDocked(DTClientEvent dTClientEvent) {
            this.showHistory();
            AltHistory.this.hidePopup();
        }

        public void clientUndocked(DTClientEvent dTClientEvent) {
            this.showHistory();
        }

        private void hideHistory() {
            Desktop desktop = AltHistory.this.getParentDesktop();
            if (desktop.isClientShowing(AltHistory.CLIENT_NAME) && AltHistory.this.isAnchored()) {
                desktop.closeClient(AltHistory.CLIENT_NAME);
                this.iIsShowPending = true;
            }
        }

        private void showHistory() {
            if (this.iIsShowPending) {
                DTOnTopWindow.setSuppressCollapseAnimation((boolean)true);
                AltHistory.this.getParentDesktop().showClient(AltHistory.CLIENT_NAME);
                DTOnTopWindow.setSuppressCollapseAnimation((boolean)false);
                this.iIsShowPending = false;
            }
        }
    }

    private class HistoryClientListener
    extends DTClientAdapter {
        private HistoryClientListener() {
        }

        public void clientOpened(DTClientEvent dTClientEvent) {
            if (!AltHistory.this.fClientOpened) {
                AltHistory.this.fClientOpened = true;
                XCmdWndView.getInstance().addFocusListener(AltHistory.this.fFocusAppearanceUpdater);
                XCmdWndView.getInstance().addKeyListener(new CommandWindowKeyListener());
                AltHistory.this.setMatchToolBarVisible(AltHistory.this.fShowMatchToolBarAction.isSelected());
                AltHistory.this.fUpperRightActionsButton = AltHistory.this.createShowActionsButton();
                AltHistory.this.fUpperRightActionsButton.setName("Command History Actions Floating Button");
                AltHistory.this.fUpperRightActionsButton.setOpaque(true);
                AltHistory.this.fUpperRightActionsButton.setBackground(AltHistory.this.getBackground());
                AltHistory.this.updateUpperRightActionButtonVisibility();
                AltHistory.this.fAlignmentPanel.add((Component)AltHistory.this.fUpperRightActionsButton, JLayeredPane.PALETTE_LAYER);
                if (AltHistory.this.fBackupDialogPane != null) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AltHistory.this._showPopup();
                        }
                    });
                }
            }
        }

        public void clientClosed(DTClientEvent dTClientEvent) {
        }

        public void clientUndocking(DTClientEvent dTClientEvent) {
            final Desktop desktop = AltHistory.this.getParentDesktop();
            if (desktop.isClientSelected((Component)((Object)AltHistory.this))) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        desktop.setClientSelected((Component)((Object)CmdWin.getInstance()), true);
                    }
                });
            }
        }

        public void clientDocked(DTClientEvent dTClientEvent) {
            AltHistory.this.dissociateWithCommandWindow();
            AltHistory.this.updateColors();
            boolean bl = CmdHistoryPrefs.getShowExecutionTimeWhenDocked();
            AltHistory.this.fTable.setTimeColumnVisible(bl);
            AltHistory.this.fTable.useUnfocusedSelectionColors();
            AltHistory.this.fShowExecutionTimeAction.setSelected(bl);
            boolean bl2 = CmdHistoryPrefs.getShowMatchBarWhenDocked();
            AltHistory.this.setMatchToolBarVisible(bl2);
            AltHistory.this.fShowMatchToolBarAction.setSelected(bl2);
            AltHistory.this.updateToolBarActionsButtonVisibility();
            AltHistory.this.updateUpperRightActionButtonVisibility();
            AltHistory.this.updateLocationDependentActions();
        }

        public void clientUndocked(DTClientEvent dTClientEvent) {
            AltHistory.this.cancelFind();
            AltHistory.resetRecall();
            AltHistory.this.updateColors();
            boolean bl = CmdHistoryPrefs.getShowExecutionTime();
            AltHistory.this.fTable.setTimeColumnVisible(bl);
            AltHistory.this.fShowExecutionTimeAction.setSelected(bl);
            boolean bl2 = CmdHistoryPrefs.getShowMatchToolBar();
            if (bl2) {
                AltHistory.this.setMatchToolBarTemporary(false);
            }
            AltHistory.this.setMatchToolBarVisible(bl2);
            AltHistory.this.fShowMatchToolBarAction.setSelected(bl2);
            AltHistory.this.updateToolBarActionsButtonVisibility();
            AltHistory.this.updateUpperRightActionButtonVisibility();
        }

        public void clientTornOff(DTClientEvent dTClientEvent) {
            AltHistory.this.dissociateWithCommandWindow();
            AltHistory.this.updateToolBarActionsButtonVisibility();
            AltHistory.this.updateUpperRightActionButtonVisibility();
            AltHistory.this.updateLocationDependentActions();
        }

        public void clientAnchored(DTClientEvent dTClientEvent) {
            AltHistory.this.fTable.clearSelection();
            AltHistory.this.fTable.scrollToBottom();
            AltHistory.this.fTable.useFocusedSelectionColors();
            AltHistory.this.updateToolBarActionsButtonVisibility();
            AltHistory.this.updateUpperRightActionButtonVisibility();
            AltHistory.this.updateLocationDependentActions();
        }

        public void clientResized(DTClientEvent dTClientEvent) {
            if (AltHistory.this.isAnchored() && !AltHistory.this.fEmptyLabel.isVisible()) {
                Window window = SwingUtilities.windowForComponent((Component)((Object)AltHistory.this));
                Rectangle rectangle = window.getBounds();
                if (rectangle.height != AltHistory.this.fLastComputedHeight) {
                    Prefs.setIntegerPref((String)"AltHistoryPopupHeight", (int)rectangle.height);
                }
                if (rectangle.width != AltHistory.this.fLastComputedWidth) {
                    Prefs.setIntegerPref((String)"AltHistoryPopupWidth", (int)rectangle.width);
                }
            }
        }
    }

    private class PreferenceListener
    implements FontListener,
    PrefListener {
        private PreferenceListener() {
        }

        public void fontChanged(Font font) {
            AltHistory.this.setFont(font);
        }

        public void prefChanged(PrefEvent prefEvent) {
            if (prefEvent.getPrefKey().equals("ColorsBackground")) {
                AltHistory.this.updateBackgroundColor();
            }
            if (prefEvent.getPrefKey().equals("ColorsText")) {
                AltHistory.this.updateForegroundColor();
            }
        }
    }

    private class LocalMouseListener
    extends MouseAdapter {
        private LocalMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Window window;
            if (AltHistory.this.isAnchored() && !(window = SwingUtilities.windowForComponent((Component)((Object)AltHistory.this))).getFocusableWindowState()) {
                XCmdWndView.getInstance().requestFocus();
            }
            if (mouseEvent.isPopupTrigger()) {
                AltHistory.this.showContextMenu(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), null);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                AltHistory.this.showContextMenu(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), null);
            } else if (mouseEvent.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                AltHistory.this.evaluateSelection();
            }
        }
    }

    private class AlignmentPanel
    extends MJLayeredPane
    implements TableModelListener {
        private AlignmentPanel() {
            this.setLayout(null);
            this.add(AltHistory.this.fScroller);
            this.add(AltHistory.this.fEmptyLabel);
            if (AltHistory.this.fBackupDialogPane != null) {
                this.add(AltHistory.this.fBackupDialogPane);
            }
            AltHistory.this.fTable.getModel().addTableModelListener(this);
            AltHistory.this.fScroller.getVerticalScrollBar().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                    if (AltHistory.this.isAnchored()) {
                        AlignmentPanel.this.revalidate();
                    }
                }

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    if (AltHistory.this.isAnchored()) {
                        AlignmentPanel.this.revalidate();
                    }
                }
            });
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (AltHistory.this.isAnchored() && this.isShowing()) {
                this.revalidate();
                this.repaint();
            }
        }

        public void doLayout() {
            int n;
            Cloneable cloneable;
            int n2 = this.getWidth();
            int n3 = this.getHeight();
            Insets insets = this.getInsets();
            int n4 = n2 - insets.left - insets.right;
            int n5 = n3 - insets.top - insets.bottom;
            int n6 = insets.left;
            int n7 = insets.top;
            if (AltHistory.this.fBackupDialogPane != null) {
                cloneable = AltHistory.this.fBackupDialogPane.getPreferredSize();
                AltHistory.this.fBackupDialogPane.setBounds(n6, n7, n4, cloneable.height);
                n7 += cloneable.height;
                n5 -= cloneable.height;
            }
            if (AltHistory.this.fScroller.isVisible()) {
                cloneable = new Rectangle(n6, n7, n4, n5);
                if (AltHistory.this.isAnchored() && (n = ((AltHistory)AltHistory.this).fTable.getPreferredSize().height) < n5) {
                    int n8 = n5 - n;
                    ((Rectangle)cloneable).y += n8;
                    ((Rectangle)cloneable).height -= n8;
                }
                AltHistory.this.fScroller.setBounds((Rectangle)cloneable);
            } else if (AltHistory.this.fEmptyLabel.isVisible()) {
                AltHistory.this.fEmptyLabel.setBounds(n6, n7, n4, ((AltHistory)AltHistory.this).fEmptyLabel.getPreferredSize().height);
            }
            if (AltHistory.this.fUpperRightActionsButton != null && AltHistory.this.fUpperRightActionsButton.isVisible()) {
                cloneable = AltHistory.this.fUpperRightActionsButton.getPreferredSize();
                n = n2 - insets.right - cloneable.width - 3;
                if (AltHistory.this.fScroller.isVisible() && AltHistory.this.fScroller.getVerticalScrollBar().isVisible()) {
                    n -= ((AltHistory)AltHistory.this).fScroller.getVerticalScrollBar().getPreferredSize().width;
                }
                AltHistory.this.fUpperRightActionsButton.setBounds(n, insets.top + 2, cloneable.width, cloneable.height);
            }
        }
    }

    private static class CorrectedMessagePanel
    extends MessagePanel {
        private CorrectedMessagePanel(MessageModel<?> messageModel, MessagePanelPainter<?> messagePanelPainter) {
            super(messageModel, messagePanelPainter);
        }

        public int getMessageBarPercentage(double d) {
            return (int)((double)(this.getHeight() - 42) * d);
        }

        public void paint(Graphics graphics) {
            graphics.setColor(INDICATOR_BAR_BACKGROUND_COLOR);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paint(graphics);
        }
    }

    public static interface RecallListener {
        public void commandRecalled(String[] var1);
    }
}

