/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdhist;

import com.mathworks.mde.cmdhist.CmdHistoryPrefs;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.SpinnerNumberModel;

public class CmdHistoryPrefsPanel
extends MJPanel {
    private static CmdHistoryPrefsPanel sPrefsPanel = null;
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mde.cmdhist.resources.RES_CmdHist");
    private MJCheckBox fSaveExitCheckbox;
    private MJCheckBox fSaveDupCheckbox;
    private JCheckBox fDontSaveCheckbox;
    private MJSpinner fSaveCapacitySpinner;
    private MJRadioButton fMatchAnywhereRadioButton;
    private MJRadioButton fMatchBeginningRadioButton;
    private MJCheckBox fMatchCaseCheckbox;
    private MJCheckBox fFilterMatchesCheckbox;
    private MJCheckBox fShowMatchToolBarCheckbox;
    private MJCheckBox fShowMatchLocationsCheckbox;
    private MJCheckBox fShowExecutionTimeCheckbox;
    private ControlUpdater fControlUpdater = new ControlUpdater();

    public CmdHistoryPrefsPanel() {
        this.setName("CommandHistoryPrefsPanel");
        int n = CmdHistoryPrefs.getHistoryOptions();
        this.setLayout((LayoutManager)new MGridLayout(0, 1, 4, 4, 131072));
        this.fSaveExitCheckbox = new MJCheckBox(sRes.getString("chpp.filter.exit"), (n & 8) != 0);
        this.fSaveExitCheckbox.setName("ExitCheckbox");
        this.fSaveDupCheckbox = new MJCheckBox(sRes.getString("chpp.filter.dups"), (n & 4) != 0);
        this.fSaveDupCheckbox.setName("DupsCheckbox");
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridLayout(4, 1));
        mJPanel.setBorder(BorderFactory.createTitledBorder(sRes.getString("chpp.save.groupbox")));
        this.fDontSaveCheckbox = new MJCheckBox(sRes.getString("chpp.nosave.checkbox"), CmdHistoryPrefs.getNumCommandsToSave() == -1);
        this.fDontSaveCheckbox.setName("SaveToFileCheckbox");
        mJPanel.add((Component)this.fSaveExitCheckbox);
        mJPanel.add((Component)this.fSaveDupCheckbox);
        mJPanel.add(this.fDontSaveCheckbox);
        this.fSaveCapacitySpinner = new MJSpinner(new SpinnerNumberModel(CmdHistoryPrefs.getCommandCapacity(), 1, 1000000, 5000)){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                JComponent jComponent = this.getEditor();
                String string = String.format("%d$,", 1000000);
                dimension.width = jComponent.getFontMetrics(jComponent.getFont()).stringWidth(string) + 20;
                return dimension;
            }
        };
        this.fSaveCapacitySpinner.setName("SaveCapacitySpinner");
        this.fSaveCapacitySpinner.setDefaultEditorAccessibleName(sRes.getString("chpp.save_capacity.spinner"));
        String string = sRes.getString("chpp.save_capacity");
        int n2 = string.indexOf("{0}");
        String string2 = string.substring(0, n2 - 1);
        String string3 = string.substring(n2 + 4, string.length());
        MJPanel mJPanel2 = new MJPanel(){

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        mJPanel2.setLayout(new BoxLayout((Container)mJPanel2, 0));
        mJPanel2.add((Component)new MJLabel(string2));
        mJPanel2.add(Box.createHorizontalStrut(3));
        mJPanel2.add((Component)this.fSaveCapacitySpinner);
        mJPanel2.add(Box.createHorizontalStrut(3));
        mJPanel2.add((Component)new MJLabel(string3));
        mJPanel2.add(Box.createHorizontalGlue());
        mJPanel.add((Component)mJPanel2);
        this.add((Component)mJPanel);
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new GridLayout(4, 1));
        mJPanel3.setBorder(BorderFactory.createTitledBorder(sRes.getString("chpp.match.groupbox")));
        this.fMatchAnywhereRadioButton = new MJRadioButton(sRes.getString("chpp.match_anywhere"), CmdHistoryPrefs.getMatchAnywhere());
        this.fMatchAnywhereRadioButton.setName("MatchAnywhereRadioButton");
        this.fMatchBeginningRadioButton = new MJRadioButton(sRes.getString("chpp.match_beginning"), !CmdHistoryPrefs.getMatchAnywhere());
        this.fMatchBeginningRadioButton.setName("MatchBeginningRadioButton");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.fMatchAnywhereRadioButton);
        buttonGroup.add((AbstractButton)this.fMatchBeginningRadioButton);
        this.fMatchCaseCheckbox = new MJCheckBox(sRes.getString("chpp.match_case"), CmdHistoryPrefs.getMatchCase());
        this.fMatchCaseCheckbox.setName("MatchCaseCheckbox");
        this.fFilterMatchesCheckbox = new MJCheckBox(sRes.getString("chpp.filter_matches"), CmdHistoryPrefs.getFilterMatches());
        this.fFilterMatchesCheckbox.setName("FilterMatchesCheckbox");
        mJPanel3.add((Component)this.fMatchAnywhereRadioButton);
        mJPanel3.add((Component)this.fMatchBeginningRadioButton);
        mJPanel3.add((Component)this.fMatchCaseCheckbox);
        mJPanel3.add((Component)this.fFilterMatchesCheckbox);
        this.add((Component)mJPanel3);
        MJPanel mJPanel4 = new MJPanel((LayoutManager)new GridLayout(3, 1));
        mJPanel4.setBorder(BorderFactory.createTitledBorder(sRes.getString("chpp.show.groupbox")));
        boolean bl = MatlabDesktopServices.getDesktop().isClientDocked("Command History");
        this.fShowMatchToolBarCheckbox = new MJCheckBox(sRes.getString("chpp.show_toolbar"), bl ? CmdHistoryPrefs.getShowMatchBarWhenDocked() : CmdHistoryPrefs.getShowMatchToolBar());
        this.fShowMatchToolBarCheckbox.setName("ShowMatchToolBarCheckbox");
        this.fShowMatchLocationsCheckbox = new MJCheckBox(sRes.getString("chpp.show_locations"), CmdHistoryPrefs.getShowMatchIndicatorBar());
        this.fShowMatchLocationsCheckbox.setName("ShowMatchLocationsCheckbox");
        this.fShowExecutionTimeCheckbox = new MJCheckBox(sRes.getString("chpp.show_time"), bl ? CmdHistoryPrefs.getShowExecutionTimeWhenDocked() : CmdHistoryPrefs.getShowExecutionTime());
        this.fShowExecutionTimeCheckbox.setName("ShowExecutionTimeCheckbox");
        mJPanel4.add((Component)this.fShowMatchToolBarCheckbox);
        mJPanel4.add((Component)this.fShowMatchLocationsCheckbox);
        mJPanel4.add((Component)this.fShowExecutionTimeCheckbox);
        this.add((Component)mJPanel4);
    }

    public static MJPanel createPrefsPanel() {
        if (sPrefsPanel != null) {
            CmdHistoryPrefsPanel.sPrefsPanel.fControlUpdater.dispose();
            sPrefsPanel = null;
        }
        sPrefsPanel = new CmdHistoryPrefsPanel();
        return sPrefsPanel;
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl && sPrefsPanel != null) {
            sPrefsPanel.saveOptions();
        }
    }

    private void saveOptions() {
        int n = 2;
        if (this.fSaveDupCheckbox.isSelected()) {
            n |= 4;
        }
        if (this.fSaveExitCheckbox.isSelected()) {
            n |= 8;
        }
        CmdHistoryPrefs.setHistoryOptions(n);
        int n2 = 1;
        if (this.fDontSaveCheckbox != null) {
            n2 = this.fDontSaveCheckbox.isSelected() ? -1 : 1;
        }
        CmdHistoryPrefs.setSaveNLines(n2);
        if (this.fSaveCapacitySpinner != null) {
            CmdHistoryPrefs.setCommandCapacity((Integer)this.fSaveCapacitySpinner.getValue());
        }
        CmdHistoryPrefs.setMatchAnywhere(this.fMatchAnywhereRadioButton.isSelected());
        CmdHistoryPrefs.setMatchCase(this.fMatchCaseCheckbox.isSelected());
        CmdHistoryPrefs.setFilterMatches(this.fFilterMatchesCheckbox.isSelected());
        if (MatlabDesktopServices.getDesktop().isClientDocked("Command History")) {
            CmdHistoryPrefs.setShowMatchBarWhenDocked(this.fShowMatchToolBarCheckbox.isSelected());
            CmdHistoryPrefs.setShowExecutionTimeWhenDocked(this.fShowExecutionTimeCheckbox.isSelected());
        } else {
            CmdHistoryPrefs.setShowMatchToolBar(this.fShowMatchToolBarCheckbox.isSelected());
            CmdHistoryPrefs.setShowExecutionTime(this.fShowExecutionTimeCheckbox.isSelected());
        }
        CmdHistoryPrefs.setShowMatchIndicatorBar(this.fShowMatchLocationsCheckbox.isSelected());
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env__commandhistory_prefs"};
    }

    private class ControlUpdater
    extends DTClientAdapter
    implements PrefListener {
        private ControlUpdater() {
            Prefs.addListener((PrefListener)this, (String)"CommandHistoryMatchCase");
            Prefs.addListener((PrefListener)this, (String)"CommandHistoryMatchAnywhere");
            Prefs.addListener((PrefListener)this, (String)"CommandHistoryFilterMatches");
            Prefs.addListener((PrefListener)this, (String)"CommandHistoryShowMatchBar");
            Prefs.addListener((PrefListener)this, (String)"CommandHistoryShowMatchBarWhenDocked");
            Prefs.addListener((PrefListener)this, (String)"CommandHistoryShowMachIndicatorBar");
            Prefs.addListener((PrefListener)this, (String)"CommandHistoryShowExecutionTime");
            Prefs.addListener((PrefListener)this, (String)"CommandHistoryShowExecutionTimeWhenDocked");
            MatlabDesktopServices.getDesktop().addClientListener("Command History", (DTClientListener)this);
        }

        private void dispose() {
            Prefs.removeListener((PrefListener)this);
            MatlabDesktopServices.getDesktop().removeClientListener("Command History", (DTClientListener)this);
        }

        public void prefChanged(PrefEvent prefEvent) {
            boolean bl = MatlabDesktopServices.getDesktop().isClientDocked("Command History");
            switch (prefEvent.getPrefKey()) {
                case "CommandHistoryMatchCase": {
                    CmdHistoryPrefsPanel.this.fMatchCaseCheckbox.setSelected(CmdHistoryPrefs.getMatchCase());
                    break;
                }
                case "CommandHistoryMatchAnywhere": {
                    CmdHistoryPrefsPanel.this.fMatchAnywhereRadioButton.setSelected(CmdHistoryPrefs.getMatchAnywhere());
                    CmdHistoryPrefsPanel.this.fMatchBeginningRadioButton.setSelected(!CmdHistoryPrefs.getMatchAnywhere());
                    break;
                }
                case "CommandHistoryFilterMatches": {
                    CmdHistoryPrefsPanel.this.fFilterMatchesCheckbox.setSelected(CmdHistoryPrefs.getFilterMatches());
                    break;
                }
                case "CommandHistoryShowMatchBar": {
                    if (bl) break;
                    CmdHistoryPrefsPanel.this.fShowMatchToolBarCheckbox.setSelected(CmdHistoryPrefs.getShowMatchToolBar());
                    break;
                }
                case "CommandHistoryShowMatchBarWhenDocked": {
                    if (!bl) break;
                    CmdHistoryPrefsPanel.this.fShowMatchToolBarCheckbox.setSelected(CmdHistoryPrefs.getShowMatchBarWhenDocked());
                    break;
                }
                case "CommandHistoryShowMachIndicatorBar": {
                    CmdHistoryPrefsPanel.this.fShowMatchLocationsCheckbox.setSelected(CmdHistoryPrefs.getShowMatchIndicatorBar());
                    break;
                }
                case "CommandHistoryShowExecutionTime": {
                    if (bl) break;
                    CmdHistoryPrefsPanel.this.fShowExecutionTimeCheckbox.setSelected(CmdHistoryPrefs.getShowExecutionTime());
                    break;
                }
                case "CommandHistoryShowExecutionTimeWhenDocked": {
                    if (!bl) break;
                    CmdHistoryPrefsPanel.this.fShowExecutionTimeCheckbox.setSelected(CmdHistoryPrefs.getShowExecutionTimeWhenDocked());
                }
            }
        }

        public void clientDocked(DTClientEvent dTClientEvent) {
            CmdHistoryPrefsPanel.this.fShowMatchToolBarCheckbox.setSelected(CmdHistoryPrefs.getShowMatchBarWhenDocked());
            CmdHistoryPrefsPanel.this.fShowExecutionTimeCheckbox.setSelected(CmdHistoryPrefs.getShowExecutionTimeWhenDocked());
        }

        public void clientUndocked(DTClientEvent dTClientEvent) {
            CmdHistoryPrefsPanel.this.fShowMatchToolBarCheckbox.setSelected(CmdHistoryPrefs.getShowMatchToolBar());
            CmdHistoryPrefsPanel.this.fShowExecutionTimeCheckbox.setSelected(CmdHistoryPrefs.getShowExecutionTime());
        }
    }
}

