/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdwin;

import com.mathworks.mde.cmdhist.AltHistory;
import com.mathworks.mde.cmdwin.CmdWinDocument;
import com.mathworks.mde.cmdwin.CmdWinDocumentUtilities;
import com.mathworks.mde.cmdwin.CmdWinMLIF;
import com.mathworks.mde.cmdwin.CmdWinPrefs;
import com.mathworks.mde.cmdwin.CmdWinTextUtilities;
import com.mathworks.mde.cmdwin.CmdWinUndoManager;
import com.mathworks.mde.cmdwin.Prompt;
import com.mathworks.mde.cmdwin.TabCompletionImpl;
import com.mathworks.mde.cmdwin.XCaret;
import com.mathworks.mde.cmdwin.XCmdWndView;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.find.FindFiles;
import com.mathworks.mde.functionbrowser.FunctionBrowser;
import com.mathworks.mde.functionhints.FunctionHints;
import com.mathworks.mlwidgets.help.HelpPopup;
import com.mathworks.mlwidgets.tabcompletion.TabCompletionAction;
import com.mathworks.mlwidgets.tabcompletion.TabCompletionInterface;
import com.mathworks.mwswing.ClipboardListener;
import com.mathworks.mwswing.ClipboardMonitor;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.binding.ActionData;
import com.mathworks.mwswing.binding.Context;
import com.mathworks.mwswing.binding.KeyBindingManager;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.text.MTextAction;
import com.mathworks.services.Prefs;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.StringUtils;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.im.InputContext;
import java.text.CharacterIterator;
import java.text.MessageFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;

public class CmdWinEditorKit
extends DefaultEditorKit
implements ClipboardListener {
    private static ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mde.cmdwin.resources.RES_CmdWin");
    private static Hashtable<String, Action> sDefaultActionTable = new Hashtable();
    private static Hashtable<String, Action> sActionTable = new Hashtable();
    private static TabCompletionAction sCWTabAction = new CWTabCompletionAction();
    private static CmdWinUndoManager sCmdWinUndoMgr = null;
    public static final String insertBreakAction = "insert-break";
    public static final String selectWordAction = "select-word";
    public static final String insertTabAction = "insert-tab";
    public static final String deletePrevCharAction = "delete-previous";
    public static final String defaultKey = "default-typed";
    public static final String deleteNextCharAction = "delete-next";
    public static final String cwDownHistory = "next-history-item";
    public static final String cwUpHistory = "previous-history-item";
    public static final String beginLineAction = "caret-begin-line";
    public static final String endLineAction = "caret-end-line";
    public static final String undoAction = "undo";
    public static final String redoAction = "redo";
    public static final String escAction = "clear-text-at-prompt";
    public static final String killCutAction = "kill-line";
    public static final String cutAction = "cut-to-clipboard";
    public static final String copyAction = "copy-to-clipboard";
    public static final String pasteAction = "paste-from-clipboard";
    public static final String breakAction = "break-interrupt";
    public static final String selectionBeginLineAction = "selection-begin-line";
    public static final String selectionEndLineAction = "selection-end-line";
    public static final String evaluateSelection = "evaluate-selection";
    public static final String selectLineAction = "select-line";
    public static final String clearWindow = "clear-command-window";
    public static final String helpOnSelection = "help-on-selection";
    public static final String openSelection = "open-selection";
    public static final String print = "print";
    public static final String dropLine = "drop-line";
    public static final String pageSetup = "show-page-setup";
    public static final String printSelection = "print-selection";
    public static final String findString = "find-and-replace";
    public static final String findFilesString = "find-files";
    public static final String incForwardString = "inc-search-forward";
    public static final String incBackwardString = "inc-search-backward";
    public static final String pageUpAction = "page-up";
    public static final String pageDownAction = "page-down";
    public static final String endAction = "caret-end";
    public static final String beginAction = "caret-begin";
    public static final String ctrlReturnAction = "open-errored-file";
    public static final String nextWordAction = "caret-next-word";
    public static final String previousWordAction = "caret-previous-word";
    public static final String selNextWordAction = "selection-next-word";
    public static final String selPreviousWordAction = "selection-previous-word";
    public static final String overWrite = "toggle-typing-mode";
    public static final String forwardAction = "caret-forward";
    public static final String backwardAction = "caret-backward";
    public static final String upAction = "caret-up";
    public static final String downAction = "caret-down";
    public static final String scrollTop = "adjust-window-top";
    public static final String scrollBottom = "adjust-window-bottom";
    public static final String openFunctionBrowser = "function-browser-key";
    public static final String showFunctionBrowserButton = "show-funcbrowser-btn";
    public static final String openFunctionHints = "function-hints-key";
    public static final String selectPageUpAction = "selection-page-up";
    public static final String selectPageDownAction = "selection-page-down";
    public static final String showHistoryAction = "show-history";
    private static final Action[] sCWActions = new Action[]{new CWDefaultKeyTypedAction(), new CWOverwrite(), new CWReturnAction(), sCWTabAction, new CWDeleteNextCharAction(), new CWDeletePrevCharAction(), new CWDownHistoryAction(), new CWUpHistoryAction(), new SelectWordAction(), new CWBeginLineAction("caret-begin-line", false), new CWBeginLineAction("selection-begin-line", true), new CWEndLineAction("caret-end-line", false), new CWEndLineAction("selection-end-line", true), new CWSelectLineAction(), new CWUndoAction(), new CWRedoAction(), new CWEscAction(), new CWKillCutAction(), new CWCutAction(), new CWCopyAction(), new CWPasteAction(), new CWNavigationAction("page-up"), new CWNavigationAction("page-down"), new CWNavigationAction("caret-end"), new CWNavigationAction("caret-begin"), new CWBreakAction(), new EvaluateAction(), new HelpAction(), new OpenSelAction(), new PrintAction(), new DropLineAction(), new PageSetupAction(), new PrintSelectionAction(), new FindAction(), new FindFilesAction(), new IncrementalSearchAction("inc-search-forward", true), new IncrementalSearchAction("inc-search-backward", false), new CWSelectAllAction(), new CtrlReturnAction(), new CWNextWordAction("caret-next-word", false), new CWPreviousWordAction("caret-previous-word", false), new CWNextWordAction("selection-next-word", true), new CWPreviousWordAction("selection-previous-word", true), new ClearCommandWindowAction(), new CWNextVisualPositionAction("caret-forward", 3), new CWNextVisualPositionAction("caret-backward", 7), new CWUpOrDownAction("caret-up"), new CWUpOrDownAction("caret-down"), new ScrollToTop(), new ScrollToBottom(), new FunctionBrowserAction(), new FunctionBrowserButtonShowAction(), new FunctionHintsAction(), new CWSelectionUpAction(), new CWSelectionDownAction(), new CWSelectPageUpAction(), new CWSelectPageDownAction(), new ShowHistoryAction()};
    private static final CmdWinDocument sCWDoc = CmdWinDocument.getInstance();
    private static StringCharacterIterator sHandyIterator = new StringCharacterIterator("h");
    private static String sLastHistoryCmd = "";
    private static String sLastCommandPrefixForHistory = null;
    private static Segment sSegmentForHistory = new Segment();
    private static boolean sRecallListenerAttached = false;
    private static boolean sInsertingRecalledCommand = false;
    private static boolean sSendingCommand = false;
    private static boolean sExtendingRecall = false;
    private static boolean sRecalledCommandsAppended = false;
    private static final Action sAppendRecalledCommandsAction = new AppendRecalledCommandsAction();
    private static final CmdWinEditorKit sCWKit = new CmdWinEditorKit();
    private static final int RECALL_RUN_THRESHOLD = 100;
    private static final int RECALL_APPEND_THRESHOLD = 100;
    private static final int RECALL_APPEND_LIMIT = 1000;

    private CmdWinEditorKit() {
        CmdWinEditorKit.createDefaultActionTable(this);
        CmdWinEditorKit.createActionTable();
        if (!PlatformInfo.isUnix()) {
            ClipboardMonitor.addListener((ClipboardListener)this);
            this.clipboardContentTypeChanged(ClipboardMonitor.getFlavors());
        }
        sCmdWinUndoMgr = CmdWinUndoManager.getInstance(this, sCWDoc, XCmdWndView.getInstance());
        sCWDoc.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (documentEvent.getOffset() >= sCWDoc.getAfterThePrompt()) {
                    this.changedUpdate(documentEvent);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                if (!sInsertingRecalledCommand) {
                    AltHistory.resetRecall();
                }
            }
        });
    }

    public void clipboardContentTypeChanged(DataFlavor[] dataFlavorArray) {
        boolean bl = false;
        if (dataFlavorArray != null) {
            for (int i = 0; i < dataFlavorArray.length && !bl; ++i) {
                bl = dataFlavorArray[i].equals(DataFlavor.stringFlavor);
            }
        }
        CmdWinEditorKit.getActionByName(pasteAction).setEnabled(bl);
    }

    static boolean containsWhitespace(CharacterIterator characterIterator) {
        char c = characterIterator.first();
        while (c != '\uffff') {
            if (Character.isWhitespace(c)) {
                return true;
            }
            c = characterIterator.next();
        }
        return characterIterator.getEndIndex() == 0;
    }

    private static void createActionTable() {
        Action[] actionArray = sCWActions;
        for (int i = 0; i < actionArray.length; ++i) {
            Action action = actionArray[i];
            Object object = action.getValue("ActionCommandKey");
            if (object == null) {
                object = action.getValue("Name");
            }
            sActionTable.put((String)object, action);
        }
    }

    private static void createDefaultActionTable(CmdWinEditorKit cmdWinEditorKit) {
        Action[] actionArray = cmdWinEditorKit.getDefaultActions();
        for (int i = 0; i < actionArray.length; ++i) {
            Action action = actionArray[i];
            sDefaultActionTable.put((String)action.getValue("Name"), action);
        }
    }

    @Override
    public Document createDefaultDocument() {
        return CmdWinDocument.getInstance();
    }

    @Override
    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), sCWActions);
    }

    static Action getActionByName(String string) {
        return sActionTable.get(string);
    }

    static Action getDefaultActionByName(String string) {
        return sDefaultActionTable.get(string);
    }

    private Action[] getDefaultActions() {
        return super.getActions();
    }

    static CmdWinEditorKit getInstance() {
        return sCWKit;
    }

    static void insertCommandAndSend(String string) throws BadLocationException {
        sCWDoc.setUserInitialized();
        XCaret.combineCarets();
        try {
            sCWDoc.clearSuggestion();
            sCWDoc.insertAtPrompt(string);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        int n = sCWDoc.getAfterThePrompt() + string.length();
        CmdWinEditorKit.sendCurrentCommand(n);
    }

    static void insertCommand(String string) throws BadLocationException {
        sCWDoc.setUserInitialized();
        XCaret.combineCarets();
        try {
            string = string + "\n";
            sCWDoc.insertAtPrompt(string);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        int n = sCWDoc.getAfterThePrompt() + string.length();
        if (string != null) {
            sHandyIterator.setText(string);
            if (!CmdWinEditorKit.isWhitespace(sHandyIterator)) {
                CmdWinEditorKit.sendCommandToHistory(string);
                sCWDoc.setPrompt(Prompt.NULL_PROMPT);
            }
        }
        AltHistory.resetRecall();
        try {
            sCWDoc.insertPrompt(n);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
            return;
        }
    }

    static boolean isWhitespace(CharacterIterator characterIterator) {
        char c = characterIterator.first();
        while (c != '\uffff') {
            if (!Character.isWhitespace(c)) {
                return false;
            }
            c = characterIterator.next();
        }
        return true;
    }

    static void sendCurrentCommand(int n) {
        int n2;
        String string;
        assert (EventQueue.isDispatchThread());
        sSendingCommand = true;
        try {
            if (sCWDoc.getInUsePrompt() == Prompt.TYPEAHEAD_PROMPT) {
                sCWDoc.setPrompt(Prompt.NULL_PROMPT);
                sCWDoc.replacePrompt();
                n -= Prompt.TYPEAHEAD_PROMPT.length();
            }
            if ((string = sCWDoc.getText(n2 = sCWDoc.getAfterThePrompt(), n - n2)) == null || !string.endsWith("\n")) {
                sInsertingRecalledCommand = true;
                sCWDoc.insertString(n, "\n", null);
                sInsertingRecalledCommand = false;
                ++n;
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
            sSendingCommand = false;
            return;
        }
        n2 = sCWDoc.getAfterThePrompt();
        string = null;
        try {
            string = sCWDoc.getText(n2, n - n2);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        if (string != null) {
            Object object;
            String[] stringArray = AltHistory.getRecalledCommands();
            if (!sRecalledCommandsAppended && stringArray.length > 1) {
                int n3;
                int n4;
                if (stringArray.length > 100 && (n4 = MJOptionPane.showConfirmDialog((Component)((Object)AltHistory.getInstance()), (Object)(MessageFormat.format(sRes.getString("message.commands_selected"), Integer.toString(stringArray.length)) + "\n" + sRes.getString("message.want_to_run")), (String)MessageFormat.format(sRes.getString("title.many_selected"), Integer.toString(100)), (int)0, (int)2)) == 1) {
                    AltHistory.resetRecall();
                    try {
                        sCWDoc.remove(n2, n - n2);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    sLastCommandPrefixForHistory = null;
                    sSendingCommand = false;
                    return;
                }
                object = new StringBuilder(string);
                for (int i = n3 = AltHistory.showDotDotDotForMultiSelect() ? 1 : 0; i < stringArray.length; ++i) {
                    ((StringBuilder)object).append(stringArray[i]);
                    ((StringBuilder)object).append('\n');
                }
                string = ((StringBuilder)object).toString();
            }
            sHandyIterator.setText(string);
            if (!CmdWinEditorKit.isWhitespace(sHandyIterator)) {
                CmdWinEditorKit.sendCommandToHistory(string);
                sCWDoc.setPrompt(Prompt.NULL_PROMPT);
            }
            if (AltHistory.isEvaluatingRecalledCommands()) {
                object = new StringTokenizer(string, "\n");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    CmdWinMLIF.doEval(((StringTokenizer)object).nextToken());
                }
            } else {
                CmdWinMLIF.doEval(string);
            }
        }
        AltHistory.resetRecall();
        try {
            sCWDoc.insertPrompt(n);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
            sSendingCommand = false;
            return;
        }
        sCmdWinUndoMgr.reset();
        sSendingCommand = false;
    }

    private static void sendCommandToHistory(String string) {
        if (CmdWinMLIF.isInBangMode()) {
            return;
        }
        string = string.trim();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            sHandyIterator.setText(string2);
            if (CmdWinEditorKit.isWhitespace(sHandyIterator)) continue;
            arrayList.add(string2.trim());
        }
        AltHistory.addCommands(arrayList);
    }

    private static void openFunctionHints(JTextComponent jTextComponent) {
        try {
            CurrentMCode currentMCode = new CurrentMCode(jTextComponent).getCurrentMCode();
            int n = currentMCode.getTextLength();
            int n2 = currentMCode.getOffsetOfCurrentPrompt();
            if (n > 0) {
                String string = sCWDoc.getText(n2, n);
                FunctionHints.openFunctionHintsSynchronously(jTextComponent, string);
            } else {
                FunctionHints.hidePopup();
            }
        }
        catch (BadLocationException badLocationException) {
            Log.log((String)badLocationException.toString());
        }
    }

    private static boolean isCurrentLineStartWithPromptStr(int n, int n2) throws BadLocationException {
        String[] stringArray;
        for (String string : stringArray = Prompt.getAllPromptStrings()) {
            if (!sCWDoc.getText(n, n2 - n).startsWith(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean isCurrentPromptEmpty() {
        return sCWDoc.getCurrentPrompt().toString().isEmpty();
    }

    private static void maybeOpenFunctionHints(JTextComponent jTextComponent, ActionEvent actionEvent) {
        if (!Prefs.getBooleanPref((String)"CommandWindowFunctionHints", (boolean)true)) {
            return;
        }
        try {
            CurrentMCode currentMCode = new CurrentMCode(jTextComponent).getCurrentMCode();
            int n = currentMCode.getTextLength();
            int n2 = currentMCode.getOffsetOfCurrentPrompt();
            if (n > 0) {
                String string = sCWDoc.getText(n2, n);
                FunctionHints.openFunctionHints(jTextComponent, string, actionEvent);
            } else {
                FunctionHints.hidePopup();
            }
        }
        catch (BadLocationException badLocationException) {
            Log.log((String)actionEvent.toString());
        }
    }

    private static void closeFunctionHints() {
        FunctionHints.hidePopup();
    }

    private static void closeHistoryPopup() {
        if (AltHistory.isPopupShowing()) {
            AltHistory.resetRecall();
        }
    }

    private static boolean doesCopyActionUseKeyStroke(KeyStroke keyStroke) {
        if (keyStroke == null) {
            return false;
        }
        KeyBindingManager keyBindingManager = MatlabKeyBindings.getManager();
        Context context = keyBindingManager.getContext("CommandWindow");
        ActionData actionData = keyBindingManager.getActionData(copyAction);
        List list = keyBindingManager.getCurrentKeyBindingSet().getKeyBindings(context, actionData);
        return list.contains(new KeyStrokeList(new KeyStroke[]{keyStroke}));
    }

    private static void selectWord(ActionEvent actionEvent, JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            try {
                int n = jTextComponent.getCaretPosition();
                int n2 = CmdWinTextUtilities.getWordStart(jTextComponent, n);
                int n3 = CmdWinTextUtilities.getWordEnd(jTextComponent, n);
                jTextComponent.setCaretPosition(n2);
                jTextComponent.moveCaretPosition(n3);
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
            }
        }
    }

    private static boolean multipleLinesAfterPrompt() {
        return CmdWinEditorKit.getTextAtPrompt().indexOf(10) >= 0;
    }

    private static String getTextAtPrompt() {
        try {
            sCWDoc.getCurrentPromptLine(sSegmentForHistory);
            return sSegmentForHistory.toString();
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertCommandFromHistory(boolean bl, boolean bl2) {
        String string;
        block16: {
            boolean bl3;
            sExtendingRecall = bl2;
            sRecalledCommandsAppended = false;
            if (!sRecallListenerAttached) {
                AltHistory.addRecallListener(new HistoryRecallListener());
                sRecallListenerAttached = true;
            }
            sCWDoc.clearSuggestion();
            string = CmdWinEditorKit.getTextAtPrompt();
            boolean bl4 = bl3 = string.indexOf(10) >= 0;
            if (bl2 || string == null || !bl3) break block16;
            XCmdWndView xCmdWndView = XCmdWndView.getInstance();
            int n = sCWDoc.getPromptOffset();
            int n2 = n >= 0 ? xCmdWndView.getLineOfOffset(n) : 0;
            int n3 = xCmdWndView.getLineOfOffset(xCmdWndView.getCaretPosition());
            String string2 = null;
            if (bl && n3 < xCmdWndView.getLineCount() - 1) {
                string2 = downAction;
            } else if (!bl && n3 > n2) {
                string2 = upAction;
            }
            if (string2 != null) {
                CmdWinEditorKit.getDefaultActionByName(string2).actionPerformed(new ActionEvent(xCmdWndView, 1001, string2));
            }
            AltHistory.resetRecall();
            XCmdWndView.getInstance().scrollToBottom();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    sExtendingRecall = false;
                }
            });
            return;
        }
        try {
            String string3;
            boolean bl5 = false;
            if (sLastCommandPrefixForHistory == null) {
                sLastCommandPrefixForHistory = string;
            } else {
                string = sLastCommandPrefixForHistory;
            }
            if (bl) {
                boolean bl6 = AltHistory.isPopupShowing();
                string3 = AltHistory.recallNext(string, bl2);
                bl5 = bl6 && !AltHistory.isPopupShowing();
            } else {
                string3 = AltHistory.recallPrevious(string, bl2);
            }
            if (string3 == null || string3.equals("")) {
                if (!bl5) {
                    Toolkit.getDefaultToolkit().beep();
                }
                sInsertingRecalledCommand = true;
                sCWDoc.removeCurrentPromptLine();
                sCWDoc.insertAtPrompt(sLastCommandPrefixForHistory);
                sLastCommandPrefixForHistory = null;
                sInsertingRecalledCommand = false;
            }
        }
        catch (BadLocationException badLocationException) {
            try {
                Log.logException((Exception)badLocationException);
            }
            catch (Throwable throwable) {
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            return;
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public static void appendRecalledCommands() {
        if (sSendingCommand) {
            return;
        }
        try {
            String[] stringArray = AltHistory.getRecalledCommands();
            if (stringArray.length > 1) {
                int n = CmdWinEditorKit.enforceAppendLimit(stringArray.length);
                if (n == 0) {
                    sCWDoc.removeCurrentPromptLine();
                    return;
                }
                if (AltHistory.willShowAsPopup() && !AltHistory.showDotDotDotForMultiSelect()) {
                    XCmdWndView.getInstance().getScrollPane().detachFromBottom();
                }
                int n2 = sCWDoc.getPromptLineEndOffset(false);
                sCWDoc.insertString(n2, "\n", null);
                ++n2;
                for (int i = 1; i < n; ++i) {
                    sCWDoc.insertString(n2, stringArray[i], null);
                    n2 += stringArray[i].length();
                    if (i >= n - 1) continue;
                    sCWDoc.insertString(n2, "\n", null);
                    ++n2;
                }
                if (AltHistory.showDotDotDotForMultiSelect()) {
                    XCmdWndView.getInstance().scrollToBottom();
                    AltHistory.resetRecall();
                } else if (AltHistory.willShowAsPopup()) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            XCmdWndView.getInstance().getScrollPane().anchorToBottom();
                        }
                    });
                }
                sRecalledCommandsAppended = true;
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
    }

    public static void appendCommands(String[] stringArray) {
        int n = CmdWinEditorKit.enforceAppendLimit(stringArray.length);
        try {
            if (n == 0) {
                sCWDoc.removeCurrentPromptLine();
                return;
            }
            int n2 = sCWDoc.getPromptLineEndOffset(false);
            for (int i = 0; i < n; ++i) {
                sCWDoc.insertString(n2, stringArray[i], null);
                n2 += stringArray[i].length();
                if (i >= stringArray.length - 1) continue;
                sCWDoc.insertString(n2, "\n", null);
                ++n2;
            }
            XCmdWndView.getInstance().scrollToBottom();
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
    }

    private static int enforceAppendLimit(int n) {
        int n2;
        if (n > 1000) {
            MJOptionPane.showMessageDialog((Component)((Object)AltHistory.getInstance()), (Object)(MessageFormat.format(sRes.getString("message.commands_selected"), Integer.toString(n)) + "\n" + sRes.getString("message.cant_display")), (String)MessageFormat.format(sRes.getString("title.many_selected"), Integer.toString(1000)), (int)2);
            n = 0;
        } else if (n > 100 && !sExtendingRecall && (n2 = MJOptionPane.showConfirmDialog((Component)((Object)AltHistory.getInstance()), (Object)(MessageFormat.format(sRes.getString("message.commands_selected"), Integer.toString(n)) + "\n" + sRes.getString("message.want_to_display")), (String)MessageFormat.format(sRes.getString("title.many_selected"), Integer.toString(100)), (int)0, (int)2)) == 1) {
            n = 0;
        }
        return n;
    }

    private static class CurrentMCode {
        private JTextComponent fTarget;
        private int fTextLength;
        private int fOffsetOfCurrentPrompt;

        public CurrentMCode(JTextComponent jTextComponent) {
            this.fTarget = jTextComponent;
        }

        public int getTextLength() {
            return this.fTextLength;
        }

        public int getOffsetOfCurrentPrompt() {
            return this.fOffsetOfCurrentPrompt;
        }

        public CurrentMCode getCurrentMCode() throws BadLocationException {
            this.fTextLength = 0;
            this.fOffsetOfCurrentPrompt = 0;
            if (!CmdWinEditorKit.isCurrentPromptEmpty()) {
                this.fTextLength = this.fTarget.getCaretPosition() - sCWDoc.getAfterThePrompt();
                this.fOffsetOfCurrentPrompt = sCWDoc.getAfterThePrompt();
            } else {
                Element element = sCWDoc.getDefaultRootElement();
                int n = element.getElementCount();
                int n2 = 0;
                for (int i = n - 1; i >= 0; --i) {
                    Element element2 = element.getElement(i);
                    int n3 = element2.getStartOffset();
                    int n4 = element2.getEndOffset();
                    assert (n4 >= n3);
                    if (!CmdWinEditorKit.isCurrentLineStartWithPromptStr(n3, n4)) continue;
                    n2 = n3;
                    break;
                }
                this.fTextLength = this.fTarget.getCaretPosition() - n2;
                this.fOffsetOfCurrentPrompt = n2;
            }
            return this;
        }
    }

    private static class AppendRecalledCommandsAction
    extends MJAbstractAction {
        private AppendRecalledCommandsAction() {
            super("...");
            this.setTip(sRes.getString("tip.append_commands") + " (Shift+Enter)");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdWinEditorKit.appendRecalledCommands();
        }
    }

    private static class HistoryRecallListener
    implements AltHistory.RecallListener {
        private HistoryRecallListener() {
        }

        @Override
        public void commandRecalled(String[] stringArray) {
            if (stringArray.length > 0) {
                try {
                    sInsertingRecalledCommand = true;
                    sCWDoc.removeCurrentPromptLine();
                    sCWDoc.insertAtPrompt(stringArray[0]);
                    sInsertingRecalledCommand = false;
                }
                catch (BadLocationException badLocationException) {
                    Log.logException((Exception)badLocationException);
                }
            }
            if (AltHistory.showDotDotDotForMultiSelect()) {
                XCmdWndView.getInstance().setMoreIndicator(stringArray.length > 1 ? sAppendRecalledCommandsAction : null);
            } else if (stringArray.length > 1) {
                sInsertingRecalledCommand = true;
                CmdWinEditorKit.appendRecalledCommands();
                sInsertingRecalledCommand = false;
            }
        }
    }

    private static class CWTabCompletionAction
    extends TabCompletionAction {
        private CWTabCompletionAction() {
            super((TabCompletionInterface)new TabCompletionImpl());
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandWindow", CmdWinEditorKit.insertTabAction, (ExtendedAction)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AltHistory.resetRecall();
            super.actionPerformed(actionEvent);
        }
    }

    private static class ShowHistoryAction
    extends CWTextAction {
        public ShowHistoryAction() {
            super(CmdWinEditorKit.showHistoryAction, false);
            this.setAccelerator(KeyStroke.getKeyStroke(38, 2));
            this.putValue("ActionCommandKey", CmdWinEditorKit.showHistoryAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AltHistory.showPopup();
        }
    }

    private static class CWSelectPageDownAction
    extends CWTextAction {
        private CWSelectPageDownAction() {
            super(CmdWinEditorKit.selectPageDownAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AltHistory.isPopupShowing()) {
                AltHistory.invokeTableAction("scrolDownpExtendSelection");
            } else {
                CmdWinEditorKit.getDefaultActionByName(CmdWinEditorKit.selectPageDownAction).actionPerformed(actionEvent);
            }
        }
    }

    private static class CWSelectPageUpAction
    extends CWTextAction {
        private CWSelectPageUpAction() {
            super(CmdWinEditorKit.selectPageUpAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AltHistory.isPopupShowing()) {
                AltHistory.invokeTableAction("scrollUpExtendSelection");
            } else {
                CmdWinEditorKit.getDefaultActionByName(CmdWinEditorKit.selectPageUpAction).actionPerformed(actionEvent);
            }
        }
    }

    private static class CWSelectionDownAction
    extends CWTextAction {
        private CWSelectionDownAction() {
            super("selection-down");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AltHistory.willShowAsPopup() && !AltHistory.isPopupShowing() && CmdWinEditorKit.multipleLinesAfterPrompt()) {
                Action action = CmdWinEditorKit.getDefaultActionByName("selection-down");
                action.actionPerformed(actionEvent);
            } else {
                if (FunctionHints.isOpen()) {
                    FunctionHints.hidePopup();
                }
                XCaret.combineCarets();
                CmdWinEditorKit.insertCommandFromHistory(true, true);
            }
        }
    }

    private static class CWSelectionUpAction
    extends CWTextAction {
        private CWSelectionUpAction() {
            super("selection-up");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ((AltHistory.willShowAsPopup() && !AltHistory.isPopupShowing() || !AltHistory.willShowAsPopup() && sLastCommandPrefixForHistory == null) && CmdWinEditorKit.multipleLinesAfterPrompt()) {
                Action action = CmdWinEditorKit.getDefaultActionByName("selection-up");
                action.actionPerformed(actionEvent);
            } else {
                if (FunctionHints.isOpen()) {
                    FunctionHints.hidePopup();
                }
                XCaret.combineCarets();
                CmdWinEditorKit.insertCommandFromHistory(false, true);
            }
        }
    }

    public static class IncrementalSearchAction
    extends CWTextAction {
        private boolean fForward = true;

        IncrementalSearchAction(String string, boolean bl) {
            super(string);
            this.fForward = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XCmdWndView.getInstance().startIncSearch(this.fForward);
        }
    }

    public static class FindAction
    extends CWTextAction {
        FindAction() {
            super(CmdWinEditorKit.findString);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XCmdWndView.getInstance().invokeFindDialog();
        }
    }

    public static class FindFilesAction
    extends CWTextAction {
        FindFilesAction() {
            super(CmdWinEditorKit.findFilesString);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
            FindFiles.invoke(jTextComponent.getSelectedText());
        }
    }

    private static class CWOverwrite
    extends CWTextAction {
        CWOverwrite() {
            super(CmdWinEditorKit.overWrite);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XCmdWndView cfr_ignored_0 = (XCmdWndView)this.getTextComponentIfNull(actionEvent);
            XCmdWndView.setOverwriteMode(!((XCmdWndView)this.getTextComponentIfNull(actionEvent)).isOverwriteMode());
        }
    }

    private static class CWSelectLineAction
    extends CWTextAction {
        private Action start = new CWBeginLineAction("caret-begin-line", false);

        CWSelectLineAction() {
            super(CmdWinEditorKit.selectLineAction, false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdWinEditorKit.closeHistoryPopup();
            CmdWinEditorKit.closeFunctionHints();
            this.start.actionPerformed(actionEvent);
            JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
            int n = jTextComponent.getCaretPosition();
            int n2 = CmdWinDocumentUtilities.getLineEnd(sCWDoc, n);
            if (sCWDoc.isAfterThePrompt(n)) {
                n2 = sCWDoc.getPromptLineEndOffset(false);
            }
            if (n2 < sCWDoc.getLength()) {
                jTextComponent.moveCaretPosition(n2 + 1);
            } else {
                jTextComponent.moveCaretPosition(n2);
            }
        }
    }

    private static class CWSelectAllAction
    extends CWTextAction {
        CWSelectAllAction() {
            super("select-all");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AltHistory.isPopupShowing()) {
                AltHistory.invokeTableAction("selectAll");
            } else {
                Action action = CmdWinEditorKit.getDefaultActionByName("select-all");
                action.actionPerformed(actionEvent);
            }
        }
    }

    private static class ScrollToBottom
    extends CWTextAction {
        ScrollToBottom() {
            super(CmdWinEditorKit.scrollBottom);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XCmdWndView.getInstance().scrollToBottom();
        }
    }

    private static class ScrollToTop
    extends CWTextAction {
        ScrollToTop() {
            super(CmdWinEditorKit.scrollTop);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XCmdWndView.getInstance().scrollToOffset(0);
        }
    }

    private static class DropLineAction
    extends CWTextAction {
        DropLineAction() {
            super(CmdWinEditorKit.dropLine);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
                if (!(jTextComponent.getCaret() instanceof XCaret)) {
                    InputContext inputContext = jTextComponent.getInputContext();
                    if (inputContext != null) {
                        inputContext.endComposition();
                    }
                    return;
                }
                XCaret xCaret = (XCaret)jTextComponent.getCaret();
                int n = xCaret.getDot();
                if (sCWDoc.isInOrBeforeThePrompt(n)) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    sCWDoc.insertString(n, "\n", null);
                }
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
            }
        }
    }

    public static class CWDefaultKeyTypedAction
    extends CWTextAction {
        public CWDefaultKeyTypedAction() {
            super(CmdWinEditorKit.defaultKey, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            char c;
            boolean bl;
            if (!(actionEvent.getModifiers() != 0 && actionEvent.getModifiers() != 1 || actionEvent != null && actionEvent.getActionCommand().charAt(0) == '\u001b')) {
                sCWKit;
                sLastCommandPrefixForHistory = null;
            }
            sCWDoc.clearSuggestionFlag();
            JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
            Caret caret = jTextComponent.getCaret();
            int n = caret.getDot();
            if (!((XCmdWndView)jTextComponent).isOverwriteMode() || sCWDoc.isInOrBeforeThePrompt(n) || jTextComponent.getSelectedText() != null) {
                CmdWinEditorKit.getDefaultActionByName(CmdWinEditorKit.defaultKey).actionPerformed(actionEvent);
                CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
                return;
            }
            int n2 = actionEvent.getModifiers();
            boolean bl2 = (n2 & 2) != 0;
            boolean bl3 = bl = (n2 & 8) != 0;
            if (bl && !bl2 || bl2 && !bl) {
                return;
            }
            if (jTextComponent != null && actionEvent != null && (c = (string = actionEvent.getActionCommand()).charAt(0)) >= ' ' && c != '\u007f') {
                XCaret.adjustSelection(caret);
                try {
                    if (n < sCWDoc.getLength() && sCWDoc.getText(n, 1).charAt(0) != '\n') {
                        sCWDoc.remove(n, 1);
                        sCWDoc.insertString(n, string, null);
                    } else {
                        jTextComponent.replaceSelection(string);
                    }
                    CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
                }
                catch (BadLocationException badLocationException) {
                    Log.logException((Exception)badLocationException);
                }
            }
        }
    }

    static class SelectWordAction
    extends CWTextAction {
        SelectWordAction() {
            super(CmdWinEditorKit.selectWordAction, false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdWinEditorKit.selectWord(actionEvent, this.getTextComponentIfNull(actionEvent));
        }
    }

    private static class CWUpHistoryAction
    extends CWTextAction {
        CWUpHistoryAction() {
            super(CmdWinEditorKit.cwUpHistory);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (FunctionHints.isOpen()) {
                FunctionHints.hidePopup();
            }
            XCaret.combineCarets();
            CmdWinEditorKit.insertCommandFromHistory(false, false);
        }
    }

    static class CWNextWordAction
    extends CWTextAction {
        private boolean select;

        CWNextWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdWinEditorKit.closeHistoryPopup();
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n = jTextComponent.getCaretPosition();
                boolean bl = false;
                int n2 = n;
                Element element = CmdWinTextUtilities.getParagraphElement(jTextComponent, n);
                try {
                    n = CmdWinTextUtilities.getNextWord(jTextComponent, n);
                    if (n >= element.getEndOffset() && n2 != element.getEndOffset() - 1) {
                        n = element.getEndOffset() - 1;
                    }
                }
                catch (BadLocationException badLocationException) {
                    int n3 = jTextComponent.getDocument().getLength();
                    if (n != n3) {
                        n = n2 != element.getEndOffset() - 1 ? element.getEndOffset() - 1 : n3;
                    }
                    bl = true;
                }
                if (!bl) {
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n);
                    } else {
                        jTextComponent.setCaretPosition(n);
                    }
                    CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    private static class CWUpOrDownAction
    extends CWTextAction {
        CWUpOrDownAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Action action = CmdWinEditorKit.getDefaultActionByName(this.getActionID());
            assert (action != null) : "Could not find action for id: " + this.getActionID();
            action.actionPerformed(actionEvent);
        }
    }

    private static class CWNextVisualPositionAction
    extends CWTextAction {
        private int iDirection;
        private String iName;

        CWNextVisualPositionAction(String string, int n) {
            super(string);
            this.iDirection = n;
            this.iName = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdWinEditorKit.closeHistoryPopup();
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent.getSelectionStart() == jTextComponent.getSelectionEnd()) {
                Action action = CmdWinEditorKit.getDefaultActionByName(this.iName);
                action.actionPerformed(actionEvent);
                CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
                return;
            }
            if (jTextComponent != null) {
                Caret caret = jTextComponent.getCaret();
                if (this.iDirection == 3) {
                    caret.setDot(jTextComponent.getSelectionEnd());
                    CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
                    return;
                }
                if (this.iDirection == 7) {
                    caret.setDot(jTextComponent.getSelectionStart());
                    CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
                    return;
                }
            }
        }
    }

    static class CWPreviousWordAction
    extends CWTextAction {
        private boolean select;

        CWPreviousWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdWinEditorKit.closeHistoryPopup();
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                int n = jTextComponent.getCaretPosition();
                boolean bl = false;
                try {
                    Element element = CmdWinTextUtilities.getParagraphElement(jTextComponent, n);
                    n = CmdWinTextUtilities.getPreviousWord(jTextComponent, n);
                    if (n < element.getStartOffset()) {
                        n = CmdWinTextUtilities.getParagraphElement(jTextComponent, n).getEndOffset() - 1;
                    }
                }
                catch (BadLocationException badLocationException) {
                    if (n != 0) {
                        n = 0;
                    }
                    bl = true;
                }
                if (!bl) {
                    if (this.select) {
                        jTextComponent.moveCaretPosition(n);
                    } else {
                        jTextComponent.setCaretPosition(n);
                    }
                    CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(jTextComponent);
                }
            }
        }
    }

    private static class CWDownHistoryAction
    extends CWTextAction {
        CWDownHistoryAction() {
            super(CmdWinEditorKit.cwDownHistory);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (FunctionHints.isOpen()) {
                FunctionHints.hidePopup();
            }
            XCaret.combineCarets();
            CmdWinEditorKit.insertCommandFromHistory(true, false);
        }
    }

    private static class CWPasteAction
    extends CWTextAction {
        CWPasteAction() {
            super(CmdWinEditorKit.pasteAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            sCmdWinUndoMgr.startEditGroup();
            this.getTextComponentIfNull(actionEvent).paste();
            sCmdWinUndoMgr.endEditGroup();
        }
    }

    private static class CWCutAction
    extends CWTextAction {
        CWCutAction() {
            super(CmdWinEditorKit.cutAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            sCmdWinUndoMgr.startEditGroup();
            Action action = CmdWinEditorKit.getDefaultActionByName(CmdWinEditorKit.cutAction);
            action.actionPerformed(actionEvent);
            sCmdWinUndoMgr.endEditGroup();
        }
    }

    private static class CWCopyAction
    extends CWTextAction {
        CWCopyAction() {
            super(CmdWinEditorKit.copyAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.getTextComponentIfNull(actionEvent).copy();
        }
    }

    private static class CWBreakAction
    extends CWTextAction {
        CWBreakAction() {
            super(CmdWinEditorKit.breakAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            KeyStroke keyStroke = XCmdWndView.getInstance().getLastKeyStrokePressed();
            Action action = CmdWinEditorKit.getActionByName(CmdWinEditorKit.copyAction);
            if (CmdWinEditorKit.doesCopyActionUseKeyStroke(keyStroke) && action.isEnabled()) {
                action.actionPerformed(actionEvent);
            } else {
                Caret caret = this.getTextComponentIfNull(actionEvent).getCaret();
                caret.setDot(sCWDoc.getLength());
                XCaret.combineCarets();
                CmdWinMLIF.sendInterruptMsg();
            }
        }
    }

    private static class CWEscAction
    extends CWTextAction {
        CWEscAction() {
            super(CmdWinEditorKit.escAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (FunctionHints.isOpen()) {
                FunctionHints.hidePopup();
                return;
            }
            try {
                boolean bl = AltHistory.isPopupShowing();
                String[] stringArray = AltHistory.getRecalledCommands();
                CmdWinEditorKit.closeHistoryPopup();
                if (bl) {
                    if (sLastCommandPrefixForHistory != null && sLastCommandPrefixForHistory.length() > 0) {
                        String string = CmdWinEditorKit.getTextAtPrompt();
                        if (stringArray.length == 0 || !string.equals(stringArray[stringArray.length - 1])) {
                            sLastCommandPrefixForHistory = null;
                        } else {
                            sLastCommandPrefixForHistory = "";
                        }
                    }
                    return;
                }
                Caret caret = this.getTextComponentIfNull(actionEvent).getCaret();
                if (sCWDoc.isInOrBeforeThePrompt(caret.getDot())) {
                    XCaret.combineCarets();
                }
                sCWDoc.removeCurrentPromptLine();
                sCWKit;
                sLastCommandPrefixForHistory = null;
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
                return;
            }
        }
    }

    private static class FunctionHintsAction
    extends CWTextAction {
        FunctionHintsAction() {
            super(CmdWinEditorKit.openFunctionHints);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            CmdWinEditorKit.openFunctionHints(jTextComponent);
        }
    }

    private static class FunctionBrowserButtonShowAction
    extends CWTextAction {
        FunctionBrowserButtonShowAction() {
            super(CmdWinEditorKit.showFunctionBrowserButton);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdWinPrefs.setShowFunctionBrowser(true);
        }
    }

    private static class FunctionBrowserAction
    extends CWTextAction {
        FunctionBrowserAction() {
            super(CmdWinEditorKit.openFunctionBrowser);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
            String string = Prompt.stripPrompts(jTextComponent.getSelectedText());
            FunctionBrowser.open(jTextComponent, string);
        }
    }

    static class PageSetupAction
    extends CWTextAction {
        PageSetupAction() {
            super(CmdWinEditorKit.pageSetup);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XCmdWndView.showPageSetupDialog();
        }
    }

    static class PrintSelectionAction
    extends CWTextAction {
        PrintSelectionAction() {
            super(CmdWinEditorKit.printSelection);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XCmdWndView.getInstance().print(true);
        }
    }

    static class PrintAction
    extends CWTextAction {
        PrintAction() {
            super(CmdWinEditorKit.print);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XCmdWndView.getInstance().print(false);
        }
    }

    private static class OpenSelAction
    extends CWTextAction {
        OpenSelAction() {
            super(CmdWinEditorKit.openSelection);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getTextComponentIfNull(actionEvent).getSelectedText().trim();
            string = StringUtils.quoteSingleQuotes((String)string);
            CmdWinMLIF.doEval("try open('" + string + "'); catch edit('" + string + "'); end");
            XCaret.combineCarets();
        }
    }

    private static class HelpAction
    extends CWTextAction {
        HelpAction() {
            super(CmdWinEditorKit.helpOnSelection);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
            if (jTextComponent == null) {
                return;
            }
            String string = null;
            try {
                int n = jTextComponent.getCaretPosition() - sCWDoc.getAfterThePrompt();
                if (n > 0) {
                    string = sCWDoc.getText(sCWDoc.getAfterThePrompt(), n);
                }
            }
            catch (BadLocationException badLocationException) {
                Log.log((String)actionEvent.toString());
            }
            if (this.getAcceleratorSequence() != null) {
                HelpPopup.showHelp((JTextComponent)jTextComponent, (KeyStrokeList)new KeyStrokeList(this.getAcceleratorSequence()), (String)string);
            } else {
                HelpPopup.showHelp((JTextComponent)jTextComponent, (KeyStroke)this.getAccelerator(), string);
            }
        }
    }

    private static class ClearCommandWindowAction
    extends CWTextAction {
        ClearCommandWindowAction() {
            super(CmdWinEditorKit.clearWindow);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MLDesktop.getInstance().getClearCommandAction().actionPerformed(actionEvent);
            CmdWinEditorKit.closeFunctionHints();
        }
    }

    private static class EvaluateAction
    extends CWTextAction {
        EvaluateAction() {
            super(CmdWinEditorKit.evaluateSelection);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = Prompt.stripPrompts(this.getTextComponentIfNull(actionEvent).getSelectedText());
            XCaret.combineCarets();
            CmdWinMLIF.doExecuteCommand(string);
        }
    }

    private static class CWKillCutAction
    extends CWTextAction {
        CWKillCutAction() {
            super(CmdWinEditorKit.killCutAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
            if (!(jTextComponent.getCaret() instanceof XCaret)) {
                InputContext inputContext = jTextComponent.getInputContext();
                if (inputContext != null) {
                    inputContext.endComposition();
                }
                return;
            }
            XCaret xCaret = (XCaret)this.getTextComponentIfNull(actionEvent).getCaret();
            int n = xCaret.getDot();
            if (sCWDoc.isInOrBeforeThePrompt(n)) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            xCaret.removeSelection();
            Action action = CmdWinEditorKit.getActionByName(CmdWinEditorKit.selectionEndLineAction);
            action.actionPerformed(actionEvent);
            action = CmdWinEditorKit.getDefaultActionByName(CmdWinEditorKit.cutAction);
            action.actionPerformed(actionEvent);
        }
    }

    private static class CWRedoAction
    extends CWTextAction {
        CWRedoAction() {
            super(CmdWinEditorKit.redoAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (sCmdWinUndoMgr.canRedo()) {
                sCmdWinUndoMgr.redo();
            }
            CmdWinEditorKit.closeFunctionHints();
        }
    }

    private static class CWUndoAction
    extends CWTextAction {
        CWUndoAction() {
            super(CmdWinEditorKit.undoAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (sCmdWinUndoMgr.canUndo()) {
                sCmdWinUndoMgr.undo();
            }
            CmdWinEditorKit.closeFunctionHints();
        }
    }

    private static class CWReturnAction
    extends CWTextAction {
        public CWReturnAction() {
            super(CmdWinEditorKit.insertBreakAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdWinEditorKit.closeFunctionHints();
            if (CmdWinMLIF.isInBangMode() && PlatformInfo.isUnix()) {
                return;
            }
            JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
            String string = jTextComponent.getSelectedText();
            if (!(jTextComponent.getCaret() instanceof XCaret)) {
                InputContext inputContext = jTextComponent.getInputContext();
                if (inputContext != null) {
                    inputContext.endComposition();
                }
                return;
            }
            try {
                jTextComponent.setCaretPosition(sCWDoc.getPromptLineEndOffset(false));
            }
            catch (Exception exception) {
                assert (exception instanceof IllegalArgumentException);
                jTextComponent.setCaretPosition(sCWDoc.getLength());
            }
            if (string != null && string.length() > 0) {
                CmdWinMLIF.doExecuteCommand(string);
            } else {
                CmdWinEditorKit.sendCurrentCommand(sCWDoc.getPromptLineEndOffset(false));
            }
        }
    }

    private static class CtrlReturnAction
    extends CWTextAction {
        public CtrlReturnAction() {
            super(CmdWinEditorKit.ctrlReturnAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Point point = XCaret.getInstance().getLocation();
            if (sCWDoc.isClickInHyperLink(point)) {
                sCWDoc.goToHyperLink(point);
            }
        }
    }

    private static class CWNavigationAction
    extends CWTextAction {
        private String name = null;

        public CWNavigationAction(String string) {
            super(string);
            this.name = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (FunctionHints.isOpen()) {
                FunctionHints.dispatchKeyEventToScrollPane(actionEvent);
                return;
            }
            if (AltHistory.isPopupShowing()) {
                if (CmdWinEditorKit.pageUpAction == this.name) {
                    AltHistory.invokeTableAction("scrollUpChangeSelection");
                    return;
                }
                if (CmdWinEditorKit.pageDownAction == this.name) {
                    AltHistory.invokeTableAction("scrollDownChangeSelection");
                    return;
                }
                if (CmdWinEditorKit.beginAction == this.name) {
                    AltHistory.invokeTableAction("selectFirstRow");
                    return;
                }
                if (CmdWinEditorKit.endAction == this.name) {
                    AltHistory.invokeTableAction("selectLastRow");
                    return;
                }
            }
            Action action = CmdWinEditorKit.getDefaultActionByName(this.name);
            action.actionPerformed(actionEvent);
        }
    }

    private static class CWDeletePrevCharAction
    extends CWTextAction {
        CWDeletePrevCharAction() {
            super(CmdWinEditorKit.deletePrevCharAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Caret caret = this.getTextComponentIfNull(actionEvent).getCaret();
            JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
            int n2 = caret.getDot();
            boolean bl = n2 != (n = caret.getMark());
            boolean bl2 = sCWDoc.isInOrBeforeThePrompt(n2);
            boolean bl3 = sCWDoc.isInOrBeforeThePrompt(n);
            if (bl && (bl2 && bl3 || bl2 && sCWDoc.isInOrBeforeThePrompt(caret.getMark() - 1) || bl3 && sCWDoc.isInOrBeforeThePrompt(caret.getDot() - 1))) {
                XCaret.adjustSelection(caret);
                Toolkit.getDefaultToolkit().beep();
            } else if (!bl && sCWDoc.isInOrBeforeThePrompt(n2 - 1)) {
                XCaret.adjustSelection(caret);
                if (sCWDoc.isInOrBeforeThePrompt(caret.getDot() - 1)) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    Action action = CmdWinEditorKit.getDefaultActionByName(CmdWinEditorKit.deletePrevCharAction);
                    action.actionPerformed(actionEvent);
                    CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
                }
            } else {
                if (!(!bl || !bl2 && !bl3 || bl2 && bl3)) {
                    if (!bl2) {
                        jTextComponent.setCaretPosition(n2);
                        jTextComponent.moveCaretPosition(sCWDoc.getAfterThePrompt());
                    } else {
                        jTextComponent.setCaretPosition(sCWDoc.getAfterThePrompt());
                        jTextComponent.moveCaretPosition(n);
                    }
                }
                Action action = CmdWinEditorKit.getDefaultActionByName(CmdWinEditorKit.deletePrevCharAction);
                action.actionPerformed(actionEvent);
                CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
            }
        }
    }

    private static class CWDeleteNextCharAction
    extends CWTextAction {
        CWDeleteNextCharAction() {
            super(CmdWinEditorKit.deleteNextCharAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (CmdWinMLIF.isInBangMode() && PlatformInfo.isUnix()) {
                return;
            }
            Caret caret = this.getTextComponentIfNull(actionEvent).getCaret();
            JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
            int n2 = caret.getDot();
            boolean bl = n2 != (n = caret.getMark());
            boolean bl2 = sCWDoc.isInOrBeforeThePrompt(n2);
            boolean bl3 = sCWDoc.isInOrBeforeThePrompt(n);
            if (bl && bl2 && bl3) {
                XCaret.adjustSelection(caret);
            } else {
                if (!bl && sCWDoc.isInOrBeforeThePrompt(n2 - 1)) {
                    XCaret.adjustSelection(caret);
                }
                if (!(!bl || !bl2 && !bl3 || bl2 && bl3)) {
                    if (!bl2) {
                        jTextComponent.setCaretPosition(n2);
                        jTextComponent.moveCaretPosition(sCWDoc.getAfterThePrompt());
                    } else {
                        jTextComponent.setCaretPosition(sCWDoc.getAfterThePrompt());
                        jTextComponent.moveCaretPosition(n);
                    }
                }
                Action action = CmdWinEditorKit.getDefaultActionByName(CmdWinEditorKit.deleteNextCharAction);
                action.actionPerformed(actionEvent);
                CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
            }
        }
    }

    static class CWEndLineAction
    extends CWTextAction {
        private boolean fSelect;

        CWEndLineAction(String string, boolean bl) {
            super(string);
            this.fSelect = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdWinEditorKit.closeHistoryPopup();
            JTextComponent jTextComponent = this.getTextComponentIfNull(actionEvent);
            int n = CmdWinDocumentUtilities.getLineEnd(sCWDoc, jTextComponent.getCaretPosition());
            if (this.fSelect) {
                jTextComponent.moveCaretPosition(n);
            } else {
                jTextComponent.setCaretPosition(n);
            }
            CmdWinEditorKit.maybeOpenFunctionHints(jTextComponent, actionEvent);
        }
    }

    private static class CWBeginLineAction
    extends CWTextAction {
        private boolean fSelect;

        public CWBeginLineAction(String string, boolean bl) {
            super(string);
            this.fSelect = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CmdWinEditorKit.closeHistoryPopup();
            try {
                XCmdWndView xCmdWndView = XCmdWndView.getInstance();
                int n = sCWDoc.getPromptOffset();
                int n2 = n >= 0 ? xCmdWndView.getLineOfOffset(n) : 0;
                int n3 = xCmdWndView.getLineOfOffset(xCmdWndView.getCaretPosition());
                if (n3 != n2) {
                    CmdWinEditorKit.getDefaultActionByName(this.fSelect ? CmdWinEditorKit.selectionBeginLineAction : CmdWinEditorKit.beginLineAction).actionPerformed(actionEvent);
                } else if (this.fSelect) {
                    this.getTextComponentIfNull(actionEvent).moveCaretPosition(sCWDoc.getAfterThePrompt());
                } else {
                    this.getTextComponentIfNull(actionEvent).setCaretPosition(sCWDoc.getAfterThePrompt());
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            CmdWinEditorKit.closeFunctionHints();
        }
    }

    private static abstract class CWTextAction
    extends MTextAction {
        public CWTextAction(String string, boolean bl) {
            super(string);
            if (bl) {
                this.addKeyBindingAndActionInfo(string);
            }
        }

        public CWTextAction(String string) {
            this(string, true);
        }

        public CWTextAction(String string, Icon icon) {
            super(string, icon);
            throw new IllegalStateException("This signature is not supported.");
        }

        public CWTextAction(String string, Icon icon, boolean bl) {
            super(string, icon, bl);
            throw new IllegalStateException("This signature is not supported.");
        }

        private void addKeyBindingAndActionInfo(String string) {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("CommandWindow", string, (ExtendedAction)this);
        }

        protected JTextComponent getTextComponentIfNull(ActionEvent actionEvent) {
            JTextComponent jTextComponent = null;
            if (actionEvent != null && actionEvent.getSource() instanceof JTextComponent) {
                jTextComponent = (JTextComponent)actionEvent.getSource();
            }
            if (jTextComponent == null) {
                jTextComponent = XCmdWndView.getInstance();
            }
            return jTextComponent;
        }
    }
}

