/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdwin;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class LoadNativeCmdWin {
    private static final AtomicBoolean LIB_LOADED = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void loadNativeCmdWin() {
        if (LIB_LOADED.get()) return;
        Class<LoadNativeCmdWin> clazz = LoadNativeCmdWin.class;
        synchronized (LoadNativeCmdWin.class) {
            if (LIB_LOADED.get()) return;
            try {
                System.loadLibrary("nativecmdwin");
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane jOptionPane = new JOptionPane("Failed to load nativecmdwin library: " + throwable.getMessage(), 0, -1){

                            @Override
                            public int getMaxCharactersPerLineCount() {
                                return 100;
                            }
                        };
                        jOptionPane.createDialog("ERROR").setVisible(true);
                    }
                });
            }
            finally {
                LIB_LOADED.set(true);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean preventLibraryLoad() {
        Class<LoadNativeCmdWin> clazz = LoadNativeCmdWin.class;
        synchronized (LoadNativeCmdWin.class) {
            boolean bl = LIB_LOADED.getAndSet(true);
            assert (!bl) : "attempt to prevent nativecmdwin library loading was too late.";
            // ** MonitorExit[var0] (shouldn't be in output)
            return bl;
        }
    }
}

