/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.difftool;

import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorEvent;
import com.mathworks.matlab.api.editor.EditorMenuGroupID;
import com.mathworks.matlab.api.editor.EditorMenuID;
import com.mathworks.matlab.api.menus.MenuBuilder;
import com.mathworks.matlab.api.menus.MenuContext;
import com.mathworks.matlab.api.menus.MenuContributor;
import com.mathworks.matlab.api.menus.MenuGroupID;
import com.mathworks.matlab.api.menus.MenuID;
import com.mathworks.mde.difftool.FileDiffToolMenu;
import com.mathworks.mde.difftool.UnsavedChangesDiffToolAction;
import com.mathworks.mde.editor.plugins.difftool.DiffToolInfoImpl;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.datamodel.FutureFileStorageLocation;
import com.mathworks.widgets.editor.SelfRemovingEditorEventListener;
import com.mathworks.widgets.menus.DefaultMenuGroupID;
import java.awt.Component;
import javax.swing.Action;

public class DiffToolMenuContributor
implements MenuContributor<Editor> {
    public Class<Editor> getContributionTarget() {
        return Editor.class;
    }

    public void contribute(Editor editor, MenuContext menuContext) {
        if (editor.getStorageLocation() instanceof FileStorageLocation || editor.getStorageLocation() instanceof FutureFileStorageLocation) {
            new DiffToolMenuContribution(editor, menuContext).contribute();
        }
    }

    public void contributeToContextMenu(Editor editor, MenuBuilder menuBuilder) {
    }

    private static class DiffToolMenuContribution {
        private final MenuContext fContext;
        private Editor fEditor;

        private DiffToolMenuContribution(Editor editor, MenuContext menuContext) {
            this.fEditor = editor;
            this.fContext = menuContext;
        }

        private void contribute() {
            DiffToolInfoImpl diffToolInfoImpl = new DiffToolInfoImpl(this.fEditor);
            final FileDiffToolMenu fileDiffToolMenu = new FileDiffToolMenu(diffToolInfoImpl);
            final UnsavedChangesDiffToolAction unsavedChangesDiffToolAction = new UnsavedChangesDiffToolAction(diffToolInfoImpl);
            MJMenu mJMenu = fileDiffToolMenu.getMenu();
            DefaultMenuGroupID defaultMenuGroupID = new DefaultMenuGroupID("DiffToolMenuGroup");
            MenuBuilder menuBuilder = this.fContext.getBuilder((MenuID)EditorMenuID.TOOLS);
            menuBuilder.insertGroupAfter((MenuGroupID)EditorMenuGroupID.TOOLS_REPORT_GROUP, (MenuGroupID)defaultMenuGroupID);
            menuBuilder.add((MenuGroupID)defaultMenuGroupID, (Action)unsavedChangesDiffToolAction.getAction());
            menuBuilder.add((MenuGroupID)defaultMenuGroupID, (Component)mJMenu);
            new SelfRemovingEditorEventListener(this.fEditor){

                public void handleEventOccurred(EditorEvent editorEvent) {
                    if (editorEvent == EditorEvent.DIRTY_STATE_CHANGED || editorEvent == EditorEvent.AUTOSAVED || editorEvent == EditorEvent.AUTOSAVE_OPTIONS_CHANGED) {
                        fileDiffToolMenu.updateActionStatus();
                        unsavedChangesDiffToolAction.updateActionStatus();
                    }
                }
            };
        }
    }
}

