/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.embeddedoutputs;

import com.mathworks.mde.embeddedoutputs.OutputDataType;
import com.mathworks.mde.embeddedoutputs.RegionData;
import com.mathworks.mde.embeddedoutputs.RegionOutputsMessage;
import com.mathworks.mde.embeddedoutputs.RegionStateHandler;
import com.mathworks.mde.embeddedoutputs.RegionsData;
import com.mathworks.mde.embeddedoutputs.evaluation.EvalCanceledException;
import com.mathworks.mde.embeddedoutputs.evaluation.EvaluationManager;
import com.mathworks.mde.embeddedoutputs.evaluation.InterruptManager;
import com.mathworks.mde.embeddedoutputs.evaluation.StateManager;
import com.mathworks.mde.embeddedoutputs.figures.FigureManager;
import com.mathworks.mvm.MVM;
import java.util.List;

public final class RegionEvaluator {
    private static final double SAVE_STATE_THREASHOLD_TIME = 0.3;
    private final FigureManager fFigureManager;
    private final EvaluationManager fEvaluationManager;
    private final StateManager fStateManager;
    private final String fUniqueId;
    private String fCurrentRequestId;
    private long fEvalStartTime;

    public RegionEvaluator(String string, MVM mVM) {
        this.fUniqueId = string;
        this.fFigureManager = new FigureManager(string, mVM);
        this.fEvaluationManager = new EvaluationManager(string, mVM);
        this.fStateManager = new StateManager(string, mVM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evalRegions(RegionsData regionsData, RegionStateHandler regionStateHandler) {
        try {
            this.fCurrentRequestId = regionsData.getRequestId();
            List<RegionData> list = regionsData.getRegionList();
            this.fFigureManager.closeFiguresAndEnableCapture();
            int n = this.fStateManager.updateRegionsAndGetStartNumber(list, regionsData.getFullRun());
            if (n == -1) {
                return;
            }
            List<RegionData> list2 = list.subList(n, list.size());
            this.fEvalStartTime = System.nanoTime();
            for (RegionData regionData : list2) {
                this.evalRegion(regionData.getRegionString(), regionData.getRegionNumber(), regionStateHandler, regionsData.getRequestId(), regionsData.getFullRun());
            }
        }
        catch (EvalCanceledException evalCanceledException) {
            InterruptManager.removeInterrupttedRequestId(regionsData.getRequestId());
            this.fCurrentRequestId = null;
            try {
                this.fFigureManager.disableCaptureFigures();
            }
            finally {
                regionStateHandler.regionsCompleted(regionsData.getRequestId());
            }
        }
        finally {
            InterruptManager.removeInterrupttedRequestId(regionsData.getRequestId());
            this.fCurrentRequestId = null;
            try {
                this.fFigureManager.disableCaptureFigures();
            }
            finally {
                regionStateHandler.regionsCompleted(regionsData.getRequestId());
            }
        }
    }

    private void evalRegion(String string, int n, RegionStateHandler regionStateHandler, String string2, boolean bl) throws EvalCanceledException {
        boolean bl2;
        if (InterruptManager.isRequestInterruptted(string2)) {
            throw new EvalCanceledException();
        }
        regionStateHandler.regionEvalStarted(n);
        this.fFigureManager.snapshotFigures();
        List<OutputDataType> list = this.fEvaluationManager.evalCode(string, n);
        long l = System.nanoTime() - this.fEvalStartTime;
        double d = (double)l / 1.0E9;
        boolean bl3 = bl2 = !bl && !InterruptManager.isRequestInterruptted(string2) && d > 0.3;
        if (bl2) {
            this.fEvalStartTime = System.nanoTime();
        }
        list.addAll(this.fFigureManager.getFigureChangesAndSaveState(n, bl2));
        RegionOutputsMessage regionOutputsMessage = new RegionOutputsMessage(n, string2, list);
        regionStateHandler.regionEvalCompleted(regionOutputsMessage);
    }

    public void dispose() {
        if (this.fCurrentRequestId != null && !this.fCurrentRequestId.isEmpty()) {
            InterruptManager.interrupt(this.fUniqueId, this.fCurrentRequestId);
        }
        this.fStateManager.dispose();
        this.fFigureManager.disableCaptureFigures();
        this.fEvaluationManager.dispose();
    }
}

