/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.embeddedoutputs.evaluation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;

public class InterruptManager {
    private static final Map<String, List<Future<Object>>> FUTURE_RESULT_CONCURRENT_HASH_MAP = new ConcurrentHashMap<String, List<Future<Object>>>();
    private static final List<String> INTERRUPTED_REQUEST_IDS = new CopyOnWriteArrayList<String>();

    private InterruptManager() {
    }

    public static void addInterruptableFuture(String string, Future<Object> future) {
        if (!FUTURE_RESULT_CONCURRENT_HASH_MAP.containsKey(string)) {
            FUTURE_RESULT_CONCURRENT_HASH_MAP.put(string, new ArrayList());
        }
        FUTURE_RESULT_CONCURRENT_HASH_MAP.get(string).add(future);
    }

    public static void removeInterruptableFuture(String string, Future<Object> future) {
        if (!FUTURE_RESULT_CONCURRENT_HASH_MAP.containsKey(string)) {
            return;
        }
        if (FUTURE_RESULT_CONCURRENT_HASH_MAP.get(string).contains(future)) {
            FUTURE_RESULT_CONCURRENT_HASH_MAP.get(string).remove(future);
        }
    }

    public static void interrupt(String string, String string2) {
        if (!InterruptManager.isRequestInterruptted(string2)) {
            InterruptManager.addInterupttedRequestId(string2);
        }
        InterruptManager.interrupt(string);
    }

    public static void interrupt(String string) {
        if (FUTURE_RESULT_CONCURRENT_HASH_MAP.containsKey(string)) {
            List<Future<Object>> list = FUTURE_RESULT_CONCURRENT_HASH_MAP.remove(string);
            for (Future<Object> future : list) {
                future.cancel(true);
            }
        }
    }

    private static void addInterupttedRequestId(String string) {
        INTERRUPTED_REQUEST_IDS.add(string);
    }

    public static void removeInterrupttedRequestId(String string) {
        if (InterruptManager.isRequestInterruptted(string)) {
            INTERRUPTED_REQUEST_IDS.remove(string);
        }
    }

    public static boolean isRequestInterruptted(String string) {
        return INTERRUPTED_REQUEST_IDS.contains(string);
    }
}

